/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core;

import java.util.List;
import java.util.concurrent.Executor;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQIOErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQQueueMaxConsumerLimitReached;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.exception.ActiveMQXAException;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.ChannelHandler;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.CoreProtocolManager;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ActiveMQExceptionMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateAddressMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateQueueMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateQueueMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSharedQueueMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSharedQueueMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.NullResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.RollbackMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionAcknowledgeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionAddMetaDataMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionAddMetaDataMessageV2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryResponseMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryResponseMessage_V3;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryResponseMessage_V4;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionConsumerCloseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionConsumerFlowCreditMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionCreateConsumerMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionDeleteQueueMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionExpireMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionForceConsumerDelivery;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionIndividualAcknowledgeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionQueueQueryMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionQueueQueryResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionQueueQueryResponseMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionQueueQueryResponseMessage_V3;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionRequestProducerCreditsMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendContinuationMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendLargeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionUniqueAddMetaDataMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAAfterFailedMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXACommitMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAEndMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAForgetMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAGetInDoubtXidsResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAGetTimeoutResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAJoinMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAPrepareMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAResumeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXARollbackMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXASetTimeoutMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXASetTimeoutResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAStartMessage;
import org.apache.activemq.artemis.core.remoting.CloseListener;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnection;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.BindingQueryResult;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.spi.core.protocol.EmbedMessageUtil;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.utils.SimpleFuture;
import org.apache.activemq.artemis.utils.SimpleFutureImpl;
import org.apache.activemq.artemis.utils.actors.Actor;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.jboss.logging.Logger;

public class ServerSessionPacketHandler
implements ChannelHandler {
    private static final Logger logger = Logger.getLogger(ServerSessionPacketHandler.class);
    private final ServerSession session;
    private final StorageManager storageManager;
    private final Channel channel;
    private volatile CoreRemotingConnection remotingConnection;
    private final Actor<Packet> packetActor;
    private final ArtemisExecutor callExecutor;
    private final CoreProtocolManager manager;
    private volatile LargeServerMessage currentLargeMessage;
    private final boolean direct;
    private static final Object DUMMY = Boolean.TRUE;
    private static final ThreadLocal<Object> inHandler = new ThreadLocal();

    public ServerSessionPacketHandler(ActiveMQServer server, CoreProtocolManager manager, ServerSession session, StorageManager storageManager, Channel channel) {
        this.manager = manager;
        this.session = session;
        session.addCloseable(failed -> this.clearLargeMessage());
        this.storageManager = storageManager;
        this.channel = channel;
        this.remotingConnection = channel.getConnection();
        Connection conn = this.remotingConnection.getTransportConnection();
        this.callExecutor = server.getExecutorFactory().getExecutor();
        this.packetActor = new Actor((Executor)this.callExecutor, this::onMessagePacket);
        this.direct = conn instanceof NettyConnection ? ((NettyConnection)conn).isDirectDeliver() : false;
    }

    private void clearLargeMessage() {
        if (this.currentLargeMessage != null) {
            try {
                this.currentLargeMessage.deleteFile();
            }
            catch (Throwable error) {
                ActiveMQServerLogger.LOGGER.errorDeletingLargeMessageFile(error);
            }
        }
    }

    public ServerSession getSession() {
        return this.session;
    }

    public long getID() {
        return this.channel.getID();
    }

    public void connectionFailed(ActiveMQException exception, boolean failedOver) {
        ActiveMQServerLogger.LOGGER.clientConnectionFailed(this.session.getName());
        this.flushExecutor();
        try {
            this.session.close(true);
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.errorClosingSession(e);
        }
        ActiveMQServerLogger.LOGGER.clearingUpSession(this.session.getName());
    }

    private static void onStartMessagePacketHandler() {
        assert (inHandler.get() == null) : "recursion on packet handling is not supported";
        inHandler.set(DUMMY);
    }

    private static boolean inHandler() {
        Object dummy = inHandler.get();
        assert (dummy != null && dummy == DUMMY || dummy == null) : "wrong marker";
        return dummy != null;
    }

    private static void onExitMessagePacketHandler() {
        assert (inHandler.get() != null) : "marker not set";
        inHandler.set(null);
    }

    public void flushExecutor() {
        if (!ServerSessionPacketHandler.inHandler()) {
            this.packetActor.flush();
            this.callExecutor.flush();
        }
    }

    public void close() {
        this.flushExecutor();
        this.channel.flushConfirmations();
        try {
            this.session.close(false);
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.errorClosingSession(e);
        }
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void handlePacket(Packet packet) {
        this.packetActor.act((Object)packet);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onMessagePacket(Packet packet) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ServerSessionPacketHandler::handlePacket," + packet));
        }
        ServerSessionPacketHandler.onStartMessagePacketHandler();
        try {
            byte type = packet.getType();
            switch (type) {
                case 71: {
                    this.onSessionSend(packet);
                    return;
                }
                case 41: {
                    this.onSessionAcknowledge(packet);
                    return;
                }
                case 79: {
                    this.onSessionRequestProducerCredits(packet);
                    return;
                }
                case 70: {
                    this.onSessionConsumerFlowCredit(packet);
                    return;
                }
                default: {
                    this.slowPacketHandler(packet);
                    return;
                }
            }
        }
        finally {
            ServerSessionPacketHandler.onExitMessagePacketHandler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void slowPacketHandler(Packet packet) {
        byte type = packet.getType();
        this.storageManager.setContext(this.session.getSessionContext());
        NullResponseMessage response = null;
        boolean flush = false;
        boolean closeChannel = false;
        boolean requiresResponse = false;
        try {
            try {
                switch (type) {
                    case 72: {
                        SessionSendLargeMessage message = (SessionSendLargeMessage)packet;
                        this.sendLarge(message.getLargeMessage());
                        break;
                    }
                    case 73: {
                        SessionSendContinuationMessage message = (SessionSendContinuationMessage)packet;
                        requiresResponse = message.isRequiresResponse();
                        this.sendContinuations(message.getPacketSize(), message.getMessageBodySize(), message.getBody(), message.isContinues());
                        if (!requiresResponse) break;
                        response = new NullResponseMessage();
                        break;
                    }
                    case 40: {
                        SessionCreateConsumerMessage request = (SessionCreateConsumerMessage)packet;
                        requiresResponse = request.isRequiresResponse();
                        this.session.createConsumer(request.getID(), request.getQueueName(this.remotingConnection.getClientVersion()), request.getFilterString(), request.isBrowseOnly());
                        if (!requiresResponse) break;
                        QueueQueryResult queueQueryResult = this.session.executeQueueQuery(request.getQueueName(this.remotingConnection.getClientVersion()));
                        if (this.channel.supports((byte)-14)) {
                            response = new SessionQueueQueryResponseMessage_V3(queueQueryResult);
                            break;
                        }
                        if (this.channel.supports((byte)-7)) {
                            response = new SessionQueueQueryResponseMessage_V2(queueQueryResult);
                            break;
                        }
                        response = new SessionQueueQueryResponseMessage(queueQueryResult);
                        break;
                    }
                    case -11: {
                        CreateAddressMessage request = (CreateAddressMessage)packet;
                        requiresResponse = request.isRequiresResponse();
                        this.session.createAddress(request.getAddress(), request.getRoutingTypes(), request.isAutoCreated());
                        if (!requiresResponse) break;
                        response = new NullResponseMessage();
                        break;
                    }
                    case 34: {
                        CreateQueueMessage request = (CreateQueueMessage)packet;
                        requiresResponse = request.isRequiresResponse();
                        this.session.createQueue(request.getAddress(), request.getQueueName(), RoutingType.MULTICAST, request.getFilterString(), request.isTemporary(), request.isDurable());
                        if (!requiresResponse) break;
                        response = new NullResponseMessage();
                        break;
                    }
                    case -12: {
                        CreateQueueMessage_V2 request = (CreateQueueMessage_V2)packet;
                        requiresResponse = request.isRequiresResponse();
                        this.session.createQueue(request.getAddress(), request.getQueueName(), request.getRoutingType(), request.getFilterString(), request.isTemporary(), request.isDurable(), request.getMaxConsumers(), request.isPurgeOnNoConsumers(), request.isAutoCreated());
                        if (!requiresResponse) break;
                        response = new NullResponseMessage();
                        break;
                    }
                    case 36: {
                        CreateSharedQueueMessage request = (CreateSharedQueueMessage)packet;
                        requiresResponse = request.isRequiresResponse();
                        this.session.createSharedQueue(request.getAddress(), request.getQueueName(), request.isDurable(), request.getFilterString());
                        if (!requiresResponse) break;
                        response = new NullResponseMessage();
                        break;
                    }
                    case -13: {
                        CreateSharedQueueMessage_V2 request = (CreateSharedQueueMessage_V2)packet;
                        requiresResponse = request.isRequiresResponse();
                        this.session.createSharedQueue(request.getAddress(), request.getQueueName(), request.getRoutingType(), request.isDurable(), request.getFilterString());
                        if (!requiresResponse) break;
                        response = new NullResponseMessage();
                        break;
                    }
                    case 35: {
                        requiresResponse = true;
                        SessionDeleteQueueMessage request = (SessionDeleteQueueMessage)packet;
                        this.session.deleteQueue(request.getQueueName());
                        response = new NullResponseMessage();
                        break;
                    }
                    case 45: {
                        requiresResponse = true;
                        SessionQueueQueryMessage request = (SessionQueueQueryMessage)packet;
                        QueueQueryResult result = this.session.executeQueueQuery(request.getQueueName(this.remotingConnection.getClientVersion()));
                        if (this.remotingConnection.getClientVersion() < 129) {
                            result.setAddress(SessionQueueQueryMessage.getOldPrefixedAddress((SimpleString)result.getAddress(), (RoutingType)result.getRoutingType()));
                        }
                        if (this.channel.supports((byte)-14)) {
                            response = new SessionQueueQueryResponseMessage_V3(result);
                            break;
                        }
                        if (this.channel.supports((byte)-7)) {
                            response = new SessionQueueQueryResponseMessage_V2(result);
                            break;
                        }
                        response = new SessionQueueQueryResponseMessage(result);
                        break;
                    }
                    case 49: {
                        List convertedQueueNames;
                        List<SimpleString> queueNames;
                        requiresResponse = true;
                        SessionBindingQueryMessage request = (SessionBindingQueryMessage)packet;
                        int clientVersion = this.remotingConnection.getClientVersion();
                        BindingQueryResult result = this.session.executeBindingQuery(request.getAddress(clientVersion));
                        if (clientVersion < 129 && this.session.getMetaData("jms-session") != null && !(queueNames = result.getQueueNames()).isEmpty() && (convertedQueueNames = request.convertQueueNames(clientVersion, queueNames)) != queueNames) {
                            result = new BindingQueryResult(result.isExists(), convertedQueueNames, result.isAutoCreateQueues(), result.isAutoCreateAddresses(), result.isDefaultPurgeOnNoConsumers(), result.getDefaultMaxConsumers());
                        }
                        if (this.channel.supports((byte)-15)) {
                            response = new SessionBindingQueryResponseMessage_V4(result.isExists(), result.getQueueNames(), result.isAutoCreateQueues(), result.isAutoCreateAddresses(), result.isDefaultPurgeOnNoConsumers(), result.getDefaultMaxConsumers());
                            break;
                        }
                        if (this.channel.supports((byte)-10)) {
                            response = new SessionBindingQueryResponseMessage_V3(result.isExists(), result.getQueueNames(), result.isAutoCreateQueues(), result.isAutoCreateAddresses());
                            break;
                        }
                        if (this.channel.supports((byte)-8)) {
                            response = new SessionBindingQueryResponseMessage_V2(result.isExists(), result.getQueueNames(), result.isAutoCreateQueues());
                            break;
                        }
                        response = new SessionBindingQueryResponseMessage(result.isExists(), result.getQueueNames());
                        break;
                    }
                    case 42: {
                        SessionExpireMessage message = (SessionExpireMessage)packet;
                        this.session.expire(message.getConsumerID(), message.getMessageID());
                        break;
                    }
                    case 43: {
                        requiresResponse = true;
                        this.session.commit();
                        response = new NullResponseMessage();
                        break;
                    }
                    case 44: {
                        requiresResponse = true;
                        this.session.rollback(((RollbackMessage)packet).isConsiderLastMessageAsDelivered());
                        response = new NullResponseMessage();
                        break;
                    }
                    case 53: {
                        requiresResponse = true;
                        SessionXACommitMessage message = (SessionXACommitMessage)packet;
                        this.session.xaCommit(message.getXid(), message.isOnePhase());
                        response = new SessionXAResponseMessage(false, 0, null);
                        break;
                    }
                    case 52: {
                        requiresResponse = true;
                        SessionXAEndMessage message = (SessionXAEndMessage)packet;
                        this.session.xaEnd(message.getXid());
                        response = new SessionXAResponseMessage(false, 0, null);
                        break;
                    }
                    case 60: {
                        requiresResponse = true;
                        SessionXAForgetMessage message = (SessionXAForgetMessage)packet;
                        this.session.xaForget(message.getXid());
                        response = new SessionXAResponseMessage(false, 0, null);
                        break;
                    }
                    case 57: {
                        requiresResponse = true;
                        SessionXAJoinMessage message = (SessionXAJoinMessage)packet;
                        this.session.xaJoin(message.getXid());
                        response = new SessionXAResponseMessage(false, 0, null);
                        break;
                    }
                    case 59: {
                        requiresResponse = true;
                        SessionXAResumeMessage message = (SessionXAResumeMessage)packet;
                        this.session.xaResume(message.getXid());
                        response = new SessionXAResponseMessage(false, 0, null);
                        break;
                    }
                    case 56: {
                        requiresResponse = true;
                        SessionXARollbackMessage message = (SessionXARollbackMessage)packet;
                        this.session.xaRollback(message.getXid());
                        response = new SessionXAResponseMessage(false, 0, null);
                        break;
                    }
                    case 51: {
                        requiresResponse = true;
                        SessionXAStartMessage message = (SessionXAStartMessage)packet;
                        this.session.xaStart(message.getXid());
                        response = new SessionXAResponseMessage(false, 0, null);
                        break;
                    }
                    case 39: {
                        requiresResponse = true;
                        SessionXAAfterFailedMessage message = (SessionXAAfterFailedMessage)packet;
                        this.session.xaFailed(message.getXid());
                        break;
                    }
                    case 58: {
                        requiresResponse = true;
                        this.session.xaSuspend();
                        response = new SessionXAResponseMessage(false, 0, null);
                        break;
                    }
                    case 54: {
                        requiresResponse = true;
                        SessionXAPrepareMessage message = (SessionXAPrepareMessage)packet;
                        this.session.xaPrepare(message.getXid());
                        response = new SessionXAResponseMessage(false, 0, null);
                        break;
                    }
                    case 61: {
                        requiresResponse = true;
                        List<Xid> xids = this.session.xaGetInDoubtXids();
                        response = new SessionXAGetInDoubtXidsResponseMessage(xids);
                        break;
                    }
                    case 65: {
                        requiresResponse = true;
                        int timeout = this.session.xaGetTimeout();
                        response = new SessionXAGetTimeoutResponseMessage(timeout);
                        break;
                    }
                    case 63: {
                        requiresResponse = true;
                        SessionXASetTimeoutMessage message = (SessionXASetTimeoutMessage)packet;
                        this.session.xaSetTimeout(message.getTimeoutSeconds());
                        response = new SessionXASetTimeoutResponseMessage(true);
                        break;
                    }
                    case 67: {
                        this.session.start();
                        break;
                    }
                    case 68: {
                        requiresResponse = true;
                        this.session.stop();
                        response = new NullResponseMessage();
                        break;
                    }
                    case 69: {
                        requiresResponse = true;
                        this.session.close(false);
                        response = new NullResponseMessage();
                        flush = true;
                        closeChannel = true;
                        break;
                    }
                    case 81: {
                        SessionIndividualAcknowledgeMessage message = (SessionIndividualAcknowledgeMessage)packet;
                        requiresResponse = message.isRequiresResponse();
                        this.session.individualAcknowledge(message.getConsumerID(), message.getMessageID());
                        if (!requiresResponse) break;
                        response = new NullResponseMessage();
                        break;
                    }
                    case 74: {
                        requiresResponse = true;
                        SessionConsumerCloseMessage message = (SessionConsumerCloseMessage)packet;
                        this.session.closeConsumer(message.getConsumerID());
                        response = new NullResponseMessage();
                        break;
                    }
                    case 78: {
                        SessionForceConsumerDelivery message = (SessionForceConsumerDelivery)packet;
                        this.session.forceConsumerDelivery(message.getConsumerID(), message.getSequence());
                        break;
                    }
                    case 104: {
                        response = new NullResponseMessage();
                        SessionAddMetaDataMessage message = (SessionAddMetaDataMessage)packet;
                        this.session.addMetaData(message.getKey(), message.getData());
                        break;
                    }
                    case 105: {
                        requiresResponse = true;
                        SessionAddMetaDataMessageV2 message = (SessionAddMetaDataMessageV2)packet;
                        if (message.isRequiresConfirmations()) {
                            response = new NullResponseMessage();
                        }
                        this.session.addMetaData(message.getKey(), message.getData());
                        break;
                    }
                    case 106: {
                        requiresResponse = true;
                        SessionUniqueAddMetaDataMessage message = (SessionUniqueAddMetaDataMessage)packet;
                        if (this.session.addUniqueMetaData(message.getKey(), message.getData())) {
                            response = new NullResponseMessage();
                            break;
                        }
                        response = new ActiveMQExceptionMessage((ActiveMQException)ActiveMQMessageBundle.BUNDLE.duplicateMetadata(message.getKey(), message.getData()));
                        break;
                    }
                }
            }
            catch (ActiveMQIOErrorException e) {
                response = ServerSessionPacketHandler.onActiveMQIOErrorExceptionWhileHandlePacket(e, requiresResponse, (Packet)response, this.session);
            }
            catch (ActiveMQXAException e) {
                response = ServerSessionPacketHandler.onActiveMQXAExceptionWhileHandlePacket(e, requiresResponse, (Packet)response);
            }
            catch (ActiveMQQueueMaxConsumerLimitReached e) {
                response = ServerSessionPacketHandler.onActiveMQQueueMaxConsumerLimitReachedWhileHandlePacket(e, requiresResponse, (Packet)response);
            }
            catch (ActiveMQException e) {
                response = ServerSessionPacketHandler.onActiveMQExceptionWhileHandlePacket(e, requiresResponse, (Packet)response);
            }
            catch (Throwable t) {
                response = ServerSessionPacketHandler.onCatchThrowableWhileHandlePacket(t, requiresResponse, (Packet)response, this.session);
            }
            this.sendResponse(packet, (Packet)response, flush, closeChannel);
        }
        finally {
            this.storageManager.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSessionAcknowledge(Packet packet) {
        this.storageManager.setContext(this.session.getSessionContext());
        try {
            Packet response = null;
            boolean requiresResponse = false;
            try {
                SessionAcknowledgeMessage message = (SessionAcknowledgeMessage)packet;
                requiresResponse = message.isRequiresResponse();
                this.session.acknowledge(message.getConsumerID(), message.getMessageID());
                if (requiresResponse) {
                    response = new NullResponseMessage();
                }
            }
            catch (ActiveMQIOErrorException e) {
                response = ServerSessionPacketHandler.onActiveMQIOErrorExceptionWhileHandlePacket(e, requiresResponse, response, this.session);
            }
            catch (ActiveMQXAException e) {
                response = ServerSessionPacketHandler.onActiveMQXAExceptionWhileHandlePacket(e, requiresResponse, response);
            }
            catch (ActiveMQQueueMaxConsumerLimitReached e) {
                response = ServerSessionPacketHandler.onActiveMQQueueMaxConsumerLimitReachedWhileHandlePacket(e, requiresResponse, response);
            }
            catch (ActiveMQException e) {
                response = ServerSessionPacketHandler.onActiveMQExceptionWhileHandlePacket(e, requiresResponse, response);
            }
            catch (Throwable t) {
                response = ServerSessionPacketHandler.onCatchThrowableWhileHandlePacket(t, requiresResponse, response, this.session);
            }
            this.sendResponse(packet, response, false, false);
        }
        finally {
            this.storageManager.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSessionSend(Packet packet) {
        this.storageManager.setContext(this.session.getSessionContext());
        try {
            Packet response = null;
            boolean requiresResponse = false;
            try {
                SessionSendMessage message = (SessionSendMessage)packet;
                requiresResponse = message.isRequiresResponse();
                this.session.send(EmbedMessageUtil.extractEmbedded(message.getMessage()), this.direct);
                if (requiresResponse) {
                    response = new NullResponseMessage();
                }
            }
            catch (ActiveMQIOErrorException e) {
                response = ServerSessionPacketHandler.onActiveMQIOErrorExceptionWhileHandlePacket(e, requiresResponse, response, this.session);
            }
            catch (ActiveMQXAException e) {
                response = ServerSessionPacketHandler.onActiveMQXAExceptionWhileHandlePacket(e, requiresResponse, response);
            }
            catch (ActiveMQQueueMaxConsumerLimitReached e) {
                response = ServerSessionPacketHandler.onActiveMQQueueMaxConsumerLimitReachedWhileHandlePacket(e, requiresResponse, response);
            }
            catch (ActiveMQException e) {
                response = ServerSessionPacketHandler.onActiveMQExceptionWhileHandlePacket(e, requiresResponse, response);
            }
            catch (Throwable t) {
                response = ServerSessionPacketHandler.onCatchThrowableWhileHandlePacket(t, requiresResponse, response, this.session);
            }
            this.sendResponse(packet, response, false, false);
        }
        finally {
            this.storageManager.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSessionRequestProducerCredits(Packet packet) {
        this.storageManager.setContext(this.session.getSessionContext());
        try {
            Packet response = null;
            boolean requiresResponse = false;
            try {
                SessionRequestProducerCreditsMessage message = (SessionRequestProducerCreditsMessage)packet;
                this.session.requestProducerCredits(message.getAddress(), message.getCredits());
            }
            catch (ActiveMQIOErrorException e) {
                response = ServerSessionPacketHandler.onActiveMQIOErrorExceptionWhileHandlePacket(e, requiresResponse, response, this.session);
            }
            catch (ActiveMQXAException e) {
                response = ServerSessionPacketHandler.onActiveMQXAExceptionWhileHandlePacket(e, requiresResponse, response);
            }
            catch (ActiveMQQueueMaxConsumerLimitReached e) {
                response = ServerSessionPacketHandler.onActiveMQQueueMaxConsumerLimitReachedWhileHandlePacket(e, requiresResponse, response);
            }
            catch (ActiveMQException e) {
                response = ServerSessionPacketHandler.onActiveMQExceptionWhileHandlePacket(e, requiresResponse, response);
            }
            catch (Throwable t) {
                response = ServerSessionPacketHandler.onCatchThrowableWhileHandlePacket(t, requiresResponse, response, this.session);
            }
            this.sendResponse(packet, response, false, false);
        }
        finally {
            this.storageManager.clearContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSessionConsumerFlowCredit(Packet packet) {
        this.storageManager.setContext(this.session.getSessionContext());
        try {
            Packet response = null;
            boolean requiresResponse = false;
            try {
                SessionConsumerFlowCreditMessage message = (SessionConsumerFlowCreditMessage)packet;
                this.session.receiveConsumerCredits(message.getConsumerID(), message.getCredits());
            }
            catch (ActiveMQIOErrorException e) {
                response = ServerSessionPacketHandler.onActiveMQIOErrorExceptionWhileHandlePacket(e, requiresResponse, response, this.session);
            }
            catch (ActiveMQXAException e) {
                response = ServerSessionPacketHandler.onActiveMQXAExceptionWhileHandlePacket(e, requiresResponse, response);
            }
            catch (ActiveMQQueueMaxConsumerLimitReached e) {
                response = ServerSessionPacketHandler.onActiveMQQueueMaxConsumerLimitReachedWhileHandlePacket(e, requiresResponse, response);
            }
            catch (ActiveMQException e) {
                response = ServerSessionPacketHandler.onActiveMQExceptionWhileHandlePacket(e, requiresResponse, response);
            }
            catch (Throwable t) {
                response = ServerSessionPacketHandler.onCatchThrowableWhileHandlePacket(t, requiresResponse, response, this.session);
            }
            this.sendResponse(packet, response, false, false);
        }
        finally {
            this.storageManager.clearContext();
        }
    }

    private static Packet onActiveMQIOErrorExceptionWhileHandlePacket(ActiveMQIOErrorException e, boolean requiresResponse, Packet response, ServerSession session) {
        session.markTXFailed(e);
        if (requiresResponse) {
            logger.debug((Object)"Sending exception to client", (Throwable)e);
            response = new ActiveMQExceptionMessage((ActiveMQException)((Object)e));
        } else {
            ActiveMQServerLogger.LOGGER.caughtException(e);
        }
        return response;
    }

    private static Packet onActiveMQXAExceptionWhileHandlePacket(ActiveMQXAException e, boolean requiresResponse, Packet response) {
        if (requiresResponse) {
            logger.debug((Object)"Sending exception to client", (Throwable)e);
            response = new SessionXAResponseMessage(true, e.errorCode, e.getMessage());
        } else {
            ActiveMQServerLogger.LOGGER.caughtXaException((Exception)((Object)e));
        }
        return response;
    }

    private static Packet onActiveMQQueueMaxConsumerLimitReachedWhileHandlePacket(ActiveMQQueueMaxConsumerLimitReached e, boolean requiresResponse, Packet response) {
        if (requiresResponse) {
            logger.debug((Object)"Sending exception to client", (Throwable)e);
            response = new ActiveMQExceptionMessage((ActiveMQException)((Object)e));
        } else {
            ActiveMQServerLogger.LOGGER.caughtException(e);
        }
        return response;
    }

    private static Packet onActiveMQExceptionWhileHandlePacket(ActiveMQException e, boolean requiresResponse, Packet response) {
        if (requiresResponse) {
            logger.debug((Object)"Sending exception to client", (Throwable)e);
            response = new ActiveMQExceptionMessage(e);
        } else if (e.getType() == ActiveMQExceptionType.QUEUE_EXISTS) {
            logger.debug((Object)"Caught exception", (Throwable)e);
        } else {
            ActiveMQServerLogger.LOGGER.caughtException(e);
        }
        return response;
    }

    private static Packet onCatchThrowableWhileHandlePacket(Throwable t, boolean requiresResponse, Packet response, ServerSession session) {
        session.markTXFailed(t);
        if (requiresResponse) {
            ActiveMQServerLogger.LOGGER.warn("Sending unexpected exception to the client", t);
            ActiveMQInternalErrorException activeMQInternalErrorException = new ActiveMQInternalErrorException();
            activeMQInternalErrorException.initCause(t);
            response = new ActiveMQExceptionMessage((ActiveMQException)activeMQInternalErrorException);
        } else {
            ActiveMQServerLogger.LOGGER.caughtException(t);
        }
        return response;
    }

    private void sendResponse(final Packet confirmPacket, final Packet response, final boolean flush, final boolean closeChannel) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ServerSessionPacketHandler::scheduling response::" + response));
        }
        this.storageManager.afterCompleteOperations(new IOCallback(){

            public void onError(int errorCode, String errorMessage) {
                ActiveMQServerLogger.LOGGER.errorProcessingIOCallback(errorCode, errorMessage);
                ActiveMQExceptionMessage exceptionMessage = new ActiveMQExceptionMessage(ActiveMQExceptionType.createException((int)errorCode, (String)errorMessage));
                ServerSessionPacketHandler.this.doConfirmAndResponse(confirmPacket, (Packet)exceptionMessage, flush, closeChannel);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("ServerSessionPacketHandler::exception response sent::" + exceptionMessage));
                }
            }

            public void done() {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("ServerSessionPacketHandler::regular response sent::" + response));
                }
                ServerSessionPacketHandler.this.doConfirmAndResponse(confirmPacket, response, flush, closeChannel);
            }
        });
    }

    private void doConfirmAndResponse(Packet confirmPacket, Packet response, boolean flush, boolean closeChannel) {
        if (confirmPacket != null) {
            this.channel.confirm(confirmPacket);
            if (flush) {
                this.channel.flushConfirmations();
            }
        }
        if (response != null) {
            this.channel.send(response);
        }
        if (closeChannel) {
            this.channel.close();
        }
    }

    public void closeListeners() {
        List listeners = this.remotingConnection.removeCloseListeners();
        for (CloseListener closeListener : listeners) {
            closeListener.connectionClosed();
            if (!(closeListener instanceof FailureListener)) continue;
            this.remotingConnection.removeFailureListener((FailureListener)closeListener);
        }
        this.flushExecutor();
    }

    public int transferConnection(CoreRemotingConnection newConnection, int lastReceivedCommandID) {
        SimpleFutureImpl future = new SimpleFutureImpl();
        this.callExecutor.execute(() -> this.lambda$transferConnection$1(newConnection, lastReceivedCommandID, (SimpleFuture)future));
        try {
            return (Integer)future.get();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private int internaltransferConnection(CoreRemotingConnection newConnection, int lastReceivedCommandID) {
        this.session.setTransferring(true);
        List closeListeners = this.remotingConnection.removeCloseListeners();
        List failureListeners = this.remotingConnection.removeFailureListeners();
        this.channel.transferConnection(newConnection);
        newConnection.syncIDGeneratorSequence(this.remotingConnection.getIDGeneratorSequence());
        Connection oldTransportConnection = this.remotingConnection.getTransportConnection();
        this.remotingConnection = newConnection;
        this.remotingConnection.setCloseListeners(closeListeners);
        this.remotingConnection.setFailureListeners(failureListeners);
        int serverLastReceivedCommandID = this.channel.getLastConfirmedCommandID();
        this.channel.replayCommands(lastReceivedCommandID);
        this.channel.setTransferring(false);
        this.session.setTransferring(false);
        oldTransportConnection.fireReady(true);
        return serverLastReceivedCommandID;
    }

    private void sendLarge(Message message) throws Exception {
        long id = this.storageManager.generateID();
        LargeServerMessage largeMsg = this.storageManager.createLargeMessage(id, message);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("sendLarge::" + largeMsg));
        }
        if (this.currentLargeMessage != null) {
            ActiveMQServerLogger.LOGGER.replacingIncompleteLargeMessage(this.currentLargeMessage.getMessageID());
        }
        this.currentLargeMessage = largeMsg;
    }

    private void sendContinuations(int packetSize, long messageBodySize, byte[] body, boolean continues) throws Exception {
        if (this.currentLargeMessage == null) {
            throw ActiveMQMessageBundle.BUNDLE.largeMessageNotInitialised();
        }
        this.currentLargeMessage.addBytes(body);
        if (!continues) {
            this.currentLargeMessage.releaseResources();
            if (messageBodySize >= 0L) {
                this.currentLargeMessage.putLongProperty(Message.HDR_LARGE_BODY_SIZE, messageBodySize);
            }
            this.session.doSend(this.session.getCurrentTransaction(), (Message)this.currentLargeMessage, null, false, false);
            this.currentLargeMessage = null;
        }
    }

    private /* synthetic */ void lambda$transferConnection$1(CoreRemotingConnection newConnection, int lastReceivedCommandID, SimpleFuture future) {
        int value = this.internaltransferConnection(newConnection, lastReceivedCommandID);
        future.set((Object)value);
    }
}

