/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config;

import java.io.Serializable;

public class WildcardConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final char SINGLE_WORD = '*';
    static final char ANY_WORDS = '#';
    static final char DELIMITER = '.';
    boolean routingEnabled = true;
    char singleWord = (char)42;
    char anyWords = (char)35;
    char delimiter = (char)46;
    String singleWordString = String.valueOf(this.singleWord);
    String anyWordsString = String.valueOf(this.anyWords);
    String delimiterString = String.valueOf(this.delimiter);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WildcardConfiguration)) {
            return false;
        }
        WildcardConfiguration that = (WildcardConfiguration)o;
        if (this.routingEnabled != that.routingEnabled) {
            return false;
        }
        if (this.singleWord != that.singleWord) {
            return false;
        }
        if (this.anyWords != that.anyWords) {
            return false;
        }
        return this.delimiter == that.delimiter;
    }

    public int hashCode() {
        int result = this.routingEnabled ? 1 : 0;
        result = 31 * result + this.singleWord;
        result = 31 * result + this.anyWords;
        result = 31 * result + this.delimiter;
        return result;
    }

    public String toString() {
        return "WildcardConfiguration{routingEnabled=" + this.routingEnabled + ", anyWords=" + this.anyWords + ", singleWord=" + this.singleWord + ", delimiter=" + this.delimiter + "}";
    }

    public boolean isRoutingEnabled() {
        return this.routingEnabled;
    }

    public void setRoutingEnabled(boolean routingEnabled) {
        this.routingEnabled = routingEnabled;
    }

    public char getAnyWords() {
        return this.anyWords;
    }

    public String getAnyWordsString() {
        return this.anyWordsString;
    }

    public void setAnyWords(char anyWords) {
        this.anyWords = anyWords;
        this.anyWordsString = String.valueOf(anyWords);
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public String getDelimiterString() {
        return this.delimiterString;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
        this.delimiterString = String.valueOf(delimiter);
    }

    public char getSingleWord() {
        return this.singleWord;
    }

    public String getSingleWordString() {
        return this.singleWordString;
    }

    public void setSingleWord(char singleWord) {
        this.singleWord = singleWord;
        this.singleWordString = String.valueOf(singleWord);
    }

    public String convert(String filter, WildcardConfiguration to) {
        return filter.replace(this.getDelimiter(), to.getDelimiter()).replace(this.getSingleWord(), to.getSingleWord()).replace(this.getAnyWords(), to.getAnyWords());
    }
}

