/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import io.netty.channel.Channel;
import java.io.File;
import java.io.Serializable;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.BackupReplicationStartFailedMessage;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.cluster.Bridge;
import org.apache.activemq.artemis.core.server.cluster.impl.BridgeImpl;
import org.apache.activemq.artemis.core.server.cluster.impl.ClusterConnectionImpl;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.ServerSessionImpl;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.utils.FutureLatch;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.w3c.dom.Node;

public class ActiveMQServerLogger_$logger
extends DelegatingBasicLogger
implements ActiveMQServerLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ActiveMQServerLogger_$logger.class.getName();
    private static final String interruptWhilstStoppingComponent = "AMQ223000: Received Interrupt Exception whilst waiting for component to shutdown: {0}";
    private static final String serverStarting = "AMQ221000: {0} Message Broker is starting with configuration {1}";
    private static final String serverStarted = "AMQ221001: Apache ActiveMQ Artemis Message Broker version {0} [{1}, nodeID={2}] {3}";
    private static final String serverStopped = "AMQ221002: Apache ActiveMQ Artemis Message Broker version {0} [{1}] stopped, uptime {2}";
    private static final String deployQueue = "AMQ221003: Deploying queue {0}";
    private static final String dumpServerInfo = "AMQ221004: {0}";
    private static final String deletingPendingMessage = "AMQ221005: Deleting pending large message as it was not completed: {0}";
    private static final String awaitingLiveLock = "AMQ221006: Waiting to obtain live lock";
    private static final String serverIsLive0 = "AMQ221007: Server is now live";
    private static final String awaitFailBack = "AMQ221008: live server wants to restart, restarting server in backup";
    private static final String backupServerStarted = "AMQ221109: Apache ActiveMQ Artemis Backup Server version {0} [{1}] started, waiting live to fail before it gets active";
    private static final String backupServerIsLive = "AMQ221010: Backup Server is now live";
    private static final String serverIsLive1 = "AMQ221011: Server {0} is now live";
    private static final String journalUseAIO = "AMQ221012: Using AIO Journal";
    private static final String journalUseNIO = "AMQ221013: Using NIO Journal";
    private static final String percentLoaded = "AMQ221014: {0}% loaded";
    private static final String journalCannotFindQueueReloading = "AMQ221015: Can not find queue {0} while reloading ACKNOWLEDGE_CURSOR, deleting record now";
    private static final String journalCannotFindQueueReloadingPage = "AMQ221016: Can not find queue {0} while reloading PAGE_CURSOR_COUNTER_VALUE, deleting record now";
    private static final String journalCannotFindQueueReloadingPageCursor = "AMQ221017: Can not find queue {0} while reloading PAGE_CURSOR_COUNTER_INC, deleting record now";
    private static final String largeMessageWithNoRef = "AMQ221018: Large message: {0} did not have any associated reference, file will be deleted";
    private static final String journalUnreferencedMessage = "AMQ221019: Deleting unreferenced message id={0} from the journal";
    private static final String startedAcceptor = "AMQ221020: Started {0} Acceptor at {1}:{2,number,#} for protocols [{3}]";
    private static final String errorRemovingConnection = "AMQ221021: failed to remove connection";
    private static final String errorStartingConnectorService = "AMQ221022: unable to start connector service: {0}";
    private static final String errorStoppingConnectorService = "AMQ221023: unable to stop connector service: {0}";
    private static final String backupServerSynched = "AMQ221024: Backup server {0} is synchronized with live-server.";
    private static final String replicaSyncFile = "AMQ221025: Replication: sending {0} (size={1}) to replica.";
    private static final String bridgeNoBindings = "AMQ221026: Bridge {0} connected to forwardingAddress={1}. {2} does not have any bindings. Messages will be ignored until a binding is created.";
    private static final String bridgeConnected = "AMQ221027: Bridge {0} is connected";
    private static final String bridgeStopping = "AMQ221028: Bridge is stopping, will not retry";
    private static final String bridgeStopped = "AMQ221029: stopped bridge {0}";
    private static final String bridgePaused = "AMQ221030: paused bridge {0}";
    private static final String backupAnnounced = "AMQ221031: backup announced";
    private static final String waitingToBecomeBackup = "AMQ221032: Waiting to become backup node";
    private static final String gotBackupLock = "AMQ221033: ** got backup lock";
    private static final String waitingToObtainLiveLock = "AMQ221034: Waiting {0} to obtain live lock";
    private static final String obtainedLiveLock = "AMQ221035: Live Server Obtained live lock";
    private static final String messageWithDuplicateID = "AMQ221036: Message with duplicate ID {0} was already set at {1}. Move from {2} being ignored and message removed from {3}";
    private static final String becomingLive = "AMQ221037: {0} to become ''live''";
    private static final String deprecatedConfigurationOption = "AMQ221038: Configuration option ''{0}'' is deprecated. Consult the manual for details.";
    private static final String restartingReplicatedBackupAfterFailback = "AMQ221039: Restarting as Replicating backup server after live restart";
    private static final String remoteGroupCoordinatorsNotStarted = "AMQ221040: Remote group coordinators has not started.";
    private static final String cantFindQueueOnPageComplete = "AMQ221041: Cannot find queue {0} while reloading PAGE_CURSOR_COMPLETE, deleting record now";
    private static final String timedOutWaitingCompletions = "AMQ221042: Bridge {0} timed out waiting for the completion of {1} messages, we will just shutdown the bridge after 10 seconds wait";
    private static final String addingProtocolSupport = "AMQ221043: Protocol module found: [{1}]. Adding protocol support for: {0}";
    private static final String switchingNIO = "AMQ221045: libaio is not available, switching the configuration into NIO";
    private static final String unblockingMessageProduction = "AMQ221046: Unblocking message production on address ''{0}''; size is currently: {1} bytes; max-size-bytes: {2}";
    private static final String backupServerScaledDown = "AMQ221047: Backup Server has scaled down to live server";
    private static final String slowConsumerDetected = "AMQ221048: Consumer {0}:{1} attached to queue ''{2}'' from {3} identified as ''slow.'' Expected consumption rate: {4} msgs/second; actual consumption rate: {5} msgs/second.";
    private static final String activatingReplica = "AMQ221049: Activating Replica for node: {0}";
    private static final String activatingSharedStoreSlave = "AMQ221050: Activating Shared Store Slave";
    private static final String populatingSecurityRolesFromLDAP = "AMQ221051: Populating security roles from LDAP at: {0}";
    private static final String deployTopic = "AMQ221052: Deploying topic {0}";
    private static final String disallowedProtocol = "AMQ221053: Disallowing use of vulnerable protocol ''{0}'' on acceptor ''{1}''. See http://www.oracle.com/technetwork/topics/security/poodlecve-2014-3566-2339408.html for more details.";
    private static final String switchingNIOonPath = "AMQ221054: libaio was found but the filesystem does not support AIO. Switching the configuration into NIO. Journal path: {0}";
    private static final String removingBackupData = "AMQ221055: There were too many old replicated folders upon startup, removing {0}";
    private static final String reloadingConfiguration = "AMQ221056: Reloading configuration ...{0}";
    private static final String usingDefaultPaging = "AMQ221057: Global Max Size is being adjusted to 1/2 of the JVM max size (-Xmx). being defined as {0}";
    private static final String invalidJournalFileSize = "AMQ221058: resetting Journal File size from {0} to {1} to fit with alignment of {2}";
    private static final String backupDeletingData = "AMQ221059: Deleting old data directory {0} as the max folders is set to 0";
    private static final String sendingQuorumVoteRequest = "AMQ221060: Sending quorum vote request to {0}: {1}";
    private static final String receivedQuorumVoteResponse = "AMQ221061: Received quorum vote response from {0}: {1}";
    private static final String receivedQuorumVoteRequest = "AMQ221062: Received quorum vote request: {0}";
    private static final String sendingQuorumVoteResponse = "AMQ221063: Sending quorum vote response: {0}";
    private static final String nodeFoundInClusterTopology = "AMQ221064: Node {0} found in cluster topology";
    private static final String nodeNotFoundInClusterTopology = "AMQ221065: Node {0} not found in cluster topology";
    private static final String initiatingQuorumVote = "AMQ221066: Initiating quorum vote: {0}";
    private static final String waitingForQuorumVoteResults = "AMQ221067: Waiting {0} {1} for quorum vote results.";
    private static final String receivedAllQuorumVotes = "AMQ221068: Received all quorum votes.";
    private static final String timeoutWaitingForQuorumVoteResponses = "AMQ221069: Timeout waiting for quorum vote responses.";
    private static final String restartingAsBackupBasedOnQuorumVoteResults = "AMQ221070: Restarting as backup based on quorum vote results.";
    private static final String failingOverBasedOnQuorumVoteResults = "AMQ221071: Failing over based on quorum vote results.";
    private static final String serverFinalisedWIthoutBeingSTopped = "AMQ222000: ActiveMQServer is being finalized and has not been stopped. Please remember to stop the server before letting it go out of scope";
    private static final String errorClosingSessionsWhileStoppingServer = "AMQ222001: Error closing sessions while stopping server";
    private static final String timedOutStoppingThreadpool = "AMQ222002: Timed out waiting for pool to terminate {0}. Interrupting all its threads!";
    private static final String divertWithNoAddress = "AMQ222004: Must specify an address for each divert. This one will not be deployed.";
    private static final String divertWithNoForwardingAddress = "AMQ222005: Must specify a forwarding address for each divert. This one will not be deployed.";
    private static final String divertBindingAlreadyExists = "AMQ222006: Binding already exists with name {0}, divert will not be deployed";
    private static final String clusterSecurityRisk = "AMQ222007: Security risk! Apache ActiveMQ Artemis is running with the default cluster admin user and default password. Please see the cluster chapter in the ActiveMQ Artemis User Guide for instructions on how to change this.";
    private static final String serverRestartWarning = "AMQ222008: unable to restart server, please kill and restart manually";
    private static final String replicationStartProblem = "AMQ222009: Unable to announce backup for replication. Trying to stop the server.";
    private static final String ioCriticalIOError = "AMQ222010: Critical IO Error, shutting down the server. file={1}, message={0}";
    private static final String errorStoppingServer = "AMQ222011: Error stopping server";
    private static final String backupActivationProblem = "AMQ222012: Timed out waiting for backup activation to exit";
    private static final String errorStartingReplication0 = "AMQ222013: Error when trying to start replication";
    private static final String errorStoppingReplication = "AMQ222014: Error when trying to stop replication";
    private static final String connectorWithNoName = "AMQ222016: Cannot deploy a connector with no name specified.";
    private static final String connectorAlreadyDeployed = "AMQ222017: There is already a connector with name {0} deployed. This one will not be deployed.";
    private static final String AIONotFound = "AMQ222018: AIO was not located on this platform, it will fall back to using pure Java NIO. If your platform is Linux, install LibAIO to enable the AIO journal";
    private static final String discoveryGroupAlreadyDeployed = "AMQ222019: There is already a discovery group with name {0} deployed. This one will not be deployed.";
    private static final String errorScanningURLs = "AMQ222020: error scanning for URL''s";
    private static final String problemUndeployingNode = "AMQ222021: problem undeploying {0}";
    private static final String timedOutStoppingPagingCursor = "AMQ222022: Timed out waiting for paging cursor to stop {0} {1}";
    private static final String problemCleaningPageAddress = "AMQ222023: problem cleaning page address {0}";
    private static final String problemCompletingOperations = "AMQ222024: Could not complete operations on IO context {0}";
    private static final String problemCleaningPagesubscriptionCounter = "AMQ222025: Problem cleaning page subscription counter";
    private static final String problemCleaningCursorPages = "AMQ222026: Error on cleaning up cursor pages";
    private static final String timedOutFlushingExecutorsPagingCursor = "AMQ222027: Timed out flushing executors for paging cursor to stop {0}";
    private static final String pageNotFound = "AMQ222028: Could not find page cache for page {0} removing it from the journal";
    private static final String pageSubscriptionCouldntLoad = "AMQ222029: Could not locate page transaction {0}, ignoring message on position {1} on address={2} queue={3}";
    private static final String pageInvalid = "AMQ222030: File {0} being renamed to {1}.invalidPage as it was loaded partially. Please verify your data.";
    private static final String pageDeleteError = "AMQ222031: Error while deleting page file";
    private static final String pageFinaliseError = "AMQ222032: page finalise error";
    private static final String pageSuspectFile = "AMQ222033: Page file {0} had incomplete records at position {1} at record number {2}";
    private static final String pageTxDeleteError = "AMQ222034: Can not delete page transaction id={0}";
    private static final String pageStoreFactoryNoIdFile = "AMQ222035: Directory {0} did not have an identification file {1}";
    private static final String pageStoreTimeout = "AMQ222036: Timed out on waiting PagingStore {0} to shutdown";
    private static final String pageStoreStartIOError = "AMQ222037: IO Error, impossible to start paging";
    private static final String pageStoreStart = "AMQ222038: Starting paging on address ''{0}''; size is currently: {1} bytes; max-size-bytes: {2}";
    private static final String pageStoreDropMessages = "AMQ222039: Messages sent to address ''{0}'' are being dropped; size is currently: {1} bytes; max-size-bytes: {2}";
    private static final String serverIsStopped = "AMQ222040: Server is stopped";
    private static final String journalCannotFindQueueDelCount = "AMQ222041: Cannot find queue {0} to update delivery count";
    private static final String journalCannotFindMessageDelCount = "AMQ222042: Cannot find message {0} to update delivery count";
    private static final String journalCannotFindQueueForMessage = "AMQ222043: Message for queue {0} which does not exist. This message will be ignored.";
    private static final String journalErrorDeletingMessage = "AMQ222044: It was not possible to delete message {0}";
    private static final String journalMessageInPreparedTX = "AMQ222045: Message in prepared tx for queue {0} which does not exist. This message will be ignored.";
    private static final String journalErrorRemovingRef = "AMQ222046: Failed to remove reference for {0}";
    private static final String journalCannotFindQueueReloadingACK = "AMQ222047: Can not find queue {0} while reloading ACKNOWLEDGE_CURSOR";
    private static final String journalPAGEOnPrepared = "AMQ222048: PAGE_CURSOR_COUNTER_VALUE record used on a prepared statement, invalid state";
    private static final String journalInvalidRecordType = "AMQ222049: InternalError: Record type {0} not recognized. Maybe you are using journal files created on a different version";
    private static final String journalInvalidRecordTypeOnPreparedTX = "AMQ222050: Can not locate recordType={0} on loadPreparedTransaction//deleteRecords";
    private static final String journalError = "AMQ222051: Journal Error";
    private static final String errorIncrementDelayDeletionCount = "AMQ222052: error incrementing delay detection";
    private static final String lareMessageErrorCopying = "AMQ222053: Error on copying large message {0} for DLA or Expiry";
    private static final String errorExecutingAIOCallback = "AMQ222054: Error on executing IOCallback";
    private static final String errorDeletingDuplicateCache = "AMQ222055: Error on deleting duplicate cache";
    private static final String noDLA = "AMQ222056: Did not route to any bindings for address {0} and sendToDLAOnNoRoute is true but there is no DLA configured for the address, the message will be ignored.";
    private static final String ioErrorAddingReferences = "AMQ222057: It was not possible to add references due to an IO error code {0} message = {1}";
    private static final String duplicateMessageDetected = "AMQ222059: Duplicate message detected - message will not be routed. Message information:\n{0}";
    private static final String journalErrorConfirmingLargeMessage = "AMQ222060: Error while confirming large message completion on rollback for recordID={0}";
    private static final String clientConnectionFailed = "AMQ222061: Client connection failed, clearing up resources for session {0}";
    private static final String clearingUpSession = "AMQ222062: Cleared up resources for session {0}";
    private static final String errorProcessingIOCallback = "AMQ222063: Error processing IOCallback code = {0} message = {1}";
    private static final String incompatibleVersionAfterConnect = "AMQ222065: Client is not being consistent on the request versioning. It just sent a version id={0} while it informed {1} previously";
    private static final String reattachRequestFailed = "AMQ222066: Reattach request from {0} failed as there is no confirmationWindowSize configured, which may be ok for your system";
    private static final String connectionFailureDetected = "AMQ222067: Connection failure has been detected: {0} [code={1}]";
    private static final String errorCleaningStompConn = "AMQ222069: error cleaning up stomp connection";
    private static final String stompTXAckNorSupported = "AMQ222070: Stomp Transactional acknowledgement is not supported";
    private static final String errorOnStompHeartBeat = "AMQ222071: Interrupted while waiting for stomp heartbeat to die";
    private static final String timedOutFlushingInvmChannel = "AMQ222072: Timed out flushing channel on InVMConnection";
    private static final String nettyChannelGroupError = "AMQ212074: channel group did not completely close";
    private static final String nettyChannelStillOpen = "AMQ222075: {0} is still connected to {1}";
    private static final String nettyChannelGroupBindError = "AMQ222076: channel group did not completely unbind";
    private static final String nettyChannelStillBound = "AMQ222077: {0} is still bound to {1}";
    private static final String errorCreatingRemotingInterceptor = "AMQ222078: Error instantiating remoting interceptor {0}";
    private static final String invalidAcceptorKeys = "AMQ222079: The following keys are invalid for configuring the acceptor: {0} the acceptor will not be started.";
    private static final String errorCreatingAcceptor = "AMQ222080: Error instantiating remoting acceptor {0}";
    private static final String timeoutRemotingThreadPool = "AMQ222081: Timed out waiting for remoting thread pool to terminate";
    private static final String errorOnFailureCheck = "AMQ222082: error on connection failure check";
    private static final String connectorKeysInvalid = "AMQ222083: The following keys are invalid for configuring the connector service: {0} the connector will not be started.";
    private static final String connectorKeysMissing = "AMQ222084: The following keys are required for configuring the connector service: {0} the connector will not be started.";
    private static final String invalidPacketForReplication = "AMQ222085: Packet {0} can not be processed by the ReplicationEndpoint";
    private static final String errorHandlingReplicationPacket = "AMQ222086: error handling packet {0} for replication";
    private static final String errorClosingPageOnReplication = "AMQ222087: Replication Error while closing the page on backup";
    private static final String journalcomparisonMismatch = "AMQ222088: Journal comparison mismatch:\n{0}";
    private static final String errorDeletingLargeMessage = "AMQ222089: Replication Error deleting large message ID = {0}";
    private static final String largeMessageNotAvailable = "AMQ222090: Replication Large MessageID {0}  is not available on backup server. Ignoring replication message";
    private static final String replicationStopOnBackupShutdown = "AMQ222091: The backup node has been shut-down, replication will now stop";
    private static final String replicationStopOnBackupFail = "AMQ222092: Connection to the backup node failed, removing replication now";
    private static final String timedOutWaitingToStopBridge = "AMQ222093: Timed out waiting to stop Bridge";
    private static final String bridgeUnableToSendMessage = "AMQ222094: Bridge unable to send message {0}, will try again once bridge reconnects";
    private static final String bridgeConnectionFailed = "AMQ222095: Connection failed with failedOver={0}";
    private static final String errorQueryingBridge1 = "AMQ222096: Error on querying binding on bridge {0}. Retrying in 100 milliseconds";
    private static final String errorQueryingBridge2 = "AMQ222097: Address {0} does not have any bindings, retry #({1})";
    private static final String errorStartingBridge = "AMQ222098: Server is starting, retry to create the session for bridge {0}";
    private static final String errorConnectingBridge = "AMQ222099: Bridge {0} is unable to connect to destination. It will be disabled.";
    private static final String bridgeLocatorShutdown = "AMQ222100: ServerLocator was shutdown, can not retry on opening connection for bridge";
    private static final String bridgeAbortStart = "AMQ222101: Bridge {0} achieved {1} maxattempts={2} it will stop retrying to reconnect";
    private static final String errorReConnecting = "AMQ222102: Unexpected exception while trying to reconnect";
    private static final String timedOutXID = "AMQ222103: transaction with xid {0} timed out";
    private static final String ioErrorOnTX = "AMQ222104: IO Error completing the transaction, code = {0}, message = {1}";
    private static final String errorCompletingContext = "AMQ222105: Could not finish context execution in 10 seconds";
    private static final String replacingIncompleteLargeMessage = "AMQ222106: Replacing incomplete LargeMessage with ID={0}";
    private static final String clientConnectionFailedClearingSession = "AMQ222107: Cleared up resources for session {0}";
    private static final String broadcastGroupClosed = "AMQ222108: unable to send notification when broadcast group is stopped";
    private static final String timeoutLockingConsumer = "AMQ222109: Timed out waiting for write lock on consumer. Check the Thread dump";
    private static final String noQueueIdDefined = "AMQ222110: no queue IDs defined!,  originalMessage  = {0}, copiedMessage = {1}, props={2}";
    private static final String managementOperationError = "AMQ222111: exception while invoking {0} on {1}";
    private static final String managementAttributeError = "AMQ222112: exception while retrieving attribute {0} on {1}";
    private static final String managementStopError = "AMQ222113: On ManagementService stop, there are {0} unexpected registered MBeans: {1}";
    private static final String unableToDeleteGroupBindings = "AMQ222114: Unable to delete group binding info {0}";
    private static final String errorClosingServerLocator = "AMQ222115: Error closing serverLocator={0}";
    private static final String unableToStartBroadcastGroup = "AMQ222116: unable to start broadcast group {0}";
    private static final String unableToStartClusterConnection = "AMQ222117: unable to start cluster connection {0}";
    private static final String unableToStartBridge = "AMQ222118: unable to start Bridge {0}";
    private static final String announceBackupNoConnector = "AMQ222119: No connector with name {0}. backup cannot be announced.";
    private static final String announceBackupNoClusterConnections = "AMQ222120: no cluster connections defined, unable to announce backup";
    private static final String bridgeNotUnique = "AMQ222121: Must specify a unique name for each bridge. This one will not be deployed.";
    private static final String bridgeNoQueue = "AMQ222122: Must specify a queue name for each bridge. This one {0} will not be deployed.";
    private static final String bridgeNoForwardAddress = "AMQ222123: Forward address is not specified on bridge {0}. Will use original message address instead";
    private static final String bridgeAlreadyDeployed = "AMQ222124: There is already a bridge with name {0} deployed. This one will not be deployed.";
    private static final String bridgeQueueNotFound = "AMQ222125: No queue found with name {0} bridge {1} will not be deployed.";
    private static final String bridgeNoDiscoveryGroup = "AMQ222126: No discovery group found with name {0} bridge will not be deployed.";
    private static final String clusterConnectionNotUnique = "AMQ222127: Must specify a unique name for each cluster connection. This one will not be deployed.";
    private static final String clusterConnectionNoForwardAddress = "AMQ222128: Must specify an address for each cluster connection. This one will not be deployed.";
    private static final String clusterConnectionNoConnector = "AMQ222129: No connector with name {0}. The cluster connection will not be deployed.";
    private static final String clusterConnectionAlreadyExists = "AMQ222130: Cluster Configuration  {0} already exists. The cluster connection will not be deployed.";
    private static final String clusterConnectionNoDiscoveryGroup = "AMQ222131: No discovery group with name {0}. The cluster connection will not be deployed.";
    private static final String broadcastGroupAlreadyExists = "AMQ222132: There is already a broadcast-group with name {0} deployed. This one will not be deployed.";
    private static final String broadcastGroupNoConnector = "AMQ222133: There is no connector deployed with name {0}. The broadcast group with name {1} will not be deployed.";
    private static final String noConnector = "AMQ222134: No connector defined with name {0}. The bridge will not be deployed.";
    private static final String errorStoppingRedistributor = "AMQ222135: Stopping Redistributor, Timed out waiting for tasks to complete";
    private static final String ioErrorRedistributing = "AMQ222136: IO Error during redistribution, errorCode = {0} message = {1}";
    private static final String errorAnnouncingBackup = "AMQ222137: Unable to announce backup, retrying";
    private static final String noLocalMemborOnClusterConnection = "AMQ222138: Local Member is not set at on ClusterConnection {0}";
    private static final String remoteQueueAlreadyBoundOnClusterConnection = "AMQ222139: {0}::Remote queue binding {1} has already been bound in the post office. Most likely cause for this is you have a loop in your cluster due to cluster max-hops being too large or you have multiple cluster connections to the same nodes using overlapping addresses";
    private static final String nodeManagerCantOpenFile = "AMQ222141: Node Manager can not open file {0}";
    private static final String errorResttingLargeMessage = "AMQ222142: Error on resetting large message deliver - {0}";
    private static final String errorTransferringConsumer = "AMQ222143: Timed out waiting for executor to complete";
    private static final String errorFlushingExecutorsOnQueue = "AMQ222144: Queue could not finish waiting executors. Try increasing the thread pool size";
    private static final String errorExpiringReferencesOnQueue = "AMQ222145: Error expiring reference {0} 0n queue";
    private static final String errorExpiringReferencesNoBindings = "AMQ222146: Message has expired. No bindings for Expiry Address {0} so dropping it";
    private static final String errorExpiringReferencesNoQueue = "AMQ222147: Messages are being expired on queue{0}. However there is no expiry queue configured, hence messages will be dropped.";
    private static final String messageExceededMaxDelivery = "AMQ222148: Message {0} has exceeded max delivery attempts. No bindings for Dead Letter Address {1} so dropping it";
    private static final String messageExceededMaxDeliverySendtoDLA = "AMQ222149: Message {0} has reached maximum delivery attempts, sending it to Dead Letter Address {1} from {2}";
    private static final String messageExceededMaxDeliveryNoDLA = "AMQ222150: Message {0} has exceeded max delivery attempts. No Dead Letter Address configured for queue {1} so dropping it";
    private static final String removingBadConsumer = "AMQ222151: removing consumer which did not handle a message, consumer={0}, message={1}";
    private static final String errorDecrementingRefCount = "AMQ222152: Unable to decrement reference counting on queue";
    private static final String errorRemovingMessage = "AMQ222153: Unable to remove message id = {0} please remove manually";
    private static final String errorCheckingDLQ = "AMQ222154: Error checking DLQ";
    private static final String errorRegisteringBackup = "AMQ222155: Failed to register as backup. Stopping the server.";
    private static final String memoryError = "AMQ222156: Less than {0}%\n{1}\nYou are in danger of running out of RAM. Have you set paging parameters on your addresses? (See user manual \"Paging\" chapter)";
    private static final String errorCompletingCallbackOnReplicationManager = "AMQ222157: Error completing callback on replication manager";
    private static final String activationDidntFinish = "AMQ222158: {0} activation thread did not finish.";
    private static final String broadcastBridgeStoppedError = "AMQ222159: unable to send notification when broadcast group is stopped";
    private static final String notificationBridgeStoppedError = "AMQ222160: unable to send notification when broadcast group is stopped";
    private static final String groupHandlerSendTimeout = "AMQ222161: Group Handler timed-out waiting for sendCondition";
    private static final String backupMovingDataAway = "AMQ222162: Moving data directory {0} to {1}";
    private static final String stopReplicatedBackupAfterFailback = "AMQ222163: Server is being completely stopped, since this was a replicated backup there may be journal files that need cleaning up. The Apache ActiveMQ Artemis broker will have to be manually restarted.";
    private static final String errorStartingReplication1 = "AMQ222164: Error when trying to start replication {0}";
    private static final String AddressSettingsNoDLA = "AMQ222165: No Dead Letter Address configured for queue {0} in AddressSettings";
    private static final String AddressSettingsNoExpiryAddress = "AMQ222166: No Expiry Address configured for queue {0} in AddressSettings";
    private static final String groupingQueueRemoved = "AMQ222167: Group Binding not available so deleting {0} groups from {1}, groups will be bound to another node";
    private static final String warnDeprecatedProtocol = "AMQ222168: The ''protocol'' property is deprecated. If you want this Acceptor to support multiple protocols, use the ''protocols'' property, e.g. with value ''CORE,AMQP,STOMP''";
    private static final String warnDisconnectOldClient = "AMQ222169: You have old legacy clients connected to the queue {0} and we can''t disconnect them, these clients may just hang";
    private static final String bridgeConfirmationWindowTooSmall = "AMQ222170: Bridge {0} forwarding address {1} has confirmation-window-size ({2}) greater than address'' max-size-bytes'' ({3})";
    private static final String bridgeCantFindAddressConfig = "AMQ222171: Bridge {0} forwarding address {1} could not be resolved on address-settings configuration";
    private static final String queueBusy = "AMQ222172: Queue {0} was busy for more than {1} milliseconds. There are possibly consumers hanging on a network operation";
    private static final String queueDuplicatedRenaming = "AMQ222173: Queue {0} is duplicated during reload. This queue will be renamed as {1}";
    private static final String timeoutFlushInTransit = "AMQ222174: Queue {0}, on address={1}, is taking too long to flush deliveries. Watch out for frozen clients.";
    private static final String bridgeCantFindConnectors = "AMQ222175: Bridge {0} could not find configured connectors";
    private static final String xidReplacedOnXStart = "AMQ222176: A session that was already doing XA work on {0} is replacing the xid by {1} . This was most likely caused from a previous communication timeout";
    private static final String rolePermissionConfigurationError = "AMQ222177: Wrong configuration for role, {0} is not a valid permission";
    private static final String errorRecoveringPageCounter = "AMQ222178: Error during recovery of page counters";
    private static final String failedToScaleDown = "AMQ222181: Unable to scaleDown messages";
    private static final String missingClusterConfigForScaleDown = "AMQ222182: Missing cluster-configuration for scale-down-clustername {0}";
    private static final String blockingMessageProduction = "AMQ222183: Blocking message production on address ''{0}''; size is currently: {1} bytes; max-size-bytes on address: {2}, global-max-size is {3}";
    private static final String groupBindingsOnRecovery = "AMQ222184: Unable to recover group bindings in SCALE_DOWN mode, only FULL backup server can do this";
    private static final String noClusterConnectionForReplicationCluster = "AMQ222185: no cluster connection for specified replication cluster";
    private static final String clusterControlAuthfailure = "AMQ222186: unable to authorise cluster control";
    private static final String activateReplicatedBackupFailed = "AMQ222187: Failed to activate replicated backup";
    private static final String unableToFindTargetQueue = "AMQ222188: Unable to find target queue for node {0}";
    private static final String activateSharedStoreSlaveFailed = "AMQ222189: Failed to activate shared store slave";
    private static final String cannotFindRoleForUser = "AMQ222191: Could not find any configured role for user {0}.";
    private static final String couldNotDeleteTempFile = "AMQ222192: Could not delete: {0}";
    private static final String memoryLimitReached = "AMQ222193: Memory Limit reached. Producer ({0}) stopped to prevent flooding {1} (blocking for {2}s). See http://activemq.apache.org/producer-flow-control.html for more info.";
    private static final String nullPageCursorInfo = "AMQ222194: PageCursorInfo == null on address {0}, pos = {1}, queue = {2}.";
    private static final String largeMessageNotFound = "AMQ222195: Large message {0} wasn''t found when dealing with add pending large message";
    private static final String bindingNotFound = "AMQ222196: Could not find binding with id={0} on routeFromCluster for message={1} binding = {2}";
    private static final String nonDeliveryHandled = "AMQ222197: Internal error! Delivery logic has identified a non delivery and still handled a consumer!";
    private static final String couldNotFlushClusterManager = "AMQ222198: Could not flush ClusterManager executor ({0}) in 10 seconds, verify your thread pool size";
    private static final String threadDump = "AMQ222199: Thread dump: {0}";
    private static final String couldNotFinishExecutor = "AMQ222200: Could not finish executor on {0}";
    private static final String activationTimeout = "AMQ222201: Timed out waiting for activation to exit";
    private static final String connectionTTLEqualsCheckPeriod = "AMQ222202: {0}: <{1}> should not be set to the same value as <{2}>.  If a system is under high load, or there is a minor network delay, there is a high probability of a cluster split/failure due to connection timeout.";
    private static final String noProtocolManagerFound = "AMQ222203: Classpath lacks a protocol-manager for protocol {0}, Protocol being ignored on acceptor {1}";
    private static final String duplicatedAcceptor = "AMQ222204: Duplicated Acceptor {0} with parameters {1} classFactory={2} duplicated on the configuration";
    private static final String potentialOOME = "AMQ222205: OutOfMemoryError possible! There are currently {0} addresses with a total max-size-bytes of {1} bytes, but the maximum memory available is {2} bytes.";
    private static final String connectionLimitReached = "AMQ222206: Connection limit of {0} reached. Refusing connection from {1}.";
    private static final String slowReplicationResponse = "AMQ222207: The backup server is not responding promptly introducing latency beyond the limit. Replication server being disconnected now.";
    private static final String sslHandshakeFailed = "AMQ222208: SSL handshake failed for client from {0}: {1}.";
    private static final String impossibleToRouteGrouped = "AMQ222209: Could not contact group handler coordinator after 10 retries, message being routed without grouping information";
    private static final String diskBeyondCapacity = "AMQ222210: Storage usage is beyond max-disk-usage. System will start blocking producers.";
    private static final String diskCapacityRestored = "AMQ222211: Storage is back to stable now, under max-disk-usage.";
    private static final String blockingDiskFull = "AMQ222212: Disk Full! Blocking message production on address ''{0}''. Clients will report blocked.";
    private static final String serverIsolatedOnNetwork = "AMQ222213: There was an issue on the network, server is isolated!";
    private static final String negativeAddressSize = "AMQ222214: Destination {1} has an inconsistent and negative address size={0}.";
    private static final String negativeGlobalAddressSize = "AMQ222215: Global Address Size has negative and inconsistent value as {0}";
    private static final String securityProblemWhileCreatingSession = "AMQ222216: Security problem while creating session: {0}";
    private static final String connectorRefNotFound = "AMQ222217: Cannot find connector-ref {0}. The cluster-connection {1} will not be deployed.";
    private static final String disconnectCritical = "AMQ222218: Server disconnecting: {0}";
    private static final String initializationError = "AMQ224000: Failure in initialisation";
    private static final String errorDeployingURI1 = "AMQ224001: Error deploying URI {0}";
    private static final String errorDeployingURI0 = "AMQ224002: Error deploying URI";
    private static final String errorUnDeployingURI = "AMQ224003: Error undeploying URI {0}";
    private static final String unableToDeployNode = "AMQ224005: Unable to deploy node {0}";
    private static final String invalidFilter = "AMQ224006: Invalid filter: {0}";
    private static final String pageSubscriptionError = "AMQ224007: page subscription = {0} error={1}";
    private static final String batchingIdError = "AMQ224008: Failed to store id";
    private static final String cannotFindMessage = "AMQ224009: Cannot find message {0}";
    private static final String journalCannotFindQueue = "AMQ224010: Cannot find queue messages for queueID={0} on ack for messageID={1}";
    private static final String journalCannotFindQueueScheduled = "AMQ224011: Cannot find queue messages {0} for message {1} while processing scheduled messages";
    private static final String largeMessageErrorReleasingResources = "AMQ224012: error releasing resources";
    private static final String errorExpiringMessages = "AMQ224013: failed to expire messages for queue";
    private static final String errorClosingSession = "AMQ224014: Failed to close session";
    private static final String caughtXaException = "AMQ224015: Caught XA exception";
    private static final String caughtException = "AMQ224016: Caught exception";
    private static final String invalidPacket = "AMQ224017: Invalid packet {0}";
    private static final String failedToCreateSession = "AMQ224018: Failed to create session";
    private static final String failedToReattachSession = "AMQ224019: Failed to reattach session";
    private static final String failedToHandleCreateQueue = "AMQ224020: Failed to handle create queue";
    private static final String errorDecodingPacket = "AMQ224021: Failed to decode packet";
    private static final String errorCallingFailureListener = "AMQ224022: Failed to execute failure listener";
    private static final String stompErrorTXExists = "AMQ224024: Stomp Error, tx already exist! {0}";
    private static final String errorWritingToInvmConnector = "AMQ224027: Failed to write to handler on invm connector {0}";
    private static final String errorStoppingAcceptor = "AMQ224028: Failed to stop acceptor {0}";
    private static final String largeMessageIncompatible = "AMQ224029: large message sync: largeMessage instance is incompatible with it, ignoring data";
    private static final String errorCancellingRefOnBridge = "AMQ224030: Could not cancel reference {0}";
    private static final String stompBeginTX = "AMQ224031: -------------------------------Stomp begin tx: {0}";
    private static final String errorPausingBridge = "AMQ224032: Failed to pause bridge";
    private static final String errorBroadcastingConnectorConfigs = "AMQ224033: Failed to broadcast connector configs";
    private static final String errorClosingConsumer = "AMQ224034: Failed to close consumer";
    private static final String errorClosingFlowRecord = "AMQ224035: Failed to close cluster connection flow record";
    private static final String errorUpdatingTopology = "AMQ224036: Failed to update cluster connection topology";
    private static final String errorHandlingMessage = "AMQ224037: cluster connection Failed to handle message";
    private static final String errorAckingOldReference = "AMQ224038: Failed to ack old reference";
    private static final String errorExpiringRef = "AMQ224039: Failed to expire message reference";
    private static final String errorRemovingConsumer = "AMQ224040: Failed to remove consumer";
    private static final String errorDelivering = "AMQ224041: Failed to deliver";
    private static final String errorRestartingBackupServer = "AMQ224042: Error while restarting the backup server: {0}";
    private static final String errorSendingForcedDelivery = "AMQ224043: Failed to send forced delivery message";
    private static final String errorAckingMessage = "AMQ224044: error acknowledging message";
    private static final String errorRunningLargeMessageDeliverer = "AMQ224045: Failed to run large message deliverer";
    private static final String errorBrowserHandlingMessage = "AMQ224046: Exception while browser handled from {0}";
    private static final String errorDeletingLargeMessageFile = "AMQ224047: Failed to delete large message file";
    private static final String errorRemovingTempQueue = "AMQ224048: Failed to remove temporary queue {0}";
    private static final String cannotFindConsumer = "AMQ224049: Cannot find consumer with id {0}";
    private static final String errorClosingConnection = "AMQ224050: Failed to close connection {0}";
    private static final String errorCallingNotifListener = "AMQ224051: Failed to call notification listener";
    private static final String errorCallingRepoListener = "AMQ224052: Unable to call Hierarchical Repository Change Listener";
    private static final String errorTimingOutTX = "AMQ224053: failed to timeout transaction, xid:{0}";
    private static final String errorStoppingReplicationManager = "AMQ224054: exception while stopping the replication manager";
    private static final String bridgeFailedToAck = "AMQ224055: Bridge Failed to ack";
    private static final String autoFailBackDenied = "AMQ224056: Live server will not fail-back automatically";
    private static final String failbackMissedBackupAnnouncement = "AMQ224057: Backup server that requested fail-back was not announced. Server will not stop for fail-back.";
    private static final String clusterManagerAuthenticationError = "AMQ224058: Stopping ClusterManager. As it failed to authenticate with the cluster: {0}";
    private static final String invalidCipherSuite = "AMQ224059: Invalid cipher suite specified. Supported cipher suites are: {0}";
    private static final String invalidProtocol = "AMQ224060: Invalid protocol specified. Supported protocols are: {0}";
    private static final String incompatibleWithHAPolicy = "AMQ224061: Setting both <{0}> and <ha-policy> is invalid. Please use <ha-policy> exclusively as <{0}> is deprecated. Ignoring <{0}> value.";
    private static final String failedToSendSlowConsumerNotification = "AMQ224062: Failed to send SLOW_CONSUMER notification: {0}";
    private static final String failedToCloseConsumerConnectionsForAddress = "AMQ224063: Failed to close consumer connections for address {0}";
    private static final String incompatibleWithHAPolicyChosen = "AMQ224064: Setting <{0}> is invalid with this HA Policy Configuration. Please use <ha-policy> exclusively or remove. Ignoring <{0}> value.";
    private static final String errorRemovingAutoCreatedQueue = "AMQ224065: Failed to remove auto-created queue {0}";
    private static final String errorOpeningContextForLDAP = "AMQ224066: Error opening context for LDAP";
    private static final String errorPopulatingSecurityRolesFromLDAP = "AMQ224067: Error populating security roles from LDAP";
    private static final String errorStoppingComponent = "AMQ224068: Unable to stop component: {0}";
    private static final String configurationReloadFailed = "AMQ224069: Change detected in broker configuration file, but reload failed";
    private static final String invalidMessageCounterPeriod = "AMQ224072: Message Counter Sample Period too short: {0}";
    private static final String journalUseMAPPED = "AMQ224073: Using MAPPED Journal";
    private static final String failedToPurgeQueue = "AMQ224074: Failed to purge queue {0} on no consumers";
    private static final String journalCannotFindPageTX = "AMQ224075: Cannot find pageTX id = {0}";
    private static final String undeployAddress = "AMQ224076: UnDeploying address {0}";
    private static final String undeployQueue = "AMQ224077: UnDeploying queue {0}";
    private static final String duplicateCacheSizeWarning = "AMQ224078: The size of duplicate cache detection (<id_cache-size/>) appears to be too large {0}. It should be no greater than the number of messages that can be squeezed into conformation buffer (<confirmation-window-size/>) {1}.";

    public ActiveMQServerLogger_$logger(Logger log) {
        super(log);
    }

    @Override
    public final void interruptWhilstStoppingComponent(String componentClassName) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.interruptWhilstStoppingComponent$str(), (Object)componentClassName);
    }

    protected String interruptWhilstStoppingComponent$str() {
        return interruptWhilstStoppingComponent;
    }

    @Override
    public final void serverStarting(String type, Configuration configuration) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.serverStarting$str(), (Object)type, (Object)configuration);
    }

    protected String serverStarting$str() {
        return serverStarting;
    }

    @Override
    public final void serverStarted(String fullVersion, String name, SimpleString nodeId, String identity) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.serverStarted$str(), new Object[]{fullVersion, name, nodeId, identity});
    }

    protected String serverStarted$str() {
        return serverStarted;
    }

    @Override
    public final void serverStopped(String version, SimpleString nodeId, String uptime) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.serverStopped$str(), (Object)version, (Object)nodeId, (Object)uptime);
    }

    protected String serverStopped$str() {
        return serverStopped;
    }

    @Override
    public final void deployQueue(SimpleString queueName) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.deployQueue$str(), (Object)queueName);
    }

    protected String deployQueue$str() {
        return deployQueue;
    }

    @Override
    public final void dumpServerInfo(String serverInfo) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.dumpServerInfo$str(), (Object)serverInfo);
    }

    protected String dumpServerInfo$str() {
        return dumpServerInfo;
    }

    public final void deletingPendingMessage(Pair msgToDelete) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.deletingPendingMessage$str(), (Object)msgToDelete);
    }

    protected String deletingPendingMessage$str() {
        return deletingPendingMessage;
    }

    @Override
    public final void awaitingLiveLock() {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.awaitingLiveLock$str(), new Object[0]);
    }

    protected String awaitingLiveLock$str() {
        return awaitingLiveLock;
    }

    @Override
    public final void serverIsLive() {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.serverIsLive0$str(), new Object[0]);
    }

    protected String serverIsLive0$str() {
        return serverIsLive0;
    }

    @Override
    public final void awaitFailBack() {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.awaitFailBack$str(), new Object[0]);
    }

    protected String awaitFailBack$str() {
        return awaitFailBack;
    }

    @Override
    public final void backupServerStarted(String version, SimpleString nodeID) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.backupServerStarted$str(), (Object)version, (Object)nodeID);
    }

    protected String backupServerStarted$str() {
        return backupServerStarted;
    }

    @Override
    public final void backupServerIsLive() {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.backupServerIsLive$str(), new Object[0]);
    }

    protected String backupServerIsLive$str() {
        return backupServerIsLive;
    }

    @Override
    public final void serverIsLive(String identity) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.serverIsLive1$str(), (Object)identity);
    }

    protected String serverIsLive1$str() {
        return serverIsLive1;
    }

    @Override
    public final void journalUseAIO() {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.journalUseAIO$str(), new Object[0]);
    }

    protected String journalUseAIO$str() {
        return journalUseAIO;
    }

    @Override
    public final void journalUseNIO() {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.journalUseNIO$str(), new Object[0]);
    }

    protected String journalUseNIO$str() {
        return journalUseNIO;
    }

    @Override
    public final void percentLoaded(Long percent) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.percentLoaded$str(), (Object)percent);
    }

    protected String percentLoaded$str() {
        return percentLoaded;
    }

    @Override
    public final void journalCannotFindQueueReloading(Long queueID) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.journalCannotFindQueueReloading$str(), (Object)queueID);
    }

    protected String journalCannotFindQueueReloading$str() {
        return journalCannotFindQueueReloading;
    }

    @Override
    public final void journalCannotFindQueueReloadingPage(Long queueID) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.journalCannotFindQueueReloadingPage$str(), (Object)queueID);
    }

    protected String journalCannotFindQueueReloadingPage$str() {
        return journalCannotFindQueueReloadingPage;
    }

    @Override
    public final void journalCannotFindQueueReloadingPageCursor(Long queueID) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.journalCannotFindQueueReloadingPageCursor$str(), (Object)queueID);
    }

    protected String journalCannotFindQueueReloadingPageCursor$str() {
        return journalCannotFindQueueReloadingPageCursor;
    }

    @Override
    public final void largeMessageWithNoRef(Long messageID) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.largeMessageWithNoRef$str(), (Object)messageID);
    }

    protected String largeMessageWithNoRef$str() {
        return largeMessageWithNoRef;
    }

    @Override
    public final void journalUnreferencedMessage(Long messageID) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.journalUnreferencedMessage$str(), (Object)messageID);
    }

    protected String journalUnreferencedMessage$str() {
        return journalUnreferencedMessage;
    }

    @Override
    public final void startedAcceptor(String acceptorType, String host, Integer port, String enabledProtocols) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.startedAcceptor$str(), new Object[]{acceptorType, host, port, enabledProtocols});
    }

    protected String startedAcceptor$str() {
        return startedAcceptor;
    }

    @Override
    public final void errorRemovingConnection() {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.errorRemovingConnection$str(), new Object[0]);
    }

    protected String errorRemovingConnection$str() {
        return errorRemovingConnection;
    }

    @Override
    public final void errorStartingConnectorService(Throwable e, String name) {
        this.log.logv(FQCN, Logger.Level.INFO, e, this.errorStartingConnectorService$str(), (Object)name);
    }

    protected String errorStartingConnectorService$str() {
        return errorStartingConnectorService;
    }

    @Override
    public final void errorStoppingConnectorService(Throwable e, String name) {
        this.log.logv(FQCN, Logger.Level.INFO, e, this.errorStoppingConnectorService$str(), (Object)name);
    }

    protected String errorStoppingConnectorService$str() {
        return errorStoppingConnectorService;
    }

    @Override
    public final void backupServerSynched(ActiveMQServerImpl server) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.backupServerSynched$str(), (Object)server);
    }

    protected String backupServerSynched$str() {
        return backupServerSynched;
    }

    @Override
    public final void replicaSyncFile(SequentialFile jf, Long size) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.replicaSyncFile$str(), (Object)jf, (Object)size);
    }

    protected String replicaSyncFile$str() {
        return replicaSyncFile;
    }

    @Override
    public final void bridgeNoBindings(SimpleString name, SimpleString forwardingAddress, SimpleString address) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.bridgeNoBindings$str(), (Object)name, (Object)forwardingAddress, (Object)address);
    }

    protected String bridgeNoBindings$str() {
        return bridgeNoBindings;
    }

    @Override
    public final void bridgeConnected(BridgeImpl name) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.bridgeConnected$str(), (Object)name);
    }

    protected String bridgeConnected$str() {
        return bridgeConnected;
    }

    @Override
    public final void bridgeStopping() {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.bridgeStopping$str(), new Object[0]);
    }

    protected String bridgeStopping$str() {
        return bridgeStopping;
    }

    @Override
    public final void bridgeStopped(SimpleString name) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.bridgeStopped$str(), (Object)name);
    }

    protected String bridgeStopped$str() {
        return bridgeStopped;
    }

    @Override
    public final void bridgePaused(SimpleString name) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.bridgePaused$str(), (Object)name);
    }

    protected String bridgePaused$str() {
        return bridgePaused;
    }

    @Override
    public final void backupAnnounced() {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.backupAnnounced$str(), new Object[0]);
    }

    protected String backupAnnounced$str() {
        return backupAnnounced;
    }

    @Override
    public final void waitingToBecomeBackup() {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.waitingToBecomeBackup$str(), new Object[0]);
    }

    protected String waitingToBecomeBackup$str() {
        return waitingToBecomeBackup;
    }

    @Override
    public final void gotBackupLock() {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.gotBackupLock$str(), new Object[0]);
    }

    protected String gotBackupLock$str() {
        return gotBackupLock;
    }

    @Override
    public final void waitingToObtainLiveLock(String timeoutMessage) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.waitingToObtainLiveLock$str(), (Object)timeoutMessage);
    }

    protected String waitingToObtainLiveLock$str() {
        return waitingToObtainLiveLock;
    }

    @Override
    public final void obtainedLiveLock() {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.obtainedLiveLock$str(), new Object[0]);
    }

    protected String obtainedLiveLock$str() {
        return obtainedLiveLock;
    }

    @Override
    public final void messageWithDuplicateID(Object duplicateProperty, SimpleString toAddress, SimpleString address, SimpleString simpleString) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.messageWithDuplicateID$str(), new Object[]{duplicateProperty, toAddress, address, simpleString});
    }

    protected String messageWithDuplicateID$str() {
        return messageWithDuplicateID;
    }

    @Override
    public final void becomingLive(ActiveMQServer server) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.becomingLive$str(), (Object)server);
    }

    protected String becomingLive$str() {
        return becomingLive;
    }

    @Override
    public final void deprecatedConfigurationOption(String deprecatedOption) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.deprecatedConfigurationOption$str(), (Object)deprecatedOption);
    }

    protected String deprecatedConfigurationOption$str() {
        return deprecatedConfigurationOption;
    }

    @Override
    public final void restartingReplicatedBackupAfterFailback() {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.restartingReplicatedBackupAfterFailback$str(), new Object[0]);
    }

    protected String restartingReplicatedBackupAfterFailback$str() {
        return restartingReplicatedBackupAfterFailback;
    }

    @Override
    public final void remoteGroupCoordinatorsNotStarted() {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.remoteGroupCoordinatorsNotStarted$str(), new Object[0]);
    }

    protected String remoteGroupCoordinatorsNotStarted$str() {
        return remoteGroupCoordinatorsNotStarted;
    }

    @Override
    public final void cantFindQueueOnPageComplete(long queueID) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.cantFindQueueOnPageComplete$str(), (Object)queueID);
    }

    protected String cantFindQueueOnPageComplete$str() {
        return cantFindQueueOnPageComplete;
    }

    @Override
    public final void timedOutWaitingCompletions(String bridgeName, long numberOfMessages) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.timedOutWaitingCompletions$str(), (Object)bridgeName, (Object)numberOfMessages);
    }

    protected String timedOutWaitingCompletions$str() {
        return timedOutWaitingCompletions;
    }

    @Override
    public final void addingProtocolSupport(String protocolKey, String moduleName) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.addingProtocolSupport$str(), (Object)protocolKey, (Object)moduleName);
    }

    protected String addingProtocolSupport$str() {
        return addingProtocolSupport;
    }

    @Override
    public final void switchingNIO() {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.switchingNIO$str(), new Object[0]);
    }

    protected String switchingNIO$str() {
        return switchingNIO;
    }

    @Override
    public final void unblockingMessageProduction(SimpleString addressName, long currentSize, long maxSize) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.unblockingMessageProduction$str(), (Object)addressName, (Object)currentSize, (Object)maxSize);
    }

    protected String unblockingMessageProduction$str() {
        return unblockingMessageProduction;
    }

    @Override
    public final void backupServerScaledDown() {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.backupServerScaledDown$str(), new Object[0]);
    }

    protected String backupServerScaledDown$str() {
        return backupServerScaledDown;
    }

    @Override
    public final void slowConsumerDetected(String sessionID, long consumerID, String queueName, String remoteAddress, float slowConsumerThreshold, float consumerRate) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.slowConsumerDetected$str(), new Object[]{sessionID, consumerID, queueName, remoteAddress, Float.valueOf(slowConsumerThreshold), Float.valueOf(consumerRate)});
    }

    protected String slowConsumerDetected$str() {
        return slowConsumerDetected;
    }

    @Override
    public final void activatingReplica(SimpleString nodeID) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.activatingReplica$str(), (Object)nodeID);
    }

    protected String activatingReplica$str() {
        return activatingReplica;
    }

    @Override
    public final void activatingSharedStoreSlave() {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.activatingSharedStoreSlave$str(), new Object[0]);
    }

    protected String activatingSharedStoreSlave$str() {
        return activatingSharedStoreSlave;
    }

    @Override
    public final void populatingSecurityRolesFromLDAP(String url) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.populatingSecurityRolesFromLDAP$str(), (Object)url);
    }

    protected String populatingSecurityRolesFromLDAP$str() {
        return populatingSecurityRolesFromLDAP;
    }

    @Override
    public final void deployTopic(SimpleString topicName) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.deployTopic$str(), (Object)topicName);
    }

    protected String deployTopic$str() {
        return deployTopic;
    }

    @Override
    public final void disallowedProtocol(String protocol, String acceptorName) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.disallowedProtocol$str(), (Object)protocol, (Object)acceptorName);
    }

    protected String disallowedProtocol$str() {
        return disallowedProtocol;
    }

    @Override
    public final void switchingNIOonPath(String journalPath) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.switchingNIOonPath$str(), (Object)journalPath);
    }

    protected String switchingNIOonPath$str() {
        return switchingNIOonPath;
    }

    @Override
    public final void removingBackupData(String path) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.removingBackupData$str(), (Object)path);
    }

    protected String removingBackupData$str() {
        return removingBackupData;
    }

    @Override
    public final void reloadingConfiguration(String module) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.reloadingConfiguration$str(), (Object)module);
    }

    protected String reloadingConfiguration$str() {
        return reloadingConfiguration;
    }

    @Override
    public final void usingDefaultPaging(long bytes) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.usingDefaultPaging$str(), (Object)bytes);
    }

    protected String usingDefaultPaging$str() {
        return usingDefaultPaging;
    }

    @Override
    public final void invalidJournalFileSize(int journalFileSize, int fileSize, int alignment) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.invalidJournalFileSize$str(), (Object)journalFileSize, (Object)fileSize, (Object)alignment);
    }

    protected String invalidJournalFileSize$str() {
        return invalidJournalFileSize;
    }

    @Override
    public final void backupDeletingData(String oldPath) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.backupDeletingData$str(), (Object)oldPath);
    }

    protected String backupDeletingData$str() {
        return backupDeletingData;
    }

    @Override
    public final void sendingQuorumVoteRequest(String remoteAddress, String vote) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.sendingQuorumVoteRequest$str(), (Object)remoteAddress, (Object)vote);
    }

    protected String sendingQuorumVoteRequest$str() {
        return sendingQuorumVoteRequest;
    }

    @Override
    public final void receivedQuorumVoteResponse(String remoteAddress, String vote) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.receivedQuorumVoteResponse$str(), (Object)remoteAddress, (Object)vote);
    }

    protected String receivedQuorumVoteResponse$str() {
        return receivedQuorumVoteResponse;
    }

    @Override
    public final void receivedQuorumVoteRequest(String vote) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.receivedQuorumVoteRequest$str(), (Object)vote);
    }

    protected String receivedQuorumVoteRequest$str() {
        return receivedQuorumVoteRequest;
    }

    @Override
    public final void sendingQuorumVoteResponse(String vote) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.sendingQuorumVoteResponse$str(), (Object)vote);
    }

    protected String sendingQuorumVoteResponse$str() {
        return sendingQuorumVoteResponse;
    }

    @Override
    public final void nodeFoundInClusterTopology(String nodeId) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.nodeFoundInClusterTopology$str(), (Object)nodeId);
    }

    protected String nodeFoundInClusterTopology$str() {
        return nodeFoundInClusterTopology;
    }

    @Override
    public final void nodeNotFoundInClusterTopology(String nodeId) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.nodeNotFoundInClusterTopology$str(), (Object)nodeId);
    }

    protected String nodeNotFoundInClusterTopology$str() {
        return nodeNotFoundInClusterTopology;
    }

    @Override
    public final void initiatingQuorumVote(SimpleString vote) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.initiatingQuorumVote$str(), (Object)vote);
    }

    protected String initiatingQuorumVote$str() {
        return initiatingQuorumVote;
    }

    @Override
    public final void waitingForQuorumVoteResults(int timeout, String unit) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.waitingForQuorumVoteResults$str(), (Object)timeout, (Object)unit);
    }

    protected String waitingForQuorumVoteResults$str() {
        return waitingForQuorumVoteResults;
    }

    @Override
    public final void receivedAllQuorumVotes() {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.receivedAllQuorumVotes$str(), new Object[0]);
    }

    protected String receivedAllQuorumVotes$str() {
        return receivedAllQuorumVotes;
    }

    @Override
    public final void timeoutWaitingForQuorumVoteResponses() {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.timeoutWaitingForQuorumVoteResponses$str(), new Object[0]);
    }

    protected String timeoutWaitingForQuorumVoteResponses$str() {
        return timeoutWaitingForQuorumVoteResponses;
    }

    @Override
    public final void restartingAsBackupBasedOnQuorumVoteResults() {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.restartingAsBackupBasedOnQuorumVoteResults$str(), new Object[0]);
    }

    protected String restartingAsBackupBasedOnQuorumVoteResults$str() {
        return restartingAsBackupBasedOnQuorumVoteResults;
    }

    @Override
    public final void failingOverBasedOnQuorumVoteResults() {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.failingOverBasedOnQuorumVoteResults$str(), new Object[0]);
    }

    protected String failingOverBasedOnQuorumVoteResults$str() {
        return failingOverBasedOnQuorumVoteResults;
    }

    @Override
    public final void serverFinalisedWIthoutBeingSTopped() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.serverFinalisedWIthoutBeingSTopped$str(), new Object[0]);
    }

    protected String serverFinalisedWIthoutBeingSTopped$str() {
        return serverFinalisedWIthoutBeingSTopped;
    }

    @Override
    public final void errorClosingSessionsWhileStoppingServer(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorClosingSessionsWhileStoppingServer$str(), new Object[0]);
    }

    protected String errorClosingSessionsWhileStoppingServer$str() {
        return errorClosingSessionsWhileStoppingServer;
    }

    @Override
    public final void timedOutStoppingThreadpool(ExecutorService service) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.timedOutStoppingThreadpool$str(), (Object)service);
    }

    protected String timedOutStoppingThreadpool$str() {
        return timedOutStoppingThreadpool;
    }

    @Override
    public final void divertWithNoAddress() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.divertWithNoAddress$str(), new Object[0]);
    }

    protected String divertWithNoAddress$str() {
        return divertWithNoAddress;
    }

    @Override
    public final void divertWithNoForwardingAddress() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.divertWithNoForwardingAddress$str(), new Object[0]);
    }

    protected String divertWithNoForwardingAddress$str() {
        return divertWithNoForwardingAddress;
    }

    @Override
    public final void divertBindingAlreadyExists(SimpleString bindingName) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.divertBindingAlreadyExists$str(), (Object)bindingName);
    }

    protected String divertBindingAlreadyExists$str() {
        return divertBindingAlreadyExists;
    }

    @Override
    public final void clusterSecurityRisk() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.clusterSecurityRisk$str(), new Object[0]);
    }

    protected String clusterSecurityRisk$str() {
        return clusterSecurityRisk;
    }

    @Override
    public final void serverRestartWarning() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.serverRestartWarning$str(), new Object[0]);
    }

    protected String serverRestartWarning$str() {
        return serverRestartWarning;
    }

    @Override
    public final void serverRestartWarning(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.serverRestartWarning$str(), new Object[0]);
    }

    @Override
    public final void replicationStartProblem(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.replicationStartProblem$str(), new Object[0]);
    }

    protected String replicationStartProblem$str() {
        return replicationStartProblem;
    }

    @Override
    public final void ioCriticalIOError(String message, String file, Throwable code) {
        this.log.logv(FQCN, Logger.Level.WARN, code, this.ioCriticalIOError$str(), (Object)message, (Object)file);
    }

    protected String ioCriticalIOError$str() {
        return ioCriticalIOError;
    }

    @Override
    public final void errorStoppingServer(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorStoppingServer$str(), new Object[0]);
    }

    protected String errorStoppingServer$str() {
        return errorStoppingServer;
    }

    @Override
    public final void backupActivationProblem() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.backupActivationProblem$str(), new Object[0]);
    }

    protected String backupActivationProblem$str() {
        return backupActivationProblem;
    }

    @Override
    public final void errorStartingReplication(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorStartingReplication0$str(), new Object[0]);
    }

    protected String errorStartingReplication0$str() {
        return errorStartingReplication0;
    }

    @Override
    public final void errorStoppingReplication(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorStoppingReplication$str(), new Object[0]);
    }

    protected String errorStoppingReplication$str() {
        return errorStoppingReplication;
    }

    @Override
    public final void connectorWithNoName() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.connectorWithNoName$str(), new Object[0]);
    }

    protected String connectorWithNoName$str() {
        return connectorWithNoName;
    }

    @Override
    public final void connectorAlreadyDeployed(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.connectorAlreadyDeployed$str(), (Object)name);
    }

    protected String connectorAlreadyDeployed$str() {
        return connectorAlreadyDeployed;
    }

    @Override
    public final void AIONotFound() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.AIONotFound$str(), new Object[0]);
    }

    protected String AIONotFound$str() {
        return AIONotFound;
    }

    @Override
    public final void discoveryGroupAlreadyDeployed(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.discoveryGroupAlreadyDeployed$str(), (Object)name);
    }

    protected String discoveryGroupAlreadyDeployed$str() {
        return discoveryGroupAlreadyDeployed;
    }

    @Override
    public final void errorScanningURLs(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorScanningURLs$str(), new Object[0]);
    }

    protected String errorScanningURLs$str() {
        return errorScanningURLs;
    }

    @Override
    public final void problemUndeployingNode(Exception e, Node node) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.problemUndeployingNode$str(), (Object)node);
    }

    protected String problemUndeployingNode$str() {
        return problemUndeployingNode;
    }

    @Override
    public final void timedOutStoppingPagingCursor(FutureLatch future, Executor executor) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.timedOutStoppingPagingCursor$str(), (Object)future, (Object)executor);
    }

    protected String timedOutStoppingPagingCursor$str() {
        return timedOutStoppingPagingCursor;
    }

    @Override
    public final void problemCleaningPageAddress(Exception e, SimpleString address) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.problemCleaningPageAddress$str(), (Object)address);
    }

    protected String problemCleaningPageAddress$str() {
        return problemCleaningPageAddress;
    }

    @Override
    public final void problemCompletingOperations(OperationContext e) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.problemCompletingOperations$str(), (Object)e);
    }

    protected String problemCompletingOperations$str() {
        return problemCompletingOperations;
    }

    @Override
    public final void problemCleaningPagesubscriptionCounter(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.problemCleaningPagesubscriptionCounter$str(), new Object[0]);
    }

    protected String problemCleaningPagesubscriptionCounter$str() {
        return problemCleaningPagesubscriptionCounter;
    }

    @Override
    public final void problemCleaningCursorPages(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.problemCleaningCursorPages$str(), new Object[0]);
    }

    protected String problemCleaningCursorPages$str() {
        return problemCleaningCursorPages;
    }

    @Override
    public final void timedOutFlushingExecutorsPagingCursor(PageSubscription pageSubscription) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.timedOutFlushingExecutorsPagingCursor$str(), (Object)pageSubscription);
    }

    protected String timedOutFlushingExecutorsPagingCursor$str() {
        return timedOutFlushingExecutorsPagingCursor;
    }

    @Override
    public final void pageNotFound(PagePosition pos) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.pageNotFound$str(), (Object)pos);
    }

    protected String pageNotFound$str() {
        return pageNotFound;
    }

    @Override
    public final void pageSubscriptionCouldntLoad(long transactionID, PagePosition position, SimpleString address, SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.pageSubscriptionCouldntLoad$str(), new Object[]{transactionID, position, address, name});
    }

    protected String pageSubscriptionCouldntLoad$str() {
        return pageSubscriptionCouldntLoad;
    }

    @Override
    public final void pageInvalid(String fileName, String name) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.pageInvalid$str(), (Object)fileName, (Object)name);
    }

    protected String pageInvalid$str() {
        return pageInvalid;
    }

    @Override
    public final void pageDeleteError(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.pageDeleteError$str(), new Object[0]);
    }

    protected String pageDeleteError$str() {
        return pageDeleteError;
    }

    @Override
    public final void pageFinaliseError(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.pageFinaliseError$str(), new Object[0]);
    }

    protected String pageFinaliseError$str() {
        return pageFinaliseError;
    }

    @Override
    public final void pageSuspectFile(String fileName, int position, int msgNumber) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.pageSuspectFile$str(), (Object)fileName, (Object)position, (Object)msgNumber);
    }

    protected String pageSuspectFile$str() {
        return pageSuspectFile;
    }

    @Override
    public final void pageTxDeleteError(Exception e, long recordID) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.pageTxDeleteError$str(), (Object)recordID);
    }

    protected String pageTxDeleteError$str() {
        return pageTxDeleteError;
    }

    @Override
    public final void pageStoreFactoryNoIdFile(String s, String addressFile) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.pageStoreFactoryNoIdFile$str(), (Object)s, (Object)addressFile);
    }

    protected String pageStoreFactoryNoIdFile$str() {
        return pageStoreFactoryNoIdFile;
    }

    @Override
    public final void pageStoreTimeout(SimpleString address) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.pageStoreTimeout$str(), (Object)address);
    }

    protected String pageStoreTimeout$str() {
        return pageStoreTimeout;
    }

    @Override
    public final void pageStoreStartIOError(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.pageStoreStartIOError$str(), new Object[0]);
    }

    protected String pageStoreStartIOError$str() {
        return pageStoreStartIOError;
    }

    @Override
    public final void pageStoreStart(SimpleString storeName, long addressSize, long maxSize) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.pageStoreStart$str(), (Object)storeName, (Object)addressSize, (Object)maxSize);
    }

    protected String pageStoreStart$str() {
        return pageStoreStart;
    }

    @Override
    public final void pageStoreDropMessages(SimpleString storeName, long addressSize, long maxSize) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.pageStoreDropMessages$str(), (Object)storeName, (Object)addressSize, (Object)maxSize);
    }

    protected String pageStoreDropMessages$str() {
        return pageStoreDropMessages;
    }

    @Override
    public final void serverIsStopped() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.serverIsStopped$str(), new Object[0]);
    }

    protected String serverIsStopped$str() {
        return serverIsStopped;
    }

    @Override
    public final void journalCannotFindQueueDelCount(Long queueID) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.journalCannotFindQueueDelCount$str(), (Object)queueID);
    }

    protected String journalCannotFindQueueDelCount$str() {
        return journalCannotFindQueueDelCount;
    }

    @Override
    public final void journalCannotFindMessageDelCount(Long msg) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.journalCannotFindMessageDelCount$str(), (Object)msg);
    }

    protected String journalCannotFindMessageDelCount$str() {
        return journalCannotFindMessageDelCount;
    }

    @Override
    public final void journalCannotFindQueueForMessage(Long queueID) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.journalCannotFindQueueForMessage$str(), (Object)queueID);
    }

    protected String journalCannotFindQueueForMessage$str() {
        return journalCannotFindQueueForMessage;
    }

    @Override
    public final void journalErrorDeletingMessage(Exception e, Long messageID) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.journalErrorDeletingMessage$str(), (Object)messageID);
    }

    protected String journalErrorDeletingMessage$str() {
        return journalErrorDeletingMessage;
    }

    @Override
    public final void journalMessageInPreparedTX(Long queueID) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.journalMessageInPreparedTX$str(), (Object)queueID);
    }

    protected String journalMessageInPreparedTX$str() {
        return journalMessageInPreparedTX;
    }

    @Override
    public final void journalErrorRemovingRef(Long messageID) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.journalErrorRemovingRef$str(), (Object)messageID);
    }

    protected String journalErrorRemovingRef$str() {
        return journalErrorRemovingRef;
    }

    @Override
    public final void journalCannotFindQueueReloadingACK(Long queueID) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.journalCannotFindQueueReloadingACK$str(), (Object)queueID);
    }

    protected String journalCannotFindQueueReloadingACK$str() {
        return journalCannotFindQueueReloadingACK;
    }

    @Override
    public final void journalPAGEOnPrepared() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.journalPAGEOnPrepared$str(), new Object[0]);
    }

    protected String journalPAGEOnPrepared$str() {
        return journalPAGEOnPrepared;
    }

    @Override
    public final void journalInvalidRecordType(Byte recordType) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.journalInvalidRecordType$str(), (Object)recordType);
    }

    protected String journalInvalidRecordType$str() {
        return journalInvalidRecordType;
    }

    @Override
    public final void journalInvalidRecordTypeOnPreparedTX(Byte recordType) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.journalInvalidRecordTypeOnPreparedTX$str(), (Object)recordType);
    }

    protected String journalInvalidRecordTypeOnPreparedTX$str() {
        return journalInvalidRecordTypeOnPreparedTX;
    }

    @Override
    public final void journalError(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.journalError$str(), new Object[0]);
    }

    protected String journalError$str() {
        return journalError;
    }

    @Override
    public final void errorIncrementDelayDeletionCount(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorIncrementDelayDeletionCount$str(), new Object[0]);
    }

    protected String errorIncrementDelayDeletionCount$str() {
        return errorIncrementDelayDeletionCount;
    }

    @Override
    public final void lareMessageErrorCopying(Exception e, LargeServerMessage largeServerMessage) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.lareMessageErrorCopying$str(), (Object)largeServerMessage);
    }

    protected String lareMessageErrorCopying$str() {
        return lareMessageErrorCopying;
    }

    @Override
    public final void errorExecutingAIOCallback(Throwable t) {
        this.log.logv(FQCN, Logger.Level.WARN, t, this.errorExecutingAIOCallback$str(), new Object[0]);
    }

    protected String errorExecutingAIOCallback$str() {
        return errorExecutingAIOCallback;
    }

    @Override
    public final void errorDeletingDuplicateCache(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorDeletingDuplicateCache$str(), new Object[0]);
    }

    protected String errorDeletingDuplicateCache$str() {
        return errorDeletingDuplicateCache;
    }

    @Override
    public final void noDLA(SimpleString address) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.noDLA$str(), (Object)address);
    }

    protected String noDLA$str() {
        return noDLA;
    }

    @Override
    public final void ioErrorAddingReferences(Integer errorCode, String errorMessage) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.ioErrorAddingReferences$str(), (Object)errorCode, (Object)errorMessage);
    }

    protected String ioErrorAddingReferences$str() {
        return ioErrorAddingReferences;
    }

    @Override
    public final void duplicateMessageDetected(Message message) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.duplicateMessageDetected$str(), (Object)message);
    }

    protected String duplicateMessageDetected$str() {
        return duplicateMessageDetected;
    }

    @Override
    public final void journalErrorConfirmingLargeMessage(Throwable e, Long messageID) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.journalErrorConfirmingLargeMessage$str(), (Object)messageID);
    }

    protected String journalErrorConfirmingLargeMessage$str() {
        return journalErrorConfirmingLargeMessage;
    }

    @Override
    public final void clientConnectionFailed(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.clientConnectionFailed$str(), (Object)name);
    }

    protected String clientConnectionFailed$str() {
        return clientConnectionFailed;
    }

    @Override
    public final void clearingUpSession(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.clearingUpSession$str(), (Object)name);
    }

    protected String clearingUpSession$str() {
        return clearingUpSession;
    }

    @Override
    public final void errorProcessingIOCallback(Integer errorCode, String errorMessage) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.errorProcessingIOCallback$str(), (Object)errorCode, (Object)errorMessage);
    }

    protected String errorProcessingIOCallback$str() {
        return errorProcessingIOCallback;
    }

    @Override
    public final void incompatibleVersionAfterConnect(int version, int clientVersion) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.incompatibleVersionAfterConnect$str(), (Object)version, (Object)clientVersion);
    }

    protected String incompatibleVersionAfterConnect$str() {
        return incompatibleVersionAfterConnect;
    }

    @Override
    public final void reattachRequestFailed(String remoteAddress) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.reattachRequestFailed$str(), (Object)remoteAddress);
    }

    protected String reattachRequestFailed$str() {
        return reattachRequestFailed;
    }

    @Override
    public final void connectionFailureDetected(String message, ActiveMQExceptionType type) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.connectionFailureDetected$str(), (Object)message, (Object)type);
    }

    protected String connectionFailureDetected$str() {
        return connectionFailureDetected;
    }

    @Override
    public final void errorCleaningStompConn(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorCleaningStompConn$str(), new Object[0]);
    }

    protected String errorCleaningStompConn$str() {
        return errorCleaningStompConn;
    }

    @Override
    public final void stompTXAckNorSupported() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.stompTXAckNorSupported$str(), new Object[0]);
    }

    protected String stompTXAckNorSupported$str() {
        return stompTXAckNorSupported;
    }

    @Override
    public final void errorOnStompHeartBeat(InterruptedException e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorOnStompHeartBeat$str(), new Object[0]);
    }

    protected String errorOnStompHeartBeat$str() {
        return errorOnStompHeartBeat;
    }

    @Override
    public final void timedOutFlushingInvmChannel() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.timedOutFlushingInvmChannel$str(), new Object[0]);
    }

    protected String timedOutFlushingInvmChannel$str() {
        return timedOutFlushingInvmChannel;
    }

    @Override
    public final void nettyChannelGroupError() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.nettyChannelGroupError$str(), new Object[0]);
    }

    protected String nettyChannelGroupError$str() {
        return nettyChannelGroupError;
    }

    @Override
    public final void nettyChannelStillOpen(Channel channel, SocketAddress remoteAddress) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.nettyChannelStillOpen$str(), (Object)channel, (Object)remoteAddress);
    }

    protected String nettyChannelStillOpen$str() {
        return nettyChannelStillOpen;
    }

    @Override
    public final void nettyChannelGroupBindError() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.nettyChannelGroupBindError$str(), new Object[0]);
    }

    protected String nettyChannelGroupBindError$str() {
        return nettyChannelGroupBindError;
    }

    @Override
    public final void nettyChannelStillBound(Channel channel, SocketAddress remoteAddress) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.nettyChannelStillBound$str(), (Object)channel, (Object)remoteAddress);
    }

    protected String nettyChannelStillBound$str() {
        return nettyChannelStillBound;
    }

    @Override
    public final void errorCreatingRemotingInterceptor(Exception e, String interceptorClass) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorCreatingRemotingInterceptor$str(), (Object)interceptorClass);
    }

    protected String errorCreatingRemotingInterceptor$str() {
        return errorCreatingRemotingInterceptor;
    }

    @Override
    public final void invalidAcceptorKeys(String s) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.invalidAcceptorKeys$str(), (Object)s);
    }

    protected String invalidAcceptorKeys$str() {
        return invalidAcceptorKeys;
    }

    @Override
    public final void errorCreatingAcceptor(Exception e, String factoryClassName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorCreatingAcceptor$str(), (Object)factoryClassName);
    }

    protected String errorCreatingAcceptor$str() {
        return errorCreatingAcceptor;
    }

    @Override
    public final void timeoutRemotingThreadPool() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.timeoutRemotingThreadPool$str(), new Object[0]);
    }

    protected String timeoutRemotingThreadPool$str() {
        return timeoutRemotingThreadPool;
    }

    @Override
    public final void errorOnFailureCheck(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.errorOnFailureCheck$str(), new Object[0]);
    }

    protected String errorOnFailureCheck$str() {
        return errorOnFailureCheck;
    }

    @Override
    public final void connectorKeysInvalid(String s) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.connectorKeysInvalid$str(), (Object)s);
    }

    protected String connectorKeysInvalid$str() {
        return connectorKeysInvalid;
    }

    @Override
    public final void connectorKeysMissing(String s) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.connectorKeysMissing$str(), (Object)s);
    }

    protected String connectorKeysMissing$str() {
        return connectorKeysMissing;
    }

    @Override
    public final void invalidPacketForReplication(Packet packet) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.invalidPacketForReplication$str(), (Object)packet);
    }

    protected String invalidPacketForReplication$str() {
        return invalidPacketForReplication;
    }

    @Override
    public final void errorHandlingReplicationPacket(Exception e, Packet packet) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorHandlingReplicationPacket$str(), (Object)packet);
    }

    protected String errorHandlingReplicationPacket$str() {
        return errorHandlingReplicationPacket;
    }

    @Override
    public final void errorClosingPageOnReplication(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorClosingPageOnReplication$str(), new Object[0]);
    }

    protected String errorClosingPageOnReplication$str() {
        return errorClosingPageOnReplication;
    }

    @Override
    public final void journalcomparisonMismatch(String s) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.journalcomparisonMismatch$str(), (Object)s);
    }

    protected String journalcomparisonMismatch$str() {
        return journalcomparisonMismatch;
    }

    @Override
    public final void errorDeletingLargeMessage(Exception e, long messageId) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorDeletingLargeMessage$str(), (Object)messageId);
    }

    protected String errorDeletingLargeMessage$str() {
        return errorDeletingLargeMessage;
    }

    @Override
    public final void largeMessageNotAvailable(long messageId) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.largeMessageNotAvailable$str(), (Object)messageId);
    }

    protected String largeMessageNotAvailable$str() {
        return largeMessageNotAvailable;
    }

    @Override
    public final void replicationStopOnBackupShutdown() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.replicationStopOnBackupShutdown$str(), new Object[0]);
    }

    protected String replicationStopOnBackupShutdown$str() {
        return replicationStopOnBackupShutdown;
    }

    @Override
    public final void replicationStopOnBackupFail(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.replicationStopOnBackupFail$str(), new Object[0]);
    }

    protected String replicationStopOnBackupFail$str() {
        return replicationStopOnBackupFail;
    }

    @Override
    public final void timedOutWaitingToStopBridge() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.timedOutWaitingToStopBridge$str(), new Object[0]);
    }

    protected String timedOutWaitingToStopBridge$str() {
        return timedOutWaitingToStopBridge;
    }

    @Override
    public final void bridgeUnableToSendMessage(Exception e, MessageReference ref) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.bridgeUnableToSendMessage$str(), (Object)ref);
    }

    protected String bridgeUnableToSendMessage$str() {
        return bridgeUnableToSendMessage;
    }

    @Override
    public final void bridgeConnectionFailed(Boolean failedOver) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.bridgeConnectionFailed$str(), (Object)failedOver);
    }

    protected String bridgeConnectionFailed$str() {
        return bridgeConnectionFailed;
    }

    @Override
    public final void errorQueryingBridge(Throwable t, SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, t, this.errorQueryingBridge1$str(), (Object)name);
    }

    protected String errorQueryingBridge1$str() {
        return errorQueryingBridge1;
    }

    @Override
    public final void errorQueryingBridge(SimpleString address, Integer retryCount) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.errorQueryingBridge2$str(), (Object)address, (Object)retryCount);
    }

    protected String errorQueryingBridge2$str() {
        return errorQueryingBridge2;
    }

    @Override
    public final void errorStartingBridge(SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.errorStartingBridge$str(), (Object)name);
    }

    protected String errorStartingBridge$str() {
        return errorStartingBridge;
    }

    @Override
    public final void errorConnectingBridge(Exception e, Bridge bridge) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorConnectingBridge$str(), (Object)bridge);
    }

    protected String errorConnectingBridge$str() {
        return errorConnectingBridge;
    }

    @Override
    public final void bridgeLocatorShutdown() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.bridgeLocatorShutdown$str(), new Object[0]);
    }

    protected String bridgeLocatorShutdown$str() {
        return bridgeLocatorShutdown;
    }

    @Override
    public final void bridgeAbortStart(SimpleString name, Integer retryCount, Integer reconnectAttempts) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.bridgeAbortStart$str(), (Object)name, (Object)retryCount, (Object)reconnectAttempts);
    }

    protected String bridgeAbortStart$str() {
        return bridgeAbortStart;
    }

    @Override
    public final void errorReConnecting(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorReConnecting$str(), new Object[0]);
    }

    protected String errorReConnecting$str() {
        return errorReConnecting;
    }

    @Override
    public final void timedOutXID(Xid xid) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.timedOutXID$str(), (Object)xid);
    }

    protected String timedOutXID$str() {
        return timedOutXID;
    }

    @Override
    public final void ioErrorOnTX(Integer errorCode, String errorMessage) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.ioErrorOnTX$str(), (Object)errorCode, (Object)errorMessage);
    }

    protected String ioErrorOnTX$str() {
        return ioErrorOnTX;
    }

    @Override
    public final void errorCompletingContext(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorCompletingContext$str(), new Object[0]);
    }

    protected String errorCompletingContext$str() {
        return errorCompletingContext;
    }

    @Override
    public final void replacingIncompleteLargeMessage(Long messageID) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.replacingIncompleteLargeMessage$str(), (Object)messageID);
    }

    protected String replacingIncompleteLargeMessage$str() {
        return replacingIncompleteLargeMessage;
    }

    @Override
    public final void clientConnectionFailedClearingSession(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.clientConnectionFailedClearingSession$str(), (Object)name);
    }

    protected String clientConnectionFailedClearingSession$str() {
        return clientConnectionFailedClearingSession;
    }

    @Override
    public final void broadcastGroupClosed(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.broadcastGroupClosed$str(), new Object[0]);
    }

    protected String broadcastGroupClosed$str() {
        return broadcastGroupClosed;
    }

    @Override
    public final void timeoutLockingConsumer() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.timeoutLockingConsumer$str(), new Object[0]);
    }

    protected String timeoutLockingConsumer$str() {
        return timeoutLockingConsumer;
    }

    @Override
    public final void noQueueIdDefined(Message message, Message messageCopy, SimpleString idsHeaderName) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.noQueueIdDefined$str(), (Object)message, (Object)messageCopy, (Object)idsHeaderName);
    }

    protected String noQueueIdDefined$str() {
        return noQueueIdDefined;
    }

    @Override
    public final void managementOperationError(Exception e, String op, String resourceName) {
        this.log.logv(FQCN, Logger.Level.TRACE, (Throwable)e, this.managementOperationError$str(), (Object)op, (Object)resourceName);
    }

    protected String managementOperationError$str() {
        return managementOperationError;
    }

    @Override
    public final void managementAttributeError(Exception e, String att, String resourceName) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.managementAttributeError$str(), (Object)att, (Object)resourceName);
    }

    protected String managementAttributeError$str() {
        return managementAttributeError;
    }

    public final void managementStopError(Integer size, List unexpectedResourceNames) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.managementStopError$str(), (Object)size, (Object)unexpectedResourceNames);
    }

    protected String managementStopError$str() {
        return managementStopError;
    }

    @Override
    public final void unableToDeleteGroupBindings(Exception e, SimpleString groupId) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToDeleteGroupBindings$str(), (Object)groupId);
    }

    protected String unableToDeleteGroupBindings$str() {
        return unableToDeleteGroupBindings;
    }

    @Override
    public final void errorClosingServerLocator(Exception e, ServerLocatorInternal clusterLocator) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorClosingServerLocator$str(), (Object)clusterLocator);
    }

    protected String errorClosingServerLocator$str() {
        return errorClosingServerLocator;
    }

    @Override
    public final void unableToStartBroadcastGroup(Exception e, String name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToStartBroadcastGroup$str(), (Object)name);
    }

    protected String unableToStartBroadcastGroup$str() {
        return unableToStartBroadcastGroup;
    }

    @Override
    public final void unableToStartClusterConnection(Exception e, SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToStartClusterConnection$str(), (Object)name);
    }

    protected String unableToStartClusterConnection$str() {
        return unableToStartClusterConnection;
    }

    @Override
    public final void unableToStartBridge(Exception e, SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.unableToStartBridge$str(), (Object)name);
    }

    protected String unableToStartBridge$str() {
        return unableToStartBridge;
    }

    @Override
    public final void announceBackupNoConnector(String connectorName) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.announceBackupNoConnector$str(), (Object)connectorName);
    }

    protected String announceBackupNoConnector$str() {
        return announceBackupNoConnector;
    }

    @Override
    public final void announceBackupNoClusterConnections() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.announceBackupNoClusterConnections$str(), new Object[0]);
    }

    protected String announceBackupNoClusterConnections$str() {
        return announceBackupNoClusterConnections;
    }

    @Override
    public final void bridgeNotUnique() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.bridgeNotUnique$str(), new Object[0]);
    }

    protected String bridgeNotUnique$str() {
        return bridgeNotUnique;
    }

    @Override
    public final void bridgeNoQueue(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.bridgeNoQueue$str(), (Object)name);
    }

    protected String bridgeNoQueue$str() {
        return bridgeNoQueue;
    }

    @Override
    public final void bridgeNoForwardAddress(String bridgeName) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.bridgeNoForwardAddress$str(), (Object)bridgeName);
    }

    protected String bridgeNoForwardAddress$str() {
        return bridgeNoForwardAddress;
    }

    @Override
    public final void bridgeAlreadyDeployed(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.bridgeAlreadyDeployed$str(), (Object)name);
    }

    protected String bridgeAlreadyDeployed$str() {
        return bridgeAlreadyDeployed;
    }

    @Override
    public final void bridgeQueueNotFound(String queueName, String bridgeName) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.bridgeQueueNotFound$str(), (Object)queueName, (Object)bridgeName);
    }

    protected String bridgeQueueNotFound$str() {
        return bridgeQueueNotFound;
    }

    @Override
    public final void bridgeNoDiscoveryGroup(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.bridgeNoDiscoveryGroup$str(), (Object)name);
    }

    protected String bridgeNoDiscoveryGroup$str() {
        return bridgeNoDiscoveryGroup;
    }

    @Override
    public final void clusterConnectionNotUnique() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.clusterConnectionNotUnique$str(), new Object[0]);
    }

    protected String clusterConnectionNotUnique$str() {
        return clusterConnectionNotUnique;
    }

    @Override
    public final void clusterConnectionNoForwardAddress() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.clusterConnectionNoForwardAddress$str(), new Object[0]);
    }

    protected String clusterConnectionNoForwardAddress$str() {
        return clusterConnectionNoForwardAddress;
    }

    @Override
    public final void clusterConnectionNoConnector(String connectorName) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.clusterConnectionNoConnector$str(), (Object)connectorName);
    }

    protected String clusterConnectionNoConnector$str() {
        return clusterConnectionNoConnector;
    }

    @Override
    public final void clusterConnectionAlreadyExists(String connectorName) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.clusterConnectionAlreadyExists$str(), (Object)connectorName);
    }

    protected String clusterConnectionAlreadyExists$str() {
        return clusterConnectionAlreadyExists;
    }

    @Override
    public final void clusterConnectionNoDiscoveryGroup(String discoveryGroupName) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.clusterConnectionNoDiscoveryGroup$str(), (Object)discoveryGroupName);
    }

    protected String clusterConnectionNoDiscoveryGroup$str() {
        return clusterConnectionNoDiscoveryGroup;
    }

    @Override
    public final void broadcastGroupAlreadyExists(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.broadcastGroupAlreadyExists$str(), (Object)name);
    }

    protected String broadcastGroupAlreadyExists$str() {
        return broadcastGroupAlreadyExists;
    }

    @Override
    public final void broadcastGroupNoConnector(String connectorName, String bgName) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.broadcastGroupNoConnector$str(), (Object)connectorName, (Object)bgName);
    }

    protected String broadcastGroupNoConnector$str() {
        return broadcastGroupNoConnector;
    }

    @Override
    public final void noConnector(String name) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.noConnector$str(), (Object)name);
    }

    protected String noConnector$str() {
        return noConnector;
    }

    @Override
    public final void errorStoppingRedistributor() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.errorStoppingRedistributor$str(), new Object[0]);
    }

    protected String errorStoppingRedistributor$str() {
        return errorStoppingRedistributor;
    }

    @Override
    public final void ioErrorRedistributing(Integer errorCode, String errorMessage) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.ioErrorRedistributing$str(), (Object)errorCode, (Object)errorMessage);
    }

    protected String ioErrorRedistributing$str() {
        return ioErrorRedistributing;
    }

    @Override
    public final void errorAnnouncingBackup(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.errorAnnouncingBackup$str(), new Object[0]);
    }

    protected String errorAnnouncingBackup$str() {
        return errorAnnouncingBackup;
    }

    @Override
    public final void noLocalMemborOnClusterConnection(ClusterConnectionImpl clusterConnection) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.noLocalMemborOnClusterConnection$str(), (Object)clusterConnection);
    }

    protected String noLocalMemborOnClusterConnection$str() {
        return noLocalMemborOnClusterConnection;
    }

    @Override
    public final void remoteQueueAlreadyBoundOnClusterConnection(Object messageFlowRecord, SimpleString clusterName) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.remoteQueueAlreadyBoundOnClusterConnection$str(), messageFlowRecord, (Object)clusterName);
    }

    protected String remoteQueueAlreadyBoundOnClusterConnection$str() {
        return remoteQueueAlreadyBoundOnClusterConnection;
    }

    @Override
    public final void nodeManagerCantOpenFile(Exception e, File file) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.nodeManagerCantOpenFile$str(), (Object)file);
    }

    protected String nodeManagerCantOpenFile$str() {
        return nodeManagerCantOpenFile;
    }

    @Override
    public final void errorResttingLargeMessage(Throwable e, Object deliverer) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.errorResttingLargeMessage$str(), deliverer);
    }

    protected String errorResttingLargeMessage$str() {
        return errorResttingLargeMessage;
    }

    @Override
    public final void errorTransferringConsumer() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.errorTransferringConsumer$str(), new Object[0]);
    }

    protected String errorTransferringConsumer$str() {
        return errorTransferringConsumer;
    }

    @Override
    public final void errorFlushingExecutorsOnQueue() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.errorFlushingExecutorsOnQueue$str(), new Object[0]);
    }

    protected String errorFlushingExecutorsOnQueue$str() {
        return errorFlushingExecutorsOnQueue;
    }

    @Override
    public final void errorExpiringReferencesOnQueue(Exception e, MessageReference ref) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.errorExpiringReferencesOnQueue$str(), (Object)ref);
    }

    protected String errorExpiringReferencesOnQueue$str() {
        return errorExpiringReferencesOnQueue;
    }

    @Override
    public final void errorExpiringReferencesNoBindings(SimpleString expiryAddress) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.errorExpiringReferencesNoBindings$str(), (Object)expiryAddress);
    }

    protected String errorExpiringReferencesNoBindings$str() {
        return errorExpiringReferencesNoBindings;
    }

    @Override
    public final void errorExpiringReferencesNoQueue(SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.errorExpiringReferencesNoQueue$str(), (Object)name);
    }

    protected String errorExpiringReferencesNoQueue$str() {
        return errorExpiringReferencesNoQueue;
    }

    @Override
    public final void messageExceededMaxDelivery(MessageReference ref, SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.messageExceededMaxDelivery$str(), (Object)ref, (Object)name);
    }

    protected String messageExceededMaxDelivery$str() {
        return messageExceededMaxDelivery;
    }

    @Override
    public final void messageExceededMaxDeliverySendtoDLA(MessageReference ref, SimpleString name, SimpleString simpleString) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.messageExceededMaxDeliverySendtoDLA$str(), (Object)ref, (Object)name, (Object)simpleString);
    }

    protected String messageExceededMaxDeliverySendtoDLA$str() {
        return messageExceededMaxDeliverySendtoDLA;
    }

    @Override
    public final void messageExceededMaxDeliveryNoDLA(MessageReference ref, SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.messageExceededMaxDeliveryNoDLA$str(), (Object)ref, (Object)name);
    }

    protected String messageExceededMaxDeliveryNoDLA$str() {
        return messageExceededMaxDeliveryNoDLA;
    }

    @Override
    public final void removingBadConsumer(Throwable e, Consumer consumer, MessageReference reference) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.removingBadConsumer$str(), (Object)consumer, (Object)reference);
    }

    protected String removingBadConsumer$str() {
        return removingBadConsumer;
    }

    @Override
    public final void errorDecrementingRefCount(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.errorDecrementingRefCount$str(), new Object[0]);
    }

    protected String errorDecrementingRefCount$str() {
        return errorDecrementingRefCount;
    }

    @Override
    public final void errorRemovingMessage(Throwable e, Long messageID) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.errorRemovingMessage$str(), (Object)messageID);
    }

    protected String errorRemovingMessage$str() {
        return errorRemovingMessage;
    }

    @Override
    public final void errorCheckingDLQ(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.errorCheckingDLQ$str(), new Object[0]);
    }

    protected String errorCheckingDLQ$str() {
        return errorCheckingDLQ;
    }

    @Override
    public final void errorRegisteringBackup() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.errorRegisteringBackup$str(), new Object[0]);
    }

    protected String errorRegisteringBackup$str() {
        return errorRegisteringBackup;
    }

    @Override
    public final void memoryError(Integer memoryWarningThreshold, String info) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.memoryError$str(), (Object)memoryWarningThreshold, (Object)info);
    }

    protected String memoryError$str() {
        return memoryError;
    }

    @Override
    public final void errorCompletingCallbackOnReplicationManager(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.errorCompletingCallbackOnReplicationManager$str(), new Object[0]);
    }

    protected String errorCompletingCallbackOnReplicationManager$str() {
        return errorCompletingCallbackOnReplicationManager;
    }

    @Override
    public final void activationDidntFinish(ActiveMQServer server) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.activationDidntFinish$str(), (Object)server);
    }

    protected String activationDidntFinish$str() {
        return activationDidntFinish;
    }

    @Override
    public final void broadcastBridgeStoppedError(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.broadcastBridgeStoppedError$str(), new Object[0]);
    }

    protected String broadcastBridgeStoppedError$str() {
        return broadcastBridgeStoppedError;
    }

    @Override
    public final void notificationBridgeStoppedError(Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.notificationBridgeStoppedError$str(), new Object[0]);
    }

    protected String notificationBridgeStoppedError$str() {
        return notificationBridgeStoppedError;
    }

    @Override
    public final void groupHandlerSendTimeout() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.groupHandlerSendTimeout$str(), new Object[0]);
    }

    protected String groupHandlerSendTimeout$str() {
        return groupHandlerSendTimeout;
    }

    @Override
    public final void backupMovingDataAway(String oldPath, String newPath) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.backupMovingDataAway$str(), (Object)oldPath, (Object)newPath);
    }

    protected String backupMovingDataAway$str() {
        return backupMovingDataAway;
    }

    @Override
    public final void stopReplicatedBackupAfterFailback() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.stopReplicatedBackupAfterFailback$str(), new Object[0]);
    }

    protected String stopReplicatedBackupAfterFailback$str() {
        return stopReplicatedBackupAfterFailback;
    }

    @Override
    public final void errorStartingReplication(BackupReplicationStartFailedMessage.BackupRegistrationProblem problem) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.errorStartingReplication1$str(), (Object)problem);
    }

    protected String errorStartingReplication1$str() {
        return errorStartingReplication1;
    }

    @Override
    public final void AddressSettingsNoDLA(SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.AddressSettingsNoDLA$str(), (Object)name);
    }

    protected String AddressSettingsNoDLA$str() {
        return AddressSettingsNoDLA;
    }

    @Override
    public final void AddressSettingsNoExpiryAddress(SimpleString name) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.AddressSettingsNoExpiryAddress$str(), (Object)name);
    }

    protected String AddressSettingsNoExpiryAddress$str() {
        return AddressSettingsNoExpiryAddress;
    }

    @Override
    public final void groupingQueueRemoved(int size, SimpleString clusterName) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.groupingQueueRemoved$str(), (Object)size, (Object)clusterName);
    }

    protected String groupingQueueRemoved$str() {
        return groupingQueueRemoved;
    }

    @Override
    public final void warnDeprecatedProtocol() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.warnDeprecatedProtocol$str(), new Object[0]);
    }

    protected String warnDeprecatedProtocol$str() {
        return warnDeprecatedProtocol;
    }

    @Override
    public final void warnDisconnectOldClient(String queueName) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.warnDisconnectOldClient$str(), (Object)queueName);
    }

    protected String warnDisconnectOldClient$str() {
        return warnDisconnectOldClient;
    }

    @Override
    public final void bridgeConfirmationWindowTooSmall(String bridgeName, String address, int windowConfirmation, long maxSizeBytes) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.bridgeConfirmationWindowTooSmall$str(), new Object[]{bridgeName, address, windowConfirmation, maxSizeBytes});
    }

    protected String bridgeConfirmationWindowTooSmall$str() {
        return bridgeConfirmationWindowTooSmall;
    }

    @Override
    public final void bridgeCantFindAddressConfig(String bridgeName, String forwardingAddress) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.bridgeCantFindAddressConfig$str(), (Object)bridgeName, (Object)forwardingAddress);
    }

    protected String bridgeCantFindAddressConfig$str() {
        return bridgeCantFindAddressConfig;
    }

    @Override
    public final void queueBusy(String name, long timeout) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.queueBusy$str(), (Object)name, (Object)timeout);
    }

    protected String queueBusy$str() {
        return queueBusy;
    }

    @Override
    public final void queueDuplicatedRenaming(String name, String newName) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.queueDuplicatedRenaming$str(), (Object)name, (Object)newName);
    }

    protected String queueDuplicatedRenaming$str() {
        return queueDuplicatedRenaming;
    }

    @Override
    public final void timeoutFlushInTransit(String queueName, String addressName) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.timeoutFlushInTransit$str(), (Object)queueName, (Object)addressName);
    }

    protected String timeoutFlushInTransit$str() {
        return timeoutFlushInTransit;
    }

    @Override
    public final void bridgeCantFindConnectors(String bridgeName) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.bridgeCantFindConnectors$str(), (Object)bridgeName);
    }

    protected String bridgeCantFindConnectors$str() {
        return bridgeCantFindConnectors;
    }

    @Override
    public final void xidReplacedOnXStart(String xidOriginalToString, String xidReplacedToString) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.xidReplacedOnXStart$str(), (Object)xidOriginalToString, (Object)xidReplacedToString);
    }

    protected String xidReplacedOnXStart$str() {
        return xidReplacedOnXStart;
    }

    @Override
    public final void rolePermissionConfigurationError(String permission) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.rolePermissionConfigurationError$str(), (Object)permission);
    }

    protected String rolePermissionConfigurationError$str() {
        return rolePermissionConfigurationError;
    }

    @Override
    public final void errorRecoveringPageCounter(Throwable error) {
        this.log.logv(FQCN, Logger.Level.WARN, error, this.errorRecoveringPageCounter$str(), new Object[0]);
    }

    protected String errorRecoveringPageCounter$str() {
        return errorRecoveringPageCounter;
    }

    @Override
    public final void failedToScaleDown(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.failedToScaleDown$str(), new Object[0]);
    }

    protected String failedToScaleDown$str() {
        return failedToScaleDown;
    }

    @Override
    public final void missingClusterConfigForScaleDown(String scaleDownCluster) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.missingClusterConfigForScaleDown$str(), (Object)scaleDownCluster);
    }

    protected String missingClusterConfigForScaleDown$str() {
        return missingClusterConfigForScaleDown;
    }

    @Override
    public final void blockingMessageProduction(SimpleString addressName, long currentSize, long maxSize, long globalMaxSize) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.blockingMessageProduction$str(), new Object[]{addressName, currentSize, maxSize, globalMaxSize});
    }

    protected String blockingMessageProduction$str() {
        return blockingMessageProduction;
    }

    @Override
    public final void groupBindingsOnRecovery() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.groupBindingsOnRecovery$str(), new Object[0]);
    }

    protected String groupBindingsOnRecovery$str() {
        return groupBindingsOnRecovery;
    }

    @Override
    public final void noClusterConnectionForReplicationCluster() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.noClusterConnectionForReplicationCluster$str(), new Object[0]);
    }

    protected String noClusterConnectionForReplicationCluster$str() {
        return noClusterConnectionForReplicationCluster;
    }

    @Override
    public final void clusterControlAuthfailure() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.clusterControlAuthfailure$str(), new Object[0]);
    }

    protected String clusterControlAuthfailure$str() {
        return clusterControlAuthfailure;
    }

    @Override
    public final void activateReplicatedBackupFailed(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.activateReplicatedBackupFailed$str(), new Object[0]);
    }

    protected String activateReplicatedBackupFailed$str() {
        return activateReplicatedBackupFailed;
    }

    @Override
    public final void unableToFindTargetQueue(String targetNodeID) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.unableToFindTargetQueue$str(), (Object)targetNodeID);
    }

    protected String unableToFindTargetQueue$str() {
        return unableToFindTargetQueue;
    }

    @Override
    public final void activateSharedStoreSlaveFailed(Throwable e) {
        this.log.logv(FQCN, Logger.Level.WARN, e, this.activateSharedStoreSlaveFailed$str(), new Object[0]);
    }

    protected String activateSharedStoreSlaveFailed$str() {
        return activateSharedStoreSlaveFailed;
    }

    @Override
    public final void cannotFindRoleForUser(String user) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.cannotFindRoleForUser$str(), (Object)user);
    }

    protected String cannotFindRoleForUser$str() {
        return cannotFindRoleForUser;
    }

    @Override
    public final void couldNotDeleteTempFile(String tempFileName) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.couldNotDeleteTempFile$str(), (Object)tempFileName);
    }

    protected String couldNotDeleteTempFile$str() {
        return couldNotDeleteTempFile;
    }

    @Override
    public final void memoryLimitReached(String producerID, String address, long duration) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.memoryLimitReached$str(), (Object)producerID, (Object)address, (Object)duration);
    }

    protected String memoryLimitReached$str() {
        return memoryLimitReached;
    }

    @Override
    public final void nullPageCursorInfo(String address, String position, long id) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.nullPageCursorInfo$str(), (Object)address, (Object)position, (Object)id);
    }

    protected String nullPageCursorInfo$str() {
        return nullPageCursorInfo;
    }

    @Override
    public final void largeMessageNotFound(long id) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.largeMessageNotFound$str(), (Object)id);
    }

    protected String largeMessageNotFound$str() {
        return largeMessageNotFound;
    }

    @Override
    public final void bindingNotFound(long id, String message, String binding) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.bindingNotFound$str(), (Object)id, (Object)message, (Object)binding);
    }

    protected String bindingNotFound$str() {
        return bindingNotFound;
    }

    @Override
    public final void nonDeliveryHandled() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.nonDeliveryHandled$str(), new Object[0]);
    }

    protected String nonDeliveryHandled$str() {
        return nonDeliveryHandled;
    }

    @Override
    public final void couldNotFlushClusterManager(String manager) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.couldNotFlushClusterManager$str(), (Object)manager);
    }

    protected String couldNotFlushClusterManager$str() {
        return couldNotFlushClusterManager;
    }

    @Override
    public final void threadDump(String manager) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.threadDump$str(), (Object)manager);
    }

    protected String threadDump$str() {
        return threadDump;
    }

    @Override
    public final void couldNotFinishExecutor(String clusterConnection) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.couldNotFinishExecutor$str(), (Object)clusterConnection);
    }

    protected String couldNotFinishExecutor$str() {
        return couldNotFinishExecutor;
    }

    @Override
    public final void activationTimeout() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.activationTimeout$str(), new Object[0]);
    }

    protected String activationTimeout$str() {
        return activationTimeout;
    }

    @Override
    public final void connectionTTLEqualsCheckPeriod(String connectionName, String ttl, String checkPeriod) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.connectionTTLEqualsCheckPeriod$str(), (Object)connectionName, (Object)ttl, (Object)checkPeriod);
    }

    protected String connectionTTLEqualsCheckPeriod$str() {
        return connectionTTLEqualsCheckPeriod;
    }

    @Override
    public final void noProtocolManagerFound(String protocol, String host) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.noProtocolManagerFound$str(), (Object)protocol, (Object)host);
    }

    protected String noProtocolManagerFound$str() {
        return noProtocolManagerFound;
    }

    @Override
    public final void duplicatedAcceptor(String name, String parameters, String classFactory) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.duplicatedAcceptor$str(), (Object)name, (Object)parameters, (Object)classFactory);
    }

    protected String duplicatedAcceptor$str() {
        return duplicatedAcceptor;
    }

    @Override
    public final void potentialOOME(long addressCount, long totalMaxSizeBytes, long maxMemory) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.potentialOOME$str(), (Object)addressCount, (Object)totalMaxSizeBytes, (Object)maxMemory);
    }

    protected String potentialOOME$str() {
        return potentialOOME;
    }

    @Override
    public final void connectionLimitReached(long connectionsAllowed, String address) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.connectionLimitReached$str(), (Object)connectionsAllowed, (Object)address);
    }

    protected String connectionLimitReached$str() {
        return connectionLimitReached;
    }

    @Override
    public final void slowReplicationResponse() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.slowReplicationResponse$str(), new Object[0]);
    }

    protected String slowReplicationResponse$str() {
        return slowReplicationResponse;
    }

    @Override
    public final void sslHandshakeFailed(String clientAddress, String cause) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.sslHandshakeFailed$str(), (Object)clientAddress, (Object)cause);
    }

    protected String sslHandshakeFailed$str() {
        return sslHandshakeFailed;
    }

    @Override
    public final void impossibleToRouteGrouped() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.impossibleToRouteGrouped$str(), new Object[0]);
    }

    protected String impossibleToRouteGrouped$str() {
        return impossibleToRouteGrouped;
    }

    @Override
    public final void diskBeyondCapacity() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.diskBeyondCapacity$str(), new Object[0]);
    }

    protected String diskBeyondCapacity$str() {
        return diskBeyondCapacity;
    }

    @Override
    public final void diskCapacityRestored() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.diskCapacityRestored$str(), new Object[0]);
    }

    protected String diskCapacityRestored$str() {
        return diskCapacityRestored;
    }

    @Override
    public final void blockingDiskFull(SimpleString addressName) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.blockingDiskFull$str(), (Object)addressName);
    }

    protected String blockingDiskFull$str() {
        return blockingDiskFull;
    }

    @Override
    public final void serverIsolatedOnNetwork() {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.serverIsolatedOnNetwork$str(), new Object[0]);
    }

    protected String serverIsolatedOnNetwork$str() {
        return serverIsolatedOnNetwork;
    }

    @Override
    public final void negativeAddressSize(long size, String destination) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.negativeAddressSize$str(), (Object)size, (Object)destination);
    }

    protected String negativeAddressSize$str() {
        return negativeAddressSize;
    }

    @Override
    public final void negativeGlobalAddressSize(long size) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.negativeGlobalAddressSize$str(), (Object)size);
    }

    protected String negativeGlobalAddressSize$str() {
        return negativeGlobalAddressSize;
    }

    @Override
    public final void securityProblemWhileCreatingSession(String message) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.securityProblemWhileCreatingSession$str(), (Object)message);
    }

    protected String securityProblemWhileCreatingSession$str() {
        return securityProblemWhileCreatingSession;
    }

    @Override
    public final void connectorRefNotFound(String connectorRef, String clusterConnection) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.connectorRefNotFound$str(), (Object)connectorRef, (Object)clusterConnection);
    }

    protected String connectorRefNotFound$str() {
        return connectorRefNotFound;
    }

    @Override
    public final void disconnectCritical(String reason, Exception e) {
        this.log.logv(FQCN, Logger.Level.WARN, (Throwable)e, this.disconnectCritical$str(), (Object)reason);
    }

    protected String disconnectCritical$str() {
        return disconnectCritical;
    }

    @Override
    public final void initializationError(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, this.initializationError$str(), new Object[0]);
    }

    protected String initializationError$str() {
        return initializationError;
    }

    @Override
    public final void errorDeployingURI(Throwable e, URI uri) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, this.errorDeployingURI1$str(), (Object)uri);
    }

    protected String errorDeployingURI1$str() {
        return errorDeployingURI1;
    }

    @Override
    public final void errorDeployingURI(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, this.errorDeployingURI0$str(), new Object[0]);
    }

    protected String errorDeployingURI0$str() {
        return errorDeployingURI0;
    }

    @Override
    public final void errorUnDeployingURI(Throwable e, URI a) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, this.errorUnDeployingURI$str(), (Object)a);
    }

    protected String errorUnDeployingURI$str() {
        return errorUnDeployingURI;
    }

    @Override
    public final void unableToDeployNode(Exception e, Node node) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.unableToDeployNode$str(), (Object)node);
    }

    protected String unableToDeployNode$str() {
        return unableToDeployNode;
    }

    @Override
    public final void invalidFilter(SimpleString filter, Throwable cause) {
        this.log.logv(FQCN, Logger.Level.ERROR, cause, this.invalidFilter$str(), (Object)filter);
    }

    protected String invalidFilter$str() {
        return invalidFilter;
    }

    @Override
    public final void pageSubscriptionError(IOCallback IOCallback2, String error) {
        this.log.logv(FQCN, Logger.Level.ERROR, null, this.pageSubscriptionError$str(), (Object)IOCallback2, (Object)error);
    }

    protected String pageSubscriptionError$str() {
        return pageSubscriptionError;
    }

    @Override
    public final void batchingIdError(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.batchingIdError$str(), new Object[0]);
    }

    protected String batchingIdError$str() {
        return batchingIdError;
    }

    @Override
    public final void cannotFindMessage(Long id) {
        this.log.logv(FQCN, Logger.Level.ERROR, null, this.cannotFindMessage$str(), (Object)id);
    }

    protected String cannotFindMessage$str() {
        return cannotFindMessage;
    }

    @Override
    public final void journalCannotFindQueue(Long queue, Long id) {
        this.log.logv(FQCN, Logger.Level.ERROR, null, this.journalCannotFindQueue$str(), (Object)queue, (Object)id);
    }

    protected String journalCannotFindQueue$str() {
        return journalCannotFindQueue;
    }

    @Override
    public final void journalCannotFindQueueScheduled(Long queue, Long id) {
        this.log.logv(FQCN, Logger.Level.ERROR, null, this.journalCannotFindQueueScheduled$str(), (Object)queue, (Object)id);
    }

    protected String journalCannotFindQueueScheduled$str() {
        return journalCannotFindQueueScheduled;
    }

    @Override
    public final void largeMessageErrorReleasingResources(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.largeMessageErrorReleasingResources$str(), new Object[0]);
    }

    protected String largeMessageErrorReleasingResources$str() {
        return largeMessageErrorReleasingResources;
    }

    @Override
    public final void errorExpiringMessages(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorExpiringMessages$str(), new Object[0]);
    }

    protected String errorExpiringMessages$str() {
        return errorExpiringMessages;
    }

    @Override
    public final void errorClosingSession(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorClosingSession$str(), new Object[0]);
    }

    protected String errorClosingSession$str() {
        return errorClosingSession;
    }

    @Override
    public final void caughtXaException(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.caughtXaException$str(), new Object[0]);
    }

    protected String caughtXaException$str() {
        return caughtXaException;
    }

    @Override
    public final void caughtException(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, this.caughtException$str(), new Object[0]);
    }

    protected String caughtException$str() {
        return caughtException;
    }

    @Override
    public final void invalidPacket(Packet packet) {
        this.log.logv(FQCN, Logger.Level.ERROR, null, this.invalidPacket$str(), (Object)packet);
    }

    protected String invalidPacket$str() {
        return invalidPacket;
    }

    @Override
    public final void failedToCreateSession(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToCreateSession$str(), new Object[0]);
    }

    protected String failedToCreateSession$str() {
        return failedToCreateSession;
    }

    @Override
    public final void failedToReattachSession(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToReattachSession$str(), new Object[0]);
    }

    protected String failedToReattachSession$str() {
        return failedToReattachSession;
    }

    @Override
    public final void failedToHandleCreateQueue(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToHandleCreateQueue$str(), new Object[0]);
    }

    protected String failedToHandleCreateQueue$str() {
        return failedToHandleCreateQueue;
    }

    @Override
    public final void errorDecodingPacket(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorDecodingPacket$str(), new Object[0]);
    }

    protected String errorDecodingPacket$str() {
        return errorDecodingPacket;
    }

    @Override
    public final void errorCallingFailureListener(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, this.errorCallingFailureListener$str(), new Object[0]);
    }

    protected String errorCallingFailureListener$str() {
        return errorCallingFailureListener;
    }

    @Override
    public final void stompErrorTXExists(String txID) {
        this.log.logv(FQCN, Logger.Level.ERROR, null, this.stompErrorTXExists$str(), (Object)txID);
    }

    protected String stompErrorTXExists$str() {
        return stompErrorTXExists;
    }

    @Override
    public final void errorWritingToInvmConnector(Exception e, Runnable runnable) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorWritingToInvmConnector$str(), (Object)runnable);
    }

    protected String errorWritingToInvmConnector$str() {
        return errorWritingToInvmConnector;
    }

    @Override
    public final void errorStoppingAcceptor(String name) {
        this.log.logv(FQCN, Logger.Level.ERROR, null, this.errorStoppingAcceptor$str(), (Object)name);
    }

    protected String errorStoppingAcceptor$str() {
        return errorStoppingAcceptor;
    }

    @Override
    public final void largeMessageIncompatible() {
        this.log.logv(FQCN, Logger.Level.ERROR, null, this.largeMessageIncompatible$str(), new Object[0]);
    }

    protected String largeMessageIncompatible$str() {
        return largeMessageIncompatible;
    }

    @Override
    public final void errorCancellingRefOnBridge(Exception e, MessageReference ref2) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorCancellingRefOnBridge$str(), (Object)ref2);
    }

    protected String errorCancellingRefOnBridge$str() {
        return errorCancellingRefOnBridge;
    }

    @Override
    public final void stompBeginTX(String txID) {
        this.log.logv(FQCN, Logger.Level.ERROR, null, this.stompBeginTX$str(), (Object)txID);
    }

    protected String stompBeginTX$str() {
        return stompBeginTX;
    }

    @Override
    public final void errorPausingBridge(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorPausingBridge$str(), new Object[0]);
    }

    protected String errorPausingBridge$str() {
        return errorPausingBridge;
    }

    @Override
    public final void errorBroadcastingConnectorConfigs(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorBroadcastingConnectorConfigs$str(), new Object[0]);
    }

    protected String errorBroadcastingConnectorConfigs$str() {
        return errorBroadcastingConnectorConfigs;
    }

    @Override
    public final void errorClosingConsumer(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorClosingConsumer$str(), new Object[0]);
    }

    protected String errorClosingConsumer$str() {
        return errorClosingConsumer;
    }

    @Override
    public final void errorClosingFlowRecord(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorClosingFlowRecord$str(), new Object[0]);
    }

    protected String errorClosingFlowRecord$str() {
        return errorClosingFlowRecord;
    }

    @Override
    public final void errorUpdatingTopology(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorUpdatingTopology$str(), new Object[0]);
    }

    protected String errorUpdatingTopology$str() {
        return errorUpdatingTopology;
    }

    @Override
    public final void errorHandlingMessage(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorHandlingMessage$str(), new Object[0]);
    }

    protected String errorHandlingMessage$str() {
        return errorHandlingMessage;
    }

    @Override
    public final void errorAckingOldReference(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorAckingOldReference$str(), new Object[0]);
    }

    protected String errorAckingOldReference$str() {
        return errorAckingOldReference;
    }

    @Override
    public final void errorExpiringRef(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorExpiringRef$str(), new Object[0]);
    }

    protected String errorExpiringRef$str() {
        return errorExpiringRef;
    }

    @Override
    public final void errorRemovingConsumer(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorRemovingConsumer$str(), new Object[0]);
    }

    protected String errorRemovingConsumer$str() {
        return errorRemovingConsumer;
    }

    @Override
    public final void errorDelivering(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorDelivering$str(), new Object[0]);
    }

    protected String errorDelivering$str() {
        return errorDelivering;
    }

    @Override
    public final void errorRestartingBackupServer(Exception e, ActiveMQServer backup) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorRestartingBackupServer$str(), (Object)backup);
    }

    protected String errorRestartingBackupServer$str() {
        return errorRestartingBackupServer;
    }

    @Override
    public final void errorSendingForcedDelivery(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorSendingForcedDelivery$str(), new Object[0]);
    }

    protected String errorSendingForcedDelivery$str() {
        return errorSendingForcedDelivery;
    }

    @Override
    public final void errorAckingMessage(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorAckingMessage$str(), new Object[0]);
    }

    protected String errorAckingMessage$str() {
        return errorAckingMessage;
    }

    @Override
    public final void errorRunningLargeMessageDeliverer(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorRunningLargeMessageDeliverer$str(), new Object[0]);
    }

    protected String errorRunningLargeMessageDeliverer$str() {
        return errorRunningLargeMessageDeliverer;
    }

    @Override
    public final void errorBrowserHandlingMessage(Exception e, MessageReference current) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorBrowserHandlingMessage$str(), (Object)current);
    }

    protected String errorBrowserHandlingMessage$str() {
        return errorBrowserHandlingMessage;
    }

    @Override
    public final void errorDeletingLargeMessageFile(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, this.errorDeletingLargeMessageFile$str(), new Object[0]);
    }

    protected String errorDeletingLargeMessageFile$str() {
        return errorDeletingLargeMessageFile;
    }

    @Override
    public final void errorRemovingTempQueue(Exception e, SimpleString bindingName) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorRemovingTempQueue$str(), (Object)bindingName);
    }

    protected String errorRemovingTempQueue$str() {
        return errorRemovingTempQueue;
    }

    @Override
    public final void cannotFindConsumer(long consumerID) {
        this.log.logv(FQCN, Logger.Level.ERROR, null, this.cannotFindConsumer$str(), (Object)consumerID);
    }

    protected String cannotFindConsumer$str() {
        return cannotFindConsumer;
    }

    @Override
    public final void errorClosingConnection(ServerSessionImpl serverSession) {
        this.log.logv(FQCN, Logger.Level.ERROR, null, this.errorClosingConnection$str(), (Object)serverSession);
    }

    protected String errorClosingConnection$str() {
        return errorClosingConnection;
    }

    @Override
    public final void errorCallingNotifListener(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorCallingNotifListener$str(), new Object[0]);
    }

    protected String errorCallingNotifListener$str() {
        return errorCallingNotifListener;
    }

    @Override
    public final void errorCallingRepoListener(Throwable e) {
        this.log.logv(FQCN, Logger.Level.ERROR, e, this.errorCallingRepoListener$str(), new Object[0]);
    }

    protected String errorCallingRepoListener$str() {
        return errorCallingRepoListener;
    }

    @Override
    public final void errorTimingOutTX(Exception e, Xid xid) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorTimingOutTX$str(), (Object)xid);
    }

    protected String errorTimingOutTX$str() {
        return errorTimingOutTX;
    }

    @Override
    public final void errorStoppingReplicationManager(Throwable t) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, this.errorStoppingReplicationManager$str(), new Object[0]);
    }

    protected String errorStoppingReplicationManager$str() {
        return errorStoppingReplicationManager;
    }

    @Override
    public final void bridgeFailedToAck(Throwable t) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, this.bridgeFailedToAck$str(), new Object[0]);
    }

    protected String bridgeFailedToAck$str() {
        return bridgeFailedToAck;
    }

    @Override
    public final void autoFailBackDenied() {
        this.log.logv(FQCN, Logger.Level.ERROR, null, this.autoFailBackDenied$str(), new Object[0]);
    }

    protected String autoFailBackDenied$str() {
        return autoFailBackDenied;
    }

    @Override
    public final void failbackMissedBackupAnnouncement() {
        this.log.logv(FQCN, Logger.Level.ERROR, null, this.failbackMissedBackupAnnouncement$str(), new Object[0]);
    }

    protected String failbackMissedBackupAnnouncement$str() {
        return failbackMissedBackupAnnouncement;
    }

    @Override
    public final void clusterManagerAuthenticationError(String msg) {
        this.log.logv(FQCN, Logger.Level.ERROR, null, this.clusterManagerAuthenticationError$str(), (Object)msg);
    }

    protected String clusterManagerAuthenticationError$str() {
        return clusterManagerAuthenticationError;
    }

    @Override
    public final void invalidCipherSuite(String validSuites) {
        this.log.logv(FQCN, Logger.Level.ERROR, null, this.invalidCipherSuite$str(), (Object)validSuites);
    }

    protected String invalidCipherSuite$str() {
        return invalidCipherSuite;
    }

    @Override
    public final void invalidProtocol(String validProtocols) {
        this.log.logv(FQCN, Logger.Level.ERROR, null, this.invalidProtocol$str(), (Object)validProtocols);
    }

    protected String invalidProtocol$str() {
        return invalidProtocol;
    }

    @Override
    public final void incompatibleWithHAPolicy(String parameter) {
        this.log.logv(FQCN, Logger.Level.ERROR, null, this.incompatibleWithHAPolicy$str(), (Object)parameter);
    }

    protected String incompatibleWithHAPolicy$str() {
        return incompatibleWithHAPolicy;
    }

    @Override
    public final void failedToSendSlowConsumerNotification(Notification notification, Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToSendSlowConsumerNotification$str(), (Object)notification);
    }

    protected String failedToSendSlowConsumerNotification$str() {
        return failedToSendSlowConsumerNotification;
    }

    @Override
    public final void failedToCloseConsumerConnectionsForAddress(String address, Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToCloseConsumerConnectionsForAddress$str(), (Object)address);
    }

    protected String failedToCloseConsumerConnectionsForAddress$str() {
        return failedToCloseConsumerConnectionsForAddress;
    }

    @Override
    public final void incompatibleWithHAPolicyChosen(String parameter) {
        this.log.logv(FQCN, Logger.Level.ERROR, null, this.incompatibleWithHAPolicyChosen$str(), (Object)parameter);
    }

    protected String incompatibleWithHAPolicyChosen$str() {
        return incompatibleWithHAPolicyChosen;
    }

    @Override
    public final void errorRemovingAutoCreatedQueue(Exception e, SimpleString bindingName) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorRemovingAutoCreatedQueue$str(), (Object)bindingName);
    }

    protected String errorRemovingAutoCreatedQueue$str() {
        return errorRemovingAutoCreatedQueue;
    }

    @Override
    public final void errorOpeningContextForLDAP(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorOpeningContextForLDAP$str(), new Object[0]);
    }

    protected String errorOpeningContextForLDAP$str() {
        return errorOpeningContextForLDAP;
    }

    @Override
    public final void errorPopulatingSecurityRolesFromLDAP(Exception e) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorPopulatingSecurityRolesFromLDAP$str(), new Object[0]);
    }

    protected String errorPopulatingSecurityRolesFromLDAP$str() {
        return errorPopulatingSecurityRolesFromLDAP;
    }

    @Override
    public final void errorStoppingComponent(Throwable t, String componentClassName) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, this.errorStoppingComponent$str(), (Object)componentClassName);
    }

    protected String errorStoppingComponent$str() {
        return errorStoppingComponent;
    }

    @Override
    public final void configurationReloadFailed(Throwable t) {
        this.log.logv(FQCN, Logger.Level.ERROR, t, this.configurationReloadFailed$str(), new Object[0]);
    }

    protected String configurationReloadFailed$str() {
        return configurationReloadFailed;
    }

    @Override
    public final void invalidMessageCounterPeriod(long value) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.invalidMessageCounterPeriod$str(), (Object)value);
    }

    protected String invalidMessageCounterPeriod$str() {
        return invalidMessageCounterPeriod;
    }

    @Override
    public final void journalUseMAPPED() {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.journalUseMAPPED$str(), new Object[0]);
    }

    protected String journalUseMAPPED$str() {
        return journalUseMAPPED;
    }

    @Override
    public final void failedToPurgeQueue(Exception e, SimpleString bindingName) {
        this.log.logv(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToPurgeQueue$str(), (Object)bindingName);
    }

    protected String failedToPurgeQueue$str() {
        return failedToPurgeQueue;
    }

    @Override
    public final void journalCannotFindPageTX(Long id) {
        this.log.logv(FQCN, Logger.Level.ERROR, null, this.journalCannotFindPageTX$str(), (Object)id);
    }

    protected String journalCannotFindPageTX$str() {
        return journalCannotFindPageTX;
    }

    @Override
    public final void undeployAddress(SimpleString addressName) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.undeployAddress$str(), (Object)addressName);
    }

    protected String undeployAddress$str() {
        return undeployAddress;
    }

    @Override
    public final void undeployQueue(SimpleString queueName) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.undeployQueue$str(), (Object)queueName);
    }

    protected String undeployQueue$str() {
        return undeployQueue;
    }

    @Override
    public final void duplicateCacheSizeWarning(int idCacheSize, int confirmationWindowSize) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.duplicateCacheSizeWarning$str(), (Object)idCacheSize, (Object)confirmationWindowSize);
    }

    protected String duplicateCacheSizeWarning$str() {
        return duplicateCacheSizeWarning;
    }
}

