/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.openwire;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.InflaterOutputStream;
import javax.jms.JMSException;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.protocol.openwire.OpenwireMessage;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQConsumer;
import org.apache.activemq.artemis.core.protocol.openwire.util.OpenWireUtil;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.spi.core.protocol.MessageConverter;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMapMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.apache.activemq.command.ActiveMQStreamMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.util.ByteArrayInputStream;
import org.apache.activemq.util.ByteArrayOutputStream;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.ByteSequenceData;
import org.apache.activemq.util.MarshallingSupport;
import org.apache.activemq.wireformat.WireFormat;
import org.fusesource.hawtbuf.UTF8Buffer;

public class OpenWireMessageConverter
implements MessageConverter<OpenwireMessage> {
    public static final String AMQ_PREFIX = "__HDR_";
    public static final String AMQ_MSG_DLQ_DELIVERY_FAILURE_CAUSE_PROPERTY = "__HDR_dlqDeliveryFailureCause";
    private static final String AMQ_MSG_ARRIVAL = "__HDR_ARRIVAL";
    private static final String AMQ_MSG_BROKER_IN_TIME = "__HDR_BROKER_IN_TIME";
    private static final String AMQ_MSG_BROKER_PATH = "__HDR_BROKER_PATH";
    private static final String AMQ_MSG_CLUSTER = "__HDR_CLUSTER";
    private static final String AMQ_MSG_COMMAND_ID = "__HDR_COMMAND_ID";
    private static final String AMQ_MSG_DATASTRUCTURE = "__HDR_DATASTRUCTURE";
    private static final String AMQ_MSG_GROUP_ID = "__HDR_GROUP_ID";
    private static final String AMQ_MSG_GROUP_SEQUENCE = "__HDR_GROUP_SEQUENCE";
    private static final String AMQ_MSG_MESSAGE_ID = "__HDR_MESSAGE_ID";
    private static final String AMQ_MSG_ORIG_DESTINATION = "__HDR_ORIG_DESTINATION";
    private static final String AMQ_MSG_ORIG_TXID = "__HDR_ORIG_TXID";
    private static final String AMQ_MSG_PRODUCER_ID = "__HDR_PRODUCER_ID";
    private static final String AMQ_MSG_MARSHALL_PROP = "__HDR_MARSHALL_PROP";
    private static final String AMQ_MSG_REPLY_TO = "__HDR_REPLY_TO";
    private static final String AMQ_MSG_USER_ID = "__HDR_USER_ID";
    private static final String AMQ_MSG_DROPPABLE = "__HDR_DROPPABLE";
    private static final String AMQ_MSG_COMPRESSED = "__HDR_COMPRESSED";
    private static final String AMQ_NOTIFICATIONS_DESTINATION = "activemq.notifications";
    private final WireFormat marshaller;

    public OpenWireMessageConverter(WireFormat marshaller) {
        this.marshaller = marshaller;
    }

    public OpenwireMessage fromCore(ICoreMessage coreMessage) throws Exception {
        return null;
    }

    public ICoreMessage toCore(OpenwireMessage pureMessage) throws Exception {
        return null;
    }

    public Object outbound(Message message, int deliveryCount) {
        return null;
    }

    public Message inbound(Object message) throws Exception {
        String userId;
        ActiveMQDestination replyTo;
        ByteSequence propBytes;
        String groupId;
        DataStructure ds;
        BrokerId[] cluster;
        CoreMessage coreMessage;
        org.apache.activemq.command.Message messageSend;
        block114: {
            ByteSequence contents;
            ActiveMQBuffer body;
            byte coreType;
            block113: {
                messageSend = (org.apache.activemq.command.Message)message;
                coreMessage = new CoreMessage(-1L, messageSend.getSize());
                String type = messageSend.getType();
                if (type != null) {
                    coreMessage.putStringProperty(new SimpleString("JMSType"), new SimpleString(type));
                }
                coreMessage.setDurable(messageSend.isPersistent());
                coreMessage.setExpiration(messageSend.getExpiration());
                coreMessage.setPriority(messageSend.getPriority());
                coreMessage.setTimestamp(messageSend.getTimestamp());
                coreType = OpenWireMessageConverter.toCoreType(messageSend.getDataStructureType());
                coreMessage.setType(coreType);
                body = coreMessage.getBodyBuffer();
                contents = messageSend.getContent();
                if (contents != null || coreType != 3) break block113;
                body.writeNullableString(null);
                break block114;
            }
            if (contents == null) break block114;
            boolean messageCompressed = messageSend.isCompressed();
            if (messageCompressed) {
                coreMessage.putBooleanProperty(AMQ_MSG_COMPRESSED, messageCompressed);
            }
            switch (coreType) {
                case 3: {
                    Object tis = new ByteArrayInputStream(contents);
                    if (messageCompressed) {
                        tis = new InflaterInputStream((InputStream)tis);
                    }
                    DataInputStream tdataIn = new DataInputStream((InputStream)tis);
                    String text = MarshallingSupport.readUTF8((DataInput)tdataIn);
                    tdataIn.close();
                    body.writeNullableSimpleString(new SimpleString(text));
                    break;
                }
                case 5: {
                    Object mis = new ByteArrayInputStream(contents);
                    if (messageCompressed) {
                        mis = new InflaterInputStream((InputStream)mis);
                    }
                    DataInputStream mdataIn = new DataInputStream((InputStream)mis);
                    Map map = MarshallingSupport.unmarshalPrimitiveMap((DataInputStream)mdataIn);
                    mdataIn.close();
                    TypedProperties props = new TypedProperties();
                    OpenWireMessageConverter.loadMapIntoProperties(props, map);
                    props.encode(body.byteBuf());
                    break;
                }
                case 2: {
                    if (messageCompressed) {
                        try (InflaterInputStream ois = new InflaterInputStream((InputStream)new ByteArrayInputStream(contents));
                             ByteArrayOutputStream decompressed = new ByteArrayOutputStream();){
                            byte[] buf = new byte[1024];
                            int n = ((InputStream)ois).read(buf);
                            while (n != -1) {
                                decompressed.write(buf, 0, n);
                                n = ((InputStream)ois).read();
                            }
                            contents = decompressed.toByteSequence();
                        }
                    }
                    body.writeInt(contents.length);
                    body.writeBytes(contents.data, contents.offset, contents.length);
                    break;
                }
                case 6: {
                    Object sis = new ByteArrayInputStream(contents);
                    if (messageCompressed) {
                        sis = new InflaterInputStream((InputStream)sis);
                    }
                    DataInputStream sdis = new DataInputStream((InputStream)sis);
                    int stype = sdis.read();
                    while (stype != -1) {
                        switch (stype) {
                            case 1: {
                                body.writeByte((byte)2);
                                body.writeBoolean(sdis.readBoolean());
                                break;
                            }
                            case 2: {
                                body.writeByte((byte)3);
                                body.writeByte(sdis.readByte());
                                break;
                            }
                            case 10: {
                                body.writeByte((byte)4);
                                int slen = sdis.readInt();
                                byte[] sbytes = new byte[slen];
                                sdis.read(sbytes);
                                body.writeInt(slen);
                                body.writeBytes(sbytes);
                                break;
                            }
                            case 3: {
                                body.writeByte((byte)11);
                                char schar = sdis.readChar();
                                body.writeShort((short)schar);
                                break;
                            }
                            case 7: {
                                body.writeByte((byte)9);
                                double sdouble = sdis.readDouble();
                                body.writeLong(Double.doubleToLongBits(sdouble));
                                break;
                            }
                            case 8: {
                                body.writeByte((byte)8);
                                float sfloat = sdis.readFloat();
                                body.writeInt(Float.floatToIntBits(sfloat));
                                break;
                            }
                            case 5: {
                                body.writeByte((byte)6);
                                body.writeInt(sdis.readInt());
                                break;
                            }
                            case 6: {
                                body.writeByte((byte)7);
                                body.writeLong(sdis.readLong());
                                break;
                            }
                            case 4: {
                                body.writeByte((byte)5);
                                body.writeShort(sdis.readShort());
                                break;
                            }
                            case 9: {
                                body.writeByte((byte)10);
                                String sstring = sdis.readUTF();
                                body.writeNullableString(sstring);
                                break;
                            }
                            case 13: {
                                body.writeByte((byte)10);
                                String sbigString = MarshallingSupport.readUTF8((DataInput)sdis);
                                body.writeNullableString(sbigString);
                                break;
                            }
                            case 0: {
                                body.writeByte((byte)10);
                                body.writeNullableString(null);
                                break;
                            }
                        }
                        stype = sdis.read();
                    }
                    sdis.close();
                    break;
                }
                case 4: {
                    if (messageCompressed) {
                        Inflater inflater = new Inflater();
                        try (ByteArrayOutputStream decompressed = new ByteArrayOutputStream();){
                            int length = ByteSequenceData.readIntBig((ByteSequence)contents);
                            contents.offset = 0;
                            byte[] data = Arrays.copyOfRange(contents.getData(), 4, contents.getLength());
                            inflater.setInput(data);
                            byte[] buffer = new byte[length];
                            int count = inflater.inflate(buffer);
                            decompressed.write(buffer, 0, count);
                            contents = decompressed.toByteSequence();
                        }
                        catch (Exception e) {
                            throw new IOException(e);
                        }
                        finally {
                            inflater.end();
                        }
                    }
                    body.writeBytes(contents.data, contents.offset, contents.length);
                    break;
                }
                default: {
                    if (messageCompressed) {
                        try (ByteArrayOutputStream decompressed = new ByteArrayOutputStream();
                             InflaterOutputStream os = new InflaterOutputStream((OutputStream)decompressed);){
                            ((OutputStream)os).write(contents.data, contents.offset, contents.getLength());
                            contents = decompressed.toByteSequence();
                        }
                        catch (Exception e) {
                            throw new IOException(e);
                        }
                    }
                    body.writeBytes(contents.data, contents.offset, contents.length);
                }
            }
        }
        coreMessage.putLongProperty(AMQ_MSG_ARRIVAL, messageSend.getArrival());
        coreMessage.putLongProperty(AMQ_MSG_BROKER_IN_TIME, messageSend.getBrokerInTime());
        BrokerId[] brokers = messageSend.getBrokerPath();
        if (brokers != null) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < brokers.length; ++i) {
                builder.append(brokers[i].getValue());
                if (i == brokers.length - 1) continue;
                builder.append(",");
            }
            coreMessage.putStringProperty(AMQ_MSG_BROKER_PATH, builder.toString());
        }
        if ((cluster = messageSend.getCluster()) != null) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < cluster.length; ++i) {
                builder.append(cluster[i].getValue());
                if (i == cluster.length - 1) continue;
                builder.append(",");
            }
            coreMessage.putStringProperty(AMQ_MSG_CLUSTER, builder.toString());
        }
        coreMessage.putIntProperty(AMQ_MSG_COMMAND_ID, messageSend.getCommandId());
        String corrId = messageSend.getCorrelationId();
        if (corrId != null) {
            coreMessage.putStringProperty("JMSCorrelationID", corrId);
        }
        if ((ds = messageSend.getDataStructure()) != null) {
            ByteSequence dsBytes = this.marshaller.marshal((Object)ds);
            dsBytes.compact();
            coreMessage.putBytesProperty(AMQ_MSG_DATASTRUCTURE, dsBytes.data);
        }
        if ((groupId = messageSend.getGroupID()) != null) {
            coreMessage.putStringProperty(AMQ_MSG_GROUP_ID, groupId);
        }
        coreMessage.putIntProperty(AMQ_MSG_GROUP_SEQUENCE, messageSend.getGroupSequence());
        MessageId messageId = messageSend.getMessageId();
        ByteSequence midBytes = this.marshaller.marshal((Object)messageId);
        midBytes.compact();
        coreMessage.putBytesProperty(AMQ_MSG_MESSAGE_ID, midBytes.data);
        ProducerId producerId = messageSend.getProducerId();
        if (producerId != null) {
            ByteSequence producerIdBytes = this.marshaller.marshal((Object)producerId);
            producerIdBytes.compact();
            coreMessage.putBytesProperty(AMQ_MSG_PRODUCER_ID, producerIdBytes.data);
        }
        if ((propBytes = messageSend.getMarshalledProperties()) != null) {
            propBytes.compact();
            coreMessage.putBytesProperty(AMQ_MSG_MARSHALL_PROP, propBytes.data);
            Map props = messageSend.getProperties();
            for (Map.Entry ent : props.entrySet()) {
                Object value = ent.getValue();
                try {
                    coreMessage.putObjectProperty((String)ent.getKey(), value);
                }
                catch (ActiveMQPropertyConversionException e) {
                    coreMessage.putStringProperty((String)ent.getKey(), value.toString());
                }
            }
        }
        if ((replyTo = messageSend.getReplyTo()) != null) {
            ByteSequence replyToBytes = this.marshaller.marshal((Object)replyTo);
            replyToBytes.compact();
            coreMessage.putBytesProperty(AMQ_MSG_REPLY_TO, replyToBytes.data);
        }
        if ((userId = messageSend.getUserID()) != null) {
            coreMessage.putStringProperty(AMQ_MSG_USER_ID, userId);
        }
        coreMessage.putBooleanProperty(AMQ_MSG_DROPPABLE, messageSend.isDroppable());
        ActiveMQDestination origDest = messageSend.getOriginalDestination();
        if (origDest != null) {
            ByteSequence origDestBytes = this.marshaller.marshal((Object)origDest);
            origDestBytes.compact();
            coreMessage.putBytesProperty(AMQ_MSG_ORIG_DESTINATION, origDestBytes.data);
        }
        return coreMessage;
    }

    private static void loadMapIntoProperties(TypedProperties props, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            SimpleString key = new SimpleString(entry.getKey());
            Object value = entry.getValue();
            if (value instanceof UTF8Buffer) {
                value = ((UTF8Buffer)value).toString();
            }
            TypedProperties.setObjectProperty((SimpleString)key, (Object)value, (TypedProperties)props);
        }
    }

    public static byte toCoreType(byte amqType) {
        switch (amqType) {
            case 29: {
                throw new IllegalStateException("We don't support BLOB type yet!");
            }
            case 24: {
                return 4;
            }
            case 25: {
                return 5;
            }
            case 26: {
                return 2;
            }
            case 27: {
                return 6;
            }
            case 28: {
                return 3;
            }
            case 23: {
                return 0;
            }
        }
        throw new IllegalStateException("Unknown ActiveMQ Artemis message type: " + amqType);
    }

    public MessageDispatch createMessageDispatch(MessageReference reference, ICoreMessage message, AMQConsumer consumer) throws IOException, JMSException {
        ActiveMQMessage amqMessage = this.toAMQMessage(reference, message, consumer.getOpenwireDestination());
        amqMessage.getMessageId().setBrokerSequenceId(message.getMessageID());
        MessageDispatch md = new MessageDispatch();
        md.setConsumerId(consumer.getId());
        md.setRedeliveryCounter(reference.getDeliveryCount() - 1);
        md.setDeliverySequenceId(amqMessage.getMessageId().getBrokerSequenceId());
        md.setMessage((org.apache.activemq.command.Message)amqMessage);
        ActiveMQDestination destination = amqMessage.getDestination();
        md.setDestination(destination);
        return md;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActiveMQMessage toAMQMessage(MessageReference reference, ICoreMessage coreMessage, ActiveMQDestination actualDestination) throws IOException {
        Set props;
        SimpleString dlqCause;
        Boolean isDroppable;
        String userId;
        byte[] marshalledBytes;
        byte[] producerIdBytes;
        byte[] origTxIdBytes;
        Integer groupSequence;
        byte[] dsBytes;
        Integer commandId;
        String clusterPath;
        Long arrival;
        ActiveMQBytesMessage amqMsg = null;
        byte coreType = coreMessage.getType();
        switch (coreType) {
            case 4: {
                amqMsg = new ActiveMQBytesMessage();
                break;
            }
            case 5: {
                amqMsg = new ActiveMQMapMessage();
                break;
            }
            case 2: {
                amqMsg = new ActiveMQObjectMessage();
                break;
            }
            case 6: {
                amqMsg = new ActiveMQStreamMessage();
                break;
            }
            case 3: {
                amqMsg = new ActiveMQTextMessage();
                break;
            }
            case 0: {
                amqMsg = new ActiveMQMessage();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown message type: " + coreMessage.getType());
            }
        }
        String type = coreMessage.getStringProperty(new SimpleString("JMSType"));
        if (type != null) {
            amqMsg.setJMSType(type);
        }
        amqMsg.setPersistent(coreMessage.isDurable());
        amqMsg.setExpiration(coreMessage.getExpiration());
        amqMsg.setPriority(coreMessage.getPriority());
        amqMsg.setTimestamp(coreMessage.getTimestamp());
        Long brokerInTime = (Long)coreMessage.getObjectProperty(AMQ_MSG_BROKER_IN_TIME);
        if (brokerInTime == null) {
            brokerInTime = 0L;
        }
        amqMsg.setBrokerInTime(brokerInTime.longValue());
        ActiveMQBuffer buffer = coreMessage.getReadOnlyBodyBuffer();
        Boolean compressProp = (Boolean)coreMessage.getObjectProperty(AMQ_MSG_COMPRESSED);
        boolean isCompressed = compressProp == null ? false : compressProp;
        amqMsg.setCompressed(isCompressed);
        if (buffer != null) {
            buffer.resetReaderIndex();
            byte[] bytes = null;
            ActiveMQBuffer activeMQBuffer = buffer;
            synchronized (activeMQBuffer) {
                Object deflater;
                Object os;
                OutputStream out;
                if (coreType == 3) {
                    SimpleString text = buffer.readNullableSimpleString();
                    if (text != null) {
                        java.io.ByteArrayOutputStream bytesOut = new java.io.ByteArrayOutputStream(text.length() + 4);
                        out = bytesOut;
                        if (isCompressed) {
                            out = new DeflaterOutputStream(out, true);
                        }
                        try (DataOutputStream dataOut = new DataOutputStream(out);){
                            MarshallingSupport.writeUTF8((DataOutput)dataOut, (String)text.toString());
                            dataOut.flush();
                            bytes = bytesOut.toByteArray();
                        }
                    }
                } else if (coreType == 5) {
                    TypedProperties mapData = new TypedProperties();
                    if (buffer.readableBytes() > 0) {
                        mapData.decode(buffer.byteBuf());
                        Map map = mapData.getMap();
                        out = new java.io.ByteArrayOutputStream(mapData.getEncodeSize());
                        os = out;
                        if (isCompressed) {
                            os = new DeflaterOutputStream((OutputStream)os, true);
                        }
                        try (DataOutputStream dataOut = new DataOutputStream((OutputStream)os);){
                            MarshallingSupport.marshalPrimitiveMap((Map)map, (DataOutputStream)dataOut);
                            dataOut.flush();
                        }
                        bytes = ((java.io.ByteArrayOutputStream)out).toByteArray();
                    }
                } else if (coreType == 2) {
                    if (buffer.readableBytes() > 0) {
                        int len = buffer.readInt();
                        bytes = new byte[len];
                        buffer.readBytes(bytes);
                        if (isCompressed) {
                            java.io.ByteArrayOutputStream bytesOut = new java.io.ByteArrayOutputStream();
                            out = new DeflaterOutputStream((OutputStream)bytesOut, true);
                            os = null;
                            try {
                                ((FilterOutputStream)out).write(bytes);
                                ((DeflaterOutputStream)out).flush();
                            }
                            catch (Throwable dataOut) {
                                os = dataOut;
                                throw dataOut;
                            }
                            finally {
                                if (out != null) {
                                    if (os != null) {
                                        try {
                                            ((DeflaterOutputStream)out).close();
                                        }
                                        catch (Throwable dataOut) {
                                            ((Throwable)os).addSuppressed(dataOut);
                                        }
                                    } else {
                                        ((DeflaterOutputStream)out).close();
                                    }
                                }
                            }
                            bytes = bytesOut.toByteArray();
                        }
                    }
                } else if (coreType == 6) {
                    ByteArrayOutputStream bytesOut;
                    Object out2 = bytesOut = new ByteArrayOutputStream();
                    if (isCompressed) {
                        out2 = new DeflaterOutputStream((OutputStream)bytesOut, true);
                    }
                    DataOutputStream dataOut = new DataOutputStream((OutputStream)out2);
                    os = null;
                    try {
                        boolean stop = false;
                        while (!stop && buffer.readable()) {
                            byte primitiveType = buffer.readByte();
                            switch (primitiveType) {
                                case 2: {
                                    MarshallingSupport.marshalBoolean((DataOutputStream)dataOut, (boolean)buffer.readBoolean());
                                    break;
                                }
                                case 3: {
                                    MarshallingSupport.marshalByte((DataOutputStream)dataOut, (byte)buffer.readByte());
                                    break;
                                }
                                case 4: {
                                    int len = buffer.readInt();
                                    byte[] bytesData = new byte[len];
                                    buffer.readBytes(bytesData);
                                    MarshallingSupport.marshalByteArray((DataOutputStream)dataOut, (byte[])bytesData);
                                    break;
                                }
                                case 11: {
                                    char ch = (char)buffer.readShort();
                                    MarshallingSupport.marshalChar((DataOutputStream)dataOut, (char)ch);
                                    break;
                                }
                                case 9: {
                                    double doubleVal = Double.longBitsToDouble(buffer.readLong());
                                    MarshallingSupport.marshalDouble((DataOutputStream)dataOut, (double)doubleVal);
                                    break;
                                }
                                case 8: {
                                    Float floatVal = Float.valueOf(Float.intBitsToFloat(buffer.readInt()));
                                    MarshallingSupport.marshalFloat((DataOutputStream)dataOut, (float)floatVal.floatValue());
                                    break;
                                }
                                case 6: {
                                    MarshallingSupport.marshalInt((DataOutputStream)dataOut, (int)buffer.readInt());
                                    break;
                                }
                                case 7: {
                                    MarshallingSupport.marshalLong((DataOutputStream)dataOut, (long)buffer.readLong());
                                    break;
                                }
                                case 5: {
                                    MarshallingSupport.marshalShort((DataOutputStream)dataOut, (short)buffer.readShort());
                                    break;
                                }
                                case 10: {
                                    String string = buffer.readNullableString();
                                    if (string == null) {
                                        MarshallingSupport.marshalNull((DataOutputStream)dataOut);
                                        break;
                                    }
                                    MarshallingSupport.marshalString((DataOutputStream)dataOut, (String)string);
                                    break;
                                }
                                default: {
                                    stop = true;
                                }
                            }
                            dataOut.flush();
                        }
                    }
                    catch (Throwable stop) {
                        os = stop;
                        throw stop;
                    }
                    finally {
                        if (dataOut != null) {
                            if (os != null) {
                                try {
                                    dataOut.close();
                                }
                                catch (Throwable stop) {
                                    ((Throwable)os).addSuppressed(stop);
                                }
                            } else {
                                dataOut.close();
                            }
                        }
                    }
                    bytes = bytesOut.toByteArray();
                } else if (coreType == 4) {
                    int n = buffer.readableBytes();
                    bytes = new byte[n];
                    buffer.readBytes(bytes);
                    if (isCompressed) {
                        int length = bytes.length;
                        deflater = new Deflater();
                        try (ByteArrayOutputStream compressed = new ByteArrayOutputStream();){
                            compressed.write(new byte[4]);
                            ((Deflater)deflater).setInput(bytes);
                            ((Deflater)deflater).finish();
                            byte[] bytesBuf = new byte[1024];
                            while (!((Deflater)deflater).finished()) {
                                int count = ((Deflater)deflater).deflate(bytesBuf);
                                compressed.write(bytesBuf, 0, count);
                            }
                            compressed.flush();
                            ByteSequence byteSeq = compressed.toByteSequence();
                            ByteSequenceData.writeIntBig((ByteSequence)byteSeq, (int)length);
                            bytes = Arrays.copyOfRange(byteSeq.data, 0, byteSeq.length);
                        }
                        finally {
                            ((Deflater)deflater).end();
                        }
                    }
                } else {
                    int n = buffer.readableBytes();
                    bytes = new byte[n];
                    buffer.readBytes(bytes);
                    if (isCompressed) {
                        java.io.ByteArrayOutputStream bytesOut = new java.io.ByteArrayOutputStream();
                        deflater = null;
                        try (DeflaterOutputStream out32 = new DeflaterOutputStream((OutputStream)bytesOut, true);){
                            out32.write(bytes);
                            out32.flush();
                            bytes = bytesOut.toByteArray();
                        }
                        catch (Throwable out32) {
                            deflater = out32;
                            throw out32;
                        }
                        finally {
                            if (bytesOut != null) {
                                if (deflater != null) {
                                    try {
                                        bytesOut.close();
                                    }
                                    catch (Throwable out32) {
                                        ((Throwable)deflater).addSuppressed(out32);
                                    }
                                } else {
                                    bytesOut.close();
                                }
                            }
                        }
                    }
                }
                buffer.resetReaderIndex();
            }
            if (bytes != null) {
                ByteSequence content = new ByteSequence(bytes);
                amqMsg.setContent(content);
            }
        }
        if ((arrival = (Long)coreMessage.getObjectProperty(AMQ_MSG_ARRIVAL)) == null) {
            arrival = 0L;
        }
        amqMsg.setArrival(arrival.longValue());
        String brokerPath = (String)coreMessage.getObjectProperty(AMQ_MSG_BROKER_PATH);
        if (brokerPath != null && brokerPath.isEmpty()) {
            String[] brokers = brokerPath.split(",");
            BrokerId[] bids = new BrokerId[brokers.length];
            for (int i = 0; i < bids.length; ++i) {
                bids[i] = new BrokerId(brokers[i]);
            }
            amqMsg.setBrokerPath(bids);
        }
        if ((clusterPath = (String)coreMessage.getObjectProperty(AMQ_MSG_CLUSTER)) != null && clusterPath.isEmpty()) {
            String[] cluster = clusterPath.split(",");
            BrokerId[] bids = new BrokerId[cluster.length];
            for (int i = 0; i < bids.length; ++i) {
                bids[i] = new BrokerId(cluster[i]);
            }
            amqMsg.setCluster(bids);
        }
        if ((commandId = (Integer)coreMessage.getObjectProperty(AMQ_MSG_COMMAND_ID)) == null) {
            commandId = -1;
        }
        amqMsg.setCommandId(commandId.intValue());
        SimpleString corrId = (SimpleString)coreMessage.getObjectProperty("JMSCorrelationID");
        if (corrId != null) {
            amqMsg.setCorrelationId(corrId.toString());
        }
        if ((dsBytes = (byte[])coreMessage.getObjectProperty(AMQ_MSG_DATASTRUCTURE)) != null) {
            ByteSequence seq = new ByteSequence(dsBytes);
            DataStructure ds = (DataStructure)this.marshaller.unmarshal(seq);
            amqMsg.setDataStructure(ds);
        }
        amqMsg.setDestination(OpenWireUtil.toAMQAddress((Message)coreMessage, actualDestination));
        Object value = coreMessage.getObjectProperty(AMQ_MSG_GROUP_ID);
        if (value != null) {
            String groupId = value.toString();
            amqMsg.setGroupID(groupId);
        }
        if ((groupSequence = (Integer)coreMessage.getObjectProperty(AMQ_MSG_GROUP_SEQUENCE)) == null) {
            groupSequence = -1;
        }
        amqMsg.setGroupSequence(groupSequence.intValue());
        MessageId mid = null;
        byte[] midBytes = (byte[])coreMessage.getObjectProperty(AMQ_MSG_MESSAGE_ID);
        if (midBytes != null) {
            ByteSequence midSeq = new ByteSequence(midBytes);
            mid = (MessageId)this.marshaller.unmarshal(midSeq);
        } else {
            mid = new MessageId(UUIDGenerator.getInstance().generateStringUUID() + ":-1");
        }
        amqMsg.setMessageId(mid);
        byte[] origDestBytes = (byte[])coreMessage.getObjectProperty(AMQ_MSG_ORIG_DESTINATION);
        if (origDestBytes != null) {
            ActiveMQDestination origDest = (ActiveMQDestination)this.marshaller.unmarshal(new ByteSequence(origDestBytes));
            amqMsg.setOriginalDestination(origDest);
        }
        if ((origTxIdBytes = (byte[])coreMessage.getObjectProperty(AMQ_MSG_ORIG_TXID)) != null) {
            TransactionId origTxId = (TransactionId)this.marshaller.unmarshal(new ByteSequence(origTxIdBytes));
            amqMsg.setOriginalTransactionId(origTxId);
        }
        if ((producerIdBytes = (byte[])coreMessage.getObjectProperty(AMQ_MSG_PRODUCER_ID)) != null) {
            ProducerId producerId = (ProducerId)this.marshaller.unmarshal(new ByteSequence(producerIdBytes));
            amqMsg.setProducerId(producerId);
        }
        if ((marshalledBytes = (byte[])coreMessage.getObjectProperty(AMQ_MSG_MARSHALL_PROP)) != null) {
            amqMsg.setMarshalledProperties(new ByteSequence(marshalledBytes));
        }
        amqMsg.setRedeliveryCounter(reference.getDeliveryCount() - 1);
        byte[] replyToBytes = (byte[])coreMessage.getObjectProperty(AMQ_MSG_REPLY_TO);
        if (replyToBytes != null) {
            ActiveMQDestination replyTo = (ActiveMQDestination)this.marshaller.unmarshal(new ByteSequence(replyToBytes));
            amqMsg.setReplyTo(replyTo);
        }
        if ((userId = (String)coreMessage.getObjectProperty(AMQ_MSG_USER_ID)) != null) {
            amqMsg.setUserID(userId);
        }
        if ((isDroppable = (Boolean)coreMessage.getObjectProperty(AMQ_MSG_DROPPABLE)) != null) {
            amqMsg.setDroppable(isDroppable.booleanValue());
        }
        if ((dlqCause = (SimpleString)coreMessage.getObjectProperty(AMQ_MSG_DLQ_DELIVERY_FAILURE_CAUSE_PROPERTY)) != null) {
            try {
                amqMsg.setStringProperty("dlqDeliveryFailureCause", dlqCause.toString());
            }
            catch (JMSException e) {
                throw new IOException("failure to set dlq property " + dlqCause, e);
            }
        }
        if ((props = coreMessage.getPropertyNames()) != null) {
            for (SimpleString s : props) {
                String keyStr = s.toString();
                if ((keyStr.startsWith("_AMQ") || keyStr.startsWith(AMQ_PREFIX)) && !actualDestination.toString().contains(AMQ_NOTIFICATIONS_DESTINATION)) continue;
                Object prop = coreMessage.getObjectProperty(s);
                try {
                    if (prop instanceof SimpleString) {
                        amqMsg.setObjectProperty(s.toString(), (Object)prop.toString());
                        continue;
                    }
                    if (keyStr.equals("JMSXDeliveryCount") && prop instanceof Long) {
                        Long l = (Long)prop;
                        amqMsg.setObjectProperty(s.toString(), (Object)l.intValue());
                        continue;
                    }
                    amqMsg.setObjectProperty(s.toString(), prop);
                }
                catch (JMSException e) {
                    throw new IOException("exception setting property " + s + " : " + prop, e);
                }
            }
        }
        try {
            amqMsg.onSend();
            amqMsg.setCompressed(isCompressed);
        }
        catch (JMSException e) {
            throw new IOException("Failed to covert to Openwire message", e);
        }
        return amqMsg;
    }
}

