/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.critical;

import java.util.ConcurrentModificationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.apache.activemq.artemis.utils.critical.CriticalAction;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.CriticalComponent;
import org.jboss.logging.Logger;

public class CriticalAnalyzerImpl
implements CriticalAnalyzer {
    private final Logger logger = Logger.getLogger(CriticalAnalyzer.class);
    private volatile long timeout;
    private volatile long checkTime;
    private CopyOnWriteArrayList<CriticalAction> actions = new CopyOnWriteArrayList();
    private Thread thread;
    private final Semaphore running = new Semaphore(1);
    private final ConcurrentHashSet<CriticalComponent> components = new ConcurrentHashSet();

    @Override
    public void clear() {
        this.actions.clear();
        this.components.clear();
    }

    @Override
    public boolean isMeasuring() {
        return true;
    }

    @Override
    public void add(CriticalComponent component) {
        this.components.add(component);
    }

    @Override
    public void remove(CriticalComponent component) {
        this.components.remove(component);
    }

    @Override
    public CriticalAnalyzer setCheckTime(long timeout) {
        this.checkTime = timeout;
        return this;
    }

    @Override
    public long getCheckTime() {
        if (this.checkTime == 0L) {
            this.checkTime = this.getTimeout() / 2L;
        }
        return this.checkTime;
    }

    @Override
    public CriticalAnalyzer setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public long getTimeout() {
        if (this.timeout == 0L) {
            this.timeout = TimeUnit.MINUTES.toMillis(2L);
        }
        return this.timeout;
    }

    @Override
    public CriticalAnalyzer addAction(CriticalAction action) {
        this.actions.add(action);
        return this;
    }

    @Override
    public void check() {
        boolean retry = true;
        while (retry) {
            try {
                for (CriticalComponent component : this.components) {
                    if (!component.isExpired(this.timeout)) continue;
                    this.fireAction(component);
                    return;
                }
                retry = false;
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
    }

    private void fireAction(CriticalComponent component) {
        for (CriticalAction action : this.actions) {
            try {
                action.run(component);
            }
            catch (Throwable e) {
                this.logger.warn((Object)e.getMessage(), e);
            }
        }
    }

    @Override
    public void start() {
        if (!this.running.tryAcquire()) {
            return;
        }
        this.thread = new Thread("Artemis Critical Analyzer"){

            @Override
            public void run() {
                try {
                    while (true) {
                        if (CriticalAnalyzerImpl.this.running.tryAcquire(CriticalAnalyzerImpl.this.getCheckTime(), TimeUnit.MILLISECONDS)) {
                            CriticalAnalyzerImpl.this.running.release();
                            break;
                        }
                        CriticalAnalyzerImpl.this.check();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        this.running.release();
        try {
            if (this.thread != null) {
                this.thread.join();
            }
        }
        catch (Throwable e) {
            this.logger.warn((Object)e.getMessage(), e);
        }
    }

    @Override
    public boolean isStarted() {
        return this.running.availablePermits() == 0;
    }
}

