/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.tools.xml;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.utils.Base64;

public class XmlDataExporterUtil {
    public static String convertProperty(Object value) {
        if (value instanceof byte[]) {
            return XmlDataExporterUtil.encode((byte[])value);
        }
        return value == null ? "_AMQ_NULL" : value.toString();
    }

    public static String getPropertyType(Object value) {
        String stringValue = null;
        if (value == null) {
            stringValue = "bytes";
        } else if (value instanceof Boolean) {
            stringValue = "boolean";
        } else if (value instanceof Byte) {
            stringValue = "byte";
        } else if (value instanceof Short) {
            stringValue = "short";
        } else if (value instanceof Integer) {
            stringValue = "integer";
        } else if (value instanceof Long) {
            stringValue = "long";
        } else if (value instanceof Float) {
            stringValue = "float";
        } else if (value instanceof Double) {
            stringValue = "double";
        } else if (value instanceof String) {
            stringValue = "string";
        } else if (value instanceof SimpleString) {
            stringValue = "simple-string";
        } else if (value instanceof byte[]) {
            stringValue = "bytes";
        }
        return stringValue;
    }

    public static String getMessagePrettyType(byte rawType) {
        String prettyType = "default";
        if (rawType == 4) {
            prettyType = "bytes";
        } else if (rawType == 5) {
            prettyType = "map";
        } else if (rawType == 2) {
            prettyType = "object";
        } else if (rawType == 6) {
            prettyType = "stream";
        } else if (rawType == 3) {
            prettyType = "text";
        }
        return prettyType;
    }

    public static String encodeMessageBodyBase64(Message message) throws Exception {
        Objects.requireNonNull(message, "ServerMessage can not be null");
        ActiveMQBuffer byteBuffer = message.toCore().getReadOnlyBodyBuffer();
        byte[] buffer = new byte[byteBuffer.writerIndex()];
        byteBuffer.readBytes(buffer);
        return XmlDataExporterUtil.encode(buffer);
    }

    protected static String encode(byte[] data) {
        return Base64.encodeBytes((byte[])data, (boolean)true);
    }
}

