/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands;

import java.io.File;
import org.apache.activemq.artemis.cli.Artemis;
import picocli.AutoComplete;
import picocli.CommandLine;

@CommandLine.Command(name="auto-complete", description={"Generates the auto complete script file to be used in bash or zsh."})
public class AutoCompletion
implements Runnable {
    @CommandLine.Option(names={"--start-script"}, description={"the script used to start artemis. (default ./artemis)"}, defaultValue="./artemis")
    String startScript;
    @CommandLine.Parameters(description={"The generated auto-complete script"}, defaultValue="auto-complete-artemis.sh")
    File autoCompleteFile;

    @Override
    public void run() {
        try {
            CommandLine artemisCommand = Artemis.buildCommand(true, true, true);
            AutoComplete.bash((String)this.startScript, (File)this.autoCompleteFile, null, (CommandLine)artemisCommand);
            System.out.println("Type the following commands before you can use auto-complete:");
            System.out.println("*******************************************************************************************************************************");
            System.out.println("source " + this.autoCompleteFile.getAbsolutePath());
            System.out.println("*******************************************************************************************************************************");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        CommandLine commandLine = new CommandLine((Object)new AutoCompletion());
        commandLine.execute(args);
    }
}

