/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.queue;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.cli.commands.AbstractAction;
import org.apache.activemq.artemis.cli.commands.ActionContext;

@Command(name="purge", description="Delete all messages in a queue.")
public class PurgeQueue
extends AbstractAction {
    @Option(name={"--name"}, description="The queue's name.")
    String name;

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        this.purgeQueue(context);
        return null;
    }

    private void purgeQueue(final ActionContext context) throws Exception {
        this.performCoreManagement(new AbstractAction.ManagementCallback<ClientMessage>(){

            @Override
            public void setUpInvocation(ClientMessage message) throws Exception {
                ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)("queue." + PurgeQueue.this.getName()), (String)"removeAllMessages");
            }

            @Override
            public void requestSuccessful(ClientMessage reply) throws Exception {
                context.out.println("Queue " + PurgeQueue.this.getName() + " purged successfully.");
            }

            @Override
            public void requestFailed(ClientMessage reply) throws Exception {
                String errMsg = (String)ManagementHelper.getResult((ICoreMessage)reply, String.class);
                context.err.println("Failed to purge queue " + PurgeQueue.this.getName() + ". Reason: " + errMsg);
            }
        });
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.input("--name", "What is the name of the queue?", "");
        }
        return this.name;
    }
}

