/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.util;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.qpid.proton.codec.ReadableBuffer;

public class NettyReadable
implements ReadableBuffer {
    private static final Charset Charset_UTF8 = Charset.forName("UTF-8");
    private final ByteBuf buffer;

    public NettyReadable(ByteBuf buffer) {
        this.buffer = buffer;
    }

    public void put(ReadableBuffer other) {
        this.buffer.writeBytes(other.byteBuffer());
    }

    public byte get() {
        return this.buffer.readByte();
    }

    public int getInt() {
        return this.buffer.readInt();
    }

    public long getLong() {
        return this.buffer.readLong();
    }

    public short getShort() {
        return this.buffer.readShort();
    }

    public float getFloat() {
        return this.buffer.readFloat();
    }

    public double getDouble() {
        return this.buffer.readDouble();
    }

    public ReadableBuffer get(byte[] data, int offset, int length) {
        this.buffer.readBytes(data, offset, length);
        return this;
    }

    public ReadableBuffer get(byte[] data) {
        this.buffer.readBytes(data);
        return this;
    }

    public ReadableBuffer position(int position) {
        this.buffer.readerIndex(position);
        return this;
    }

    public ReadableBuffer slice() {
        return new NettyReadable(this.buffer.slice());
    }

    public ReadableBuffer flip() {
        return new NettyReadable(this.buffer.duplicate().setIndex(0, this.buffer.readerIndex()));
    }

    public ReadableBuffer limit(int limit) {
        this.buffer.writerIndex(limit);
        return this;
    }

    public int limit() {
        return this.buffer.writerIndex();
    }

    public int remaining() {
        return this.buffer.readableBytes();
    }

    public int position() {
        return this.buffer.readerIndex();
    }

    public boolean hasRemaining() {
        return this.buffer.readableBytes() > 0;
    }

    public ReadableBuffer duplicate() {
        return new NettyReadable(this.buffer.duplicate());
    }

    public ByteBuffer byteBuffer() {
        return this.buffer.nioBuffer(0, this.buffer.writerIndex());
    }

    public String readUTF8() {
        return this.buffer.toString(Charset_UTF8);
    }
}

