/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.client;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPConnectionCallback;
import org.apache.activemq.artemis.protocol.amqp.broker.ActiveMQProtonRemotingConnection;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManager;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.EventHandler;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.qpid.proton.amqp.Symbol;

public class AMQPClientConnectionFactory {
    private final ActiveMQServer server;
    private final String containerId;
    private final Map<Symbol, Object> connectionProperties;
    private final int ttl;
    private final boolean useCoreSubscriptionNaming;

    public AMQPClientConnectionFactory(ActiveMQServer server, String containerId, Map<Symbol, Object> connectionProperties, int ttl) {
        this.server = server;
        this.containerId = containerId;
        this.connectionProperties = connectionProperties;
        this.ttl = ttl;
        this.useCoreSubscriptionNaming = false;
    }

    public ActiveMQProtonRemotingConnection createConnection(ProtonProtocolManager protocolManager, Connection connection, Optional<EventHandler> eventHandler) {
        AMQPConnectionCallback connectionCallback = new AMQPConnectionCallback(protocolManager, connection, this.server.getExecutorFactory().getExecutor(), this.server);
        Executor executor = this.server.getExecutorFactory().getExecutor();
        AMQPConnectionContext amqpConnection = new AMQPConnectionContext(protocolManager, connectionCallback, this.containerId, this.ttl, protocolManager.getMaxFrameSize(), 65535, this.useCoreSubscriptionNaming, this.server.getScheduledPool());
        eventHandler.ifPresent(amqpConnection::addEventHandler);
        ActiveMQProtonRemotingConnection delegate = new ActiveMQProtonRemotingConnection(protocolManager, amqpConnection, connection, executor);
        connectionCallback.setProtonConnectionDelegate(delegate);
        amqpConnection.open(this.connectionProperties);
        return delegate;
    }
}

