/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.util;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;

public class NettyWritable
implements WritableBuffer {
    final ByteBuf nettyBuffer;

    public NettyWritable(ByteBuf nettyBuffer) {
        this.nettyBuffer = nettyBuffer;
    }

    public ByteBuf getByteBuf() {
        return this.nettyBuffer;
    }

    public void put(byte b) {
        this.nettyBuffer.writeByte((int)b);
    }

    public void putFloat(float f) {
        this.nettyBuffer.writeFloat(f);
    }

    public void putDouble(double d) {
        this.nettyBuffer.writeDouble(d);
    }

    public void put(byte[] src, int offset, int length) {
        this.nettyBuffer.writeBytes(src, offset, length);
    }

    public void putShort(short s) {
        this.nettyBuffer.writeShort((int)s);
    }

    public void putInt(int i) {
        this.nettyBuffer.writeInt(i);
    }

    public void putLong(long l) {
        this.nettyBuffer.writeLong(l);
    }

    public boolean hasRemaining() {
        return this.nettyBuffer.writerIndex() < this.nettyBuffer.capacity();
    }

    public int remaining() {
        return this.nettyBuffer.maxCapacity() - this.nettyBuffer.writerIndex();
    }

    public void ensureRemaining(int remaining) {
        this.nettyBuffer.ensureWritable(remaining);
    }

    public int position() {
        return this.nettyBuffer.writerIndex();
    }

    public void position(int position) {
        this.nettyBuffer.writerIndex(position);
    }

    public void put(ByteBuffer payload) {
        this.nettyBuffer.writeBytes(payload);
    }

    public void put(ByteBuf payload) {
        this.nettyBuffer.writeBytes(payload);
    }

    public void put(String value) {
        this.nettyBuffer.writeCharSequence((CharSequence)value, StandardCharsets.UTF_8);
    }

    public int limit() {
        return this.nettyBuffer.capacity();
    }

    public void put(ReadableBuffer buffer) {
        if (buffer.hasArray()) {
            this.nettyBuffer.writeBytes(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        } else {
            this.nettyBuffer.writeBytes(buffer.byteBuffer());
        }
    }
}

