/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class RestConsumerContextPathMatcher {
    private static final Pattern CONSUMER_PATH_PARAMETER_PATTERN = Pattern.compile("([^{]*)(\\{.*?\\})([^{]*)");
    private static final Map<String, Pattern> PATH_PATTERN = new ConcurrentHashMap<String, Pattern>();

    private RestConsumerContextPathMatcher() {
    }

    public static boolean matchPath(String requestPath, String consumerPath, boolean matchOnUriPrefix) {
        if (requestPath == null && consumerPath == null) {
            return true;
        }
        if (requestPath == null || consumerPath == null) {
            return false;
        }
        requestPath = RestConsumerContextPathMatcher.removePathSlashes(requestPath);
        consumerPath = RestConsumerContextPathMatcher.removePathSlashes(consumerPath);
        if (matchOnUriPrefix && requestPath.toLowerCase(Locale.ENGLISH).startsWith(consumerPath.toLowerCase(Locale.ENGLISH))) {
            return true;
        }
        return requestPath.equalsIgnoreCase(consumerPath);
    }

    public static <T> ConsumerPath<T> matchBestPath(String requestMethod, String requestPath, List<ConsumerPath<T>> consumerPaths) {
        boolean bl;
        ConsumerPath answer = null;
        ArrayList<ConsumerPath<T>> candidates = new ArrayList<ConsumerPath<T>>();
        for (ConsumerPath<T> consumerPath : consumerPaths) {
            if (!RestConsumerContextPathMatcher.matchRestMethod(requestMethod, consumerPath.getRestrictMethod())) continue;
            candidates.add(consumerPath);
        }
        for (ConsumerPath consumerPath : candidates) {
            if (!RestConsumerContextPathMatcher.matchRestPath(requestPath, consumerPath.getConsumerPath(), false)) continue;
            answer = consumerPath;
            break;
        }
        if (answer == null && RestConsumerContextPathMatcher.isOptionsMethod(requestMethod)) {
            candidates.clear();
            candidates.addAll(consumerPaths);
            for (ConsumerPath consumerPath : candidates) {
                if (!RestConsumerContextPathMatcher.matchRestPath(requestPath, consumerPath.getConsumerPath(), false)) continue;
                answer = consumerPath;
                break;
            }
        }
        if (bl = candidates.stream().allMatch(p -> RestConsumerContextPathMatcher.countCurlyBraces(p.getConsumerPath()) == 0)) {
            answer = candidates.stream().filter(c -> RestConsumerContextPathMatcher.matchPath(requestPath, c.getConsumerPath(), c.isMatchOnUriPrefix())).sorted(Comparator.comparingInt(o -> -1 * o.getConsumerPath().length())).findFirst().orElse(null);
        }
        if (answer == null) {
            for (ConsumerPath<T> entry : consumerPaths) {
                if (!RestConsumerContextPathMatcher.matchRestPath(requestPath, entry.getConsumerPath(), false)) continue;
                return null;
            }
        }
        if (answer != null) {
            return answer;
        }
        Iterator it = candidates.iterator();
        ArrayList<ConsumerPath> uriTemplateCandidates = new ArrayList<ConsumerPath>();
        while (it.hasNext()) {
            ConsumerPath consumer = (ConsumerPath)it.next();
            if (!RestConsumerContextPathMatcher.matchRestPath(requestPath, consumer.getConsumerPath(), true)) continue;
            uriTemplateCandidates.add(consumer);
        }
        ConsumerPath best = null;
        HashMap<Integer, List> pathMap = new HashMap<Integer, List>();
        if (uriTemplateCandidates.size() > 1) {
            for (ConsumerPath consumerPath : uriTemplateCandidates) {
                int curlyBraces = RestConsumerContextPathMatcher.countCurlyBraces(consumerPath.getConsumerPath());
                if (curlyBraces <= 0) continue;
                List consumerPathsList = pathMap.computeIfAbsent(curlyBraces, key -> new ArrayList());
                consumerPathsList.add(consumerPath);
            }
            OptionalInt optionalInt = pathMap.keySet().stream().mapToInt(Integer::intValue).min();
            if (optionalInt.isPresent()) {
                List bestConsumerPaths = (List)pathMap.get(optionalInt.getAsInt());
                if (bestConsumerPaths.size() > 1 && !RestConsumerContextPathMatcher.canBeAmbiguous(requestMethod, requestMethod)) {
                    String exceptionMsg = "Ambiguous paths " + bestConsumerPaths.stream().map(ConsumerPath::getConsumerPath).collect(Collectors.joining(",")) + " for request path " + requestPath;
                    throw new IllegalStateException(exceptionMsg);
                }
                best = (ConsumerPath)bestConsumerPaths.get(0);
            }
            if (best != null) {
                answer = best;
            }
        }
        if (answer == null && uriTemplateCandidates.size() == 1) {
            return (ConsumerPath)uriTemplateCandidates.get(0);
        }
        for (ConsumerPath consumerPath : candidates) {
            if (!RestConsumerContextPathMatcher.matchWildCard(requestPath, consumerPath.getConsumerPath())) continue;
            answer = consumerPath;
            break;
        }
        return answer;
    }

    public static void register(String consumerPath) {
        String regex = RestConsumerContextPathMatcher.prepareConsumerPathRegex(consumerPath);
        regex = regex.replace("/", "\\/").replace("-", "\\-").replace("{", "(?<").replace("}", ">[^\\/]+)");
        regex = regex.replace("*", ".*");
        Pattern pattern = Pattern.compile(regex);
        PATH_PATTERN.put(consumerPath, pattern);
    }

    public static void unRegister(String consumerPath) {
        PATH_PATTERN.remove(consumerPath);
    }

    private static boolean canBeAmbiguous(String requestMethod, String requestPath) {
        return requestMethod.equalsIgnoreCase("options");
    }

    private static boolean matchRestMethod(String method, String restrict) {
        if (restrict == null) {
            return true;
        }
        return restrict.toLowerCase(Locale.ENGLISH).contains(method.toLowerCase(Locale.ENGLISH));
    }

    private static boolean isOptionsMethod(String method) {
        return "options".equalsIgnoreCase(method);
    }

    private static boolean matchRestPath(String requestPath, String consumerPath, boolean isUriTemplate) {
        String[] consumerPaths;
        if (requestPath == null && consumerPath == null) {
            return true;
        }
        if (requestPath == null || consumerPath == null) {
            return false;
        }
        requestPath = RestConsumerContextPathMatcher.removePathSlashes(requestPath);
        consumerPath = RestConsumerContextPathMatcher.removePathSlashes(consumerPath);
        String[] requestPaths = requestPath.split("/");
        if (requestPaths.length != (consumerPaths = consumerPath.split("/")).length) {
            return false;
        }
        for (int i = 0; i < requestPaths.length; ++i) {
            String p1 = requestPaths[i];
            String p2 = consumerPaths[i];
            if (isUriTemplate && p2.startsWith("{") && p2.endsWith("}") || RestConsumerContextPathMatcher.matchPath(p1, p2, false)) continue;
            return false;
        }
        return true;
    }

    private static String removePathSlashes(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private static int countCurlyBraces(String consumerPath) {
        String[] consumerPaths;
        int curlyBraces = 0;
        consumerPath = RestConsumerContextPathMatcher.removePathSlashes(consumerPath);
        for (String p2 : consumerPaths = consumerPath.split("/")) {
            if (!p2.startsWith("{") || !p2.endsWith("}")) continue;
            ++curlyBraces;
        }
        return curlyBraces;
    }

    private static boolean matchWildCard(String requestPath, String consumerPath) {
        Pattern pattern;
        if (!((String)requestPath).endsWith("/")) {
            requestPath = (String)requestPath + "/";
        }
        if ((pattern = PATH_PATTERN.get(consumerPath)) == null) {
            return false;
        }
        Matcher matcher = pattern.matcher((CharSequence)requestPath);
        return matcher.matches();
    }

    private static String prepareConsumerPathRegex(String consumerPath) {
        Matcher m = CONSUMER_PATH_PARAMETER_PATTERN.matcher(consumerPath);
        StringBuilder regexBuilder = new StringBuilder(256);
        while (m.find()) {
            m.appendReplacement(regexBuilder, m.group(1) + m.group(2).replaceAll("[\\_\\-]", "") + m.group(3));
        }
        if (regexBuilder.isEmpty()) {
            return consumerPath;
        }
        return regexBuilder.toString();
    }

    public static interface ConsumerPath<T> {
        public String getRestrictMethod();

        public String getConsumerPath();

        public T getConsumer();

        public boolean isMatchOnUriPrefix();
    }
}

