/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web.handler;

import java.util.Arrays;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.activemq.web.DestinationFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.handler.BeanNameUrlHandlerMapping;

public class BindingBeanNameUrlHandlerMapping
extends BeanNameUrlHandlerMapping {
    private static final transient Logger LOG = LoggerFactory.getLogger(BindingBeanNameUrlHandlerMapping.class);

    protected Object getHandlerInternal(HttpServletRequest request) throws Exception {
        Object object = super.getHandlerInternal(request);
        if (object instanceof String) {
            String handlerName = (String)object;
            object = this.getApplicationContext().getBean(handlerName);
        }
        if (object instanceof HandlerExecutionChain) {
            HandlerExecutionChain handlerExecutionChain = (HandlerExecutionChain)object;
            object = handlerExecutionChain.getHandler();
        }
        if (object != null) {
            if (object instanceof DestinationFacade) {
                if (!Arrays.asList(((DestinationFacade)object).getSupportedHttpMethods()).contains(request.getMethod())) {
                    throw new UnsupportedOperationException("Unsupported method " + request.getMethod() + " for path " + request.getRequestURI());
                }
                if (request.getSession().getAttribute("secret") == null || !request.getSession().getAttribute("secret").equals(request.getParameter("secret"))) {
                    throw new UnsupportedOperationException("Possible CSRF attack");
                }
            }
            ServletRequestDataBinder binder = new ServletRequestDataBinder(object, "request");
            try {
                binder.bind((ServletRequest)request);
                binder.setIgnoreUnknownFields(true);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Bound POJO is now: " + object);
                }
            }
            catch (Exception e) {
                LOG.warn("Caught: " + e, (Throwable)e);
                throw e;
            }
        }
        return object;
    }
}

