/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.plugin;

import jakarta.annotation.PostConstruct;
import jakarta.xml.bind.JAXBElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.activemq.plugin.ConfigurationProcessor;
import org.apache.activemq.plugin.JAXBUtils;
import org.apache.activemq.plugin.RuntimeConfigurationBroker;
import org.apache.activemq.schema.core.DtoBroker;
import org.apache.activemq.util.IntrospectionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfigurationProcessor
implements ConfigurationProcessor {
    public static final Logger LOG = LoggerFactory.getLogger(DefaultConfigurationProcessor.class);
    RuntimeConfigurationBroker plugin;
    Class configurationClass;
    Pattern matchPassword = Pattern.compile("password=.*,");

    public DefaultConfigurationProcessor(RuntimeConfigurationBroker plugin, Class configurationClass) {
        this.plugin = plugin;
        this.configurationClass = configurationClass;
    }

    @Override
    public void processChanges(DtoBroker currentConfiguration, DtoBroker modifiedConfiguration) {
        List<Object> modified;
        List<Object> current = this.filter(currentConfiguration, this.configurationClass);
        if (current.equals(modified = this.filter(modifiedConfiguration, this.configurationClass))) {
            this.plugin.debug("no changes to " + this.configurationClass.getSimpleName());
            return;
        }
        this.plugin.info("changes to " + this.configurationClass.getSimpleName());
        this.processChanges(current, modified);
    }

    @Override
    public void processChanges(List current, List modified) {
        ConfigurationProcessor processor;
        int currentIndex;
        int modIndex = 0;
        for (currentIndex = 0; modIndex < modified.size() && currentIndex < current.size(); ++modIndex, ++currentIndex) {
            this.applyModifications(this.getContents(current.get(currentIndex)), this.getContents(modified.get(modIndex)));
        }
        while (modIndex < modified.size()) {
            for (Object nc : this.getContents(modified.get(modIndex))) {
                processor = this.findProcessor(nc);
                if (processor != null) {
                    processor.addNew(nc);
                    continue;
                }
                this.addNew(nc);
            }
            ++modIndex;
        }
        while (currentIndex < current.size()) {
            for (Object nc : this.getContents(current.get(currentIndex))) {
                processor = this.findProcessor(nc);
                if (processor != null) {
                    processor.remove(nc);
                    continue;
                }
                this.remove(nc);
            }
            ++currentIndex;
        }
    }

    protected void applyModifications(List<Object> current, List<Object> modification) {
        ConfigurationProcessor processor;
        Object mod;
        int currentIndex;
        int modIndex = 0;
        for (currentIndex = 0; modIndex < modification.size() && currentIndex < current.size(); ++modIndex, ++currentIndex) {
            Object candidate;
            Object existing = current.get(currentIndex);
            if (existing.equals(candidate = modification.get(modIndex))) continue;
            this.plugin.debug("modification to:" + existing + " , with: " + candidate);
            ConfigurationProcessor processor2 = this.findProcessor(existing);
            if (processor2 != null) {
                processor2.modify(existing, candidate);
                continue;
            }
            this.modify(existing, candidate);
        }
        while (modIndex < modification.size()) {
            mod = modification.get(modIndex);
            processor = this.findProcessor(mod);
            if (processor != null) {
                processor.addNew(mod);
            } else {
                this.addNew(mod);
            }
            ++modIndex;
        }
        while (currentIndex < current.size()) {
            mod = current.get(currentIndex);
            processor = this.findProcessor(mod);
            if (processor != null) {
                processor.remove(mod);
            } else {
                this.remove(mod);
            }
            ++currentIndex;
        }
    }

    @Override
    public void modify(Object existing, Object candidate) {
        this.remove(existing);
        this.addNew(candidate);
    }

    @Override
    public void addNew(Object o) {
        this.plugin.info("No runtime support for additions of " + o);
    }

    @Override
    public void remove(Object o) {
        this.plugin.info("No runtime support for removal of: " + o);
    }

    @Override
    public ConfigurationProcessor findProcessor(Object o) {
        this.plugin.info("No processor for " + o);
        return null;
    }

    protected List<Object> getContents(Object o) {
        List<Object> answer = new ArrayList<Object>();
        try {
            Object val = o.getClass().getMethod("getContents", new Class[0]).invoke(o, new Object[0]);
            if (val instanceof List) {
                answer = (List)val;
            } else {
                answer.add(val);
            }
        }
        catch (NoSuchMethodException mappingIncomplete) {
            this.plugin.debug(this.filterPasswords(o) + " has no modifiable elements");
        }
        catch (Exception e) {
            this.plugin.info("Failed to access getContents for " + o + ", runtime modifications not supported", e);
        }
        return answer;
    }

    protected String filterPasswords(Object toEscape) {
        return this.matchPassword.matcher(toEscape.toString()).replaceAll("password=???,");
    }

    protected <T> List<Object> filter(Object obj, Class<T> type) {
        return this.filter(this.getContents(obj), type);
    }

    protected <T> List<Object> filter(List<Object> objectList, Class<T> type) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (Object o : objectList) {
            if (o instanceof JAXBElement) {
                JAXBElement element = (JAXBElement)o;
                if (!type.isAssignableFrom(element.getDeclaredType())) continue;
                result.add(element.getValue());
                continue;
            }
            if (!type.isAssignableFrom(o.getClass())) continue;
            result.add(o);
        }
        return result;
    }

    protected <T> T fromDto(Object dto, T instance) {
        Properties properties = new Properties();
        IntrospectionSupport.getProperties((Object)dto, (Map)properties, null);
        this.plugin.placeHolderUtil.filter(properties);
        LOG.trace("applying props: " + this.filterPasswords(properties) + ", to " + instance.getClass().getSimpleName());
        IntrospectionSupport.setProperties(instance, (Map)properties);
        for (Object nested : this.filter(dto, Object.class)) {
            String elementName = nested.getClass().getSimpleName();
            Method setter = JAXBUtils.findSetter(instance, elementName);
            if (setter != null) {
                LinkedList<Object> argument = new LinkedList<Object>();
                for (Object elementContent : this.filter(nested, Object.class)) {
                    argument.add(this.fromDto(elementContent, JAXBUtils.inferTargetObject(elementContent)));
                }
                try {
                    setter.invoke(instance, JAXBUtils.matchType(argument, setter.getParameterTypes()[0]));
                }
                catch (Exception e) {
                    this.plugin.info("failed to invoke " + setter + " on " + instance + " with args " + argument, e);
                }
                continue;
            }
            this.plugin.info("failed to find setter for " + elementName + " on :" + instance);
        }
        this.invokePostConstruct(instance);
        return instance;
    }

    private <T> void invokePostConstruct(T instance) {
        try {
            for (Method m : instance.getClass().getDeclaredMethods()) {
                if (!m.isAnnotationPresent(PostConstruct.class) || m.getParameterCount() != 0) continue;
                try {
                    JAXBUtils.ensureAccessible(m);
                    m.invoke(instance, null);
                }
                catch (Exception e) {
                    this.plugin.info("failed to invoke @PostConstruct method " + m + " on " + instance, e);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

