/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.ws;

import java.io.IOException;
import java.security.cert.X509Certificate;
import org.apache.activemq.command.Command;
import org.apache.activemq.transport.TransportSupport;
import org.apache.activemq.transport.stomp.ProtocolConverter;
import org.apache.activemq.transport.stomp.StompFrame;
import org.apache.activemq.transport.stomp.StompInactivityMonitor;
import org.apache.activemq.transport.stomp.StompTransport;
import org.apache.activemq.transport.stomp.StompWireFormat;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.eclipse.jetty.websocket.WebSocket;

class StompSocket
extends TransportSupport
implements WebSocket.OnTextMessage,
StompTransport {
    WebSocket.Connection outbound;
    ProtocolConverter protocolConverter = new ProtocolConverter((StompTransport)this, null);
    StompWireFormat wireFormat = new StompWireFormat();

    StompSocket() {
    }

    public void onOpen(WebSocket.Connection connection) {
        this.outbound = connection;
    }

    public void onClose(int closeCode, String message) {
    }

    public void onMessage(String data) {
        try {
            this.protocolConverter.onStompCommand((StompFrame)this.wireFormat.unmarshal(new ByteSequence(data.getBytes("UTF-8"))));
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create((Exception)e));
        }
    }

    protected void doStart() throws Exception {
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
    }

    public int getReceiveCounter() {
        return 0;
    }

    public String getRemoteAddress() {
        return "StompSocket_" + ((Object)((Object)this)).hashCode();
    }

    public void oneway(Object command) throws IOException {
        try {
            this.protocolConverter.onActiveMQCommand((Command)command);
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create((Exception)e));
        }
    }

    public X509Certificate[] getPeerCertificates() {
        return null;
    }

    public void sendToActiveMQ(Command command) {
        this.doConsume(command);
    }

    public void sendToStomp(StompFrame command) throws IOException {
        this.outbound.sendMessage(command.format());
    }

    public StompInactivityMonitor getInactivityMonitor() {
        return null;
    }

    public StompWireFormat getWireFormat() {
        return this.wireFormat;
    }
}

