/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.http;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URI;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.transport.FutureResponse;
import org.apache.activemq.transport.http.HttpTransportSupport;
import org.apache.activemq.transport.util.TextWireFormat;
import org.apache.activemq.util.ByteArrayInputStream;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.ServiceStopper;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpClientTransport
extends HttpTransportSupport {
    public static final int MAX_CLIENT_TIMEOUT = 30000;
    private static final Log LOG = LogFactory.getLog(HttpClientTransport.class);
    private static final IdGenerator CLIENT_ID_GENERATOR = new IdGenerator();
    private HttpClient sendHttpClient;
    private HttpClient receiveHttpClient;
    private final String clientID = CLIENT_ID_GENERATOR.generateId();
    private boolean trace;
    private GetMethod httpMethod;

    public HttpClientTransport(TextWireFormat wireFormat, URI remoteUrl) {
        super(wireFormat, remoteUrl);
    }

    public FutureResponse asyncRequest(Object command) throws IOException {
        return null;
    }

    public void oneway(Object command) throws IOException {
        if (this.isStopped()) {
            throw new IOException("stopped.");
        }
        PostMethod httpMethod = new PostMethod(this.getRemoteUrl().toString());
        this.configureMethod((HttpMethod)httpMethod);
        String data = this.getTextWireFormat().marshalText(command);
        byte[] bytes = data.getBytes("UTF-8");
        InputStreamRequestEntity entity = new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(bytes));
        httpMethod.setRequestEntity((RequestEntity)entity);
        try {
            HttpClient client = this.getSendHttpClient();
            HttpClientParams params = new HttpClientParams();
            params.setSoTimeout(30000);
            client.setParams(params);
            int answer = client.executeMethod((HttpMethod)httpMethod);
            if (answer != 200) {
                throw new IOException("Failed to post command: " + command + " as response was: " + answer);
            }
            if (command instanceof ShutdownInfo) {
                try {
                    this.stop();
                }
                catch (Exception e) {
                    LOG.warn((Object)("Error trying to stop HTTP client: " + e), (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            throw IOExceptionSupport.create((String)("Could not post command: " + command + " due to: " + e), (Exception)e);
        }
        finally {
            httpMethod.getResponseBody();
            httpMethod.releaseConnection();
        }
    }

    public Object request(Object command) throws IOException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LOG.trace((Object)("HTTP GET consumer thread starting: " + (Object)((Object)this)));
        HttpClient httpClient = this.getReceiveHttpClient();
        URI remoteUrl = this.getRemoteUrl();
        while (!this.isStopped() && !this.isStopping()) {
            this.httpMethod = new GetMethod(remoteUrl.toString());
            this.configureMethod((HttpMethod)this.httpMethod);
            try {
                int answer = httpClient.executeMethod((HttpMethod)this.httpMethod);
                if (answer != 200) {
                    if (answer == 408) {
                        LOG.debug((Object)"GET timed out");
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            this.onException(new InterruptedIOException());
                            this.httpMethod.releaseConnection();
                            break;
                        }
                    }
                    this.onException(new IOException("Failed to perform GET on: " + remoteUrl + " as response was: " + answer));
                    break;
                }
                DataInputStream stream = new DataInputStream(this.httpMethod.getResponseBodyAsStream());
                Object command = this.getTextWireFormat().unmarshal(stream);
                if (command == null) {
                    LOG.debug((Object)("Received null command from url: " + remoteUrl));
                    continue;
                }
                this.doConsume(command);
            }
            catch (IOException e) {
                this.onException(IOExceptionSupport.create((String)("Failed to perform GET on: " + remoteUrl + " Reason: " + e.getMessage()), (Exception)e));
                break;
            }
            finally {
                this.httpMethod.releaseConnection();
            }
        }
    }

    public HttpClient getSendHttpClient() {
        if (this.sendHttpClient == null) {
            this.sendHttpClient = this.createHttpClient();
        }
        return this.sendHttpClient;
    }

    public void setSendHttpClient(HttpClient sendHttpClient) {
        this.sendHttpClient = sendHttpClient;
    }

    public HttpClient getReceiveHttpClient() {
        if (this.receiveHttpClient == null) {
            this.receiveHttpClient = this.createHttpClient();
        }
        return this.receiveHttpClient;
    }

    public void setReceiveHttpClient(HttpClient receiveHttpClient) {
        this.receiveHttpClient = receiveHttpClient;
    }

    protected void doStart() throws Exception {
        LOG.trace((Object)("HTTP GET consumer thread starting: " + (Object)((Object)this)));
        HttpClient httpClient = this.getReceiveHttpClient();
        URI remoteUrl = this.getRemoteUrl();
        HeadMethod httpMethod = new HeadMethod(remoteUrl.toString());
        this.configureMethod((HttpMethod)httpMethod);
        int answer = httpClient.executeMethod((HttpMethod)httpMethod);
        if (answer != 200) {
            throw new IOException("Failed to perform GET on: " + remoteUrl + " as response was: " + answer);
        }
        super.doStart();
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        this.httpMethod.abort();
    }

    protected HttpClient createHttpClient() {
        HttpClient client = new HttpClient();
        if (this.getProxyHost() != null) {
            client.getHostConfiguration().setProxy(this.getProxyHost(), this.getProxyPort());
        }
        return client;
    }

    protected void configureMethod(HttpMethod method) {
        method.setRequestHeader("clientID", this.clientID);
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }
}

