/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.tool;

import java.io.File;
import org.apache.activemq.openwire.tool.CSharpClassesGenerator;
import org.apache.activemq.openwire.tool.CSharpMarshallingGenerator;
import org.apache.activemq.openwire.tool.MultiSourceGenerator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.codehaus.jam.JamService;
import org.codehaus.jam.JamServiceFactory;
import org.codehaus.jam.JamServiceParams;

public class CSharpGeneratorTask
extends Task {
    int version = 2;
    File source = new File(".");
    File target = new File(".");

    public static void main(String[] args) {
        Project project = new Project();
        project.init();
        CSharpGeneratorTask generator = new CSharpGeneratorTask();
        generator.setProject(project);
        if (args.length > 0) {
            generator.version = Integer.parseInt(args[0]);
        }
        if (args.length > 1) {
            generator.source = new File(args[1]);
        }
        if (args.length > 2) {
            generator.target = new File(args[2]);
        }
        generator.execute();
    }

    public void execute() throws BuildException {
        try {
            String sourceDir = String.valueOf(this.source) + "/src/main/java";
            System.out.println("Parsing source files in: " + sourceDir);
            JamServiceFactory jamServiceFactory = JamServiceFactory.getInstance();
            JamServiceParams params = jamServiceFactory.createServiceParams();
            File[] dirs = new File[]{new File(sourceDir)};
            params.includeSourcePattern(dirs, "**/*.java");
            JamService jam = jamServiceFactory.createService(params);
            MultiSourceGenerator script = new CSharpClassesGenerator();
            script.setJam(jam);
            ((CSharpClassesGenerator)script).setTargetDir(String.valueOf(this.target) + "/src/main/csharp");
            script.setOpenwireVersion(this.version);
            ((CSharpClassesGenerator)script).run();
            script = new CSharpMarshallingGenerator();
            script.setJam(jam);
            ((CSharpMarshallingGenerator)script).setTargetDir(String.valueOf(this.target) + "/src/main/csharp");
            script.setOpenwireVersion(this.version);
            ((CSharpMarshallingGenerator)script).run();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public File getSource() {
        return this.source;
    }

    public void setSource(File basedir) {
        this.source = basedir;
    }

    public File getTarget() {
        return this.target;
    }

    public void setTarget(File target) {
        this.target = target;
    }
}

