/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.thread;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.activemq.thread.PooledTaskRunner;
import org.apache.activemq.thread.Task;
import org.apache.activemq.thread.TaskRunner;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.junit.Assert;
import org.junit.Test;

public class TaskRunnerFactoryTest {
    @Test
    public void testConcurrentTaskRunnerCreation() throws Exception {
        final TaskRunnerFactory factory = new TaskRunnerFactory();
        ExecutorService service = Executors.newFixedThreadPool(10);
        final CountDownLatch latch1 = new CountDownLatch(1);
        final CountDownLatch latch2 = new CountDownLatch(10);
        final List<TaskRunner> runners = Collections.synchronizedList(new ArrayList(10));
        for (int i = 0; i < 10; ++i) {
            service.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        latch1.await();
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException(e);
                    }
                    runners.add(factory.createTaskRunner(new Task(){

                        public boolean iterate() {
                            return false;
                        }
                    }, "task"));
                    latch2.countDown();
                }
            });
        }
        latch1.countDown();
        latch2.await();
        for (TaskRunner runner : runners) {
            Assert.assertTrue((boolean)(runner instanceof PooledTaskRunner));
        }
    }
}

