/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.xbean;

import org.apache.activemq.broker.BrokerService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class XBeanBrokerService
extends BrokerService
implements InitializingBean,
DisposableBean,
ApplicationContextAware {
    private boolean start = true;
    private ApplicationContext applicationContext = null;
    private boolean destroyApplicationContextOnShutdown = false;

    public void afterPropertiesSet() throws Exception {
        if (this.start) {
            this.start();
        }
        if (this.destroyApplicationContextOnShutdown) {
            this.addShutdownHook(new Runnable(){

                public void run() {
                    if (XBeanBrokerService.this.applicationContext instanceof ConfigurableApplicationContext) {
                        ((ConfigurableApplicationContext)XBeanBrokerService.this.applicationContext).close();
                    }
                }
            });
        }
    }

    public void destroy() throws Exception {
        this.stop();
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    public void setDestroyApplicationContextOnShutdown(boolean destroy) {
        this.destroyApplicationContextOnShutdown = destroy;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

