/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.GeneratedMessage;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.accumulo.core.client.Durability;
import org.apache.accumulo.core.client.admin.CompactionStrategyConfig;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.DurabilityImpl;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.ConfigurationObserver;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.constraints.Constraint;
import org.apache.accumulo.core.constraints.Violations;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.IterInfo;
import org.apache.accumulo.core.dataImpl.thrift.MapFileInfo;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.iterators.IterationInterruptedException;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.YieldCallback;
import org.apache.accumulo.core.iterators.system.SourceSwitchingIterator;
import org.apache.accumulo.core.master.thrift.BulkImportState;
import org.apache.accumulo.core.master.thrift.TabletLoadState;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationConfigurationUtil;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.core.tabletserver.thrift.TabletStats;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.ShutdownUtil;
import org.apache.accumulo.core.util.ratelimit.RateLimiter;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.server.fs.VolumeChooserEnvironment;
import org.apache.accumulo.server.fs.VolumeChooserEnvironmentImpl;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeUtil;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.tableOps.UserCompactionConfig;
import org.apache.accumulo.server.problems.ProblemReport;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.problems.ProblemType;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.server.tablets.TabletTime;
import org.apache.accumulo.server.tablets.UniqueNameAllocator;
import org.apache.accumulo.server.util.FileUtil;
import org.apache.accumulo.server.util.MasterMetadataUtil;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.util.ReplicationTableUtil;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.accumulo.tserver.ConditionCheckerContext;
import org.apache.accumulo.tserver.InMemoryMap;
import org.apache.accumulo.tserver.MinorCompactionReason;
import org.apache.accumulo.tserver.TConstraintViolationException;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.TabletServerResourceManager;
import org.apache.accumulo.tserver.TabletStatsKeeper;
import org.apache.accumulo.tserver.TooManyFilesException;
import org.apache.accumulo.tserver.TservConstraintEnv;
import org.apache.accumulo.tserver.compaction.CompactionPlan;
import org.apache.accumulo.tserver.compaction.CompactionStrategy;
import org.apache.accumulo.tserver.compaction.DefaultCompactionStrategy;
import org.apache.accumulo.tserver.compaction.MajorCompactionReason;
import org.apache.accumulo.tserver.compaction.MajorCompactionRequest;
import org.apache.accumulo.tserver.compaction.WriteParameters;
import org.apache.accumulo.tserver.constraints.ConstraintChecker;
import org.apache.accumulo.tserver.log.DfsLogger;
import org.apache.accumulo.tserver.mastermessage.TabletStatusMessage;
import org.apache.accumulo.tserver.metrics.TabletServerMinCMetrics;
import org.apache.accumulo.tserver.tablet.Batch;
import org.apache.accumulo.tserver.tablet.CommitSession;
import org.apache.accumulo.tserver.tablet.CompactionRunner;
import org.apache.accumulo.tserver.tablet.CompactionStats;
import org.apache.accumulo.tserver.tablet.Compactor;
import org.apache.accumulo.tserver.tablet.DatafileManager;
import org.apache.accumulo.tserver.tablet.KVEntry;
import org.apache.accumulo.tserver.tablet.MinorCompactionTask;
import org.apache.accumulo.tserver.tablet.MinorCompactor;
import org.apache.accumulo.tserver.tablet.Rate;
import org.apache.accumulo.tserver.tablet.RootFiles;
import org.apache.accumulo.tserver.tablet.ScanDataSource;
import org.apache.accumulo.tserver.tablet.ScanOptions;
import org.apache.accumulo.tserver.tablet.Scanner;
import org.apache.accumulo.tserver.tablet.SplitRowSpec;
import org.apache.accumulo.tserver.tablet.TabletClosedException;
import org.apache.accumulo.tserver.tablet.TabletData;
import org.apache.accumulo.tserver.tablet.TabletMemory;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.htrace.Sampler;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;
import org.apache.htrace.impl.ProbabilitySampler;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tablet {
    private static final Logger log = LoggerFactory.getLogger(Tablet.class);
    private final TabletServer tabletServer;
    private final ServerContext context;
    private final KeyExtent extent;
    private final TabletServerResourceManager.TabletResourceManager tabletResources;
    private final DatafileManager datafileManager;
    private final TableConfiguration tableConfiguration;
    private final String tabletDirectory;
    private final Path location;
    private final TabletMemory tabletMemory;
    private final TabletTime tabletTime;
    private final Object timeLock = new Object();
    private long persistedTime;
    private TServerInstance lastLocation = null;
    private volatile boolean tableDirChecked = false;
    private final AtomicLong dataSourceDeletions = new AtomicLong(0L);
    private final Set<ScanDataSource> activeScans = new HashSet<ScanDataSource>();
    private volatile CloseState closeState = CloseState.OPEN;
    private boolean updatingFlushID = false;
    private long lastFlushID = -1L;
    private long lastCompactID = -1L;
    private final CompactionWaitInfo compactionWaitInfo = new CompactionWaitInfo();
    private volatile CompactionState minorCompactionState = null;
    private volatile CompactionState majorCompactionState = null;
    private final Set<MajorCompactionReason> majorCompactionQueued = Collections.synchronizedSet(EnumSet.noneOf(MajorCompactionReason.class));
    private final AtomicReference<ConstraintChecker> constraintChecker = new AtomicReference();
    private int writesInProgress = 0;
    private final TabletStatsKeeper timer = new TabletStatsKeeper();
    private final Rate queryRate = new Rate(0.95);
    private long queryCount = 0L;
    private final Rate queryByteRate = new Rate(0.95);
    private long queryBytes = 0L;
    private final Rate ingestRate = new Rate(0.95);
    private long ingestCount = 0L;
    private final Rate ingestByteRate = new Rate(0.95);
    private long ingestBytes = 0L;
    private byte[] defaultSecurityLabel = new byte[0];
    private long lastMinorCompactionFinishTime = 0L;
    private long lastMapFileImportTime = 0L;
    private volatile long numEntries = 0L;
    private volatile long numEntriesInMemory = 0L;
    private final Rate scannedRate = new Rate(0.95);
    private final AtomicLong scannedCount = new AtomicLong(0L);
    private final ConfigurationObserver configObserver;
    private final Set<FileRef> bulkImporting = new HashSet<FileRef>();
    private final Cache<Long, List<FileRef>> bulkImported = CacheBuilder.newBuilder().build();
    private final int logId;
    private boolean closeCompleting = false;
    private final long splitCreationTime;
    private boolean supressFindSplits = false;
    private long timeOfLastMinCWhenFindSplitsWasSupressed = 0L;
    private long timeOfLastImportWhenFindSplitsWasSupressed = 0L;
    private Set<DfsLogger> currentLogs = new HashSet<DfsLogger>();
    private Set<DfsLogger> otherLogs = Collections.emptySet();
    private volatile Set<DfsLogger> referencedLogs = Collections.emptySet();
    private boolean removingLogs = false;
    private final ReentrantLock logLock = new ReentrantLock();

    public long getDataSourceDeletions() {
        return this.dataSourceDeletions.get();
    }

    public int getLogId() {
        return this.logId;
    }

    FileRef getNextMapFilename(String prefix) throws IOException {
        String extension = FileOperations.getNewFileExtension((AccumuloConfiguration)this.tableConfiguration);
        this.checkTabletDir();
        return new FileRef(this.location + "/" + prefix + this.context.getUniqueNameAllocator().getNextName() + "." + extension);
    }

    private void checkTabletDir() throws IOException {
        if (!this.tableDirChecked) {
            FileStatus[] files = null;
            try {
                files = this.getTabletServer().getFileSystem().listStatus(this.location);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            if (files == null) {
                if (this.location.getName().startsWith("c-")) {
                    log.debug("Tablet {} had no dir, creating {}", (Object)this.extent, (Object)this.location);
                } else {
                    log.warn("Tablet {} had no dir, creating {}", (Object)this.extent, (Object)this.location);
                }
                this.getTabletServer().getFileSystem().mkdirs(this.location);
            }
            this.tableDirChecked = true;
        }
    }

    @VisibleForTesting
    protected Tablet(TabletTime tabletTime, String tabletDirectory, int logId, Path location, DatafileManager datafileManager, TabletServer tabletServer, TabletServerResourceManager.TabletResourceManager tabletResources, TabletMemory tabletMemory, TableConfiguration tableConfiguration, KeyExtent extent, ConfigurationObserver configObserver) {
        this.tabletTime = tabletTime;
        this.tabletDirectory = tabletDirectory;
        this.logId = logId;
        this.location = location;
        this.datafileManager = datafileManager;
        this.tabletServer = tabletServer;
        this.context = tabletServer.getContext();
        this.tabletResources = tabletResources;
        this.tabletMemory = tabletMemory;
        this.tableConfiguration = tableConfiguration;
        this.extent = extent;
        this.configObserver = configObserver;
        this.splitCreationTime = 0L;
    }

    public Tablet(TabletServer tabletServer, final KeyExtent extent, TabletServerResourceManager.TabletResourceManager trm, TabletData data) throws IOException {
        String contextName;
        this.tabletServer = tabletServer;
        this.context = tabletServer.getContext();
        this.extent = extent;
        this.tabletResources = trm;
        this.lastLocation = data.getLastLocation();
        this.lastFlushID = data.getFlushID();
        this.lastCompactID = data.getCompactID();
        this.splitCreationTime = data.getSplitTime();
        this.tabletTime = TabletTime.getInstance((String)data.getTime());
        this.persistedTime = this.tabletTime.getTime();
        this.logId = tabletServer.createLogId();
        TableConfiguration tblConf = tabletServer.getTableConfiguration(extent);
        if (tblConf == null) {
            Tables.clearCache((ClientContext)tabletServer.getContext());
            tblConf = tabletServer.getTableConfiguration(extent);
            Objects.requireNonNull(tblConf, "Could not get table configuration for " + extent.getTableId());
        }
        this.tableConfiguration = tblConf;
        VolumeManager fs = tabletServer.getFileSystem();
        boolean replicationEnabled = ReplicationConfigurationUtil.isEnabled((KeyExtent)extent, (AccumuloConfiguration)this.tableConfiguration);
        VolumeUtil.TabletFiles tabletPaths = new VolumeUtil.TabletFiles(data.getDirectory(), data.getLogEntries(), data.getDataFiles());
        tabletPaths = VolumeUtil.updateTabletVolumes((ServerContext)tabletServer.getContext(), (ZooLock)tabletServer.getLock(), (VolumeManager)fs, (KeyExtent)extent, (VolumeUtil.TabletFiles)tabletPaths, (boolean)replicationEnabled);
        Path locationPath = tabletPaths.dir.contains(":") ? new Path(tabletPaths.dir) : tabletServer.getFileSystem().getFullPath(VolumeManager.FileType.TABLE, extent.getTableId() + tabletPaths.dir);
        this.location = locationPath;
        this.tabletDirectory = tabletPaths.dir;
        for (Map.Entry<Long, List<FileRef>> entry : data.getBulkImported().entrySet()) {
            this.bulkImported.put((Object)entry.getKey(), new CopyOnWriteArrayList(entry.getValue()));
        }
        this.setupDefaultSecurityLabels(extent);
        List logEntries = tabletPaths.logEntries;
        SortedMap datafiles = tabletPaths.datafiles;
        this.configObserver = new ConfigurationObserver(){

            private void reloadConstraints() {
                log.debug("Reloading constraints for extent: " + extent);
                Tablet.this.constraintChecker.set(new ConstraintChecker(Tablet.this.tableConfiguration));
            }

            public void propertiesChanged() {
                this.reloadConstraints();
                try {
                    Tablet.this.setupDefaultSecurityLabels(extent);
                }
                catch (Exception e) {
                    log.error("Failed to reload default security labels for extent: {}", (Object)extent);
                }
            }

            public void propertyChanged(String prop) {
                if (prop.startsWith(Property.TABLE_CONSTRAINT_PREFIX.getKey())) {
                    this.reloadConstraints();
                } else if (prop.equals(Property.TABLE_DEFAULT_SCANTIME_VISIBILITY.getKey())) {
                    try {
                        log.info("Default security labels changed for extent: {}", (Object)extent);
                        Tablet.this.setupDefaultSecurityLabels(extent);
                    }
                    catch (Exception e) {
                        log.error("Failed to reload default security labels for extent: {}", (Object)extent);
                    }
                }
            }

            public void sessionExpired() {
                log.trace("Session expired, no longer updating per table props...");
            }
        };
        this.tableConfiguration.addObserver(this.configObserver);
        this.tableConfiguration.getNamespaceConfiguration().addObserver(this.configObserver);
        this.tabletMemory = new TabletMemory(this);
        this.configObserver.propertiesChanged();
        if (!logEntries.isEmpty()) {
            log.info("Starting Write-Ahead Log recovery for {}", (Object)this.extent);
            AtomicLong entriesUsedOnTablet = new AtomicLong(0L);
            AtomicLong maxTime = new AtomicLong(Long.MIN_VALUE);
            CommitSession commitSession = this.getTabletMemory().getCommitSession();
            try {
                HashSet<String> absPaths = new HashSet<String>();
                for (FileRef ref : datafiles.keySet()) {
                    absPaths.add(ref.path().toString());
                }
                tabletServer.recover(this.getTabletServer().getFileSystem(), extent, logEntries, absPaths, m -> {
                    List muts = m.getUpdates();
                    for (ColumnUpdate columnUpdate : muts) {
                        if (columnUpdate.hasTimestamp()) continue;
                        maxTime.set(Math.max(maxTime.get(), columnUpdate.getTimestamp()));
                    }
                    this.getTabletMemory().mutate(commitSession, Collections.singletonList(m), 1);
                    entriesUsedOnTablet.incrementAndGet();
                });
                if (maxTime.get() != Long.MIN_VALUE) {
                    this.tabletTime.useMaxTimeFromWALog(maxTime.get());
                }
                commitSession.updateMaxCommittedTime(this.tabletTime.getTime());
                if (entriesUsedOnTablet.get() == 0L) {
                    log.debug("No replayed mutations applied, removing unused entries for {}", (Object)extent);
                    MetadataTableUtil.removeUnusedWALEntries((ServerContext)this.getTabletServer().getContext(), (KeyExtent)extent, (List)logEntries, (ZooLock)tabletServer.getLock());
                    logEntries.clear();
                } else if (ReplicationConfigurationUtil.isEnabled((KeyExtent)extent, (AccumuloConfiguration)tabletServer.getTableConfiguration(extent))) {
                    Replication.Status status = StatusUtil.openWithUnknownLength();
                    for (LogEntry logEntry : logEntries) {
                        log.debug("Writing updated status to metadata table for {} {}", (Object)logEntry.filename, (Object)ProtobufUtil.toString((GeneratedMessage)status));
                        ReplicationTableUtil.updateFiles((ClientContext)tabletServer.getContext(), (KeyExtent)extent, (String)logEntry.filename, (Replication.Status)status);
                    }
                }
            }
            catch (Throwable t) {
                String msg = "Error recovering tablet " + extent + " from log files";
                if (this.tableConfiguration.getBoolean(Property.TABLE_FAILURES_IGNORE)) {
                    log.warn(msg, t);
                }
                throw new RuntimeException(msg, t);
            }
            this.currentLogs = new HashSet<DfsLogger>();
            for (LogEntry logEntry : logEntries) {
                this.currentLogs.add(new DfsLogger(tabletServer.getContext(), tabletServer.getServerConfig(), logEntry.filename, logEntry.getColumnQualifier().toString()));
            }
            this.rebuildReferencedLogs();
            log.info("Write-Ahead Log recovery complete for {} ({} mutations applied, {} entries created)", new Object[]{this.extent, entriesUsedOnTablet.get(), this.getTabletMemory().getNumEntries()});
        }
        if ((contextName = this.tableConfiguration.get(Property.TABLE_CLASSPATH)) != null && !contextName.equals("")) {
            AccumuloVFSClassLoader.getContextManager().getClassLoader(contextName);
        }
        this.datafileManager = new DatafileManager(this, datafiles);
        this.computeNumEntries();
        this.getDatafileManager().removeFilesAfterScan(data.getScanFiles());
        if (!logEntries.isEmpty() || this.needsMajorCompaction(MajorCompactionReason.NORMAL)) {
            this.removeOldTemporaryFiles();
        }
        log.debug("TABLET_HIST {} opened", (Object)extent);
    }

    public ServerContext getContext() {
        return this.context;
    }

    private void removeOldTemporaryFiles() {
        try {
            for (FileStatus tmp : this.getTabletServer().getFileSystem().globStatus(new Path(this.location, "*_tmp"))) {
                try {
                    log.debug("Removing old temp file {}", (Object)tmp.getPath());
                    this.getTabletServer().getFileSystem().delete(tmp.getPath());
                }
                catch (IOException ex) {
                    log.error("Unable to remove old temp file " + tmp.getPath() + ": " + ex);
                }
            }
        }
        catch (IOException ex) {
            log.error("Error scanning for old temp files in {}", (Object)this.location);
        }
    }

    private void setupDefaultSecurityLabels(KeyExtent extent) {
        if (extent.isMeta()) {
            this.defaultSecurityLabel = new byte[0];
        } else {
            try {
                ColumnVisibility cv = new ColumnVisibility(this.tableConfiguration.get(Property.TABLE_DEFAULT_SCANTIME_VISIBILITY));
                this.defaultSecurityLabel = cv.getExpression();
            }
            catch (Exception e) {
                log.error("Error setting up default security label {}", (Object)e.getMessage(), (Object)e);
                this.defaultSecurityLabel = new byte[0];
            }
        }
    }

    private LookupResult lookup(SortedKeyValueIterator<Key, Value> mmfi, List<Range> ranges, HashSet<Column> columnSet, List<KVEntry> results, long maxResultsSize, long batchTimeOut) throws IOException {
        LookupResult lookupResult = new LookupResult();
        boolean exceededMemoryUsage = false;
        boolean tabletClosed = false;
        ImmutableSet cfset = null;
        if (columnSet.size() > 0) {
            cfset = LocalityGroupUtil.families(columnSet);
        }
        long timeToRun = TimeUnit.MILLISECONDS.toNanos(batchTimeOut);
        long startNanos = System.nanoTime();
        if (batchTimeOut <= 0L || batchTimeOut == Long.MAX_VALUE) {
            batchTimeOut = 0L;
        }
        YieldCallback yield = new YieldCallback();
        mmfi.enableYielding(yield);
        boolean yielded = false;
        for (Range range : ranges) {
            boolean timesUp;
            boolean bl = timesUp = batchTimeOut > 0L && System.nanoTime() - startNanos > timeToRun;
            if (exceededMemoryUsage || tabletClosed || timesUp || yielded) {
                lookupResult.unfinishedRanges.add(range);
                continue;
            }
            int entriesAdded = 0;
            try {
                if (cfset != null) {
                    mmfi.seek(range, (Collection)cfset, true);
                } else {
                    mmfi.seek(range, (Collection)LocalityGroupUtil.EMPTY_CF_SET, false);
                }
                while (mmfi.hasTop()) {
                    if (yield.hasYielded()) {
                        throw new IOException("Coding error: hasTop returned true but has yielded at " + yield.getPositionAndReset());
                    }
                    Key key = (Key)mmfi.getTopKey();
                    KVEntry kve = new KVEntry(key, (Value)mmfi.getTopValue());
                    results.add(kve);
                    ++entriesAdded;
                    lookupResult.bytesAdded += (long)kve.estimateMemoryUsed();
                    lookupResult.dataSize += (long)kve.numBytes();
                    exceededMemoryUsage = lookupResult.bytesAdded > maxResultsSize;
                    boolean bl2 = timesUp = batchTimeOut > 0L && System.nanoTime() - startNanos > timeToRun;
                    if (exceededMemoryUsage || timesUp) {
                        this.addUnfinishedRange(lookupResult, range, key, false);
                        break;
                    }
                    mmfi.next();
                }
                if (!yield.hasYielded()) continue;
                yielded = true;
                Key yieldPosition = (Key)yield.getPositionAndReset();
                if (!range.contains(yieldPosition)) {
                    throw new IOException("Underlying iterator yielded to a position outside of its range: " + yieldPosition + " not in " + range);
                }
                if (!results.isEmpty() && yieldPosition.compareTo((Key)results.get(results.size() - 1).getKey()) <= 0) {
                    throw new IOException("Underlying iterator yielded to a position that does not follow the last key returned: " + yieldPosition + " <= " + results.get(results.size() - 1).getKey());
                }
                this.addUnfinishedRange(lookupResult, range, yieldPosition, false);
                log.debug("Scan yield detected at position " + yieldPosition);
                this.getTabletServer().getScanMetrics().addYield(1L);
            }
            catch (TooManyFilesException tmfe) {
                log.warn("Tablet {} has too many files, batch lookup can not run", (Object)this.getExtent());
                this.handleTabletClosedDuringScan(results, lookupResult, exceededMemoryUsage, range, entriesAdded);
                tabletClosed = true;
            }
            catch (IOException ioe) {
                if (ShutdownUtil.isShutdownInProgress()) {
                    log.debug("IOException while shutdown in progress", (Throwable)ioe);
                    this.handleTabletClosedDuringScan(results, lookupResult, exceededMemoryUsage, range, entriesAdded);
                    tabletClosed = true;
                    continue;
                }
                throw ioe;
            }
            catch (IterationInterruptedException iie) {
                if (this.isClosed()) {
                    this.handleTabletClosedDuringScan(results, lookupResult, exceededMemoryUsage, range, entriesAdded);
                    tabletClosed = true;
                    continue;
                }
                throw iie;
            }
            catch (TabletClosedException tce) {
                this.handleTabletClosedDuringScan(results, lookupResult, exceededMemoryUsage, range, entriesAdded);
                tabletClosed = true;
            }
        }
        return lookupResult;
    }

    private void handleTabletClosedDuringScan(List<KVEntry> results, LookupResult lookupResult, boolean exceededMemoryUsage, Range range, int entriesAdded) {
        if (exceededMemoryUsage) {
            throw new IllegalStateException("Tablet " + this.extent + "should not exceed memory usage or close, not both");
        }
        if (entriesAdded > 0) {
            this.addUnfinishedRange(lookupResult, range, (Key)results.get(results.size() - 1).getKey(), false);
        } else {
            lookupResult.unfinishedRanges.add(range);
        }
        lookupResult.closed = true;
    }

    private void addUnfinishedRange(LookupResult lookupResult, Range range, Key key, boolean inclusiveStartKey) {
        if (range.getEndKey() == null || key.compareTo(range.getEndKey()) < 0) {
            Range nlur = new Range(new Key(key), inclusiveStartKey, range.getEndKey(), range.isEndKeyInclusive());
            lookupResult.unfinishedRanges.add(nlur);
        }
    }

    public void checkConditions(ConditionCheckerContext.ConditionChecker checker, Authorizations authorizations, AtomicBoolean iFlag) throws IOException {
        ScanDataSource dataSource = new ScanDataSource(this, authorizations, this.defaultSecurityLabel, iFlag);
        try {
            SourceSwitchingIterator iter = new SourceSwitchingIterator((SourceSwitchingIterator.DataSource)dataSource);
            checker.check((SortedKeyValueIterator<Key, Value>)iter);
        }
        catch (IOException ioe) {
            dataSource.close(true);
            throw ioe;
        }
        finally {
            dataSource.close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LookupResult lookup(List<Range> ranges, HashSet<Column> columns, Authorizations authorizations, List<KVEntry> results, long maxResultSize, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, AtomicBoolean interruptFlag, SamplerConfiguration samplerConfig, long batchTimeOut, String classLoaderContext) throws IOException {
        if (ranges.size() == 0) {
            return new LookupResult();
        }
        if ((ranges = Range.mergeOverlapping(ranges)).size() > 1) {
            Collections.sort(ranges);
        }
        Range tabletRange = this.extent.toDataRange();
        for (Range range : ranges) {
            tabletRange.clip(range);
        }
        ScanDataSource dataSource = new ScanDataSource(this, authorizations, this.defaultSecurityLabel, columns, ssiList, ssio, interruptFlag, samplerConfig, batchTimeOut, classLoaderContext);
        LookupResult result = null;
        try {
            SourceSwitchingIterator iter = new SourceSwitchingIterator((SourceSwitchingIterator.DataSource)dataSource);
            LookupResult lookupResult = result = this.lookup((SortedKeyValueIterator<Key, Value>)iter, ranges, columns, results, maxResultSize, batchTimeOut);
            return lookupResult;
        }
        catch (IOException ioe) {
            dataSource.close(true);
            throw ioe;
        }
        finally {
            dataSource.close(false);
            Tablet tablet = this;
            synchronized (tablet) {
                this.queryCount += (long)results.size();
                if (result != null) {
                    this.queryBytes += result.dataSize;
                }
            }
        }
    }

    Batch nextBatch(SortedKeyValueIterator<Key, Value> iter, Range range, int num, Set<Column> columns, long batchTimeOut, boolean isolated) throws IOException {
        long timeToRun = TimeUnit.MILLISECONDS.toNanos(batchTimeOut);
        long startNanos = System.nanoTime();
        if (batchTimeOut == Long.MAX_VALUE || batchTimeOut <= 0L) {
            batchTimeOut = 0L;
        }
        ArrayList<KVEntry> results = new ArrayList<KVEntry>();
        Key key = null;
        long resultSize = 0L;
        long resultBytes = 0L;
        long maxResultsSize = this.tableConfiguration.getAsBytes(Property.TABLE_SCAN_MAXMEM);
        Key continueKey = null;
        boolean skipContinueKey = false;
        YieldCallback yield = new YieldCallback();
        if (!isolated) {
            iter.enableYielding(yield);
        }
        if (columns.size() == 0) {
            iter.seek(range, (Collection)LocalityGroupUtil.EMPTY_CF_SET, false);
        } else {
            iter.seek(range, (Collection)LocalityGroupUtil.families(columns), true);
        }
        while (iter.hasTop()) {
            boolean timesUp;
            if (yield.hasYielded()) {
                throw new IOException("Coding error: hasTop returned true but has yielded at " + yield.getPositionAndReset());
            }
            Value value = (Value)iter.getTopValue();
            key = (Key)iter.getTopKey();
            KVEntry kvEntry = new KVEntry(key, value);
            results.add(kvEntry);
            resultBytes += (long)kvEntry.numBytes();
            boolean bl = timesUp = batchTimeOut > 0L && System.nanoTime() - startNanos >= timeToRun;
            if ((resultSize += (long)kvEntry.estimateMemoryUsed()) >= maxResultsSize || results.size() >= num || timesUp) {
                continueKey = new Key(key);
                skipContinueKey = true;
                break;
            }
            iter.next();
        }
        if (yield.hasYielded()) {
            continueKey = new Key((Key)yield.getPositionAndReset());
            skipContinueKey = true;
            if (!range.contains(continueKey)) {
                throw new IOException("Underlying iterator yielded to a position outside of its range: " + continueKey + " not in " + range);
            }
            if (!results.isEmpty() && continueKey.compareTo((Key)((KVEntry)((Object)results.get(results.size() - 1))).getKey()) <= 0) {
                throw new IOException("Underlying iterator yielded to a position that does not follow the last key returned: " + continueKey + " <= " + ((KVEntry)((Object)results.get(results.size() - 1))).getKey());
            }
            log.debug("Scan yield detected at position " + continueKey);
            this.getTabletServer().getScanMetrics().addYield(1L);
        } else if (!iter.hasTop()) {
            continueKey = null;
            if (results.size() == 0) {
                results = null;
            }
        }
        return new Batch(skipContinueKey, results, continueKey, resultBytes);
    }

    public Scanner createScanner(Range range, int num, Set<Column> columns, Authorizations authorizations, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, boolean isolated, AtomicBoolean interruptFlag, SamplerConfiguration samplerConfig, long batchTimeOut, String classLoaderContext) {
        this.extent.toDataRange().clip(range);
        ScanOptions opts = new ScanOptions(num, authorizations, this.defaultSecurityLabel, columns, ssiList, ssio, interruptFlag, isolated, samplerConfig, batchTimeOut, classLoaderContext);
        return new Scanner(this, range, opts);
    }

    DataFileValue minorCompact(InMemoryMap memTable, FileRef tmpDatafile, FileRef newDatafile, FileRef mergeFile, boolean hasQueueTime, long queued, CommitSession commitSession, long flushId, MinorCompactionReason mincReason) {
        boolean failed = false;
        long start = System.currentTimeMillis();
        this.timer.incrementStatusMinor();
        long count = 0L;
        String oldName = Thread.currentThread().getName();
        try {
            CompactionStats stats;
            Thread.currentThread().setName("Minor compacting " + this.extent);
            try (TraceScope span = Trace.startSpan((String)"write");){
                count = memTable.getNumEntries();
                DataFileValue dfv = null;
                if (mergeFile != null) {
                    dfv = (DataFileValue)this.getDatafileManager().getDatafileSizes().get(mergeFile);
                }
                MinorCompactor compactor = new MinorCompactor(this.tabletServer, this, memTable, mergeFile, dfv, tmpDatafile, mincReason, this.tableConfiguration);
                stats = compactor.call();
            }
            span = Trace.startSpan((String)"bringOnline");
            try {
                this.getDatafileManager().bringMinorCompactionOnline(tmpDatafile, newDatafile, mergeFile, new DataFileValue(stats.getFileSize(), stats.getEntriesWritten()), commitSession, flushId);
            }
            finally {
                if (span != null) {
                    span.close();
                }
            }
            DataFileValue dataFileValue = new DataFileValue(stats.getFileSize(), stats.getEntriesWritten());
            return dataFileValue;
        }
        catch (Error | Exception e) {
            failed = true;
            throw new RuntimeException("Exception occurred during minor compaction on " + this.extent, e);
        }
        finally {
            Thread.currentThread().setName(oldName);
            try {
                this.getTabletMemory().finalizeMinC();
            }
            catch (Throwable t) {
                log.error("Failed to free tablet memory on {}", (Object)this.extent, (Object)t);
            }
            if (!failed) {
                this.lastMinorCompactionFinishTime = System.currentTimeMillis();
            }
            TabletServerMinCMetrics minCMetrics = this.getTabletServer().getMinCMetrics();
            minCMetrics.addActive(this.lastMinorCompactionFinishTime - start);
            if (hasQueueTime) {
                this.timer.updateTime(TabletStatsKeeper.Operation.MINOR, queued, start, count, failed);
                minCMetrics.addQueued(start - queued);
            } else {
                this.timer.updateTime(TabletStatsKeeper.Operation.MINOR, start, failed);
            }
        }
    }

    private synchronized MinorCompactionTask prepareForMinC(long flushId, MinorCompactionReason mincReason) {
        Preconditions.checkState((boolean)this.otherLogs.isEmpty());
        Preconditions.checkState((boolean)this.referencedLogs.equals(this.currentLogs));
        CommitSession oldCommitSession = this.getTabletMemory().prepareForMinC();
        this.otherLogs = this.currentLogs;
        this.currentLogs = new HashSet<DfsLogger>();
        FileRef mergeFile = null;
        if (mincReason != MinorCompactionReason.RECOVERY) {
            mergeFile = this.getDatafileManager().reserveMergingMinorCompactionFile();
        }
        double tracePercent = this.tabletServer.getConfiguration().getFraction(Property.TSERV_MINC_TRACE_PERCENT);
        return new MinorCompactionTask(this, mergeFile, oldCommitSession, flushId, mincReason, tracePercent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void flush(long tableFlushID) {
        Tablet tablet;
        boolean initiateMinor;
        boolean updateMetadata;
        block25: {
            updateMetadata = false;
            initiateMinor = false;
            tablet = this;
            // MONITORENTER : tablet
            if (!this.updatingFlushID) break block25;
            // MONITOREXIT : tablet
            if (!updateMetadata) return;
            Tablet tablet2 = this;
            this.updatingFlushID = false;
            this.notifyAll();
            // MONITOREXIT : tablet2
            return;
        }
        if (this.lastFlushID >= tableFlushID) {
            // MONITOREXIT : tablet
            if (!updateMetadata) return;
            Tablet tablet3 = this;
            // MONITORENTER : tablet3
            this.updatingFlushID = false;
            this.notifyAll();
            // MONITOREXIT : tablet3
            return;
        }
        if (this.isClosing() || this.isClosed() || this.getTabletMemory().memoryReservedForMinC()) {
            // MONITOREXIT : tablet
            if (!updateMetadata) return;
            Tablet tablet4 = this;
            // MONITORENTER : tablet4
            this.updatingFlushID = false;
            this.notifyAll();
            // MONITOREXIT : tablet4
            return;
        }
        try {
            if (this.getTabletMemory().getMemTable().getNumEntries() == 0L) {
                this.lastFlushID = tableFlushID;
                this.updatingFlushID = true;
                updateMetadata = true;
            } else {
                initiateMinor = true;
            }
            // MONITOREXIT : tablet
            if (updateMetadata) {
                MetadataTableUtil.updateTabletFlushID((KeyExtent)this.extent, (long)tableFlushID, (ServerContext)this.context, (ZooLock)this.getTabletServer().getLock());
                return;
            }
            if (!initiateMinor) return;
            this.initiateMinorCompaction(tableFlushID, MinorCompactionReason.USER);
            return;
        }
        finally {
            if (updateMetadata) {
                tablet = this;
            }
        }
    }

    public boolean initiateMinorCompaction(MinorCompactionReason mincReason) {
        long flushId;
        if (this.isClosed()) {
            return false;
        }
        try {
            flushId = this.getFlushID();
        }
        catch (KeeperException.NoNodeException e) {
            log.info("Asked to initiate MinC when there was no flush id {} {}", (Object)this.getExtent(), (Object)e.getMessage());
            return false;
        }
        return this.initiateMinorCompaction(flushId, mincReason);
    }

    public boolean minorCompactNow(MinorCompactionReason mincReason) {
        long flushId;
        try {
            flushId = this.getFlushID();
        }
        catch (KeeperException.NoNodeException e) {
            log.info("Asked to initiate MinC when there was no flush id {} {}", (Object)this.getExtent(), (Object)e.getMessage());
            return false;
        }
        MinorCompactionTask mct = this.createMinorCompactionTask(flushId, mincReason);
        if (mct == null) {
            return false;
        }
        mct.run();
        return true;
    }

    boolean initiateMinorCompaction(long flushId, MinorCompactionReason mincReason) {
        MinorCompactionTask mct = this.createMinorCompactionTask(flushId, mincReason);
        if (mct == null) {
            return false;
        }
        this.getTabletResources().executeMinorCompaction(mct);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private MinorCompactionTask createMinorCompactionTask(long flushId, MinorCompactionReason mincReason) {
        long t1;
        StringBuilder logMessage;
        block9: {
            MinorCompactionTask minorCompactionTask;
            logMessage = null;
            try {
                Tablet tablet = this;
                // MONITORENTER : tablet
                t1 = System.currentTimeMillis();
                if (!this.isClosing() && !this.isClosed() && this.majorCompactionState != CompactionState.WAITING_TO_START && !this.getTabletMemory().memoryReservedForMinC() && this.getTabletMemory().getMemTable().getNumEntries() != 0L && !this.updatingFlushID) break block9;
                logMessage = new StringBuilder();
                logMessage.append(this.extent);
                logMessage.append(" closeState " + (Object)((Object)this.closeState));
                logMessage.append(" majorCompactionState " + (Object)((Object)this.majorCompactionState));
                if (this.getTabletMemory() != null) {
                    logMessage.append(" tabletMemory.memoryReservedForMinC() " + this.getTabletMemory().memoryReservedForMinC());
                }
                if (this.getTabletMemory() != null && this.getTabletMemory().getMemTable() != null) {
                    logMessage.append(" tabletMemory.getMemTable().getNumEntries() " + this.getTabletMemory().getMemTable().getNumEntries());
                }
                logMessage.append(" updatingFlushID " + this.updatingFlushID);
                minorCompactionTask = null;
                // MONITOREXIT : tablet
                if (logMessage == null) return minorCompactionTask;
            }
            catch (Throwable throwable) {
                if (logMessage == null) throw throwable;
                if (!log.isDebugEnabled()) throw throwable;
                log.debug("{}", logMessage);
                throw throwable;
            }
            if (!log.isDebugEnabled()) return minorCompactionTask;
            log.debug("{}", (Object)logMessage);
            return minorCompactionTask;
        }
        MinorCompactionTask mct = this.prepareForMinC(flushId, mincReason);
        long t2 = System.currentTimeMillis();
        // MONITOREXIT : tablet
        if (logMessage != null && log.isDebugEnabled()) {
            log.debug("{}", (Object)logMessage);
        }
        log.debug(String.format("MinC initiate lock %.2f secs", (double)(t2 - t1) / 1000.0));
        return mct;
    }

    public long getFlushID() throws KeeperException.NoNodeException {
        try {
            String zTablePath = "/accumulo/" + this.tabletServer.getInstanceID() + "/tables" + "/" + this.extent.getTableId() + "/flush-id";
            String id = new String(this.context.getZooReaderWriter().getData(zTablePath, null), StandardCharsets.UTF_8);
            return Long.parseLong(id);
        }
        catch (InterruptedException | NumberFormatException e) {
            throw new RuntimeException("Exception on " + this.extent + " getting flush ID", e);
        }
        catch (KeeperException ke) {
            if (ke instanceof KeeperException.NoNodeException) {
                throw (KeeperException.NoNodeException)((Object)ke);
            }
            throw new RuntimeException("Exception on " + this.extent + " getting flush ID", ke);
        }
    }

    long getCompactionCancelID() {
        String zTablePath = "/accumulo/" + this.tabletServer.getInstanceID() + "/tables" + "/" + this.extent.getTableId() + "/compact-cancel-id";
        try {
            String id = new String(this.context.getZooReaderWriter().getData(zTablePath, null), StandardCharsets.UTF_8);
            return Long.parseLong(id);
        }
        catch (InterruptedException | KeeperException e) {
            throw new RuntimeException("Exception on " + this.extent + " getting compact cancel ID", e);
        }
    }

    public Pair<Long, UserCompactionConfig> getCompactionID() throws KeeperException.NoNodeException {
        try {
            String zTablePath = "/accumulo/" + this.tabletServer.getInstanceID() + "/tables" + "/" + this.extent.getTableId() + "/compact-id";
            String[] tokens = new String(this.context.getZooReaderWriter().getData(zTablePath, null), StandardCharsets.UTF_8).split(",");
            long compactID = Long.parseLong(tokens[0]);
            UserCompactionConfig compactionConfig = new UserCompactionConfig();
            if (tokens.length > 1) {
                Hex hex = new Hex();
                ByteArrayInputStream bais = new ByteArrayInputStream(hex.decode(tokens[1].split("=")[1].getBytes(StandardCharsets.UTF_8)));
                DataInputStream dis = new DataInputStream(bais);
                compactionConfig.readFields((DataInput)dis);
                KeyExtent ke = new KeyExtent(this.extent.getTableId(), compactionConfig.getEndRow(), compactionConfig.getStartRow());
                if (!ke.overlaps(this.extent)) {
                    compactionConfig = new UserCompactionConfig();
                }
            }
            return new Pair((Object)compactID, (Object)compactionConfig);
        }
        catch (IOException | InterruptedException | NumberFormatException | DecoderException e) {
            throw new RuntimeException("Exception on " + this.extent + " getting compaction ID", e);
        }
        catch (KeeperException ke) {
            if (ke instanceof KeeperException.NoNodeException) {
                throw (KeeperException.NoNodeException)((Object)ke);
            }
            throw new RuntimeException("Exception on " + this.extent + " getting compaction ID", ke);
        }
    }

    private synchronized CommitSession finishPreparingMutations(long time) {
        if (this.isClosed() || this.getTabletMemory() == null) {
            return null;
        }
        CommitSession commitSession = this.getTabletMemory().getCommitSession();
        this.incrementWritesInProgress(commitSession);
        commitSession.updateMaxCommittedTime(time);
        return commitSession;
    }

    public void checkConstraints() {
        ConstraintChecker cc = this.constraintChecker.get();
        if (cc.classLoaderChanged()) {
            ConstraintChecker ncc = new ConstraintChecker(this.tableConfiguration);
            this.constraintChecker.compareAndSet(cc, ncc);
        }
    }

    public CommitSession prepareMutationsForCommit(TservConstraintEnv cenv, List<Mutation> mutations) throws TConstraintViolationException {
        ConstraintChecker cc = this.constraintChecker.get();
        ArrayList<Mutation> violators = null;
        Violations violations = new Violations();
        cenv.setExtent(this.extent);
        for (Mutation mutation : mutations) {
            Violations more = cc.check((Constraint.Environment)cenv, mutation);
            if (more == null) continue;
            violations.add(more);
            if (violators == null) {
                violators = new ArrayList<Mutation>();
            }
            violators.add(mutation);
        }
        long time = this.tabletTime.setUpdateTimes(mutations);
        if (!violations.isEmpty()) {
            HashSet violatorsSet = new HashSet(violators);
            ArrayList<Mutation> nonViolators = new ArrayList<Mutation>();
            for (Mutation mutation : mutations) {
                if (violatorsSet.contains(mutation)) continue;
                nonViolators.add(mutation);
            }
            CommitSession commitSession = null;
            if (nonViolators.size() > 0 && (commitSession = this.finishPreparingMutations(time)) == null) {
                return null;
            }
            throw new TConstraintViolationException(violations, violators, nonViolators, commitSession);
        }
        return this.finishPreparingMutations(time);
    }

    private synchronized void incrementWritesInProgress(CommitSession cs) {
        this.incrementWritesInProgress();
        cs.incrementCommitsInProgress();
    }

    private synchronized void incrementWritesInProgress() {
        if (this.writesInProgress < 0) {
            throw new IllegalStateException("FATAL: Something really bad went wrong. Attempted to increment a negative number of writes in progress " + this.writesInProgress + "on tablet " + this.extent);
        }
        ++this.writesInProgress;
    }

    private synchronized void decrementWritesInProgress(CommitSession cs) {
        this.decrementWritesInProgress();
        cs.decrementCommitsInProgress();
    }

    private synchronized void decrementWritesInProgress() {
        if (this.writesInProgress <= 0) {
            throw new IllegalStateException("FATAL: Something really bad went wrong. Attempted to decrement the number of writes in progress " + this.writesInProgress + " to < 0 on tablet " + this.extent);
        }
        --this.writesInProgress;
        if (this.writesInProgress == 0) {
            this.notifyAll();
        }
    }

    public synchronized void abortCommit(CommitSession commitSession) {
        if (this.isCloseComplete() || this.getTabletMemory() == null) {
            throw new IllegalStateException("Aborting commit when tablet " + this.extent + " is closed");
        }
        this.decrementWritesInProgress(commitSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(CommitSession commitSession, List<Mutation> mutations) {
        int totalCount = 0;
        long totalBytes = 0L;
        for (Mutation mutation : mutations) {
            totalCount += mutation.size();
            totalBytes += mutation.numBytes();
        }
        this.getTabletMemory().mutate(commitSession, mutations, totalCount);
        Tablet tablet = this;
        synchronized (tablet) {
            if (this.isCloseComplete()) {
                throw new IllegalStateException("Tablet " + this.extent + " closed with outstanding messages to the logger");
            }
            this.decrementWritesInProgress(commitSession);
            this.getTabletMemory().updateMemoryUsageStats();
            this.numEntries += (long)totalCount;
            this.numEntriesInMemory += (long)totalCount;
            this.ingestCount += (long)totalCount;
            this.ingestBytes += totalBytes;
        }
    }

    public void close(boolean saveState) throws IOException {
        this.initiateClose(saveState, false, false);
        this.completeClose(saveState, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initiateClose(boolean saveState, boolean queueMinC, boolean disableWrites) {
        if (!saveState && queueMinC) {
            throw new IllegalArgumentException("Bad state initiating close on " + this.extent + ". State not saved and requested minor compactions queue");
        }
        log.debug("initiateClose(saveState={} queueMinC={} disableWrites={}) {}", new Object[]{saveState, queueMinC, disableWrites, this.getExtent()});
        MinorCompactionTask mct = null;
        Tablet tablet = this;
        synchronized (tablet) {
            if (this.isClosed() || this.isClosing()) {
                String msg = "Tablet " + this.getExtent() + " already " + (Object)((Object)this.closeState);
                throw new IllegalStateException(msg);
            }
            this.closeState = CloseState.CLOSING;
            this.notifyAll();
            if (disableWrites) {
                this.closeState = CloseState.CLOSED;
            }
            while (this.isMajorCompactionRunning()) {
                try {
                    this.wait(50L);
                }
                catch (InterruptedException e) {
                    log.error(e.toString());
                }
            }
            while (this.updatingFlushID) {
                try {
                    this.wait(50L);
                }
                catch (InterruptedException e) {
                    log.error(e.toString());
                }
            }
            if (!saveState || this.getTabletMemory().getMemTable().getNumEntries() == 0L) {
                return;
            }
            this.getTabletMemory().waitForMinC();
            try {
                mct = this.prepareForMinC(this.getFlushID(), MinorCompactionReason.CLOSE);
            }
            catch (KeeperException.NoNodeException e) {
                throw new RuntimeException("Exception on " + this.extent + " during prep for MinC", e);
            }
            if (queueMinC) {
                this.getTabletResources().executeMinorCompaction(mct);
                return;
            }
        }
        mct.run();
    }

    synchronized void completeClose(boolean saveState, boolean completeClose) throws IOException {
        if (!this.isClosing() || this.isCloseComplete() || this.closeCompleting) {
            throw new IllegalStateException("Bad close state " + (Object)((Object)this.closeState) + " on tablet " + this.extent);
        }
        log.debug("completeClose(saveState={} completeClose={}) {}", new Object[]{saveState, completeClose, this.extent});
        this.closeCompleting = true;
        this.closeState = CloseState.CLOSED;
        this.dataSourceDeletions.incrementAndGet();
        for (ScanDataSource activeScan : this.activeScans) {
            activeScan.interrupt();
        }
        while (this.writesInProgress > 0 || this.activeScans.size() > 0) {
            try {
                this.wait(50L);
            }
            catch (InterruptedException e) {
                log.error(e.toString());
            }
        }
        this.getTabletMemory().waitForMinC();
        if (saveState && this.getTabletMemory().getMemTable().getNumEntries() > 0L) {
            try {
                this.prepareForMinC(this.getFlushID(), MinorCompactionReason.CLOSE).run();
            }
            catch (KeeperException.NoNodeException e) {
                throw new RuntimeException("Exception on " + this.extent + " during prep for MinC", e);
            }
        }
        if (saveState) {
            RuntimeException err = null;
            for (int i = 0; i < 5; ++i) {
                try {
                    this.closeConsistencyCheck();
                    err = null;
                    continue;
                }
                catch (RuntimeException t) {
                    err = t;
                    log.error("Consistency check fails, retrying", (Throwable)t);
                    UtilWaitThread.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
                }
            }
            if (err != null) {
                ProblemReports.getInstance((ServerContext)this.context).report(new ProblemReport(this.extent.getTableId(), ProblemType.TABLET_LOAD, this.extent.toString(), (Throwable)err));
                log.error("Tablet closed consistency check has failed for {} giving up and closing", (Object)this.extent);
            }
        }
        try {
            this.getTabletMemory().getMemTable().delete(0L);
        }
        catch (Throwable t) {
            log.error("Failed to delete mem table : " + t.getMessage() + " for tablet " + this.extent, t);
        }
        this.getTabletMemory().close();
        this.getTabletResources().close();
        log.debug("TABLET_HIST {} closed", (Object)this.extent);
        this.tableConfiguration.getNamespaceConfiguration().removeObserver(this.configObserver);
        this.tableConfiguration.removeObserver(this.configObserver);
        if (completeClose) {
            this.closeState = CloseState.COMPLETE;
        }
    }

    private void closeConsistencyCheck() {
        long num = this.tabletMemory.getMemTable().getNumEntries();
        if (num != 0L) {
            String msg = "Closed tablet " + this.extent + " has " + num + " entries in memory";
            log.error(msg);
            throw new RuntimeException(msg);
        }
        if (this.tabletMemory.memoryReservedForMinC()) {
            String msg = "Closed tablet " + this.extent + " has minor compacting memory";
            log.error(msg);
            throw new RuntimeException(msg);
        }
        try {
            Pair fileLog = MetadataTableUtil.getFileAndLogEntries((ServerContext)this.context, (KeyExtent)this.extent);
            if (((List)fileLog.getFirst()).size() != 0) {
                String msg = "Closed tablet " + this.extent + " has walog entries in " + MetadataTable.NAME + " " + fileLog.getFirst();
                log.error(msg);
                throw new RuntimeException(msg);
            }
            if (this.extent.isRootTablet()) {
                if (!((SortedMap)fileLog.getSecond()).keySet().equals(this.getDatafileManager().getDatafileSizes().keySet())) {
                    String msg = "Data file in " + RootTable.NAME + " differ from in memory data " + this.extent + "  " + ((SortedMap)fileLog.getSecond()).keySet() + "  " + this.getDatafileManager().getDatafileSizes().keySet();
                    log.error(msg);
                    throw new RuntimeException(msg);
                }
            } else if (!((SortedMap)fileLog.getSecond()).equals(this.getDatafileManager().getDatafileSizes())) {
                String msg = "Data file in " + MetadataTable.NAME + " differ from in memory data " + this.extent + "  " + fileLog.getSecond() + "  " + this.getDatafileManager().getDatafileSizes();
                log.error(msg);
                throw new RuntimeException(msg);
            }
        }
        catch (Exception e) {
            String msg = "Failed to do close consistency check for tablet " + this.extent;
            log.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        if (this.otherLogs.size() != 0 || this.currentLogs.size() != 0 || this.referencedLogs.size() != 0) {
            String msg = "Closed tablet " + this.extent + " has walog entries in memory currentLogs = " + this.currentLogs + "  otherLogs = " + this.otherLogs + " refererncedLogs = " + this.referencedLogs;
            log.error(msg);
            throw new RuntimeException(msg);
        }
    }

    public Path getLocation() {
        return this.location;
    }

    public synchronized void initiateMajorCompaction(MajorCompactionReason reason) {
        if (this.isClosing() || this.isClosed() || !this.needsMajorCompaction(reason) || this.isMajorCompactionRunning() || this.majorCompactionQueued.contains((Object)reason)) {
            return;
        }
        this.majorCompactionQueued.add(reason);
        try {
            this.getTabletResources().executeMajorCompaction(this.getExtent(), new CompactionRunner(this, reason));
        }
        catch (RuntimeException t) {
            log.debug("removing {} because we encountered an exception enqueing the CompactionRunner", (Object)reason, (Object)t);
            this.majorCompactionQueued.remove((Object)reason);
            throw t;
        }
    }

    public boolean needsMajorCompaction(MajorCompactionReason reason) {
        if (this.isMajorCompactionRunning()) {
            return false;
        }
        if (reason == MajorCompactionReason.CHOP || reason == MajorCompactionReason.USER) {
            return true;
        }
        return this.getTabletResources().needsMajorCompaction(this.getDatafileManager().getDatafileSizes(), reason);
    }

    public long estimateTabletSize() {
        long size = 0L;
        for (DataFileValue sz : this.getDatafileManager().getDatafileSizes().values()) {
            size += sz.getSize();
        }
        return size;
    }

    private SplitRowSpec findSplitRow(Collection<FileRef> files) {
        long splitThreshold = this.tableConfiguration.getAsBytes(Property.TABLE_SPLIT_THRESHOLD);
        long maxEndRow = this.tableConfiguration.getAsBytes(Property.TABLE_MAX_END_ROW_SIZE);
        if (this.extent.isRootTablet() || this.isFindSplitsSuppressed() || this.estimateTabletSize() <= splitThreshold) {
            return null;
        }
        SortedMap keys = null;
        try {
            keys = FileUtil.findMidPoint((ServerContext)this.context, (String)this.tabletDirectory, (Text)this.extent.getPrevEndRow(), (Text)this.extent.getEndRow(), (Collection)FileUtil.toPathStrings(files), (double)0.25);
        }
        catch (IOException e) {
            log.error("Failed to find midpoint {}", (Object)e.getMessage());
            return null;
        }
        if (keys.isEmpty()) {
            log.info("Cannot split tablet " + this.extent + ", files contain no data for tablet.");
            this.suppressFindSplits();
            return null;
        }
        try {
            Text lastRow;
            if (this.extent.getEndRow() == null) {
                Key lastKey = (Key)FileUtil.findLastKey((ServerContext)this.context, files);
                lastRow = lastKey.getRow();
            } else {
                lastRow = this.extent.getEndRow();
            }
            Key mid = (Key)keys.get(0.5);
            if (mid == null) {
                throw new IllegalStateException("Could not determine midpoint for files on " + this.extent);
            }
            if (mid.compareRow(lastRow) == 0) {
                if ((Double)keys.firstKey() < 0.5) {
                    Key candidate = (Key)keys.get(keys.firstKey());
                    if ((long)candidate.getLength() > maxEndRow) {
                        log.warn("Cannot split tablet {}, selected split point too long.  Length :  {}", (Object)this.extent, (Object)candidate.getLength());
                        this.suppressFindSplits();
                        return null;
                    }
                    if (candidate.compareRow(lastRow) != 0) {
                        if (log.isTraceEnabled()) {
                            log.trace(String.format("Splitting at %6.2f instead of .5, row at .5 is same as end row%n", keys.firstKey()));
                        }
                        return new SplitRowSpec((Double)keys.firstKey(), candidate.getRow());
                    }
                }
                log.warn("Cannot split tablet {} it contains a big row : {}", (Object)this.extent, (Object)lastRow);
                this.suppressFindSplits();
                return null;
            }
            Text text = mid.getRow();
            SortedMap firstHalf = keys.headMap(0.5);
            if (firstHalf.size() > 0) {
                Text beforeMid = ((Key)firstHalf.get(firstHalf.lastKey())).getRow();
                Text shorter = new Text();
                int trunc = Tablet.longestCommonLength(text, beforeMid);
                shorter.set(text.getBytes(), 0, Math.min(text.getLength(), trunc + 1));
                text = shorter;
            }
            if ((long)text.getLength() > maxEndRow) {
                log.warn("Cannot split tablet {}, selected split point too long.  Length :  {}", (Object)this.extent, (Object)text.getLength());
                this.suppressFindSplits();
                return null;
            }
            return new SplitRowSpec(0.5, text);
        }
        catch (IOException e) {
            log.error("Failed to find lastkey {}", (Object)e.getMessage());
            return null;
        }
    }

    private boolean isFindSplitsSuppressed() {
        if (this.supressFindSplits) {
            if (this.timeOfLastMinCWhenFindSplitsWasSupressed != this.lastMinorCompactionFinishTime || this.timeOfLastImportWhenFindSplitsWasSupressed != this.lastMapFileImportTime) {
                this.supressFindSplits = false;
            } else {
                return true;
            }
        }
        return false;
    }

    private void suppressFindSplits() {
        this.supressFindSplits = true;
        this.timeOfLastMinCWhenFindSplitsWasSupressed = this.lastMinorCompactionFinishTime;
        this.timeOfLastImportWhenFindSplitsWasSupressed = this.lastMapFileImportTime;
    }

    private static int longestCommonLength(Text text, Text beforeMid) {
        int common;
        for (common = 0; common < text.getLength() && common < beforeMid.getLength() && text.getBytes()[common] == beforeMid.getBytes()[common]; ++common) {
        }
        return common;
    }

    private Map<FileRef, Pair<Key, Key>> getFirstAndLastKeys(SortedMap<FileRef, DataFileValue> allFiles) throws IOException {
        HashMap<FileRef, Pair<Key, Key>> result = new HashMap<FileRef, Pair<Key, Key>>();
        FileOperations fileFactory = FileOperations.getInstance();
        VolumeManager fs = this.getTabletServer().getFileSystem();
        for (Map.Entry<FileRef, DataFileValue> entry : allFiles.entrySet()) {
            FileRef file = entry.getKey();
            FileSystem ns = fs.getVolumeByPath(file.path()).getFileSystem();
            FileSKVIterator openReader = fileFactory.newReaderBuilder().forFile(file.path().toString(), ns, ns.getConf(), this.context.getCryptoService()).withTableConfiguration((AccumuloConfiguration)this.getTableConfiguration()).seekToBeginning().build();
            try {
                Key first = openReader.getFirstKey();
                Key last = openReader.getLastKey();
                result.put(file, (Pair<Key, Key>)new Pair((Object)first, (Object)last));
            }
            finally {
                if (openReader == null) continue;
                openReader.close();
            }
        }
        return result;
    }

    List<FileRef> findChopFiles(KeyExtent extent, Map<FileRef, Pair<Key, Key>> firstAndLastKeys, Collection<FileRef> allFiles) {
        ArrayList<FileRef> result = new ArrayList<FileRef>();
        if (firstAndLastKeys == null) {
            result.addAll(allFiles);
            return result;
        }
        for (FileRef file : allFiles) {
            Pair<Key, Key> pair = firstAndLastKeys.get(file);
            if (pair == null) {
                result.add(file);
                continue;
            }
            Key first = (Key)pair.getFirst();
            Key last = (Key)pair.getSecond();
            if (!(first == null && last == null || first != null && !extent.contains((BinaryComparable)first.getRow())) && (last == null || extent.contains((BinaryComparable)last.getRow()))) continue;
            result.add(file);
        }
        return result;
    }

    public synchronized boolean needsSplit() {
        if (this.isClosing() || this.isClosed()) {
            return false;
        }
        return this.findSplitRow(this.getDatafileManager().getFiles()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private CompactionStats _majorCompact(MajorCompactionReason reason) throws IOException, Compactor.CompactionCanceledException {
        compactionId = null;
        strategy = null;
        firstAndLastKeys = null;
        if (reason == MajorCompactionReason.USER) {
            try {
                compactionId = this.getCompactionID();
                strategy = this.createCompactionStrategy(((UserCompactionConfig)compactionId.getSecond()).getCompactionStrategy());
            }
            catch (KeeperException.NoNodeException e) {
                throw new RuntimeException("Exception on " + this.extent + " during MajC", e);
            }
        } else if (reason == MajorCompactionReason.NORMAL || reason == MajorCompactionReason.IDLE) {
            strategy = (CompactionStrategy)Property.createTableInstanceFromPropertyName((AccumuloConfiguration)this.tableConfiguration, (Property)Property.TABLE_COMPACTION_STRATEGY, CompactionStrategy.class, (Object)new DefaultCompactionStrategy());
            strategy.init(Property.getCompactionStrategyOptions((AccumuloConfiguration)this.tableConfiguration));
        } else if (reason == MajorCompactionReason.CHOP) {
            firstAndLastKeys = this.getFirstAndLastKeys(this.getDatafileManager().getDatafileSizes());
        } else {
            throw new IllegalArgumentException("Unknown compaction reason " + (Object)reason + " during MajC on " + this.extent);
        }
        if (strategy != null) {
            sc = this.tabletResources.getTabletServerResourceManager().getSummaryCache();
            ic = this.tabletResources.getTabletServerResourceManager().getIndexCache();
            fileLenCache = this.tabletResources.getTabletServerResourceManager().getFileLenCache();
            request = new MajorCompactionRequest(this.extent, reason, this.getTabletServer().getFileSystem(), (AccumuloConfiguration)this.tableConfiguration, sc, ic, fileLenCache, this.context);
            request.setFiles(this.getDatafileManager().getDatafileSizes());
            strategy.gatherInformation(request);
        }
        filesToCompact = null;
        maxFilesToCompact = this.tableConfiguration.getCount(Property.TSERV_MAJC_THREAD_MAXOPEN);
        majCStats = new CompactionStats();
        plan = null;
        propogateDeletes = false;
        updateCompactionID = false;
        var17_13 = this;
        synchronized (var17_13) {
            t1 = System.currentTimeMillis();
            this.majorCompactionState = CompactionState.WAITING_TO_START;
            this.getTabletMemory().waitForMinC();
            t2 = System.currentTimeMillis();
            this.majorCompactionState = CompactionState.IN_PROGRESS;
            this.notifyAll();
            fs /* !! */  = this.getTabletServer().getFileSystem();
            if (this.extent.isRootTablet()) {
                RootFiles.cleanupReplacement(fs /* !! */ , fs /* !! */ .listStatus(this.location), false);
            }
            allFiles = this.getDatafileManager().getDatafileSizes();
            inputFiles = new ArrayList<FileRef>();
            if (reason == MajorCompactionReason.CHOP) {
                inputFiles.addAll(this.findChopFiles(this.extent, firstAndLastKeys, allFiles.keySet()));
            } else {
                request = new MajorCompactionRequest(this.extent, reason, (AccumuloConfiguration)this.tableConfiguration, this.context);
                request.setFiles((Map<FileRef, DataFileValue>)allFiles);
                plan = strategy.getCompactionPlan(request);
                if (plan != null) {
                    plan.validate(allFiles.keySet());
                    inputFiles.addAll(plan.inputFiles);
                }
            }
            if (!inputFiles.isEmpty()) ** GOTO lbl69
            if (reason == MajorCompactionReason.USER) {
                if (((UserCompactionConfig)compactionId.getSecond()).getIterators().isEmpty()) {
                    Tablet.log.debug("No-op major compaction by USER on 0 input files because no iterators present.");
                    this.lastCompactID = (Long)compactionId.getFirst();
                    updateCompactionID = true;
                } else {
                    Tablet.log.debug("Major compaction by USER on 0 input files with iterators.");
                    filesToCompact = new HashMap<K, V>();
                }
            } else {
                return majCStats;
lbl69:
                // 1 sources

                droppedFiles = new HashSet<FileRef>();
                droppedFiles.addAll(inputFiles);
                if (plan != null) {
                    droppedFiles.addAll(plan.deleteFiles);
                }
                propogateDeletes = droppedFiles.equals(allFiles.keySet()) == false;
                Tablet.log.debug("Major compaction plan: {} propagate deletes : {}", (Object)plan, (Object)propogateDeletes);
                filesToCompact = new HashMap<FileRef, DataFileValue>((Map<FileRef, DataFileValue>)allFiles);
                filesToCompact.keySet().retainAll(inputFiles);
                this.getDatafileManager().reserveMajorCompactingFiles(filesToCompact.keySet());
            }
            t3 = System.currentTimeMillis();
        }
        try {
            Tablet.log.debug(String.format("MajC initiate lock %.2f secs, wait %.2f secs", new Object[]{(double)(t3 - t2) / 1000.0, (double)(t2 - t1) / 1000.0}));
            if (updateCompactionID) {
                MetadataTableUtil.updateTabletCompactID((KeyExtent)this.extent, (long)((Long)compactionId.getFirst()), (ServerContext)this.context, (ZooLock)this.getTabletServer().getLock());
                var17_13 = majCStats;
                return var17_13;
            }
            if (!propogateDeletes && compactionId == null) {
                try {
                    compactionId = this.getCompactionID();
                    if (((UserCompactionConfig)compactionId.getSecond()).getCompactionStrategy() != null) {
                        compactionId = null;
                    }
                }
                catch (KeeperException.NoNodeException e) {
                    throw new RuntimeException("Exception on " + this.extent + " during MajC", e);
                }
            }
            compactionIterators = new ArrayList<E>();
            if (compactionId != null && reason == MajorCompactionReason.USER) {
                if (this.getCompactionCancelID() >= (Long)compactionId.getFirst()) {
                    fs /* !! */  = majCStats;
                    return fs /* !! */ ;
                }
                compactionIterators = ((UserCompactionConfig)compactionId.getSecond()).getIterators();
                fs /* !! */  = this;
                synchronized (fs /* !! */ ) {
                    block64: {
                        if (this.lastCompactID < (Long)compactionId.getFirst()) break block64;
                        allFiles = majCStats;
                        return allFiles;
                    }
                    ** try [egrp 11[TRYBLOCK] [12 : 1100->1106)] { 
                    {
                    }
                }
            }
lbl116:
            // 3 sources

            do {
                numToCompact = maxFilesToCompact;
                if (filesToCompact.size() > maxFilesToCompact && filesToCompact.size() < 2 * maxFilesToCompact) {
                    numToCompact = filesToCompact.size() - maxFilesToCompact + 1;
                }
                smallestFiles = this.removeSmallest(filesToCompact, numToCompact);
                fileName = this.getNextMapFilename(filesToCompact.size() == 0 && propogateDeletes == false ? "A" : "C");
                compactTmpName = new FileRef(fileName.path() + "_tmp");
                tableConf = this.createTableConfiguration(this.tableConfiguration, plan);
                span = Trace.startSpan((String)"compactFiles");
                try {
                    cenv = new Compactor.CompactionEnv(){

                        @Override
                        public boolean isCompactionEnabled() {
                            return !Tablet.this.isClosing();
                        }

                        @Override
                        public IteratorUtil.IteratorScope getIteratorScope() {
                            return IteratorUtil.IteratorScope.majc;
                        }

                        @Override
                        public RateLimiter getReadLimiter() {
                            return Tablet.this.getTabletServer().getMajorCompactionReadLimiter();
                        }

                        @Override
                        public RateLimiter getWriteLimiter() {
                            return Tablet.this.getTabletServer().getMajorCompactionWriteLimiter();
                        }
                    };
                    copy = new HashMap<FileRef, DataFileValue>(this.getDatafileManager().getDatafileSizes());
                    if (!copy.keySet().containsAll(smallestFiles)) {
                        throw new IllegalStateException("Cannot find data file values for " + smallestFiles + " on " + this.extent + " during MajC");
                    }
                    copy.keySet().retainAll(smallestFiles);
                    Tablet.log.debug("Starting MajC {} ({}) {} --> {} {}", new Object[]{this.extent, reason, copy.keySet(), compactTmpName, compactionIterators});
                    lastBatch = filesToCompact.isEmpty();
                    compactor = new Compactor(this.context, this, copy, null, compactTmpName, lastBatch != false ? propogateDeletes : true, cenv, compactionIterators, reason.ordinal(), tableConf);
                    mcs = compactor.call();
                    if (span.getSpan() != null) {
                        span.getSpan().addKVAnnotation("files", "" + smallestFiles.size());
                        span.getSpan().addKVAnnotation("read", "" + mcs.getEntriesRead());
                        span.getSpan().addKVAnnotation("written", "" + mcs.getEntriesWritten());
                    }
                    majCStats.add(mcs);
                    if (lastBatch && plan != null && plan.deleteFiles != null) {
                        smallestFiles.addAll(plan.deleteFiles);
                    }
                    this.getDatafileManager().bringMajorCompactionOnline(smallestFiles, compactTmpName, fileName, filesToCompact.size() == 0 && compactionId != null ? (Long)compactionId.getFirst() : null, new DataFileValue(mcs.getFileSize(), mcs.getEntriesWritten()));
                    if (filesToCompact.size() <= 0 || mcs.getEntriesWritten() <= 0L) continue;
                    filesToCompact.put(fileName, new DataFileValue(mcs.getFileSize(), mcs.getEntriesWritten()));
                }
                finally {
                    if (span != null) {
                        span.close();
                    }
                }
            } while (filesToCompact.size() > 0);
            var18_19 = majCStats;
            return var18_19;
        }
        finally {
            fs /* !! */  = this;
            synchronized (fs /* !! */ ) {
                this.getDatafileManager().clearMajorCompactingFile();
            }
        }
    }

    protected AccumuloConfiguration createTableConfiguration(TableConfiguration base, CompactionPlan plan) {
        if (plan == null || plan.writeParameters == null) {
            return base;
        }
        WriteParameters p = plan.writeParameters;
        ConfigurationCopy result = new ConfigurationCopy((Iterable)base);
        if (p.getHdfsBlockSize() > 0L) {
            result.set(Property.TABLE_FILE_BLOCK_SIZE, "" + p.getHdfsBlockSize());
        }
        if (p.getBlockSize() > 0L) {
            result.set(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE, "" + p.getBlockSize());
        }
        if (p.getIndexBlockSize() > 0L) {
            result.set(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE_INDEX, "" + p.getIndexBlockSize());
        }
        if (p.getCompressType() != null) {
            result.set(Property.TABLE_FILE_COMPRESSION_TYPE, p.getCompressType());
        }
        if (p.getReplication() != 0) {
            result.set(Property.TABLE_FILE_REPLICATION, "" + p.getReplication());
        }
        return result;
    }

    private Set<FileRef> removeSmallest(Map<FileRef, DataFileValue> filesToCompact, int maxFilesToCompact) {
        if (filesToCompact.size() <= maxFilesToCompact) {
            HashSet<FileRef> smallestFiles = new HashSet<FileRef>(filesToCompact.keySet());
            filesToCompact.clear();
            return smallestFiles;
        }
        PriorityQueue<Pair> fileHeap = new PriorityQueue<Pair>(filesToCompact.size(), (o1, o2) -> {
            if (((Long)o1.getSecond()).equals(o2.getSecond())) {
                return ((FileRef)o1.getFirst()).compareTo((FileRef)o2.getFirst());
            }
            if ((Long)o1.getSecond() < (Long)o2.getSecond()) {
                return -1;
            }
            return 1;
        });
        for (Map.Entry<FileRef, DataFileValue> entry : filesToCompact.entrySet()) {
            fileHeap.add(new Pair((Object)entry.getKey(), (Object)entry.getValue().getSize()));
        }
        HashSet<FileRef> smallestFiles = new HashSet<FileRef>();
        while (smallestFiles.size() < maxFilesToCompact && fileHeap.size() > 0) {
            Pair pair = (Pair)fileHeap.remove();
            filesToCompact.remove(pair.getFirst());
            smallestFiles.add((FileRef)pair.getFirst());
        }
        return smallestFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompactionStats majorCompact(MajorCompactionReason reason, long queued) {
        CompactionStats majCStats = null;
        boolean success = false;
        long start = System.currentTimeMillis();
        this.timer.incrementStatusMajor();
        Tablet tablet = this;
        synchronized (tablet) {
            this.majorCompactionQueued.remove((Object)reason);
            if (this.isClosing() || this.isClosed() || !this.needsMajorCompaction(reason) || this.isMajorCompactionRunning() || this.needsSplit()) {
                return null;
            }
            this.majorCompactionState = CompactionState.WAITING_TO_START;
        }
        double tracePercent = this.tabletServer.getConfiguration().getFraction(Property.TSERV_MAJC_TRACE_PERCENT);
        ProbabilitySampler sampler = TraceUtil.probabilitySampler((double)tracePercent);
        try (Object span = Trace.startSpan((String)"majorCompaction", (Sampler)sampler);){
            majCStats = this._majorCompact(reason);
            if (reason == MajorCompactionReason.CHOP) {
                MetadataTableUtil.chopped((ServerContext)this.getTabletServer().getContext(), (KeyExtent)this.getExtent(), (ZooLock)this.getTabletServer().getLock());
                this.getTabletServer().enqueueMasterMessage(new TabletStatusMessage(TabletLoadState.CHOPPED, this.extent));
            }
            if (span.getSpan() != null) {
                span.getSpan().addKVAnnotation("extent", "" + this.getExtent());
                if (majCStats != null) {
                    span.getSpan().addKVAnnotation("read", "" + majCStats.getEntriesRead());
                    span.getSpan().addKVAnnotation("written", "" + majCStats.getEntriesWritten());
                }
            }
            success = true;
        }
        catch (Compactor.CompactionCanceledException cce) {
            log.debug("Major compaction canceled, extent = {}", (Object)this.getExtent());
        }
        catch (IOException ioe) {
            log.error("MajC Failed, extent = " + this.getExtent(), (Throwable)ioe);
        }
        catch (RuntimeException e) {
            log.error("MajC Unexpected exception, extent = " + this.getExtent(), (Throwable)e);
        }
        finally {
            Tablet cce = this;
            synchronized (cce) {
                this.majorCompactionState = null;
                this.notifyAll();
            }
        }
        long count = 0L;
        if (majCStats != null) {
            count = majCStats.getEntriesRead();
        }
        this.timer.updateTime(TabletStatsKeeper.Operation.MAJOR, queued, start, count, !success);
        return majCStats;
    }

    public KeyExtent getExtent() {
        return this.extent;
    }

    synchronized void computeNumEntries() {
        Collection<DataFileValue> vals = this.getDatafileManager().getDatafileSizes().values();
        long numEntries = 0L;
        for (DataFileValue tableValue : vals) {
            numEntries += tableValue.getNumEntries();
        }
        this.numEntriesInMemory = this.getTabletMemory().getNumEntries();
        this.numEntries = numEntries += this.getTabletMemory().getNumEntries();
    }

    public long getNumEntries() {
        return this.numEntries;
    }

    public long getNumEntriesInMemory() {
        return this.numEntriesInMemory;
    }

    public boolean isClosing() {
        return this.closeState == CloseState.CLOSING;
    }

    public boolean isClosed() {
        CloseState localCS = this.closeState;
        return localCS == CloseState.CLOSED || localCS == CloseState.COMPLETE;
    }

    public boolean isCloseComplete() {
        return this.closeState == CloseState.COMPLETE;
    }

    public boolean isMajorCompactionRunning() {
        return this.majorCompactionState != null;
    }

    public boolean isMinorCompactionQueued() {
        return this.minorCompactionState == CompactionState.WAITING_TO_START;
    }

    public boolean isMinorCompactionRunning() {
        return this.minorCompactionState == CompactionState.IN_PROGRESS;
    }

    public boolean isMajorCompactionQueued() {
        return this.majorCompactionQueued.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeMap<KeyExtent, TabletData> split(byte[] sp) throws IOException {
        if (sp != null && this.extent.getEndRow() != null && this.extent.getEndRow().equals((Object)new Text(sp))) {
            throw new IllegalArgumentException("Attempting to split on EndRow " + this.extent.getEndRow() + " for " + this.extent);
        }
        if (sp != null && (long)sp.length > this.tableConfiguration.getAsBytes(Property.TABLE_MAX_END_ROW_SIZE)) {
            String msg = "Cannot split tablet " + this.extent + ", selected split point too long.  Length :  " + sp.length;
            log.warn(msg);
            throw new IOException(msg);
        }
        if (this.extent.isRootTablet()) {
            String msg = "Cannot split root tablet";
            log.warn(msg);
            throw new RuntimeException(msg);
        }
        try {
            this.initiateClose(true, false, false);
        }
        catch (IllegalStateException ise) {
            log.debug("File {} not splitting : {}", (Object)this.extent, (Object)ise.getMessage());
            return null;
        }
        Map firstAndLastRows = FileUtil.tryToGetFirstAndLastRows((ServerContext)this.context, this.getDatafileManager().getFiles());
        Tablet tablet = this;
        synchronized (tablet) {
            SplitRowSpec splitPoint;
            TreeMap<KeyExtent, TabletData> newTablets = new TreeMap<KeyExtent, TabletData>();
            long t1 = System.currentTimeMillis();
            if (sp == null) {
                splitPoint = this.findSplitRow(this.getDatafileManager().getFiles());
            } else {
                Text tsp = new Text(sp);
                splitPoint = new SplitRowSpec(FileUtil.estimatePercentageLTE((ServerContext)this.context, (String)this.tabletDirectory, (Text)this.extent.getPrevEndRow(), (Text)this.extent.getEndRow(), (Collection)FileUtil.toPathStrings(this.getDatafileManager().getFiles()), (Text)tsp), tsp);
            }
            if (splitPoint == null || splitPoint.row == null) {
                log.info("had to abort split because splitRow was null");
                this.closeState = CloseState.OPEN;
                return null;
            }
            this.closeState = CloseState.CLOSING;
            this.completeClose(true, false);
            Text midRow = splitPoint.row;
            double splitRatio = splitPoint.splitRatio;
            KeyExtent low = new KeyExtent(this.extent.getTableId(), midRow, this.extent.getPrevEndRow());
            KeyExtent high = new KeyExtent(this.extent.getTableId(), this.extent.getEndRow(), midRow);
            String lowDirectory = Tablet.createTabletDirectory(this.context, this.getTabletServer().getFileSystem(), this.extent.getTableId(), midRow);
            TreeMap<FileRef, DataFileValue> lowDatafileSizes = new TreeMap<FileRef, DataFileValue>();
            TreeMap<FileRef, DataFileValue> highDatafileSizes = new TreeMap<FileRef, DataFileValue>();
            ArrayList highDatafilesToRemove = new ArrayList();
            MetadataTableUtil.splitDatafiles((Text)midRow, (double)splitRatio, (Map)firstAndLastRows, this.getDatafileManager().getDatafileSizes(), lowDatafileSizes, highDatafileSizes, highDatafilesToRemove);
            log.debug("Files for low split {} {}", (Object)low, lowDatafileSizes.keySet());
            log.debug("Files for high split {} {}", (Object)high, highDatafileSizes.keySet());
            String time = this.tabletTime.getMetadataValue();
            MetadataTableUtil.splitTablet((KeyExtent)high, (Text)this.extent.getPrevEndRow(), (double)splitRatio, (ServerContext)this.getTabletServer().getContext(), (ZooLock)this.getTabletServer().getLock());
            MasterMetadataUtil.addNewTablet((ServerContext)this.getTabletServer().getContext(), (KeyExtent)low, (String)lowDirectory, (TServerInstance)this.getTabletServer().getTabletSession(), lowDatafileSizes, this.getBulkIngestedFiles(), (String)time, (long)this.lastFlushID, (long)this.lastCompactID, (ZooLock)this.getTabletServer().getLock());
            MetadataTableUtil.finishSplit((KeyExtent)high, highDatafileSizes, highDatafilesToRemove, (ServerContext)this.getTabletServer().getContext(), (ZooLock)this.getTabletServer().getLock());
            log.debug("TABLET_HIST {} split {} {}", new Object[]{this.extent, low, high});
            newTablets.put(high, new TabletData(this.tabletDirectory, highDatafileSizes, time, this.lastFlushID, this.lastCompactID, this.lastLocation, this.getBulkIngestedFiles()));
            newTablets.put(low, new TabletData(lowDirectory, lowDatafileSizes, time, this.lastFlushID, this.lastCompactID, this.lastLocation, this.getBulkIngestedFiles()));
            long t2 = System.currentTimeMillis();
            log.debug(String.format("offline split time : %6.2f secs", (double)(t2 - t1) / 1000.0));
            this.closeState = CloseState.COMPLETE;
            return newTablets;
        }
    }

    public SortedMap<FileRef, DataFileValue> getDatafiles() {
        return this.getDatafileManager().getDatafileSizes();
    }

    public double queryRate() {
        return this.queryRate.rate();
    }

    public double queryByteRate() {
        return this.queryByteRate.rate();
    }

    public double ingestRate() {
        return this.ingestRate.rate();
    }

    public double ingestByteRate() {
        return this.ingestByteRate.rate();
    }

    public double scanRate() {
        return this.scannedRate.rate();
    }

    public long totalQueries() {
        return this.queryCount;
    }

    public long totalIngest() {
        return this.ingestCount;
    }

    public void updateRates(long now) {
        this.queryRate.update(now, this.queryCount);
        this.queryByteRate.update(now, this.queryBytes);
        this.ingestRate.update(now, this.ingestCount);
        this.ingestByteRate.update(now, this.ingestBytes);
        this.scannedRate.update(now, this.scannedCount.get());
    }

    public long getSplitCreationTime() {
        return this.splitCreationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importMapFiles(long tid, Map<FileRef, MapFileInfo> fileMap, boolean setTime) throws IOException {
        HashMap<FileRef, DataFileValue> entries = new HashMap<FileRef, DataFileValue>(fileMap.size());
        ArrayList<String> files = new ArrayList<String>();
        for (Map.Entry<FileRef, MapFileInfo> entry : fileMap.entrySet()) {
            entries.put(entry.getKey(), new DataFileValue(entry.getValue().estimatedSize, 0L));
            files.add(entry.getKey().path().toString());
        }
        long now = System.currentTimeMillis();
        Tablet tablet = this;
        synchronized (tablet) {
            if (this.isClosed()) {
                throw new IOException("tablet " + this.extent + " is closed");
            }
            long lockWait = System.currentTimeMillis() - now;
            if (lockWait > this.getTabletServer().getConfiguration().getTimeInMillis(Property.GENERAL_RPC_TIMEOUT)) {
                throw new IOException("Timeout waiting " + (double)lockWait / 1000.0 + " seconds to get tablet lock for " + this.extent);
            }
            List alreadyImported = (List)this.bulkImported.getIfPresent((Object)tid);
            if (alreadyImported != null) {
                for (FileRef entry : alreadyImported) {
                    if (fileMap.remove(entry) == null) continue;
                    log.trace("Ignoring import of bulk file already imported: {}", (Object)entry);
                }
            }
            fileMap.keySet().removeIf(file -> {
                if (this.bulkImporting.contains(file)) {
                    log.info("Ignoring import of bulk file currently importing: " + file);
                    return true;
                }
                return false;
            });
            if (fileMap.isEmpty()) {
                return;
            }
            this.incrementWritesInProgress();
            this.bulkImporting.addAll(fileMap.keySet());
        }
        try {
            this.tabletServer.updateBulkImportState(files, BulkImportState.LOADING);
            this.getDatafileManager().importMapFiles(tid, entries, setTime);
            this.lastMapFileImportTime = System.currentTimeMillis();
            if (this.needsSplit()) {
                this.getTabletServer().executeSplit(this);
            } else {
                this.initiateMajorCompaction(MajorCompactionReason.NORMAL);
            }
        }
        finally {
            tablet = this;
            synchronized (tablet) {
                this.decrementWritesInProgress();
                if (!this.bulkImporting.removeAll(fileMap.keySet())) {
                    throw new AssertionError((Object)"Likely bug in code, always expect to remove something.  Please open an Accumulo issue.");
                }
                try {
                    ((List)this.bulkImported.get((Object)tid, ArrayList::new)).addAll(fileMap.keySet());
                }
                catch (Exception ex) {
                    log.info(ex.toString(), (Throwable)ex);
                }
                this.tabletServer.removeBulkImportState(files);
            }
        }
    }

    private synchronized void rebuildReferencedLogs() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(this.currentLogs);
        builder.addAll(this.otherLogs);
        this.referencedLogs = builder.build();
    }

    public void removeInUseLogs(Set<DfsLogger> candidates) {
        candidates.removeAll(this.referencedLogs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIfMinorCompactionNeededForLogs(List<DfsLogger> closedLogs) {
        int maxLogs = this.tableConfiguration.getCount(this.tableConfiguration.resolve(Property.TSERV_WALOG_MAX_REFERENCED, Property.TABLE_MINC_LOGS_MAX));
        String reason = null;
        Tablet tablet = this;
        synchronized (tablet) {
            if (this.currentLogs.size() >= maxLogs) {
                reason = "referenced " + this.currentLogs.size() + " write ahead logs";
            } else if (maxLogs < closedLogs.size()) {
                List<DfsLogger> oldClosed = closedLogs.subList(0, closedLogs.size() - maxLogs);
                for (DfsLogger closedLog : oldClosed) {
                    if (!this.currentLogs.contains(closedLog)) continue;
                    reason = "referenced at least one old write ahead log " + closedLog.getFileName();
                    break;
                }
            }
        }
        if (reason != null) {
            this.initiateMinorCompaction(MinorCompactionReason.SYSTEM);
            log.debug("Initiating minor compaction for {} because {}", (Object)this.getExtent(), (Object)reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> beginClearingUnusedLogs() {
        HashSet<String> unusedLogs = new HashSet<String>();
        ArrayList<String> otherLogsCopy = new ArrayList<String>();
        ArrayList<String> currentLogsCopy = new ArrayList<String>();
        this.logLock.lock();
        Iterator iterator = this;
        synchronized (iterator) {
            if (this.removingLogs) {
                throw new IllegalStateException("Attempted to clear logs when removal of logs in progress on " + this.extent);
            }
            for (DfsLogger logger : this.otherLogs) {
                otherLogsCopy.add(logger.toString());
                unusedLogs.add(logger.getMeta());
            }
            for (DfsLogger logger : this.currentLogs) {
                currentLogsCopy.add(logger.toString());
                unusedLogs.remove(logger.getMeta());
            }
            this.otherLogs = Collections.emptySet();
            if (unusedLogs.size() > 0) {
                this.removingLogs = true;
            }
        }
        for (String logger : otherLogsCopy) {
            log.debug("Logs for memory compacted: {} {}", (Object)this.getExtent(), (Object)logger);
        }
        for (String logger : currentLogsCopy) {
            log.debug("Logs for current memory: {} {}", (Object)this.getExtent(), (Object)logger);
        }
        for (String logger : unusedLogs) {
            log.debug("Logs to be destroyed: {} {}", (Object)this.getExtent(), (Object)logger);
        }
        return unusedLogs;
    }

    synchronized void finishClearingUnusedLogs() {
        this.removingLogs = false;
        this.rebuildReferencedLogs();
        this.logLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"UL_UNRELEASED_LOCK"}, justification="lock is released by caller calling finishedUpdatingLogsUsed method")
    public boolean beginUpdatingLogsUsed(InMemoryMap memTable, DfsLogger more, boolean mincFinish) {
        boolean bl;
        boolean bl2;
        boolean releaseLock = true;
        this.logLock.lock();
        try {
            Tablet tablet = this;
            synchronized (tablet) {
                boolean contained;
                boolean added;
                boolean addToOther;
                if (this.isCloseComplete()) {
                    throw new IllegalStateException("Can not update logs of closed tablet " + this.extent);
                }
                if (memTable == this.getTabletMemory().getMinCMemTable()) {
                    addToOther = true;
                } else {
                    if (memTable != this.getTabletMemory().getMemTable()) {
                        throw new IllegalArgumentException("Passed in memtable that is not in use for " + this.extent);
                    }
                    addToOther = false;
                }
                if (mincFinish) {
                    if (addToOther) {
                        throw new IllegalStateException("Adding to other logs for mincFinish on " + this.extent);
                    }
                    if (this.otherLogs.size() != 0) {
                        throw new IllegalStateException("Expect other logs to be 0 when minC finish, but its " + this.otherLogs + " for " + this.extent);
                    }
                    if (this.currentLogs.size() == 0) {
                        boolean bl3 = !releaseLock;
                        // MONITOREXIT @DISABLED, blocks:[0, 4, 10, 13] lbl21 : MonitorExitStatement: MONITOREXIT : var5_5
                        if (!releaseLock) return bl3;
                        this.logLock.unlock();
                        return bl3;
                    }
                }
                if (addToOther) {
                    added = this.otherLogs.add(more);
                    contained = this.currentLogs.contains(more);
                } else {
                    added = this.currentLogs.add(more);
                    contained = this.otherLogs.contains(more);
                }
                if (added) {
                    this.rebuildReferencedLogs();
                }
                if (added && !contained) {
                    return true;
                }
                bl2 = !releaseLock;
            }
        }
        catch (Throwable throwable) {
            if (!releaseLock) throw throwable;
            this.logLock.unlock();
            throw throwable;
        }
        {
            bl = bl2;
        }
        if (!releaseLock) return bl;
        this.logLock.unlock();
        return bl;
    }

    public void finishUpdatingLogsUsed() {
        this.logLock.unlock();
    }

    public synchronized void chopFiles() {
        this.initiateMajorCompaction(MajorCompactionReason.CHOP);
    }

    private CompactionStrategy createCompactionStrategy(CompactionStrategyConfig strategyConfig) {
        String context = this.tableConfiguration.get(Property.TABLE_CLASSPATH);
        String clazzName = strategyConfig.getClassName();
        try {
            Class clazz = context != null && !context.equals("") ? AccumuloVFSClassLoader.getContextManager().loadClass(context, clazzName, CompactionStrategy.class) : AccumuloVFSClassLoader.loadClass((String)clazzName, CompactionStrategy.class);
            CompactionStrategy strategy = (CompactionStrategy)clazz.newInstance();
            strategy.init(strategyConfig.getOptions());
            return strategy;
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating compaction strategy on " + this.extent, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactAll(long compactionId, UserCompactionConfig compactionConfig) {
        boolean updateMetadata = false;
        Tablet tablet = this;
        synchronized (tablet) {
            if (this.lastCompactID >= compactionId) {
                return;
            }
            if (this.isMinorCompactionRunning()) {
                if (this.compactionWaitInfo.compactionID == compactionId) {
                    if (this.lastFlushID == this.compactionWaitInfo.flushID) {
                        return;
                    }
                } else {
                    this.compactionWaitInfo.compactionID = compactionId;
                    this.compactionWaitInfo.flushID = this.lastFlushID;
                    return;
                }
            }
            if (this.isClosing() || this.isClosed() || this.majorCompactionQueued.contains((Object)MajorCompactionReason.USER) || this.isMajorCompactionRunning()) {
                return;
            }
            CompactionStrategyConfig strategyConfig = compactionConfig.getCompactionStrategy();
            CompactionStrategy strategy = this.createCompactionStrategy(strategyConfig);
            MajorCompactionRequest request = new MajorCompactionRequest(this.extent, MajorCompactionReason.USER, (AccumuloConfiguration)this.tableConfiguration, this.context);
            request.setFiles(this.getDatafileManager().getDatafileSizes());
            try {
                if (strategy.shouldCompact(request)) {
                    this.initiateMajorCompaction(MajorCompactionReason.USER);
                } else {
                    this.majorCompactionState = CompactionState.IN_PROGRESS;
                    updateMetadata = true;
                    this.lastCompactID = compactionId;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("IOException on " + this.extent + " during compact all", e);
            }
        }
        if (updateMetadata) {
            try {
                MetadataTableUtil.updateTabletCompactID((KeyExtent)this.extent, (long)compactionId, (ServerContext)this.getTabletServer().getContext(), (ZooLock)this.getTabletServer().getLock());
            }
            finally {
                tablet = this;
                synchronized (tablet) {
                    this.majorCompactionState = null;
                    this.notifyAll();
                }
            }
        }
    }

    public TableConfiguration getTableConfiguration() {
        return this.tableConfiguration;
    }

    public Durability getDurability() {
        return DurabilityImpl.fromString((String)this.getTableConfiguration().get(Property.TABLE_DURABILITY));
    }

    public void updateMemoryUsageStats(long size, long mincSize) {
        this.getTabletResources().updateMemoryUsageStats(this, size, mincSize);
    }

    public long incrementDataSourceDeletions() {
        return this.dataSourceDeletions.incrementAndGet();
    }

    public synchronized void updateQueryStats(int size, long numBytes) {
        this.queryCount += (long)size;
        this.queryBytes += numBytes;
    }

    TabletServer getTabletServer() {
        return this.tabletServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePersistedTime(long bulkTime, Map<FileRef, DataFileValue> paths, long tid) {
        Object object = this.timeLock;
        synchronized (object) {
            if (bulkTime > this.persistedTime) {
                this.persistedTime = bulkTime;
            }
            MetadataTableUtil.updateTabletDataFile((long)tid, (KeyExtent)this.extent, paths, (String)this.tabletTime.getMetadataValue(this.persistedTime), (ServerContext)this.getTabletServer().getContext(), (ZooLock)this.getTabletServer().getLock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTabletDataFile(long maxCommittedTime, FileRef newDatafile, FileRef absMergeFile, DataFileValue dfv, Set<String> unusedWalLogs, Set<FileRef> filesInUseByScans, long flushId) {
        Object object = this.timeLock;
        synchronized (object) {
            if (maxCommittedTime > this.persistedTime) {
                this.persistedTime = maxCommittedTime;
            }
            String time = this.tabletTime.getMetadataValue(this.persistedTime);
            MasterMetadataUtil.updateTabletDataFile((ServerContext)this.getTabletServer().getContext(), (KeyExtent)this.extent, (FileRef)newDatafile, (FileRef)absMergeFile, (DataFileValue)dfv, (String)time, filesInUseByScans, (String)this.tabletServer.getClientAddressString(), (ZooLock)this.tabletServer.getLock(), unusedWalLogs, (TServerInstance)this.lastLocation, (long)flushId);
        }
    }

    TabletServerResourceManager.TabletResourceManager getTabletResources() {
        return this.tabletResources;
    }

    DatafileManager getDatafileManager() {
        return this.datafileManager;
    }

    TabletMemory getTabletMemory() {
        return this.tabletMemory;
    }

    public long getAndUpdateTime() {
        return this.tabletTime.getAndUpdateTime();
    }

    public void flushComplete(long flushId) {
        this.lastLocation = null;
        this.dataSourceDeletions.incrementAndGet();
        this.tabletMemory.finishedMinC();
        this.lastFlushID = flushId;
        this.computeNumEntries();
    }

    public TServerInstance resetLastLocation() {
        TServerInstance result = this.lastLocation;
        this.lastLocation = null;
        return result;
    }

    public synchronized void addActiveScans(ScanDataSource scanDataSource) {
        this.activeScans.add(scanDataSource);
    }

    public int removeScan(ScanDataSource scanDataSource) {
        this.activeScans.remove(scanDataSource);
        return this.activeScans.size();
    }

    public synchronized void setLastCompactionID(Long compactionId) {
        if (compactionId != null) {
            this.lastCompactID = compactionId;
        }
    }

    public void minorCompactionWaitingToStart() {
        this.minorCompactionState = CompactionState.WAITING_TO_START;
    }

    public void minorCompactionStarted() {
        this.minorCompactionState = CompactionState.IN_PROGRESS;
    }

    public void minorCompactionComplete() {
        this.minorCompactionState = null;
    }

    public TabletStats getTabletStats() {
        return this.timer.getTabletStats();
    }

    public AtomicLong getScannedCounter() {
        return this.scannedCount;
    }

    private static String createTabletDirectory(ServerContext context, VolumeManager fs, TableId tableId, Text endRow) {
        UniqueNameAllocator namer = context.getUniqueNameAllocator();
        VolumeChooserEnvironmentImpl chooserEnv = new VolumeChooserEnvironmentImpl(tableId, endRow, context);
        String volume = fs.choose((VolumeChooserEnvironment)chooserEnv, ServerConstants.getBaseUris((ServerContext)context)) + "/tables" + "/";
        while (true) {
            try {
                Path lowDirectoryPath;
                String lowDirectory;
                if (endRow == null) {
                    lowDirectory = "/default_tablet";
                    lowDirectoryPath = new Path(volume + "/" + tableId + "/" + lowDirectory);
                    if (fs.exists(lowDirectoryPath) || fs.mkdirs(lowDirectoryPath)) {
                        FileSystem pathFs = fs.getVolumeByPath(lowDirectoryPath).getFileSystem();
                        return lowDirectoryPath.makeQualified(pathFs.getUri(), pathFs.getWorkingDirectory()).toString();
                    }
                    log.warn("Failed to create {} for unknown reason", (Object)lowDirectoryPath);
                } else {
                    lowDirectory = "/t-" + namer.getNextName();
                    lowDirectoryPath = new Path(volume + "/" + tableId + "/" + lowDirectory);
                    if (fs.exists(lowDirectoryPath)) {
                        throw new IllegalStateException("Attempting to create tablet dir for tableID " + tableId + " and dir exists when it should not: " + lowDirectoryPath);
                    }
                    if (fs.mkdirs(lowDirectoryPath)) {
                        FileSystem lowDirectoryFs = fs.getVolumeByPath(lowDirectoryPath).getFileSystem();
                        return lowDirectoryPath.makeQualified(lowDirectoryFs.getUri(), lowDirectoryFs.getWorkingDirectory()).toString();
                    }
                }
            }
            catch (IOException e) {
                log.warn("{}", (Object)e.getMessage(), (Object)e);
            }
            log.warn("Failed to create dir for tablet in table {} in volume {} will retry ...", (Object)tableId, (Object)volume);
            UtilWaitThread.sleepUninterruptibly((long)3L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    public Map<Long, List<FileRef>> getBulkIngestedFiles() {
        return new HashMap<Long, List<FileRef>>(this.bulkImported.asMap());
    }

    public void cleanupBulkLoadedFiles(Set<Long> tids) {
        for (Long tid : tids) {
            this.bulkImported.invalidate((Object)tid);
        }
    }

    public static class LookupResult {
        public List<Range> unfinishedRanges = new ArrayList<Range>();
        public long bytesAdded = 0L;
        public long dataSize = 0L;
        public boolean closed = false;
    }

    static enum CompactionState {
        WAITING_TO_START,
        IN_PROGRESS;

    }

    private static class CompactionWaitInfo {
        long flushID = -1L;
        long compactionID = -1L;

        private CompactionWaitInfo() {
        }
    }

    private static enum CloseState {
        OPEN,
        CLOSING,
        CLOSED,
        COMPLETE;

    }
}

