/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import java.io.IOException;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.tserver.MinorCompactionReason;
import org.apache.accumulo.tserver.compaction.MajorCompactionReason;
import org.apache.accumulo.tserver.tablet.CommitSession;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.apache.htrace.Sampler;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;
import org.apache.htrace.impl.ProbabilitySampler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MinorCompactionTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(MinorCompactionTask.class);
    private final Tablet tablet;
    private long queued;
    private CommitSession commitSession;
    private DataFileValue stats;
    private FileRef mergeFile;
    private long flushId;
    private MinorCompactionReason mincReason;
    private double tracePercent;

    MinorCompactionTask(Tablet tablet, FileRef mergeFile, CommitSession commitSession, long flushId, MinorCompactionReason mincReason, double tracePercent) {
        this.tablet = tablet;
        this.queued = System.currentTimeMillis();
        tablet.minorCompactionWaitingToStart();
        this.commitSession = commitSession;
        this.mergeFile = mergeFile;
        this.flushId = flushId;
        this.mincReason = mincReason;
        this.tracePercent = tracePercent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.tablet.minorCompactionStarted();
        ProbabilitySampler sampler = TraceUtil.probabilitySampler((double)this.tracePercent);
        try {
            try (TraceScope minorCompaction = Trace.startSpan((String)"minorCompaction", (Sampler)sampler);){
                FileRef newMapfileLocation = this.tablet.getNextMapFilename(this.mergeFile == null ? "F" : "M");
                FileRef tmpFileRef = new FileRef(newMapfileLocation.path() + "_tmp");
                try (TraceScope span = Trace.startSpan((String)"waitForCommits");){
                    Tablet tablet = this.tablet;
                    synchronized (tablet) {
                        this.commitSession.waitForCommitsToFinish();
                    }
                }
                span = Trace.startSpan((String)"start");
                try {
                    while (true) {
                        try {
                            this.tablet.getTabletServer().minorCompactionStarted(this.commitSession, this.commitSession.getWALogSeq() + 1L, newMapfileLocation.path().toString());
                        }
                        catch (IOException e) {
                            log.warn("Failed to write to write ahead log {}", (Object)e.getMessage(), (Object)e);
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    if (span != null) {
                        span.close();
                    }
                }
                span = Trace.startSpan((String)"compact");
                try {
                    this.stats = this.tablet.minorCompact(this.tablet.getTabletMemory().getMinCMemTable(), tmpFileRef, newMapfileLocation, this.mergeFile, true, this.queued, this.commitSession, this.flushId, this.mincReason);
                }
                finally {
                    if (span != null) {
                        span.close();
                    }
                }
                if (minorCompaction.getSpan() != null) {
                    minorCompaction.getSpan().addKVAnnotation("extent", this.tablet.getExtent().toString());
                    minorCompaction.getSpan().addKVAnnotation("numEntries", Long.toString(this.stats.getNumEntries()));
                    minorCompaction.getSpan().addKVAnnotation("size", Long.toString(this.stats.getSize()));
                }
            }
            if (this.tablet.needsSplit()) {
                this.tablet.getTabletServer().executeSplit(this.tablet);
            } else {
                this.tablet.initiateMajorCompaction(MajorCompactionReason.NORMAL);
            }
        }
        catch (Throwable t) {
            log.error("Unknown error during minor compaction for extent: " + this.tablet.getExtent(), t);
            throw new RuntimeException(t);
        }
        finally {
            this.tablet.minorCompactionComplete();
        }
    }
}

