/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.session;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.IterInfo;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.spi.scan.ScanInfo;
import org.apache.accumulo.tserver.scan.ScanTask;
import org.apache.accumulo.tserver.session.ScanSession;
import org.apache.accumulo.tserver.tablet.ScanBatch;
import org.apache.accumulo.tserver.tablet.Scanner;

public class SingleScanSession
extends ScanSession {
    public final KeyExtent extent;
    public final AtomicBoolean interruptFlag = new AtomicBoolean();
    public long entriesReturned = 0L;
    public long batchCount = 0L;
    public volatile ScanTask<ScanBatch> nextBatchTask;
    public Scanner scanner;
    public final long readaheadThreshold;
    public final long batchTimeOut;
    public final String context;

    public SingleScanSession(TCredentials credentials, KeyExtent extent, HashSet<Column> columnSet, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, Authorizations authorizations, long readaheadThreshold, long batchTimeOut, String context, Map<String, String> executionHints) {
        super(credentials, columnSet, ssiList, ssio, authorizations, executionHints);
        this.extent = extent;
        this.readaheadThreshold = readaheadThreshold;
        this.batchTimeOut = batchTimeOut;
        this.context = context;
    }

    public ScanInfo.Type getScanType() {
        return ScanInfo.Type.SINGLE;
    }

    public TableId getTableId() {
        return this.extent.getTableId();
    }

    @Override
    public boolean cleanup() {
        boolean ret;
        try {
            if (this.nextBatchTask != null) {
                this.nextBatchTask.cancel(true);
            }
        }
        finally {
            ret = this.scanner != null ? this.scanner.close() : true;
        }
        return ret;
    }
}

