/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.replication;

import java.util.concurrent.ThreadPoolExecutor;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.zookeeper.DistributedWorkQueue;
import org.apache.accumulo.tserver.replication.ReplicationProcessor;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationWorker
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ReplicationWorker.class);
    private ServerContext context;
    private AccumuloConfiguration conf;
    private VolumeManager fs;
    private ThreadPoolExecutor executor;

    public ReplicationWorker(ServerContext context, VolumeManager fs) {
        this.context = context;
        this.fs = fs;
        this.conf = context.getConfiguration();
    }

    public void setExecutor(ThreadPoolExecutor executor) {
        this.executor = executor;
    }

    @Override
    public void run() {
        DefaultConfiguration defaultConf = DefaultConfiguration.getInstance();
        long defaultDelay = defaultConf.getTimeInMillis(Property.REPLICATION_WORK_PROCESSOR_DELAY);
        long defaultPeriod = defaultConf.getTimeInMillis(Property.REPLICATION_WORK_PROCESSOR_PERIOD);
        long delay = this.conf.getTimeInMillis(Property.REPLICATION_WORK_PROCESSOR_DELAY);
        long period = this.conf.getTimeInMillis(Property.REPLICATION_WORK_PROCESSOR_PERIOD);
        try {
            DistributedWorkQueue workQueue;
            if (defaultDelay != delay && defaultPeriod != period) {
                log.debug("Configuration DistributedWorkQueue with delay and period of {} and {}", (Object)delay, (Object)period);
                workQueue = new DistributedWorkQueue(this.context.getZooKeeperRoot() + "/replication/workqueue", this.conf, delay, period);
            } else {
                log.debug("Configuring DistributedWorkQueue with default delay and period");
                workQueue = new DistributedWorkQueue(this.context.getZooKeeperRoot() + "/replication/workqueue", this.conf);
            }
            workQueue.startProcessing((DistributedWorkQueue.Processor)new ReplicationProcessor(this.context, this.conf, this.fs), this.executor);
        }
        catch (InterruptedException | KeeperException e) {
            throw new RuntimeException(e);
        }
    }
}

