/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.compaction.strategies;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.client.summary.Summary;
import org.apache.accumulo.core.client.summary.summarizers.DeletesSummarizer;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.tserver.compaction.CompactionPlan;
import org.apache.accumulo.tserver.compaction.DefaultCompactionStrategy;
import org.apache.accumulo.tserver.compaction.MajorCompactionRequest;

public class TooManyDeletesCompactionStrategy
extends DefaultCompactionStrategy {
    private boolean shouldCompact = false;
    private double threshold;
    private boolean proceed_bns;
    public static final String THRESHOLD_OPT = "threshold";
    public static final String THRESHOLD_OPT_DEFAULT = ".25";
    public static final String PROCEED_ZERO_NO_SUMMARY_OPT = "proceed_zero_no_summary";
    public static final String PROCEED_ZERO_NO_SUMMARY_OPT_DEFAULT = "false";

    @Override
    public void init(Map<String, String> options) {
        this.threshold = Double.parseDouble(options.getOrDefault(THRESHOLD_OPT, THRESHOLD_OPT_DEFAULT));
        if (this.threshold <= 0.0 || this.threshold > 1.0) {
            throw new IllegalArgumentException("Threshold must be in range (0.0, 1.0], saw : " + this.threshold);
        }
        this.proceed_bns = Boolean.parseBoolean(options.getOrDefault(PROCEED_ZERO_NO_SUMMARY_OPT, PROCEED_ZERO_NO_SUMMARY_OPT_DEFAULT));
    }

    @Override
    public boolean shouldCompact(MajorCompactionRequest request) {
        Collection configuredSummarizers = SummarizerConfiguration.fromTableProperties(request.getTableProperties());
        if (configuredSummarizers.stream().map(sc -> sc.getClassName()).anyMatch(cn -> cn.equals(DeletesSummarizer.class.getName()))) {
            return true;
        }
        return super.shouldCompact(request);
    }

    @Override
    public void gatherInformation(MajorCompactionRequest request) throws IOException {
        double ratio;
        super.gatherInformation(request);
        Predicate<SummarizerConfiguration> summarizerPredicate = conf -> conf.getClassName().equals(DeletesSummarizer.class.getName()) && conf.getOptions().isEmpty();
        long total = 0L;
        long deletes = 0L;
        for (Map.Entry<FileRef, DataFileValue> entry : request.getFiles().entrySet()) {
            List<Summary> summaries = request.getSummaries(Collections.singleton(entry.getKey()), summarizerPredicate);
            if (summaries.size() == 1) {
                Summary summary = (Summary)summaries.iterator().next();
                total += ((Long)summary.getStatistics().get("total")).longValue();
                deletes += ((Long)summary.getStatistics().get("deletes")).longValue();
                continue;
            }
            long numEntries = entry.getValue().getNumEntries();
            if (numEntries == 0L && !this.proceed_bns) {
                this.shouldCompact = false;
                return;
            }
            total += entry.getValue().getNumEntries();
        }
        long nonDeletes = total - deletes;
        this.shouldCompact = nonDeletes >= 0L ? (ratio = (double)deletes / (double)nonDeletes) >= this.threshold : false;
    }

    @Override
    public CompactionPlan getCompactionPlan(MajorCompactionRequest request) {
        if (this.shouldCompact) {
            CompactionPlan cp = new CompactionPlan();
            cp.inputFiles.addAll(request.getFiles().keySet());
            return cp;
        }
        return super.getCompactionPlan(request);
    }
}

