/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.compaction.strategies;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.client.summary.Summary;
import org.apache.accumulo.core.compaction.CompactionSettings;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.tserver.compaction.CompactionPlan;
import org.apache.accumulo.tserver.compaction.CompactionStrategy;
import org.apache.accumulo.tserver.compaction.MajorCompactionRequest;
import org.apache.accumulo.tserver.compaction.WriteParameters;
import org.apache.hadoop.fs.Path;

public class ConfigurableCompactionStrategy
extends CompactionStrategy {
    private List<Test> tests = new ArrayList<Test>();
    private boolean andTest = true;
    private int minFiles = 1;
    private WriteParameters writeParams = new WriteParameters();

    @Override
    public void init(Map<String, String> options) {
        boolean selectNoSummary = false;
        boolean selectExtraSummary = false;
        Set<Map.Entry<String, String>> es = options.entrySet();
        block15: for (Map.Entry<String, String> entry : es) {
            switch (CompactionSettings.valueOf((String)entry.getKey())) {
                case SF_EXTRA_SUMMARY: {
                    selectExtraSummary = true;
                    continue block15;
                }
                case SF_NO_SUMMARY: {
                    selectNoSummary = true;
                    continue block15;
                }
                case SF_NO_SAMPLE: {
                    this.tests.add(new NoSampleTest());
                    continue block15;
                }
                case SF_LT_ESIZE_OPT: {
                    this.tests.add(new FileSizeTest(entry.getValue()){

                        @Override
                        public boolean shouldCompact(long fsize, long esize) {
                            return fsize < esize;
                        }
                    });
                    continue block15;
                }
                case SF_GT_ESIZE_OPT: {
                    this.tests.add(new FileSizeTest(entry.getValue()){

                        @Override
                        public boolean shouldCompact(long fsize, long esize) {
                            return fsize > esize;
                        }
                    });
                    continue block15;
                }
                case SF_NAME_RE_OPT: {
                    this.tests.add(new PatternPathTest(entry.getValue()){

                        @Override
                        public String getInput(Path path) {
                            return path.getName();
                        }
                    });
                    continue block15;
                }
                case SF_PATH_RE_OPT: {
                    this.tests.add(new PatternPathTest(entry.getValue()){

                        @Override
                        public String getInput(Path path) {
                            return path.toString();
                        }
                    });
                    continue block15;
                }
                case MIN_FILES_OPT: {
                    this.minFiles = Integer.parseInt(entry.getValue());
                    continue block15;
                }
                case OUTPUT_COMPRESSION_OPT: {
                    this.writeParams.setCompressType(entry.getValue());
                    continue block15;
                }
                case OUTPUT_BLOCK_SIZE_OPT: {
                    this.writeParams.setBlockSize(Long.parseLong(entry.getValue()));
                    continue block15;
                }
                case OUTPUT_INDEX_BLOCK_SIZE_OPT: {
                    this.writeParams.setIndexBlockSize(Long.parseLong(entry.getValue()));
                    continue block15;
                }
                case OUTPUT_HDFS_BLOCK_SIZE_OPT: {
                    this.writeParams.setHdfsBlockSize(Long.parseLong(entry.getValue()));
                    continue block15;
                }
                case OUTPUT_REPLICATION_OPT: {
                    this.writeParams.setReplication(Integer.parseInt(entry.getValue()));
                    continue block15;
                }
            }
            throw new IllegalArgumentException("Unknown option " + entry.getKey());
        }
        if (selectExtraSummary || selectNoSummary) {
            this.tests.add(new SummaryTest(selectExtraSummary, selectNoSummary));
        }
    }

    private List<FileRef> getFilesToCompact(MajorCompactionRequest request) {
        ArrayList<FileRef> filesToCompact = new ArrayList<FileRef>();
        for (Map.Entry<FileRef, DataFileValue> entry : request.getFiles().entrySet()) {
            boolean compact = false;
            for (Test test : this.tests) {
                if (this.andTest) {
                    compact = test.shouldCompact(entry, request);
                    if (compact) continue;
                    break;
                }
                compact |= test.shouldCompact(entry, request);
            }
            if (!compact && !this.tests.isEmpty()) continue;
            filesToCompact.add(entry.getKey());
        }
        return filesToCompact;
    }

    @Override
    public boolean shouldCompact(MajorCompactionRequest request) {
        return this.getFilesToCompact(request).size() >= this.minFiles;
    }

    @Override
    public void gatherInformation(MajorCompactionRequest request) {
        for (Test test : this.tests) {
            test.gatherInformation(request);
        }
    }

    @Override
    public CompactionPlan getCompactionPlan(MajorCompactionRequest request) {
        List<FileRef> filesToCompact = this.getFilesToCompact(request);
        if (filesToCompact.size() >= this.minFiles) {
            CompactionPlan plan = new CompactionPlan();
            plan.inputFiles.addAll(filesToCompact);
            plan.writeParameters = this.writeParams;
            return plan;
        }
        return null;
    }

    private static abstract class PatternPathTest
    extends Test {
        private Pattern pattern;

        private PatternPathTest(String p) {
            this.pattern = Pattern.compile(p);
        }

        @Override
        public boolean shouldCompact(Map.Entry<FileRef, DataFileValue> file, MajorCompactionRequest request) {
            return this.pattern.matcher(this.getInput(file.getKey().path())).matches();
        }

        public abstract String getInput(Path var1);
    }

    private static abstract class FileSizeTest
    extends Test {
        private final long esize;

        private FileSizeTest(String s) {
            this.esize = Long.parseLong(s);
        }

        @Override
        public boolean shouldCompact(Map.Entry<FileRef, DataFileValue> file, MajorCompactionRequest request) {
            return this.shouldCompact(file.getValue().getSize(), this.esize);
        }

        public abstract boolean shouldCompact(long var1, long var3);
    }

    private static class NoSampleTest
    extends Test {
        private Set<FileRef> filesWithSample = Collections.emptySet();
        private boolean samplingConfigured = true;
        private boolean gatherCalled = false;

        private NoSampleTest() {
        }

        @Override
        void gatherInformation(MajorCompactionRequest request) {
            this.gatherCalled = true;
            SamplerConfigurationImpl sc = SamplerConfigurationImpl.newSamplerConfig((AccumuloConfiguration)new ConfigurationCopy(request.getTableProperties()));
            if (sc == null) {
                this.samplingConfigured = false;
            } else {
                this.filesWithSample = new HashSet<FileRef>();
                for (FileRef fref : request.getFiles().keySet()) {
                    try {
                        FileSKVIterator reader = request.openReader(fref);
                        try {
                            if (reader.getSample(sc) == null) continue;
                            this.filesWithSample.add(fref);
                        }
                        finally {
                            if (reader == null) continue;
                            reader.close();
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            }
        }

        @Override
        public boolean shouldCompact(Map.Entry<FileRef, DataFileValue> file, MajorCompactionRequest request) {
            if (!this.gatherCalled) {
                SamplerConfigurationImpl sc = SamplerConfigurationImpl.newSamplerConfig((AccumuloConfiguration)new ConfigurationCopy(request.getTableProperties()));
                return sc != null;
            }
            if (!this.samplingConfigured) {
                return false;
            }
            return !this.filesWithSample.contains(file.getKey());
        }
    }

    private static class SummaryTest
    extends Test {
        private boolean selectExtraSummary;
        private boolean selectNoSummary;
        private boolean summaryConfigured = true;
        private boolean gatherCalled = false;
        private Set<FileRef> okFiles = Collections.emptySet();

        public SummaryTest(boolean selectExtraSummary, boolean selectNoSummary) {
            this.selectExtraSummary = selectExtraSummary;
            this.selectNoSummary = selectNoSummary;
        }

        @Override
        void gatherInformation(MajorCompactionRequest request) {
            this.gatherCalled = true;
            Collection configs = SummarizerConfiguration.fromTableProperties(request.getTableProperties());
            if (configs.size() == 0) {
                this.summaryConfigured = false;
            } else {
                Set configsSet = configs instanceof Set ? (Set)configs : new HashSet(configs);
                this.okFiles = new HashSet<FileRef>();
                for (FileRef fref : request.getFiles().keySet()) {
                    HashMap<SummarizerConfiguration, Summary> sMap = new HashMap<SummarizerConfiguration, Summary>();
                    List<Summary> summaries = request.getSummaries(Collections.singletonList(fref), conf -> configsSet.contains(conf));
                    for (Summary summary : summaries) {
                        sMap.put(summary.getSummarizerConfiguration(), summary);
                    }
                    boolean needsCompaction = false;
                    for (SummarizerConfiguration sc : configs) {
                        Summary summary = (Summary)sMap.get(sc);
                        if (summary == null && this.selectNoSummary) {
                            needsCompaction = true;
                            break;
                        }
                        if (summary == null || summary.getFileStatistics().getExtra() <= 0L || !this.selectExtraSummary) continue;
                        needsCompaction = true;
                        break;
                    }
                    if (needsCompaction) continue;
                    this.okFiles.add(fref);
                }
            }
        }

        @Override
        public boolean shouldCompact(Map.Entry<FileRef, DataFileValue> file, MajorCompactionRequest request) {
            if (!this.gatherCalled) {
                Collection configs = SummarizerConfiguration.fromTableProperties(request.getTableProperties());
                return configs.size() > 0;
            }
            if (!this.summaryConfigured) {
                return false;
            }
            return !this.okFiles.contains(file.getKey());
        }
    }

    private static abstract class Test {
        private Test() {
        }

        void gatherInformation(MajorCompactionRequest request) {
        }

        abstract boolean shouldCompact(Map.Entry<FileRef, DataFileValue> var1, MajorCompactionRequest var2);
    }
}

