/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.util.ComparablePair;
import org.apache.accumulo.tserver.tablet.Tablet;

public abstract class BusiestTracker {
    private Map<KeyExtent, Long> lastCounts = Collections.emptyMap();
    private final int numBusiestTabletsToLog;

    BusiestTracker(int numBusiestTabletsToLog) {
        this.numBusiestTabletsToLog = numBusiestTabletsToLog;
    }

    protected abstract long extractCount(Tablet var1);

    public List<ComparablePair<Long, KeyExtent>> computeBusiest(Collection<Tablet> tablets) {
        HashMap<KeyExtent, Long> counts = new HashMap<KeyExtent, Long>();
        ArrayList<ComparablePair> tabletsWithDelta = new ArrayList<ComparablePair>();
        for (Tablet tablet : tablets) {
            KeyExtent extent = tablet.getExtent();
            long count = this.extractCount(tablet);
            if (count == 0L) continue;
            counts.put(extent, count);
            long lastCount = this.lastCounts.getOrDefault(extent, 0L);
            long delta = lastCount > count ? count : count - lastCount;
            if (delta <= 0L) continue;
            tabletsWithDelta.add(new ComparablePair((Comparable)Long.valueOf(delta), (Comparable)extent));
        }
        this.lastCounts = counts;
        return Ordering.natural().greatestOf(tabletsWithDelta, this.numBusiestTabletsToLog);
    }

    static BusiestTracker newBusiestIngestTracker(int numBusiestTabletsToLog) {
        return new BusiestTracker(numBusiestTabletsToLog){

            @Override
            protected long extractCount(Tablet tablet) {
                return tablet.totalIngest();
            }
        };
    }

    static BusiestTracker newBusiestQueryTracker(int numBusiestTabletsToLog) {
        return new BusiestTracker(numBusiestTabletsToLog){

            @Override
            protected long extractCount(Tablet tablet) {
                return tablet.totalQueries();
            }
        };
    }
}

