/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.beust.jcommander.Parameter;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class ZooKeeperMain
implements KeywordExecutable {
    public static void main(String[] args) throws Exception {
        new ZooKeeperMain().execute(args);
    }

    public String keyword() {
        return "zookeeper";
    }

    public KeywordExecutable.UsageGroup usageGroup() {
        return KeywordExecutable.UsageGroup.PROCESS;
    }

    public String description() {
        return "Starts Apache Zookeeper instance";
    }

    public void execute(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(ZooKeeperMain.class.getName(), args, new Object[0]);
        try (ServerContext context = new ServerContext(new SiteConfiguration());){
            FileSystem fs = context.getVolumeManager().getDefaultVolume().getFileSystem();
            String baseDir = ServerConstants.getBaseUris(context)[0];
            System.out.println("Using " + fs.makeQualified(new Path(baseDir + "/instance_id")) + " to lookup accumulo instance");
            if (opts.servers == null) {
                opts.servers = context.getZooKeepers();
            }
            System.out.println("The accumulo instance id is " + context.getInstanceID());
            if (!opts.servers.contains("/")) {
                opts.servers = opts.servers + "/accumulo/" + context.getInstanceID();
            }
            org.apache.zookeeper.ZooKeeperMain.main((String[])new String[]{"-server", opts.servers, "-timeout", "" + opts.timeout * 1000L});
        }
    }

    static class Opts
    extends Help {
        @Parameter(names={"-z", "--keepers"}, description="Comma separated list of zookeeper hosts (host:port,host:port)")
        String servers = null;
        @Parameter(names={"-t", "--timeout"}, description="timeout, in seconds to timeout the zookeeper connection")
        long timeout = 30L;

        Opts() {
        }
    }
}

