/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.PropertyType;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPropUtil {
    private static final Logger log = LoggerFactory.getLogger(SystemPropUtil.class);

    public static boolean setSystemProperty(ServerContext context, String property, String value) throws KeeperException, InterruptedException {
        if (!Property.isValidZooPropertyKey((String)property)) {
            IllegalArgumentException iae = new IllegalArgumentException("Zookeeper property is not mutable: " + property);
            log.debug("Attempted to set zookeeper property.  It is not mutable", (Throwable)iae);
            throw iae;
        }
        Property foundProp = null;
        for (Property prop : Property.values()) {
            if ((prop.getType() != PropertyType.PREFIX || !property.startsWith(prop.getKey())) && !prop.getKey().equals(property)) continue;
            foundProp = prop;
            break;
        }
        if (foundProp == null || foundProp.getType() != PropertyType.PREFIX && !foundProp.getType().isValidFormat(value)) {
            IllegalArgumentException iae = new IllegalArgumentException("Ignoring property " + property + " it is either null or in an invalid format");
            log.debug("Attempted to set zookeeper property.  Value is either null or invalid", (Throwable)iae);
            throw iae;
        }
        String zPath = context.getZooKeeperRoot() + "/config" + "/" + property;
        return context.getZooReaderWriter().putPersistentData(zPath, value.getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.OVERWRITE);
    }

    public static void removeSystemProperty(ServerContext context, String property) throws InterruptedException, KeeperException {
        String zPath = context.getZooKeeperRoot() + "/config" + "/" + property;
        context.getZooReaderWriter().recursiveDelete(zPath, ZooUtil.NodeMissingPolicy.FAIL);
    }
}

