/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.tablets;

import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.accumulo.core.util.FastFormat;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerContext;

public class UniqueNameAllocator {
    private ServerContext context;
    private long next = 0L;
    private long maxAllocated = 0L;
    private String nextNamePath;
    private Random rand;

    public UniqueNameAllocator(ServerContext context) {
        this.context = context;
        this.nextNamePath = "/accumulo/" + context.getInstanceID() + "/next_file";
        this.rand = new SecureRandom();
    }

    public synchronized String getNextName() {
        while (this.next >= this.maxAllocated) {
            final int allocate = 100 + this.rand.nextInt(100);
            try {
                byte[] max = this.context.getZooReaderWriter().mutate(this.nextNamePath, null, ZooUtil.PRIVATE, new IZooReaderWriter.Mutator(){

                    public byte[] mutate(byte[] currentValue) {
                        long l = Long.parseLong(new String(currentValue, StandardCharsets.UTF_8), 36);
                        return Long.toString(l += (long)allocate, 36).getBytes(StandardCharsets.UTF_8);
                    }
                });
                this.maxAllocated = Long.parseLong(new String(max, StandardCharsets.UTF_8), 36);
                this.next = this.maxAllocated - (long)allocate;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return new String(FastFormat.toZeroPaddedString((long)this.next++, (int)7, (int)36, (byte[])new byte[0]), StandardCharsets.UTF_8);
    }
}

