/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.commons.lang3.StringUtils;

public class UserImpersonation {
    private static final Set<String> ALWAYS_TRUE = new AlwaysTrueSet<String>();
    private static final String ALL = "*";
    private final Map<String, UsersWithHosts> proxyUsers = new HashMap<String, UsersWithHosts>();

    public UserImpersonation(AccumuloConfiguration conf) {
        String[] hostConfigs;
        String[] stringArray;
        String[] userConfigs;
        String[] stringArray2;
        String userConfigString = conf.get(Property.INSTANCE_RPC_SASL_ALLOWED_USER_IMPERSONATION);
        if (Objects.equals(userConfigString, Property.INSTANCE_RPC_SASL_ALLOWED_USER_IMPERSONATION.getDefaultValue())) {
            return;
        }
        String hostConfigString = conf.get(Property.INSTANCE_RPC_SASL_ALLOWED_HOST_IMPERSONATION);
        if (userConfigString.trim().isEmpty()) {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = "";
        } else {
            stringArray2 = userConfigs = StringUtils.split((String)userConfigString, (char)';');
        }
        if (hostConfigString.trim().isEmpty()) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = "";
        } else {
            stringArray = hostConfigs = StringUtils.split((String)hostConfigString, (char)';');
        }
        if (userConfigs.length != hostConfigs.length) {
            String msg = String.format("Should have equal number of user and host impersonation elements in configuration. Got %d and %d elements, respectively.", userConfigs.length, hostConfigs.length);
            throw new IllegalArgumentException(msg);
        }
        for (int i = 0; i < userConfigs.length; ++i) {
            String userConfig = userConfigs[i];
            String hostConfig = hostConfigs[i];
            String[] splitUserConfig = StringUtils.split((String)userConfig, (char)':');
            if (splitUserConfig.length != 2) {
                throw new IllegalArgumentException("Expect a single colon-separated pair, but found '" + userConfig + "'");
            }
            String remoteUser = splitUserConfig[0];
            String allowedImpersonationsForRemoteUser = splitUserConfig[1];
            UsersWithHosts usersWithHosts = new UsersWithHosts();
            this.proxyUsers.put(remoteUser.trim(), usersWithHosts);
            if (ALL.equals(allowedImpersonationsForRemoteUser)) {
                usersWithHosts.setAcceptAllUsers(true);
            } else {
                String[] allowedUsers = StringUtils.split((String)allowedImpersonationsForRemoteUser, (String)",");
                HashSet<String> usersSet = new HashSet<String>();
                usersSet.addAll(Arrays.asList(allowedUsers));
                usersWithHosts.setUsers(usersSet);
            }
            if (ALL.equals(hostConfig)) {
                usersWithHosts.setAcceptAllHosts(true);
                continue;
            }
            String[] allowedHosts = StringUtils.split((String)hostConfig, (String)",");
            HashSet<String> hostsSet = new HashSet<String>();
            hostsSet.addAll(Arrays.asList(allowedHosts));
            usersWithHosts.setHosts(hostsSet);
        }
    }

    public UsersWithHosts get(String remoteUser) {
        return this.proxyUsers.get(remoteUser);
    }

    public static class UsersWithHosts {
        private Set<String> users = new HashSet<String>();
        private Set<String> hosts = new HashSet<String>();
        private boolean allUsers = false;
        private boolean allHosts = false;

        public Set<String> getUsers() {
            if (this.allUsers) {
                return ALWAYS_TRUE;
            }
            return this.users;
        }

        public Set<String> getHosts() {
            if (this.allHosts) {
                return ALWAYS_TRUE;
            }
            return this.hosts;
        }

        public boolean acceptsAllUsers() {
            return this.allUsers;
        }

        public void setAcceptAllUsers(boolean allUsers) {
            this.allUsers = allUsers;
        }

        public boolean acceptsAllHosts() {
            return this.allHosts;
        }

        public void setAcceptAllHosts(boolean allHosts) {
            this.allHosts = allHosts;
        }

        public void setUsers(Set<String> users) {
            this.users = users;
            this.allUsers = false;
        }

        public void setHosts(Set<String> hosts) {
            this.hosts = hosts;
            this.allHosts = false;
        }
    }

    public static class AlwaysTrueSet<T>
    implements Set<T> {
        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return true;
        }

        @Override
        public Iterator<T> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <E> E[] toArray(E[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

