/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.state;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.master.state.Assignment;
import org.apache.accumulo.server.master.state.ClosableIterator;
import org.apache.accumulo.server.master.state.DistributedStoreException;
import org.apache.accumulo.server.master.state.MetaDataStateStore;
import org.apache.accumulo.server.master.state.RootTabletStateStore;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.server.master.state.ZooTabletStateStore;
import org.apache.hadoop.fs.Path;

public abstract class TabletStateStore
implements Iterable<TabletLocationState> {
    public abstract String name();

    @Override
    public abstract ClosableIterator<TabletLocationState> iterator();

    public abstract void setFutureLocations(Collection<Assignment> var1) throws DistributedStoreException;

    public abstract void setLocations(Collection<Assignment> var1) throws DistributedStoreException;

    public abstract void unassign(Collection<TabletLocationState> var1, Map<TServerInstance, List<Path>> var2) throws DistributedStoreException;

    public abstract void suspend(Collection<TabletLocationState> var1, Map<TServerInstance, List<Path>> var2, long var3) throws DistributedStoreException;

    public abstract void unsuspend(Collection<TabletLocationState> var1) throws DistributedStoreException;

    public static void unassign(ServerContext context, TabletLocationState tls, Map<TServerInstance, List<Path>> logsForDeadServers) throws DistributedStoreException {
        TabletStateStore.getStoreForTablet(tls.extent, context).unassign(Collections.singletonList(tls), logsForDeadServers);
    }

    public static void suspend(ServerContext context, TabletLocationState tls, Map<TServerInstance, List<Path>> logsForDeadServers, long suspensionTimestamp) throws DistributedStoreException {
        TabletStateStore.getStoreForTablet(tls.extent, context).suspend(Collections.singletonList(tls), logsForDeadServers, suspensionTimestamp);
    }

    public static void setLocation(ServerContext context, Assignment assignment) throws DistributedStoreException {
        TabletStateStore.getStoreForTablet(assignment.tablet, context).setLocations(Collections.singletonList(assignment));
    }

    protected static TabletStateStore getStoreForTablet(KeyExtent extent, ServerContext context) {
        if (extent.isRootTablet()) {
            return new ZooTabletStateStore(context);
        }
        if (extent.isMeta()) {
            return new RootTabletStateStore(context);
        }
        return new MetaDataStateStore(context);
    }
}

