/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.ZooConfiguration;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

class ZooConfigurationFactory {
    private static final Map<String, ZooConfiguration> instances = new HashMap<String, ZooConfiguration>();

    ZooConfigurationFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ZooConfiguration getInstance(ServerContext context, ZooCacheFactory zcf, AccumuloConfiguration parent) {
        ZooConfiguration config;
        Map<String, ZooConfiguration> map = instances;
        synchronized (map) {
            config = instances.get(context.getInstanceID());
            if (config == null) {
                Watcher watcher = new Watcher(){

                    public void process(WatchedEvent arg0) {
                    }
                };
                ZooCache propCache = zcf.getZooCache(context.getZooKeepers(), context.getZooKeepersSessionTimeOut(), watcher);
                config = new ZooConfiguration(context, propCache, parent);
                instances.put(context.getInstanceID(), config);
            }
        }
        return config;
    }
}

