/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.spi.common.ServiceEnvironment;
import org.apache.accumulo.server.ServerContext;

public class ServiceEnvironmentImpl
implements ServiceEnvironment {
    private final ServerContext srvCtx;
    private final ServiceEnvironment.Configuration conf;

    public ServiceEnvironmentImpl(ServerContext ctx) {
        this.srvCtx = ctx;
        this.conf = new ConfigurationImpl(this.srvCtx.getConfiguration());
    }

    public ServiceEnvironment.Configuration getConfiguration() {
        return this.conf;
    }

    public ServiceEnvironment.Configuration getConfiguration(TableId tableId) {
        return new ConfigurationImpl((AccumuloConfiguration)this.srvCtx.getServerConfFactory().getTableConfiguration(tableId));
    }

    public String getTableName(TableId tableId) throws TableNotFoundException {
        return Tables.getTableName((ClientContext)this.srvCtx, (TableId)tableId);
    }

    public <T> T instantiate(String className, Class<T> base) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        return (T)ConfigurationTypeHelper.getClassInstance(null, (String)className, base);
    }

    public <T> T instantiate(TableId tableId, String className, Class<T> base) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        String ctx = this.srvCtx.getServerConfFactory().getTableConfiguration(tableId).get(Property.TABLE_CLASSPATH);
        return (T)ConfigurationTypeHelper.getClassInstance((String)ctx, (String)className, base);
    }

    private static class ConfigurationImpl
    implements ServiceEnvironment.Configuration {
        private final AccumuloConfiguration acfg;
        private Map<String, String> customProps;
        private Map<String, String> tableCustomProps;

        ConfigurationImpl(AccumuloConfiguration acfg) {
            this.acfg = acfg;
        }

        public String get(String key) {
            Property prop = Property.getPropertyByKey((String)key);
            if (prop != null) {
                if (prop.isSensitive()) {
                    return null;
                }
                return this.acfg.get(prop);
            }
            return this.acfg.get(key);
        }

        public Map<String, String> getCustom() {
            if (this.customProps == null) {
                this.customProps = this.buildCustom(Property.GENERAL_ARBITRARY_PROP_PREFIX);
            }
            return this.customProps;
        }

        public String getCustom(String keySuffix) {
            return this.getCustom().get(keySuffix);
        }

        public Map<String, String> getTableCustom() {
            if (this.tableCustomProps == null) {
                this.tableCustomProps = this.buildCustom(Property.TABLE_ARBITRARY_PROP_PREFIX);
            }
            return this.tableCustomProps;
        }

        public String getTableCustom(String keySuffix) {
            return this.getTableCustom().get(keySuffix);
        }

        private Map<String, String> buildCustom(Property customPrefix) {
            Map props = this.acfg.getAllPropertiesWithPrefix(customPrefix);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            props.forEach((k, v) -> builder.put((Object)k.substring(customPrefix.getKey().length()), v));
            return builder.build();
        }

        public Iterator<Map.Entry<String, String>> iterator() {
            return StreamSupport.stream(this.acfg.spliterator(), false).filter(e -> !Property.isSensitive((String)((String)e.getKey()))).iterator();
        }
    }
}

