/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServerOpts;
import org.apache.accumulo.server.ServerUtil;
import org.apache.accumulo.server.metrics.Metrics;
import org.apache.accumulo.server.security.SecurityUtil;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServer
implements AutoCloseable,
Runnable {
    private final ServerContext context;
    private final String applicationName;
    private final String hostname;
    private final Logger log = LoggerFactory.getLogger((String)this.getClass().getName());
    private final MetricsSystem metricsSystem;

    protected AbstractServer(String appName, ServerOpts opts, String[] args) {
        this.applicationName = appName;
        this.hostname = Objects.requireNonNull(opts.getAddress());
        opts.parseArgs(appName, args, new Object[0]);
        SiteConfiguration siteConfig = opts.getSiteConfiguration();
        this.context = new ServerContext(siteConfig);
        SecurityUtil.serverLogin((AccumuloConfiguration)siteConfig);
        this.log.info("Version 2.0.0");
        this.log.info("Instance " + this.context.getInstanceID());
        ServerUtil.init(this.context, appName);
        this.metricsSystem = Metrics.initSystem(this.getClass().getSimpleName());
        TraceUtil.enableServerTraces((String)this.hostname, (String)appName, (AccumuloConfiguration)this.context.getConfiguration());
        if (this.context.getSaslParams() != null) {
            this.context.enforceKerberosLogin();
        }
    }

    public void runServer() throws Exception {
        AtomicReference err = new AtomicReference();
        Thread service = new Thread((Runnable)this, this.applicationName);
        service.setUncaughtExceptionHandler((thread, exception) -> err.set(exception));
        service.start();
        service.join();
        Throwable thrown = (Throwable)err.get();
        if (thrown != null) {
            if (thrown instanceof Error) {
                throw (Error)thrown;
            }
            if (thrown instanceof Exception) {
                throw (Exception)thrown;
            }
            throw new RuntimeException("Weird throwable type thrown", thrown);
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public ServerContext getContext() {
        return this.context;
    }

    public AccumuloConfiguration getConfiguration() {
        return this.getContext().getConfiguration();
    }

    public MetricsSystem getMetricsSystem() {
        return this.metricsSystem;
    }

    @Override
    public void close() {
        TraceUtil.disable();
    }
}

