/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.replication;

import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.replication.FinishedWorkUpdater;
import org.apache.accumulo.master.replication.RemoveCompleteReplicationRecords;
import org.apache.accumulo.master.replication.StatusMaker;
import org.apache.accumulo.master.replication.WorkMaker;
import org.apache.htrace.Sampler;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;
import org.apache.htrace.impl.ProbabilitySampler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationDriver
extends Daemon {
    private static final Logger log = LoggerFactory.getLogger(ReplicationDriver.class);
    private final Master master;
    private final AccumuloConfiguration conf;
    private WorkMaker workMaker;
    private StatusMaker statusMaker;
    private FinishedWorkUpdater finishedWorkUpdater;
    private RemoveCompleteReplicationRecords rcrr;
    private AccumuloClient client;

    public ReplicationDriver(Master master) {
        super("Replication Driver");
        this.master = master;
        this.conf = master.getConfiguration();
    }

    public void run() {
        ProbabilitySampler sampler = TraceUtil.probabilitySampler((double)this.conf.getFraction(Property.REPLICATION_TRACE_PERCENT));
        long millisToWait = this.conf.getTimeInMillis(Property.REPLICATION_DRIVER_DELAY);
        log.debug("Waiting {}ms before starting main replication loop", (Object)millisToWait);
        UtilWaitThread.sleep((long)millisToWait);
        log.debug("Starting replication loop");
        while (this.master.stillMaster()) {
            if (this.workMaker == null) {
                this.client = this.master.getContext();
                this.statusMaker = new StatusMaker(this.client, this.master.getFileSystem());
                this.workMaker = new WorkMaker(this.master.getContext(), this.client);
                this.finishedWorkUpdater = new FinishedWorkUpdater(this.client);
                this.rcrr = new RemoveCompleteReplicationRecords(this.client);
            }
            try (TraceScope replicationDriver = Trace.startSpan((String)"masterReplicationDriver", (Sampler)sampler);){
                try {
                    this.statusMaker.run();
                }
                catch (Exception e) {
                    log.error("Caught Exception trying to create Replication status records", (Throwable)e);
                }
                try {
                    this.workMaker.run();
                }
                catch (Exception e) {
                    log.error("Caught Exception trying to create Replication work records", (Throwable)e);
                }
                try {
                    this.finishedWorkUpdater.run();
                }
                catch (Exception e) {
                    log.error("Caught Exception trying to update Replication records using finished work records", (Throwable)e);
                }
                try {
                    this.rcrr.run();
                }
                catch (Exception e) {
                    log.error("Caught Exception trying to remove finished Replication records", (Throwable)e);
                }
            }
            long sleepMillis = this.conf.getTimeInMillis(Property.MASTER_REPLICATION_SCAN_INTERVAL);
            log.debug("Sleeping for {}ms before re-running", (Object)sleepMillis);
            try {
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException e) {
                log.error("Interrupted while sleeping", (Throwable)e);
            }
        }
    }
}

