/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.adapters.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import org.apache.abdera.Abdera;
import org.apache.abdera.i18n.templates.Template;
import org.apache.abdera.i18n.text.Normalizer;
import org.apache.abdera.i18n.text.Sanitizer;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.abdera.protocol.server.ProviderHelper;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.Target;
import org.apache.abdera.protocol.server.provider.managed.FeedConfiguration;
import org.apache.abdera.protocol.server.provider.managed.ManagedCollectionAdapter;

public class FilesystemAdapter
extends ManagedCollectionAdapter {
    private final File root = this.getRoot();
    private static final FileSorter sorter = new FileSorter();
    private static final Template paging_template = new Template("?{-join|&|count,page}");

    public FilesystemAdapter(Abdera abdera, FeedConfiguration config) {
        super(abdera, config);
    }

    private File getRoot() {
        try {
            String root = (String)this.config.getProperty("fs.root");
            File file = new File(root);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (!file.isDirectory()) {
                throw new RuntimeException("Root must be a directory");
            }
            return file;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private Entry getEntry(File entryFile) {
        if (!entryFile.exists() || !entryFile.isFile()) {
            throw new RuntimeException();
        }
        try {
            FileInputStream fis = new FileInputStream(entryFile);
            Document doc = this.abdera.getParser().parse(fis);
            Entry entry = (Entry)doc.getRoot();
            return entry;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addPagingLinks(RequestContext request, Feed feed, int currentpage, int count) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("count", count);
        params.put("page", currentpage + 1);
        String next = paging_template.expand(params);
        next = request.getResolvedUri().resolve(next).toString();
        feed.addLink(next, "next");
        if (currentpage > 0) {
            params.put("page", currentpage - 1);
            String prev = paging_template.expand(params);
            prev = request.getResolvedUri().resolve(prev).toString();
            feed.addLink(prev, "previous");
        }
        params.put("page", 0);
        String current = paging_template.expand(params);
        current = request.getResolvedUri().resolve(current).toString();
        feed.addLink(current, "current");
    }

    private void getEntries(RequestContext request, Feed feed, File root) {
        File[] files = root.listFiles();
        Arrays.sort(files, sorter);
        int length = ProviderHelper.getPageSize(request, "count", 25);
        int offset = ProviderHelper.getOffset(request, "page", length);
        String _page = request.getParameter("page");
        int page = _page != null ? Integer.parseInt(_page) : 0;
        this.addPagingLinks(request, feed, page, length);
        if (offset > files.length) {
            return;
        }
        for (int n = offset; n < offset + length && n < files.length; ++n) {
            File file = files[n];
            Entry entry = this.getEntry(file);
            feed.addEntry((Entry)entry.clone());
        }
    }

    public ResponseContext getFeed(RequestContext request) {
        Feed feed = this.abdera.newFeed();
        feed.setId(this.config.getServerConfiguration().getServerUri() + "/" + this.config.getFeedId());
        feed.setTitle(this.config.getFeedTitle());
        feed.addAuthor(this.config.getFeedAuthor());
        feed.addLink(this.config.getFeedUri());
        feed.addLink(this.config.getFeedUri(), "self");
        feed.setUpdated(new Date());
        this.getEntries(request, feed, this.root);
        return ProviderHelper.returnBase(feed.getDocument(), 200, null);
    }

    public ResponseContext deleteEntry(RequestContext request) {
        Target target = request.getTarget();
        String key = target.getParameter("entry");
        File file = this.getFile(key, false);
        if (file.exists()) {
            file.delete();
        }
        return ProviderHelper.nocontent();
    }

    public ResponseContext getEntry(RequestContext request) {
        Target target = request.getTarget();
        String key = target.getParameter("entry");
        File file = this.getFile(key, false);
        Entry entry = this.getEntry(file);
        if (entry != null) {
            return ProviderHelper.returnBase(entry.getDocument(), 200, null);
        }
        return ProviderHelper.notfound(request);
    }

    public ResponseContext postEntry(RequestContext request) {
        if (request.isAtom()) {
            try {
                Entry entry = (Entry)request.getDocument().getRoot().clone();
                String key = this.createKey(request);
                this.setEditDetail(request, entry, key);
                File file = this.getFile(key);
                FileOutputStream out = new FileOutputStream(file);
                entry.writeTo(out);
                String edit = entry.getEditLinkResolvedHref().toString();
                return ProviderHelper.returnBase(entry.getDocument(), 201, null).setLocation(edit);
            }
            catch (Exception e) {
                return ProviderHelper.badrequest(request);
            }
        }
        return ProviderHelper.notsupported(request);
    }

    private void setEditDetail(RequestContext request, Entry entry, String key) throws IOException {
        Target target = request.getTarget();
        String feed = target.getParameter("feed");
        String id = key;
        entry.setEdited(new Date());
        Link link = entry.getEditLink();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("feed", feed);
        params.put("entry", id);
        String href = request.absoluteUrlFor("entry", params);
        if (link == null) {
            entry.addLink(href, "edit");
        } else {
            link.setHref(href);
        }
    }

    private File getFile(String key) {
        return this.getFile(key, true);
    }

    private File getFile(String key, boolean post) {
        File file = new File(this.root, key);
        if (post && file.exists()) {
            throw new RuntimeException("File exists");
        }
        return file;
    }

    private String createKey(RequestContext request) throws IOException {
        String slug = request.getSlug();
        if (slug == null) {
            slug = ((Entry)request.getDocument().getRoot()).getTitle();
        }
        return Sanitizer.sanitize(slug, "", true, Normalizer.Form.D);
    }

    public ResponseContext putEntry(RequestContext request) {
        if (request.isAtom()) {
            try {
                Entry entry = (Entry)request.getDocument().getRoot().clone();
                String key = request.getTarget().getParameter("entry");
                this.setEditDetail(request, entry, key);
                File file = this.getFile(key, false);
                FileOutputStream out = new FileOutputStream(file);
                entry.writeTo(out);
                String edit = entry.getEditLinkResolvedHref().toString();
                return ProviderHelper.returnBase(entry.getDocument(), 200, null).setLocation(edit);
            }
            catch (Exception e) {
                return ProviderHelper.badrequest(request);
            }
        }
        return ProviderHelper.notsupported(request);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileSorter
    implements Comparator<File> {
        private FileSorter() {
        }

        @Override
        public int compare(File o1, File o2) {
            return o1.lastModified() > o2.lastModified() ? -1 : (o1.lastModified() < o2.lastModified() ? 1 : 0);
        }
    }
}

