/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4.debug;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.debug.AddAttributeEvent;
import org.stringtemplate.v4.debug.ConstructionEvent;
import org.stringtemplate.v4.debug.InterpEvent;
import org.stringtemplate.v4.gui.STViz;
import org.stringtemplate.v4.misc.ErrorBuffer;
import org.stringtemplate.v4.misc.ErrorManager;
import org.stringtemplate.v4.misc.MultiMap;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugST
extends ST {
    public ConstructionEvent newSTEvent = new ConstructionEvent();
    public MultiMap<String, AddAttributeEvent> addAttrEvents = new MultiMap();

    public DebugST() {
    }

    public DebugST(ST proto) {
        super(proto);
    }

    @Override
    public ST add(String name, Object value) {
        if (STGroup.debug) {
            this.addAttrEvents.map(name, new AddAttributeEvent(name, value));
        }
        return super.add(name, value);
    }

    public List<InterpEvent> inspect() {
        return this.inspect(Locale.getDefault());
    }

    public List<InterpEvent> inspect(int lineWidth) {
        return this.inspect(this.impl.nativeGroup.errMgr, Locale.getDefault(), lineWidth);
    }

    public List<InterpEvent> inspect(Locale locale) {
        return this.inspect(this.impl.nativeGroup.errMgr, locale, -1);
    }

    public List<InterpEvent> inspect(ErrorManager errMgr, Locale locale, int lineWidth) {
        ErrorBuffer errors = new ErrorBuffer();
        this.impl.nativeGroup.setListener(errors);
        StringWriter out = new StringWriter();
        AutoIndentWriter wr = new AutoIndentWriter(out);
        wr.setLineWidth(lineWidth);
        Interpreter interp = new Interpreter(this.groupThatCreatedThisInstance, locale);
        interp.exec(wr, this);
        new STViz(errMgr, this, out.toString(), interp, interp.getExecutionTrace(), errors.errors);
        return interp.getEvents();
    }

    public List<InterpEvent> getEvents() {
        return this.getEvents(Locale.getDefault());
    }

    public List<InterpEvent> getEvents(int lineWidth) {
        return this.getEvents(Locale.getDefault(), lineWidth);
    }

    public List<InterpEvent> getEvents(Locale locale) {
        return this.getEvents(locale, -1);
    }

    public List<InterpEvent> getEvents(Locale locale, int lineWidth) {
        StringWriter out = new StringWriter();
        AutoIndentWriter wr = new AutoIndentWriter(out);
        wr.setLineWidth(lineWidth);
        Interpreter interp = new Interpreter(this.groupThatCreatedThisInstance, locale);
        interp.exec(wr, this);
        return interp.getEvents();
    }

    public static class State {
        public List<InterpEvent> interpEvents = new ArrayList<InterpEvent>();
    }
}

