// $ANTLR 3.3 Nov 30, 2010 12:46:29 org/stringtemplate/v4/compiler/Group.g 2011-05-18 18:27:34

/*
 * [The "BSD license"]
 *  Copyright (c) 2011 Terence Parr
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. The name of the author may not be used to endorse or promote products
 *     derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 *  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.stringtemplate.v4.compiler;
import org.stringtemplate.v4.*;
import org.stringtemplate.v4.misc.*;
import java.io.File;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

public class GroupLexer extends Lexer {
    public static final int EOF=-1;
    public static final int T__13=13;
    public static final int T__14=14;
    public static final int T__15=15;
    public static final int T__16=16;
    public static final int T__17=17;
    public static final int T__18=18;
    public static final int T__19=19;
    public static final int T__20=20;
    public static final int T__21=21;
    public static final int T__22=22;
    public static final int T__23=23;
    public static final int T__24=24;
    public static final int T__25=25;
    public static final int T__26=26;
    public static final int T__27=27;
    public static final int TRUE=4;
    public static final int FALSE=5;
    public static final int STRING=6;
    public static final int ID=7;
    public static final int BIGSTRING=8;
    public static final int ANONYMOUS_TEMPLATE=9;
    public static final int COMMENT=10;
    public static final int LINE_COMMENT=11;
    public static final int WS=12;

    public STGroup group;

    public void reportError(RecognitionException e) {
        String msg = null;
        if ( e instanceof NoViableAltException ) {
            msg = "invalid character '"+(char)input.LA(1)+"'";
        }
        else if ( e instanceof MismatchedTokenException && ((MismatchedTokenException)e).expecting=='"' ) {
            msg = "unterminated string";
        }
        else {
            msg = getErrorMessage(e, getTokenNames());
        }
        group.errMgr.groupSyntaxError(ErrorType.SYNTAX_ERROR, getSourceName(), e, msg);
    }
    public String getSourceName() {
        String fullFileName = super.getSourceName();
        File f = new File(fullFileName); // strip to simple name
        return f.getName();
    }


    // delegates
    // delegators

    public GroupLexer() {;} 
    public GroupLexer(CharStream input) {
        this(input, new RecognizerSharedState());
    }
    public GroupLexer(CharStream input, RecognizerSharedState state) {
        super(input,state);

    }
    public String getGrammarFileName() { return "org/stringtemplate/v4/compiler/Group.g"; }

    // $ANTLR start "TRUE"
    public final void mTRUE() throws RecognitionException {
        try {
            int _type = TRUE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/stringtemplate/v4/compiler/Group.g:59:6: ( 'true' )
            // org/stringtemplate/v4/compiler/Group.g:59:8: 'true'
            {
            match("true"); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "TRUE"

    // $ANTLR start "FALSE"
    public final void mFALSE() throws RecognitionException {
        try {
            int _type = FALSE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/stringtemplate/v4/compiler/Group.g:60:7: ( 'false' )
            // org/stringtemplate/v4/compiler/Group.g:60:9: 'false'
            {
            match("false"); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "FALSE"

    // $ANTLR start "T__13"
    public final void mT__13() throws RecognitionException {
        try {
            int _type = T__13;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/stringtemplate/v4/compiler/Group.g:61:7: ( 'import' )
            // org/stringtemplate/v4/compiler/Group.g:61:9: 'import'
            {
            match("import"); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "T__13"

    // $ANTLR start "T__14"
    public final void mT__14() throws RecognitionException {
        try {
            int _type = T__14;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/stringtemplate/v4/compiler/Group.g:62:7: ( '.' )
            // org/stringtemplate/v4/compiler/Group.g:62:9: '.'
            {
            match('.'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "T__14"

    // $ANTLR start "T__15"
    public final void mT__15() throws RecognitionException {
        try {
            int _type = T__15;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/stringtemplate/v4/compiler/Group.g:63:7: ( 'group' )
            // org/stringtemplate/v4/compiler/Group.g:63:9: 'group'
            {
            match("group"); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "T__15"

    // $ANTLR start "T__16"
    public final void mT__16() throws RecognitionException {
        try {
            int _type = T__16;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/stringtemplate/v4/compiler/Group.g:64:7: ( ':' )
            // org/stringtemplate/v4/compiler/Group.g:64:9: ':'
            {
            match(':'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "T__16"

    // $ANTLR start "T__17"
    public final void mT__17() throws RecognitionException {
        try {
            int _type = T__17;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/stringtemplate/v4/compiler/Group.g:65:7: ( 'implements' )
            // org/stringtemplate/v4/compiler/Group.g:65:9: 'implements'
            {
            match("implements"); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "T__17"

    // $ANTLR start "T__18"
    public final void mT__18() throws RecognitionException {
        try {
            int _type = T__18;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/stringtemplate/v4/compiler/Group.g:66:7: ( ',' )
            // org/stringtemplate/v4/compiler/Group.g:66:9: ','
            {
            match(','); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "T__18"

    // $ANTLR start "T__19"
    public final void mT__19() throws RecognitionException {
        try {
            int _type = T__19;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/stringtemplate/v4/compiler/Group.g:67:7: ( ';' )
            // org/stringtemplate/v4/compiler/Group.g:67:9: ';'
            {
            match(';'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "T__19"

    // $ANTLR start "T__20"
    public final void mT__20() throws RecognitionException {
        try {
            int _type = T__20;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/stringtemplate/v4/compiler/Group.g:68:7: ( '@' )
            // org/stringtemplate/v4/compiler/Group.g:68:9: '@'
            {
            match('@'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "T__20"

    // $ANTLR start "T__21"
    public final void mT__21() throws RecognitionException {
        try {
            int _type = T__21;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/stringtemplate/v4/compiler/Group.g:69:7: ( '(' )
            // org/stringtemplate/v4/compiler/Group.g:69:9: '('
            {
            match('('); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "T__21"

    // $ANTLR start "T__22"
    public final void mT__22() throws RecognitionException {
        try {
            int _type = T__22;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/stringtemplate/v4/compiler/Group.g:70:7: ( ')' )
            // org/stringtemplate/v4/compiler/Group.g:70:9: ')'
            {
            match(')'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "T__22"

    // $ANTLR start "T__23"
    public final void mT__23() throws RecognitionException {
        try {
            int _type = T__23;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/stringtemplate/v4/compiler/Group.g:71:7: ( '::=' )
            // org/stringtemplate/v4/compiler/Group.g:71:9: '::='
            {
            match("::="); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "T__23"

    // $ANTLR start "T__24"
    public final void mT__24() throws RecognitionException {
        try {
            int _type = T__24;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/stringtemplate/v4/compiler/Group.g:72:7: ( '=' )
            // org/stringtemplate/v4/compiler/Group.g:72:9: '='
            {
            match('='); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "T__24"

    // $ANTLR start "T__25"
    public final void mT__25() throws RecognitionException {
        try {
            int _type = T__25;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/stringtemplate/v4/compiler/Group.g:73:7: ( '[' )
            // org/stringtemplate/v4/compiler/Group.g:73:9: '['
            {
            match('['); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "T__25"

    // $ANTLR start "T__26"
    public final void mT__26() throws RecognitionException {
        try {
            int _type = T__26;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/stringtemplate/v4/compiler/Group.g:74:7: ( ']' )
            // org/stringtemplate/v4/compiler/Group.g:74:9: ']'
            {
            match(']'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "T__26"

    // $ANTLR start "T__27"
    public final void mT__27() throws RecognitionException {
        try {
            int _type = T__27;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/stringtemplate/v4/compiler/Group.g:75:7: ( 'default' )
            // org/stringtemplate/v4/compiler/Group.g:75:9: 'default'
            {
            match("default"); 


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "T__27"

    // $ANTLR start "ID"
    public final void mID() throws RecognitionException {
        try {
            int _type = ID;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/stringtemplate/v4/compiler/Group.g:301:4: ( ( 'a' .. 'z' | 'A' .. 'Z' | '_' ) ( 'a' .. 'z' | 'A' .. 'Z' | '0' .. '9' | '-' | '_' )* )
            // org/stringtemplate/v4/compiler/Group.g:301:6: ( 'a' .. 'z' | 'A' .. 'Z' | '_' ) ( 'a' .. 'z' | 'A' .. 'Z' | '0' .. '9' | '-' | '_' )*
            {
            if ( (input.LA(1)>='A' && input.LA(1)<='Z')||input.LA(1)=='_'||(input.LA(1)>='a' && input.LA(1)<='z') ) {
                input.consume();

            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}

            // org/stringtemplate/v4/compiler/Group.g:301:30: ( 'a' .. 'z' | 'A' .. 'Z' | '0' .. '9' | '-' | '_' )*
            loop1:
            do {
                int alt1=2;
                switch ( input.LA(1) ) {
                case '-':
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case 'A':
                case 'B':
                case 'C':
                case 'D':
                case 'E':
                case 'F':
                case 'G':
                case 'H':
                case 'I':
                case 'J':
                case 'K':
                case 'L':
                case 'M':
                case 'N':
                case 'O':
                case 'P':
                case 'Q':
                case 'R':
                case 'S':
                case 'T':
                case 'U':
                case 'V':
                case 'W':
                case 'X':
                case 'Y':
                case 'Z':
                case '_':
                case 'a':
                case 'b':
                case 'c':
                case 'd':
                case 'e':
                case 'f':
                case 'g':
                case 'h':
                case 'i':
                case 'j':
                case 'k':
                case 'l':
                case 'm':
                case 'n':
                case 'o':
                case 'p':
                case 'q':
                case 'r':
                case 's':
                case 't':
                case 'u':
                case 'v':
                case 'w':
                case 'x':
                case 'y':
                case 'z':
                    {
                    alt1=1;
                    }
                    break;

                }

                switch (alt1) {
            	case 1 :
            	    // org/stringtemplate/v4/compiler/Group.g:
            	    {
            	    if ( input.LA(1)=='-'||(input.LA(1)>='0' && input.LA(1)<='9')||(input.LA(1)>='A' && input.LA(1)<='Z')||input.LA(1)=='_'||(input.LA(1)>='a' && input.LA(1)<='z') ) {
            	        input.consume();

            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;

            	default :
            	    break loop1;
                }
            } while (true);


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "ID"

    // $ANTLR start "STRING"
    public final void mSTRING() throws RecognitionException {
        try {
            int _type = STRING;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/stringtemplate/v4/compiler/Group.g:305:2: ( '\"' ( '\\\\' '\"' | '\\\\' ~ '\"' | '\\n' | ~ ( '\\\\' | '\"' | '\\n' ) )* '\"' )
            // org/stringtemplate/v4/compiler/Group.g:305:4: '\"' ( '\\\\' '\"' | '\\\\' ~ '\"' | '\\n' | ~ ( '\\\\' | '\"' | '\\n' ) )* '\"'
            {
            match('\"'); 
            // org/stringtemplate/v4/compiler/Group.g:306:3: ( '\\\\' '\"' | '\\\\' ~ '\"' | '\\n' | ~ ( '\\\\' | '\"' | '\\n' ) )*
            loop2:
            do {
                int alt2=5;
                int LA2_0 = input.LA(1);

                if ( (LA2_0=='\\') ) {
                    int LA2_2 = input.LA(2);

                    if ( (LA2_2=='\"') ) {
                        alt2=1;
                    }
                    else if ( ((LA2_2>='\u0000' && LA2_2<='!')||(LA2_2>='#' && LA2_2<='\uFFFF')) ) {
                        alt2=2;
                    }


                }
                else if ( (LA2_0=='\n') ) {
                    alt2=3;
                }
                else if ( ((LA2_0>='\u0000' && LA2_0<='\t')||(LA2_0>='\u000B' && LA2_0<='!')||(LA2_0>='#' && LA2_0<='[')||(LA2_0>=']' && LA2_0<='\uFFFF')) ) {
                    alt2=4;
                }


                switch (alt2) {
            	case 1 :
            	    // org/stringtemplate/v4/compiler/Group.g:306:5: '\\\\' '\"'
            	    {
            	    match('\\'); 
            	    match('\"'); 

            	    }
            	    break;
            	case 2 :
            	    // org/stringtemplate/v4/compiler/Group.g:307:5: '\\\\' ~ '\"'
            	    {
            	    match('\\'); 
            	    if ( (input.LA(1)>='\u0000' && input.LA(1)<='!')||(input.LA(1)>='#' && input.LA(1)<='\uFFFF') ) {
            	        input.consume();

            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;
            	case 3 :
            	    // org/stringtemplate/v4/compiler/Group.g:308:5: '\\n'
            	    {

            	    			String msg = "\\n in string";
            	        		NoViableAltException e = new NoViableAltException("", 0, 0, input);
            	    			group.errMgr.groupLexerError(ErrorType.SYNTAX_ERROR, getSourceName(), e, msg);
            	    			
            	    match('\n'); 

            	    }
            	    break;
            	case 4 :
            	    // org/stringtemplate/v4/compiler/Group.g:314:5: ~ ( '\\\\' | '\"' | '\\n' )
            	    {
            	    if ( (input.LA(1)>='\u0000' && input.LA(1)<='\t')||(input.LA(1)>='\u000B' && input.LA(1)<='!')||(input.LA(1)>='#' && input.LA(1)<='[')||(input.LA(1)>=']' && input.LA(1)<='\uFFFF') ) {
            	        input.consume();

            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;

            	default :
            	    break loop2;
                }
            } while (true);

            match('\"'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "STRING"

    // $ANTLR start "BIGSTRING"
    public final void mBIGSTRING() throws RecognitionException {
        try {
            int _type = BIGSTRING;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/stringtemplate/v4/compiler/Group.g:320:2: ( '<<' ( options {greedy=false; } : '\\\\' '>' | '\\\\' ~ '>' | ~ '\\\\' )* '>>' )
            // org/stringtemplate/v4/compiler/Group.g:320:4: '<<' ( options {greedy=false; } : '\\\\' '>' | '\\\\' ~ '>' | ~ '\\\\' )* '>>'
            {
            match("<<"); 

            // org/stringtemplate/v4/compiler/Group.g:321:3: ( options {greedy=false; } : '\\\\' '>' | '\\\\' ~ '>' | ~ '\\\\' )*
            loop3:
            do {
                int alt3=4;
                int LA3_0 = input.LA(1);

                if ( (LA3_0=='>') ) {
                    int LA3_1 = input.LA(2);

                    if ( (LA3_1=='>') ) {
                        alt3=4;
                    }
                    else if ( ((LA3_1>='\u0000' && LA3_1<='=')||(LA3_1>='?' && LA3_1<='\uFFFF')) ) {
                        alt3=3;
                    }


                }
                else if ( (LA3_0=='\\') ) {
                    int LA3_2 = input.LA(2);

                    if ( (LA3_2=='>') ) {
                        alt3=1;
                    }
                    else if ( ((LA3_2>='\u0000' && LA3_2<='=')||(LA3_2>='?' && LA3_2<='\uFFFF')) ) {
                        alt3=2;
                    }


                }
                else if ( ((LA3_0>='\u0000' && LA3_0<='=')||(LA3_0>='?' && LA3_0<='[')||(LA3_0>=']' && LA3_0<='\uFFFF')) ) {
                    alt3=3;
                }


                switch (alt3) {
            	case 1 :
            	    // org/stringtemplate/v4/compiler/Group.g:322:5: '\\\\' '>'
            	    {
            	    match('\\'); 
            	    match('>'); 

            	    }
            	    break;
            	case 2 :
            	    // org/stringtemplate/v4/compiler/Group.g:323:5: '\\\\' ~ '>'
            	    {
            	    match('\\'); 
            	    if ( (input.LA(1)>='\u0000' && input.LA(1)<='=')||(input.LA(1)>='?' && input.LA(1)<='\uFFFF') ) {
            	        input.consume();

            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;
            	case 3 :
            	    // org/stringtemplate/v4/compiler/Group.g:324:5: ~ '\\\\'
            	    {
            	    if ( (input.LA(1)>='\u0000' && input.LA(1)<='[')||(input.LA(1)>=']' && input.LA(1)<='\uFFFF') ) {
            	        input.consume();

            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;

            	default :
            	    break loop3;
                }
            } while (true);

            match(">>"); 


                    String txt = getText().replaceAll("\\\\>",">");;
            		setText(txt);
            		

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "BIGSTRING"

    // $ANTLR start "ANONYMOUS_TEMPLATE"
    public final void mANONYMOUS_TEMPLATE() throws RecognitionException {
        try {
            int _type = ANONYMOUS_TEMPLATE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/stringtemplate/v4/compiler/Group.g:334:5: ( '{' )
            // org/stringtemplate/v4/compiler/Group.g:334:7: '{'
            {
            match('{'); 

            		Token templateToken = new CommonToken(input, ANONYMOUS_TEMPLATE, 0, getCharIndex(), getCharIndex());
            		STLexer lexer =
            			new STLexer(group.errMgr, input, templateToken, group.delimiterStartChar, group.delimiterStopChar);
            		lexer.subtemplateDepth = 1;
            		Token t = lexer.nextToken();
            		while ( lexer.subtemplateDepth>=1 || t.getType()!=STLexer.RCURLY ) {
            			if ( t.getType()==STLexer.EOF_TYPE ) {
                        	MismatchedTokenException e = new MismatchedTokenException('}', input);
            				String msg = "missing final '}' in {...} anonymous template";
                			group.errMgr.groupLexerError(ErrorType.SYNTAX_ERROR, getSourceName(), e, msg);
            				break;
            			}
            			t = lexer.nextToken();
            		}
            		

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "ANONYMOUS_TEMPLATE"

    // $ANTLR start "COMMENT"
    public final void mCOMMENT() throws RecognitionException {
        try {
            int _type = COMMENT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/stringtemplate/v4/compiler/Group.g:356:5: ( '/*' ( options {greedy=false; } : . )* '*/' )
            // org/stringtemplate/v4/compiler/Group.g:356:9: '/*' ( options {greedy=false; } : . )* '*/'
            {
            match("/*"); 

            // org/stringtemplate/v4/compiler/Group.g:356:14: ( options {greedy=false; } : . )*
            loop4:
            do {
                int alt4=2;
                int LA4_0 = input.LA(1);

                if ( (LA4_0=='*') ) {
                    int LA4_1 = input.LA(2);

                    if ( (LA4_1=='/') ) {
                        alt4=2;
                    }
                    else if ( ((LA4_1>='\u0000' && LA4_1<='.')||(LA4_1>='0' && LA4_1<='\uFFFF')) ) {
                        alt4=1;
                    }


                }
                else if ( ((LA4_0>='\u0000' && LA4_0<=')')||(LA4_0>='+' && LA4_0<='\uFFFF')) ) {
                    alt4=1;
                }


                switch (alt4) {
            	case 1 :
            	    // org/stringtemplate/v4/compiler/Group.g:356:42: .
            	    {
            	    matchAny(); 

            	    }
            	    break;

            	default :
            	    break loop4;
                }
            } while (true);

            match("*/"); 

            skip();

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "COMMENT"

    // $ANTLR start "LINE_COMMENT"
    public final void mLINE_COMMENT() throws RecognitionException {
        try {
            int _type = LINE_COMMENT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/stringtemplate/v4/compiler/Group.g:360:5: ( '//' (~ ( '\\n' | '\\r' ) )* ( '\\r' )? '\\n' )
            // org/stringtemplate/v4/compiler/Group.g:360:7: '//' (~ ( '\\n' | '\\r' ) )* ( '\\r' )? '\\n'
            {
            match("//"); 

            // org/stringtemplate/v4/compiler/Group.g:360:12: (~ ( '\\n' | '\\r' ) )*
            loop5:
            do {
                int alt5=2;
                int LA5_0 = input.LA(1);

                if ( ((LA5_0>='\u0000' && LA5_0<='\t')||(LA5_0>='\u000B' && LA5_0<='\f')||(LA5_0>='\u000E' && LA5_0<='\uFFFF')) ) {
                    alt5=1;
                }


                switch (alt5) {
            	case 1 :
            	    // org/stringtemplate/v4/compiler/Group.g:360:12: ~ ( '\\n' | '\\r' )
            	    {
            	    if ( (input.LA(1)>='\u0000' && input.LA(1)<='\t')||(input.LA(1)>='\u000B' && input.LA(1)<='\f')||(input.LA(1)>='\u000E' && input.LA(1)<='\uFFFF') ) {
            	        input.consume();

            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;

            	default :
            	    break loop5;
                }
            } while (true);

            // org/stringtemplate/v4/compiler/Group.g:360:26: ( '\\r' )?
            int alt6=2;
            switch ( input.LA(1) ) {
                case '\r':
                    {
                    alt6=1;
                    }
                    break;
            }

            switch (alt6) {
                case 1 :
                    // org/stringtemplate/v4/compiler/Group.g:360:26: '\\r'
                    {
                    match('\r'); 

                    }
                    break;

            }

            match('\n'); 
            skip();

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "LINE_COMMENT"

    // $ANTLR start "WS"
    public final void mWS() throws RecognitionException {
        try {
            int _type = WS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/stringtemplate/v4/compiler/Group.g:363:5: ( ( ' ' | '\\r' | '\\t' | '\\n' ) )
            // org/stringtemplate/v4/compiler/Group.g:363:7: ( ' ' | '\\r' | '\\t' | '\\n' )
            {
            if ( (input.LA(1)>='\t' && input.LA(1)<='\n')||input.LA(1)=='\r'||input.LA(1)==' ' ) {
                input.consume();

            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}

            skip();

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "WS"

    public void mTokens() throws RecognitionException {
        // org/stringtemplate/v4/compiler/Group.g:1:8: ( TRUE | FALSE | T__13 | T__14 | T__15 | T__16 | T__17 | T__18 | T__19 | T__20 | T__21 | T__22 | T__23 | T__24 | T__25 | T__26 | T__27 | ID | STRING | BIGSTRING | ANONYMOUS_TEMPLATE | COMMENT | LINE_COMMENT | WS )
        int alt7=24;
        alt7 = dfa7.predict(input);
        switch (alt7) {
            case 1 :
                // org/stringtemplate/v4/compiler/Group.g:1:10: TRUE
                {
                mTRUE(); 

                }
                break;
            case 2 :
                // org/stringtemplate/v4/compiler/Group.g:1:15: FALSE
                {
                mFALSE(); 

                }
                break;
            case 3 :
                // org/stringtemplate/v4/compiler/Group.g:1:21: T__13
                {
                mT__13(); 

                }
                break;
            case 4 :
                // org/stringtemplate/v4/compiler/Group.g:1:27: T__14
                {
                mT__14(); 

                }
                break;
            case 5 :
                // org/stringtemplate/v4/compiler/Group.g:1:33: T__15
                {
                mT__15(); 

                }
                break;
            case 6 :
                // org/stringtemplate/v4/compiler/Group.g:1:39: T__16
                {
                mT__16(); 

                }
                break;
            case 7 :
                // org/stringtemplate/v4/compiler/Group.g:1:45: T__17
                {
                mT__17(); 

                }
                break;
            case 8 :
                // org/stringtemplate/v4/compiler/Group.g:1:51: T__18
                {
                mT__18(); 

                }
                break;
            case 9 :
                // org/stringtemplate/v4/compiler/Group.g:1:57: T__19
                {
                mT__19(); 

                }
                break;
            case 10 :
                // org/stringtemplate/v4/compiler/Group.g:1:63: T__20
                {
                mT__20(); 

                }
                break;
            case 11 :
                // org/stringtemplate/v4/compiler/Group.g:1:69: T__21
                {
                mT__21(); 

                }
                break;
            case 12 :
                // org/stringtemplate/v4/compiler/Group.g:1:75: T__22
                {
                mT__22(); 

                }
                break;
            case 13 :
                // org/stringtemplate/v4/compiler/Group.g:1:81: T__23
                {
                mT__23(); 

                }
                break;
            case 14 :
                // org/stringtemplate/v4/compiler/Group.g:1:87: T__24
                {
                mT__24(); 

                }
                break;
            case 15 :
                // org/stringtemplate/v4/compiler/Group.g:1:93: T__25
                {
                mT__25(); 

                }
                break;
            case 16 :
                // org/stringtemplate/v4/compiler/Group.g:1:99: T__26
                {
                mT__26(); 

                }
                break;
            case 17 :
                // org/stringtemplate/v4/compiler/Group.g:1:105: T__27
                {
                mT__27(); 

                }
                break;
            case 18 :
                // org/stringtemplate/v4/compiler/Group.g:1:111: ID
                {
                mID(); 

                }
                break;
            case 19 :
                // org/stringtemplate/v4/compiler/Group.g:1:114: STRING
                {
                mSTRING(); 

                }
                break;
            case 20 :
                // org/stringtemplate/v4/compiler/Group.g:1:121: BIGSTRING
                {
                mBIGSTRING(); 

                }
                break;
            case 21 :
                // org/stringtemplate/v4/compiler/Group.g:1:131: ANONYMOUS_TEMPLATE
                {
                mANONYMOUS_TEMPLATE(); 

                }
                break;
            case 22 :
                // org/stringtemplate/v4/compiler/Group.g:1:150: COMMENT
                {
                mCOMMENT(); 

                }
                break;
            case 23 :
                // org/stringtemplate/v4/compiler/Group.g:1:158: LINE_COMMENT
                {
                mLINE_COMMENT(); 

                }
                break;
            case 24 :
                // org/stringtemplate/v4/compiler/Group.g:1:171: WS
                {
                mWS(); 

                }
                break;

        }

    }


    protected DFA7 dfa7 = new DFA7(this);
    static final String DFA7_eotS =
        "\1\uffff\3\20\1\uffff\1\20\1\33\10\uffff\1\20\6\uffff\4\20\2\uffff"+
        "\1\20\2\uffff\5\20\1\52\5\20\1\uffff\1\60\2\20\1\63\1\20\1\uffff"+
        "\1\65\1\20\1\uffff\1\20\1\uffff\1\20\1\71\1\20\1\uffff\1\20\1\74"+
        "\1\uffff";
    static final String DFA7_eofS =
        "\75\uffff";
    static final String DFA7_minS =
        "\1\11\1\162\1\141\1\155\1\uffff\1\162\1\72\10\uffff\1\145\4\uffff"+
        "\1\52\1\uffff\1\165\1\154\1\160\1\157\2\uffff\1\146\2\uffff\1\145"+
        "\1\163\1\154\1\165\1\141\1\55\1\145\1\162\1\145\1\160\1\165\1\uffff"+
        "\1\55\1\164\1\155\1\55\1\154\1\uffff\1\55\1\145\1\uffff\1\164\1"+
        "\uffff\1\156\1\55\1\164\1\uffff\1\163\1\55\1\uffff";
    static final String DFA7_maxS =
        "\1\173\1\162\1\141\1\155\1\uffff\1\162\1\72\10\uffff\1\145\4\uffff"+
        "\1\57\1\uffff\1\165\1\154\1\160\1\157\2\uffff\1\146\2\uffff\1\145"+
        "\1\163\1\157\1\165\1\141\1\172\1\145\1\162\1\145\1\160\1\165\1\uffff"+
        "\1\172\1\164\1\155\1\172\1\154\1\uffff\1\172\1\145\1\uffff\1\164"+
        "\1\uffff\1\156\1\172\1\164\1\uffff\1\163\1\172\1\uffff";
    static final String DFA7_acceptS =
        "\4\uffff\1\4\2\uffff\1\10\1\11\1\12\1\13\1\14\1\16\1\17\1\20\1\uffff"+
        "\1\22\1\23\1\24\1\25\1\uffff\1\30\4\uffff\1\15\1\6\1\uffff\1\26"+
        "\1\27\13\uffff\1\1\5\uffff\1\2\2\uffff\1\5\1\uffff\1\3\3\uffff\1"+
        "\21\2\uffff\1\7";
    static final String DFA7_specialS =
        "\75\uffff}>";
    static final String[] DFA7_transitionS = {
            "\2\25\2\uffff\1\25\22\uffff\1\25\1\uffff\1\21\5\uffff\1\12\1"+
            "\13\2\uffff\1\7\1\uffff\1\4\1\24\12\uffff\1\6\1\10\1\22\1\14"+
            "\2\uffff\1\11\32\20\1\15\1\uffff\1\16\1\uffff\1\20\1\uffff\3"+
            "\20\1\17\1\20\1\2\1\5\1\20\1\3\12\20\1\1\6\20\1\23",
            "\1\26",
            "\1\27",
            "\1\30",
            "",
            "\1\31",
            "\1\32",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\34",
            "",
            "",
            "",
            "",
            "\1\35\4\uffff\1\36",
            "",
            "\1\37",
            "\1\40",
            "\1\41",
            "\1\42",
            "",
            "",
            "\1\43",
            "",
            "",
            "\1\44",
            "\1\45",
            "\1\47\2\uffff\1\46",
            "\1\50",
            "\1\51",
            "\1\20\2\uffff\12\20\7\uffff\32\20\4\uffff\1\20\1\uffff\32\20",
            "\1\53",
            "\1\54",
            "\1\55",
            "\1\56",
            "\1\57",
            "",
            "\1\20\2\uffff\12\20\7\uffff\32\20\4\uffff\1\20\1\uffff\32\20",
            "\1\61",
            "\1\62",
            "\1\20\2\uffff\12\20\7\uffff\32\20\4\uffff\1\20\1\uffff\32\20",
            "\1\64",
            "",
            "\1\20\2\uffff\12\20\7\uffff\32\20\4\uffff\1\20\1\uffff\32\20",
            "\1\66",
            "",
            "\1\67",
            "",
            "\1\70",
            "\1\20\2\uffff\12\20\7\uffff\32\20\4\uffff\1\20\1\uffff\32\20",
            "\1\72",
            "",
            "\1\73",
            "\1\20\2\uffff\12\20\7\uffff\32\20\4\uffff\1\20\1\uffff\32\20",
            ""
    };

    static final short[] DFA7_eot = DFA.unpackEncodedString(DFA7_eotS);
    static final short[] DFA7_eof = DFA.unpackEncodedString(DFA7_eofS);
    static final char[] DFA7_min = DFA.unpackEncodedStringToUnsignedChars(DFA7_minS);
    static final char[] DFA7_max = DFA.unpackEncodedStringToUnsignedChars(DFA7_maxS);
    static final short[] DFA7_accept = DFA.unpackEncodedString(DFA7_acceptS);
    static final short[] DFA7_special = DFA.unpackEncodedString(DFA7_specialS);
    static final short[][] DFA7_transition;

    static {
        int numStates = DFA7_transitionS.length;
        DFA7_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA7_transition[i] = DFA.unpackEncodedString(DFA7_transitionS[i]);
        }
    }

    class DFA7 extends DFA {

        public DFA7(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 7;
            this.eot = DFA7_eot;
            this.eof = DFA7_eof;
            this.min = DFA7_min;
            this.max = DFA7_max;
            this.accept = DFA7_accept;
            this.special = DFA7_special;
            this.transition = DFA7_transition;
        }
        public String getDescription() {
            return "1:1: Tokens : ( TRUE | FALSE | T__13 | T__14 | T__15 | T__16 | T__17 | T__18 | T__19 | T__20 | T__21 | T__22 | T__23 | T__24 | T__25 | T__26 | T__27 | ID | STRING | BIGSTRING | ANONYMOUS_TEMPLATE | COMMENT | LINE_COMMENT | WS );";
        }
    }
 

}