/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import java.util.HashMap;
import org.altbeacon.beacon.Beacon;

public class GattBeaconTracker {
    private static final String TAG = "BeaconTracker";
    private HashMap<Integer, Beacon> mBeacons = new HashMap();
    private HashMap<String, HashMap<Integer, Beacon>> mBeaconsByServiceUuidAndMac = new HashMap();

    public synchronized Beacon track(Beacon beacon) {
        Beacon trackedBeacon = null;
        trackedBeacon = beacon.getServiceUuid() != -1 ? this.trackGattBeacon(beacon) : beacon;
        return trackedBeacon;
    }

    private Beacon trackGattBeacon(Beacon beacon) {
        Beacon trackedBeacon = null;
        HashMap<Integer, Beacon> matchingTrackedBeacons = this.mBeaconsByServiceUuidAndMac.get(this.serviceUuidAndMac(beacon));
        if (matchingTrackedBeacons != null) {
            for (Beacon matchingTrackedBeacon : matchingTrackedBeacons.values()) {
                if (beacon.isExtraBeaconData()) {
                    matchingTrackedBeacon.setRssi(beacon.getRssi());
                    matchingTrackedBeacon.setExtraDataFields(beacon.getDataFields());
                    continue;
                }
                beacon.setExtraDataFields(matchingTrackedBeacon.getExtraDataFields());
                trackedBeacon = beacon;
            }
        }
        if (!beacon.isExtraBeaconData()) {
            this.updateTrackingHashes(beacon, matchingTrackedBeacons);
        }
        if (trackedBeacon == null && !beacon.isExtraBeaconData()) {
            trackedBeacon = beacon;
        }
        return trackedBeacon;
    }

    private void updateTrackingHashes(Beacon trackedBeacon, HashMap<Integer, Beacon> matchingTrackedBeacons) {
        if (matchingTrackedBeacons == null) {
            matchingTrackedBeacons = new HashMap();
            this.mBeaconsByServiceUuidAndMac.put(this.serviceUuidAndMac(trackedBeacon), matchingTrackedBeacons);
        }
        this.mBeacons.put(trackedBeacon.hashCode(), trackedBeacon);
        matchingTrackedBeacons.put(trackedBeacon.hashCode(), trackedBeacon);
    }

    private String serviceUuidAndMac(Beacon beacon) {
        return beacon.getBluetoothAddress() + beacon.getServiceUuid();
    }
}

