/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlBeaconUrlCompressor {
    private static final String EXPANSION_CODE_URL_REGEX = "^(http|https):\\/\\/(www.)?((?:[0-9a-z_-]+\\.??)+)(\\.[0-9a-z_-]+\\/?)(.*)$";
    private static final int EXPANSION_CODE_URL_PROTOCOL_GROUP = 1;
    private static final int EXPANSION_CODE_URL_WWW_GROUP = 2;
    private static final int EXPANSION_CODE_URL_HOST_GROUP = 3;
    private static final int EXPANSION_CODE_URL_TLD_GROUP = 4;
    private static final int EXPANSION_CODE_URL_PATH_GROUP = 5;
    private static final String URL_PROTOCOL_HTTP = "http";
    private static final String URL_PROTOCOL_HTTPS = "https";
    private static final String URL_HOST_WWW = "www.";
    private static final String URL_TLD_DOT_COM = ".com";
    private static final String URL_TLD_DOT_ORG = ".org";
    private static final String URL_TLD_DOT_EDU = ".edu";
    private static final String URL_TLD_DOT_NET = ".net";
    private static final String URL_TLD_DOT_INFO = ".info";
    private static final String URL_TLD_DOT_BIZ = ".biz";
    private static final String URL_TLD_DOT_GOV = ".gov";
    private static final String URL_TLD_DOT_COM_SLASH = ".com/";
    private static final String URL_TLD_DOT_ORG_SLASH = ".org/";
    private static final String URL_TLD_DOT_EDU_SLASH = ".edu/";
    private static final String URL_TLD_DOT_NET_SLASH = ".net/";
    private static final String URL_TLD_DOT_INFO_SLASH = ".info/";
    private static final String URL_TLD_DOT_BIZ_SLASH = ".biz/";
    private static final String URL_TLD_DOT_GOV_SLASH = ".gov/";
    private static final byte EXPANSION_CODE_URL_PROTOCOL_HTTP_WWW = 0;
    private static final byte EXPANSION_CODE_URL_PROTOCOL_HTTPS_WWW = 1;
    private static final byte EXPANSION_CODE_URL_PROTOCOL_HTTP = 2;
    private static final byte EXPANSION_CODE_URL_PROTOCOL_HTTPS = 3;
    private static final byte EXPANSION_CODE_URL_COM_SLASH = 0;
    private static final byte EXPANSION_CODE_URL_ORG_SLASH = 1;
    private static final byte EXPANSION_CODE_URL_EDU_SLASH = 2;
    private static final byte EXPANSION_CODE_URL_NET_SLASH = 3;
    private static final byte EXPANSION_CODE_URL_INFO_SLASH = 4;
    private static final byte EXPANSION_CODE_URL_BIZ_SLASH = 5;
    private static final byte EXPANSION_CODE_URL_GOV_SLASH = 6;
    private static final byte EXPANSION_CODE_URL_COM = 7;
    private static final byte EXPANSION_CODE_URL_ORG = 8;
    private static final byte EXPANSION_CODE_URL_EDU = 9;
    private static final byte EXPANSION_CODE_URL_NET = 10;
    private static final byte EXPANSION_CODE_URL_INFO = 11;
    private static final byte EXPANSION_CODE_URL_BIZ = 12;
    private static final byte EXPANSION_CODE_URL_GOV = 13;
    private static final byte TLD_NOT_ENCODABLE = -1;
    private static List<TLDMapEntry> tldMap = new ArrayList<TLDMapEntry>();

    private static byte encodedByteForTopLevelDomain(String tld) {
        byte encodedByte = -1;
        boolean tldFound = false;
        boolean tldMapIndex = false;
        Iterator<TLDMapEntry> iterator = tldMap.iterator();
        while (!tldFound && iterator.hasNext()) {
            TLDMapEntry entry = iterator.next();
            tldFound = entry.tld.equalsIgnoreCase(tld);
            if (!tldFound) continue;
            encodedByte = entry.encodedByte;
        }
        return encodedByte;
    }

    public static byte[] compress(String urlString) {
        byte[] compressedBytes = null;
        if (urlString != null) {
            byte[] byteBuffer = new byte[urlString.length()];
            int byteBufferIndex = 0;
            Arrays.fill(byteBuffer, (byte)0);
            Pattern urlPattern = Pattern.compile(EXPANSION_CODE_URL_REGEX);
            Matcher urlMatcher = urlPattern.matcher(urlString);
            if (urlMatcher.matches()) {
                String path;
                byte encodedTLDByte;
                String wwwdot = urlMatcher.group(2);
                boolean haswww = wwwdot != null;
                String protocol = urlMatcher.group(1);
                byteBuffer[byteBufferIndex] = protocol.equalsIgnoreCase(URL_PROTOCOL_HTTP) ? (haswww ? 0 : 2) : (haswww ? 1 : 3);
                byte[] hostnameBytes = urlMatcher.group(3).getBytes();
                int hostnameLength = hostnameBytes.length;
                System.arraycopy(hostnameBytes, 0, byteBuffer, ++byteBufferIndex, hostnameLength);
                byteBufferIndex += hostnameLength;
                String tld = urlMatcher.group(4);
                if (tld != null && (encodedTLDByte = UrlBeaconUrlCompressor.encodedByteForTopLevelDomain(tld)) != -1) {
                    byteBuffer[byteBufferIndex++] = encodedTLDByte;
                }
                if ((path = urlMatcher.group(5)) != null) {
                    int pathLength = path.length();
                    System.arraycopy(path.getBytes(), 0, byteBuffer, byteBufferIndex, pathLength);
                    byteBufferIndex += pathLength;
                }
                compressedBytes = new byte[byteBufferIndex];
                System.arraycopy(byteBuffer, 0, compressedBytes, 0, compressedBytes.length);
            }
        }
        return compressedBytes;
    }

    public static String uncompress(byte[] compressedURL) {
        StringBuffer url = new StringBuffer();
        switch (compressedURL[0] & 0xF) {
            case 0: {
                url.append("http://www.");
                break;
            }
            case 1: {
                url.append("https://www.");
                break;
            }
            case 2: {
                url.append("http://");
                break;
            }
            case 3: {
                url.append("https://");
                break;
            }
        }
        int lastByte = -1;
        block22: for (int i = 1; i < compressedURL.length; ++i) {
            int b = compressedURL[i];
            if (lastByte <= 13 && b == 0) break;
            lastByte = b;
            switch (b) {
                case 0: {
                    url.append(URL_TLD_DOT_COM);
                    continue block22;
                }
                case 1: {
                    url.append(URL_TLD_DOT_ORG);
                    continue block22;
                }
                case 2: {
                    url.append(URL_TLD_DOT_EDU);
                    continue block22;
                }
                case 3: {
                    url.append(URL_TLD_DOT_NET);
                    continue block22;
                }
                case 4: {
                    url.append(URL_TLD_DOT_INFO);
                    continue block22;
                }
                case 5: {
                    url.append(URL_TLD_DOT_BIZ);
                    continue block22;
                }
                case 6: {
                    url.append(URL_TLD_DOT_GOV);
                    continue block22;
                }
                case 7: {
                    url.append(URL_TLD_DOT_COM);
                    continue block22;
                }
                case 8: {
                    url.append(URL_TLD_DOT_ORG);
                    continue block22;
                }
                case 9: {
                    url.append(URL_TLD_DOT_EDU);
                    continue block22;
                }
                case 10: {
                    url.append(URL_TLD_DOT_NET);
                    continue block22;
                }
                case 11: {
                    url.append(URL_TLD_DOT_INFO);
                    continue block22;
                }
                case 12: {
                    url.append(URL_TLD_DOT_BIZ);
                    continue block22;
                }
                case 13: {
                    url.append("gov");
                    continue block22;
                }
                default: {
                    url.append((char)b);
                }
            }
        }
        return url.toString();
    }

    static {
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_COM_SLASH, 0));
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_ORG_SLASH, 1));
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_EDU_SLASH, 2));
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_NET_SLASH, 3));
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_INFO_SLASH, 4));
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_BIZ_SLASH, 5));
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_GOV_SLASH, 6));
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_COM, 7));
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_ORG, 8));
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_EDU, 9));
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_NET, 10));
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_INFO, 11));
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_BIZ, 12));
        tldMap.add(new TLDMapEntry(URL_TLD_DOT_GOV, 13));
    }

    private static class TLDMapEntry {
        public final String tld;
        public final byte encodedByte;

        public TLDMapEntry(String topLevelDomain, byte encodedTLDByte) {
            this.tld = topLevelDomain;
            this.encodedByte = encodedTLDByte;
        }
    }
}

