/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service.scanner;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import java.util.ArrayList;
import java.util.List;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.DetectionTracker;
import org.altbeacon.beacon.service.scanner.CycledLeScanCallback;
import org.altbeacon.beacon.service.scanner.CycledLeScanner;
import org.altbeacon.beacon.service.scanner.ScanFilterUtils;
import org.altbeacon.bluetooth.BluetoothCrashResolver;

@TargetApi(value=21)
public class CycledLeScannerForLollipop
extends CycledLeScanner {
    private static final String TAG = "CycledLeScannerForLollipop";
    private static final long BACKGROUND_L_SCAN_DETECTION_PERIOD_MILLIS = 10000L;
    private BluetoothLeScanner mScanner;
    private ScanCallback leScanCallback;
    private long mBackgroundLScanStartTime = 0L;
    private long mBackgroundLScanFirstDetectionTime = 0L;
    private boolean mScanDeferredBefore = false;
    private BeaconManager mBeaconManager = BeaconManager.getInstanceForApplication(this.mContext);

    public CycledLeScannerForLollipop(Context context, long scanPeriod, long betweenScanPeriod, boolean backgroundFlag, CycledLeScanCallback cycledLeScanCallback, BluetoothCrashResolver crashResolver) {
        super(context, scanPeriod, betweenScanPeriod, backgroundFlag, cycledLeScanCallback, crashResolver);
    }

    @Override
    protected void stopScan() {
        try {
            if (this.getScanner() != null) {
                try {
                    this.getScanner().stopScan(this.getNewLeScanCallback());
                }
                catch (NullPointerException npe) {
                    LogManager.e(TAG, "Cannot stop scan.  Unexpected NPE.", npe);
                }
            }
        }
        catch (IllegalStateException e) {
            LogManager.w(TAG, "Cannot stop scan.  Bluetooth may be turned off.", new Object[0]);
        }
    }

    @Override
    protected boolean deferScanIfNeeded() {
        long millisecondsUntilStart = this.mNextScanCycleStartTime - System.currentTimeMillis();
        if (millisecondsUntilStart > 0L) {
            long secsSinceLastDetection = System.currentTimeMillis() - DetectionTracker.getInstance().getLastDetectionTime();
            if (!this.mScanDeferredBefore) {
                if (secsSinceLastDetection > 10000L) {
                    this.mBackgroundLScanStartTime = System.currentTimeMillis();
                    this.mBackgroundLScanFirstDetectionTime = 0L;
                    LogManager.d(TAG, "This is Android L. Doing a filtered scan for the background.", new Object[0]);
                    ScanSettings settings = new ScanSettings.Builder().setScanMode(0).build();
                    this.startScan();
                } else {
                    LogManager.d(TAG, "This is Android L, but we last saw a beacon only %s ago, so we will not keep scanning in background.", secsSinceLastDetection);
                }
            }
            if (this.mBackgroundLScanStartTime > 0L && DetectionTracker.getInstance().getLastDetectionTime() > this.mBackgroundLScanStartTime) {
                if (this.mBackgroundLScanFirstDetectionTime == 0L) {
                    this.mBackgroundLScanFirstDetectionTime = DetectionTracker.getInstance().getLastDetectionTime();
                }
                if (System.currentTimeMillis() - this.mBackgroundLScanFirstDetectionTime >= 10000L) {
                    LogManager.d(TAG, "We've been detecting for a bit.  Stopping Android L background scanning", new Object[0]);
                    this.stopScan();
                    this.mBackgroundLScanStartTime = 0L;
                } else {
                    LogManager.d(TAG, "Delivering Android L background scanning results", new Object[0]);
                    this.mCycledLeScanCallback.onCycleEnd();
                }
            }
            LogManager.d(TAG, "Waiting to start full Bluetooth scan for another %s milliseconds", millisecondsUntilStart);
            if (!this.mScanDeferredBefore && this.mBackgroundFlag) {
                this.setWakeUpAlarm();
            }
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    CycledLeScannerForLollipop.this.scanLeDevice(true);
                }
            }, millisecondsUntilStart > 1000L ? 1000L : millisecondsUntilStart);
            this.mScanDeferredBefore = true;
            return true;
        }
        if (this.mBackgroundLScanStartTime > 0L) {
            this.stopScan();
            this.mBackgroundLScanStartTime = 0L;
        }
        this.mScanDeferredBefore = false;
        return false;
    }

    @Override
    protected void startScan() {
        ScanSettings settings;
        ArrayList filters = new ArrayList();
        if (this.mBackgroundFlag) {
            LogManager.d(TAG, "starting scan in SCAN_MODE_LOW_POWER", new Object[0]);
            settings = new ScanSettings.Builder().setScanMode(0).build();
        } else {
            LogManager.d(TAG, "starting scan in SCAN_MODE_LOW_LATENCY", new Object[0]);
            settings = new ScanSettings.Builder().setScanMode(2).build();
        }
        try {
            if (this.getScanner() != null) {
                List<ScanFilter> scanFilters = new ScanFilterUtils().createScanFiltersForBeaconParsers(this.mBeaconManager.getBeaconParsers());
                ScanCallback callback = this.getNewLeScanCallback();
                try {
                    this.getScanner().startScan(scanFilters, settings, callback);
                }
                catch (NullPointerException npe) {
                    LogManager.w(TAG, "Cannot start scan.  Unexpected NPE.", npe);
                }
            }
        }
        catch (IllegalStateException e) {
            LogManager.w(TAG, "Cannot start scan.  Bluetooth may be turned off.", new Object[0]);
        }
    }

    @Override
    protected void finishScan() {
        this.stopScan();
        this.mScanningPaused = true;
    }

    private BluetoothLeScanner getScanner() {
        if (this.mScanner == null) {
            LogManager.d(TAG, "Making new Android L scanner", new Object[0]);
            BluetoothAdapter bluetoothAdapter = this.getBluetoothAdapter();
            if (bluetoothAdapter != null) {
                this.mScanner = this.getBluetoothAdapter().getBluetoothLeScanner();
            }
            if (this.mScanner == null) {
                LogManager.w(TAG, "Failed to make new Android L scanner", new Object[0]);
            }
        }
        return this.mScanner;
    }

    private ScanCallback getNewLeScanCallback() {
        if (this.leScanCallback == null) {
            this.leScanCallback = new ScanCallback(){

                public void onScanResult(int callbackType, ScanResult scanResult) {
                    LogManager.d(CycledLeScannerForLollipop.TAG, "got record", new Object[0]);
                    CycledLeScannerForLollipop.this.mCycledLeScanCallback.onLeScan(scanResult.getDevice(), scanResult.getRssi(), scanResult.getScanRecord().getBytes());
                    if (CycledLeScannerForLollipop.this.mBackgroundLScanStartTime > 0L) {
                        LogManager.d(CycledLeScannerForLollipop.TAG, "got a filtered scan result in the background.", new Object[0]);
                    }
                }

                public void onBatchScanResults(List<ScanResult> results) {
                    LogManager.d(CycledLeScannerForLollipop.TAG, "got batch records", new Object[0]);
                    for (ScanResult scanResult : results) {
                        CycledLeScannerForLollipop.this.mCycledLeScanCallback.onLeScan(scanResult.getDevice(), scanResult.getRssi(), scanResult.getScanRecord().getBytes());
                    }
                    if (CycledLeScannerForLollipop.this.mBackgroundLScanStartTime > 0L) {
                        LogManager.d(CycledLeScannerForLollipop.TAG, "got a filtered batch scan result in the background.", new Object[0]);
                    }
                }

                public void onScanFailed(int i) {
                    LogManager.e(CycledLeScannerForLollipop.TAG, "Scan Failed", new Object[0]);
                }
            };
        }
        return this.leScanCallback;
    }
}

