/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.os.SystemClock;
import java.io.Serializable;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.Callback;

public class RegionMonitoringState
implements Serializable {
    private static final String TAG = RegionMonitoringState.class.getSimpleName();
    private boolean inside = false;
    private long lastSeenTime = 0L;
    private final Callback callback;
    private transient boolean activeSinceAppLaunch = false;

    public RegionMonitoringState(Callback c) {
        this.callback = c;
    }

    public Callback getCallback() {
        return this.callback;
    }

    public boolean markInside() {
        this.lastSeenTime = SystemClock.elapsedRealtime();
        if (!this.inside) {
            this.inside = true;
            return true;
        }
        return false;
    }

    public void markOutside() {
        this.inside = false;
        this.lastSeenTime = 0L;
    }

    public boolean markOutsideIfExpired() {
        if (this.inside && this.lastSeenTime > 0L && SystemClock.elapsedRealtime() - this.lastSeenTime > BeaconManager.getRegionExitPeriod()) {
            LogManager.d(TAG, "We are newly outside the region because the lastSeenTime of %s was %s seconds ago, and that is over the expiration duration of %s", this.lastSeenTime, SystemClock.elapsedRealtime() - this.lastSeenTime, BeaconManager.getRegionExitPeriod());
            this.markOutside();
            return true;
        }
        return false;
    }

    public boolean getInside() {
        return this.inside;
    }

    public boolean getActiveSinceAppLaunch() {
        return this.activeSinceAppLaunch;
    }

    public void setActiveSinceAppLaunch(boolean active) {
        this.activeSinceAppLaunch = active;
    }
}

