/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.powersave;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Bundle;
import android.os.PowerManager;
import androidx.annotation.NonNull;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.logging.LogManager;

@TargetApi(value=18)
public class BackgroundPowerSaverInternal
implements Application.ActivityLifecycleCallbacks {
    @NonNull
    private static final String TAG = "BackgroundPowerSaver";
    @NonNull
    private final BeaconManager beaconManager;
    @NonNull
    private final Context applicationContext;
    private int activeActivityCount = 0;
    private BroadcastReceiver screenOffReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            BackgroundPowerSaverInternal.this.inferBackground("the screen going off");
            BackgroundPowerSaverInternal.this.applicationContext.getApplicationContext().unregisterReceiver(BackgroundPowerSaverInternal.this.screenOffReceiver);
        }
    };

    public BackgroundPowerSaverInternal(Context context) {
        if (Build.VERSION.SDK_INT < 18) {
            LogManager.w(TAG, "BackgroundPowerSaver requires API 18 or higher.", new Object[0]);
        }
        this.applicationContext = context.getApplicationContext();
        this.beaconManager = BeaconManager.getInstanceForApplication(this.applicationContext);
        ((Application)this.applicationContext).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        ++this.activeActivityCount;
        if (this.activeActivityCount < 1) {
            LogManager.d(TAG, "reset active activity count on resume.  It was %s", this.activeActivityCount);
            this.activeActivityCount = 1;
        }
        this.beaconManager.setBackgroundMode(false);
        LogManager.d(TAG, "activity resumed: %s active activities: %s", activity, this.activeActivityCount);
        BeaconManager.getInstanceForApplication(this.applicationContext).retryForegroundServiceScanning();
    }

    public void onActivityPaused(Activity activity) {
        --this.activeActivityCount;
        LogManager.d(TAG, "activity paused: %s active activities: %s", activity, this.activeActivityCount);
        if (this.activeActivityCount < 1) {
            LogManager.d(TAG, "setting background mode", new Object[0]);
            this.beaconManager.setBackgroundMode(true);
        }
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public void enableDefaultBackgroundStateInference() {
        if (this.beaconManager.isBackgroundModeUninitialized()) {
            if (this.methodCalledByApplicationOnCreate()) {
                this.inferBackground("application.onCreate in the call stack");
            } else {
                PowerManager powerManager = (PowerManager)this.applicationContext.getSystemService("power");
                boolean screenOffNow = false;
                if (Build.VERSION.SDK_INT >= 20) {
                    boolean bl = screenOffNow = !powerManager.isInteractive();
                }
                if (screenOffNow) {
                    this.inferBackground("the screen being off");
                } else {
                    IntentFilter filter = new IntentFilter("android.intent.action.SCREEN_OFF");
                    this.applicationContext.getApplicationContext().registerReceiver(this.screenOffReceiver, filter);
                }
            }
        }
        if (this.beaconManager.isBackgroundModeUninitialized()) {
            LogManager.i(TAG, "Background mode not set.  We assume we are in the foreground.", new Object[0]);
        }
    }

    private void inferBackground(String inferenceMechanism) {
        if (this.beaconManager.isBackgroundModeUninitialized()) {
            LogManager.i(TAG, "We have inferred by " + inferenceMechanism + " that we are in the background.", new Object[0]);
            this.beaconManager.setBackgroundModeInternal(true);
        }
    }

    private boolean methodCalledByApplicationOnCreate() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        String targetMethodname = "onCreate";
        String targetClassname = Application.class.getCanonicalName();
        for (StackTraceElement element : stackTraceElements) {
            if (!targetMethodname.equals(element.getMethodName())) continue;
            if (targetClassname.equals(element.getClassName())) {
                return true;
            }
            if (element.getClassName() == null) continue;
            try {
                Class<?> c = Class.forName(element.getClassName());
                while ((c = c.getSuperclass()) != null) {
                    String superclassname = c.getCanonicalName();
                    if (!targetClassname.equals(superclassname)) continue;
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }
}

