/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.distance;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.altbeacon.beacon.distance.AndroidModel;
import org.altbeacon.beacon.distance.CurveFittedDistanceCalculator;
import org.altbeacon.beacon.distance.DistanceCalculator;
import org.altbeacon.beacon.distance.ModelSpecificDistanceUpdater;
import org.altbeacon.beacon.logging.LogManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ModelSpecificDistanceCalculator
implements DistanceCalculator {
    Map<AndroidModel, DistanceCalculator> mModelMap;
    private static final String CONFIG_FILE = "model-distance-calculations.json";
    private static final String TAG = "ModelSpecificDistanceCalculator";
    private AndroidModel mDefaultModel;
    private DistanceCalculator mDistanceCalculator;
    private AndroidModel mModel;
    private AndroidModel mRequestedModel;
    private String mRemoteUpdateUrlString = null;
    private Context mContext;
    private final ReentrantLock mLock = new ReentrantLock();

    public ModelSpecificDistanceCalculator(Context context, String remoteUpdateUrlString) {
        this(context, remoteUpdateUrlString, AndroidModel.forThisDevice());
    }

    public ModelSpecificDistanceCalculator(Context context, String remoteUpdateUrlString, AndroidModel model) {
        this.mRequestedModel = model;
        this.mRemoteUpdateUrlString = remoteUpdateUrlString;
        this.mContext = context;
        this.loadModelMap();
        this.mDistanceCalculator = this.findCalculatorForModelWithLock(model);
    }

    public AndroidModel getModel() {
        return this.mModel;
    }

    public AndroidModel getRequestedModel() {
        return this.mRequestedModel;
    }

    @Override
    public double calculateDistance(int txPower, double rssi) {
        if (this.mDistanceCalculator == null) {
            LogManager.w(TAG, "distance calculator has not been set", new Object[0]);
            return -1.0;
        }
        return this.mDistanceCalculator.calculateDistance(txPower, rssi);
    }

    DistanceCalculator findCalculatorForModelWithLock(AndroidModel model) {
        this.mLock.lock();
        try {
            DistanceCalculator distanceCalculator = this.findCalculatorForModel(model);
            return distanceCalculator;
        }
        finally {
            this.mLock.unlock();
        }
    }

    private DistanceCalculator findCalculatorForModel(AndroidModel model) {
        LogManager.d(TAG, "Finding best distance calculator for %s, %s, %s, %s", model.getVersion(), model.getBuildNumber(), model.getModel(), model.getManufacturer());
        if (this.mModelMap == null) {
            LogManager.d(TAG, "Cannot get distance calculator because modelMap was never initialized", new Object[0]);
            return null;
        }
        int highestScore = 0;
        AndroidModel bestMatchingModel = null;
        for (AndroidModel candidateModel : this.mModelMap.keySet()) {
            if (candidateModel.matchScore(model) <= highestScore) continue;
            highestScore = candidateModel.matchScore(model);
            bestMatchingModel = candidateModel;
        }
        if (bestMatchingModel != null) {
            LogManager.d(TAG, "found a match with score %s", highestScore);
            LogManager.d(TAG, "Finding best distance calculator for %s, %s, %s, %s", bestMatchingModel.getVersion(), bestMatchingModel.getBuildNumber(), bestMatchingModel.getModel(), bestMatchingModel.getManufacturer());
            this.mModel = bestMatchingModel;
        } else {
            this.mModel = this.mDefaultModel;
            LogManager.w(TAG, "Cannot find match for this device.  Using default", new Object[0]);
        }
        return this.mModelMap.get(this.mModel);
    }

    private void loadModelMap() {
        boolean mapLoaded = false;
        if (this.mRemoteUpdateUrlString != null && !(mapLoaded = this.loadModelMapFromStorage())) {
            this.requestModelMapFromWeb();
        }
        if (!mapLoaded) {
            this.loadDefaultModelMap();
        }
        this.mDistanceCalculator = this.findCalculatorForModelWithLock(this.mRequestedModel);
    }

    private SharedPreferences getSharedPreferences() {
        return this.mContext.getSharedPreferences("org.altbeacon.beacon", 0);
    }

    private boolean loadModelMapFromStorage() {
        String jsonString = this.getSharedPreferences().getString(CONFIG_FILE, null);
        if (jsonString == null) {
            return false;
        }
        try {
            this.buildModelMapWithLock(jsonString);
            return true;
        }
        catch (JSONException e) {
            LogManager.e(e, TAG, "Cannot update distance models from online database at %s with JSON: %s", this.mRemoteUpdateUrlString, jsonString);
            return false;
        }
    }

    private boolean saveJson(String jsonString) {
        this.getSharedPreferences().edit().putString(CONFIG_FILE, jsonString).commit();
        return true;
    }

    @TargetApi(value=11)
    private void requestModelMapFromWeb() {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.INTERNET") != 0) {
            LogManager.w(TAG, "App has no android.permission.INTERNET permission.  Cannot check for distance model updates", new Object[0]);
            return;
        }
        new ModelSpecificDistanceUpdater(this.mContext, this.mRemoteUpdateUrlString, new ModelSpecificDistanceUpdater.CompletionHandler(){

            @Override
            public void onComplete(String body, Exception ex, int code) {
                if (ex != null) {
                    LogManager.w(ModelSpecificDistanceCalculator.TAG, "Cannot updated distance models from online database at %s", ex, ModelSpecificDistanceCalculator.this.mRemoteUpdateUrlString);
                } else if (code != 200) {
                    LogManager.w(ModelSpecificDistanceCalculator.TAG, "Cannot updated distance models from online database at %s due to HTTP status code %s", ModelSpecificDistanceCalculator.this.mRemoteUpdateUrlString, code);
                } else {
                    LogManager.d(ModelSpecificDistanceCalculator.TAG, "Successfully downloaded distance models from online database at %s", ModelSpecificDistanceCalculator.this.mRemoteUpdateUrlString);
                    try {
                        ModelSpecificDistanceCalculator.this.buildModelMapWithLock(body);
                        if (ModelSpecificDistanceCalculator.this.saveJson(body)) {
                            ModelSpecificDistanceCalculator.this.loadModelMapFromStorage();
                            ModelSpecificDistanceCalculator.this.mDistanceCalculator = ModelSpecificDistanceCalculator.this.findCalculatorForModelWithLock(ModelSpecificDistanceCalculator.this.mRequestedModel);
                            LogManager.i(ModelSpecificDistanceCalculator.TAG, "Successfully updated distance model with latest from online database", new Object[0]);
                        }
                    }
                    catch (JSONException e) {
                        LogManager.w(e, ModelSpecificDistanceCalculator.TAG, "Cannot parse json from downloaded distance model", new Object[0]);
                    }
                }
            }
        }).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    void buildModelMapWithLock(String jsonString) throws JSONException {
        this.mLock.lock();
        try {
            this.buildModelMap(jsonString);
        }
        finally {
            this.mLock.unlock();
        }
    }

    private void buildModelMap(String jsonString) throws JSONException {
        HashMap<AndroidModel, DistanceCalculator> map = new HashMap<AndroidModel, DistanceCalculator>();
        JSONObject jsonObject = new JSONObject(jsonString);
        JSONArray array = jsonObject.getJSONArray("models");
        for (int i = 0; i < array.length(); ++i) {
            JSONObject modelObject = array.getJSONObject(i);
            boolean defaultFlag = false;
            if (modelObject.has("default")) {
                defaultFlag = modelObject.getBoolean("default");
            }
            Double coefficient1 = modelObject.getDouble("coefficient1");
            Double coefficient2 = modelObject.getDouble("coefficient2");
            Double coefficient3 = modelObject.getDouble("coefficient3");
            String version = modelObject.getString("version");
            String buildNumber = modelObject.getString("build_number");
            String model = modelObject.getString("model");
            String manufacturer = modelObject.getString("manufacturer");
            CurveFittedDistanceCalculator distanceCalculator = new CurveFittedDistanceCalculator(coefficient1, coefficient2, coefficient3);
            AndroidModel androidModel = new AndroidModel(version, buildNumber, model, manufacturer);
            map.put(androidModel, distanceCalculator);
            if (!defaultFlag) continue;
            this.mDefaultModel = androidModel;
        }
        this.mModelMap = map;
    }

    private void loadDefaultModelMap() {
        try {
            this.buildModelMap(this.stringFromFilePath(CONFIG_FILE));
        }
        catch (Exception e) {
            this.mModelMap = new HashMap<AndroidModel, DistanceCalculator>();
            LogManager.e(e, TAG, "Cannot build model distance calculations", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String stringFromFilePath(String path) throws IOException {
        InputStream stream = null;
        BufferedReader bufferedReader = null;
        StringBuilder inputStringBuilder = new StringBuilder();
        try {
            stream = ModelSpecificDistanceCalculator.class.getResourceAsStream("/" + path);
            if (stream == null) {
                stream = this.getClass().getClassLoader().getResourceAsStream("/" + path);
            }
            if (stream == null) {
                throw new RuntimeException("Cannot load resource at " + path);
            }
            bufferedReader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            String line = bufferedReader.readLine();
            while (line != null) {
                inputStringBuilder.append(line);
                inputStringBuilder.append('\n');
                line = bufferedReader.readLine();
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (stream != null) {
                stream.close();
            }
        }
        return inputStringBuilder.toString();
    }
}

