/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.app.job.JobService;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.os.Handler;
import android.os.SystemClock;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.IntentScanStrategyCoordinator;
import org.altbeacon.beacon.service.ScanHelper;
import org.altbeacon.beacon.service.ScanJobScheduler;
import org.altbeacon.beacon.service.ScanState;
import org.altbeacon.beacon.utils.ProcessUtils;

@TargetApi(value=21)
public class ScanJob
extends JobService {
    private static final String TAG = ScanJob.class.getSimpleName();
    private static int sOverrideImmediateScanJobId = -1;
    private static int sOverridePeriodicScanJobId = -1;
    @Nullable
    private ScanState mScanState = null;
    private Handler mStopHandler = new Handler();
    @Nullable
    private ScanHelper mScanHelper;
    private boolean mInitialized = false;
    private boolean mStopCalled = false;

    public boolean onStartJob(final JobParameters jobParameters) {
        LogManager.i(TAG, "ScanJob Lifecycle START: " + (Object)((Object)this), new Object[0]);
        this.mStopCalled = false;
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IntentScanStrategyCoordinator intentStrategyCoord = BeaconManager.getInstanceForApplication((Context)ScanJob.this).getIntentScanStrategyCoordinator();
                if (intentStrategyCoord != null) {
                    ScanJob scanJob = ScanJob.this;
                    synchronized (scanJob) {
                        if (ScanJob.this.mStopCalled) {
                            LogManager.d(TAG, "Quitting scan job before we even start.  Somebody told us to stop.", new Object[0]);
                            ScanJob.this.jobFinished(jobParameters, false);
                            return;
                        }
                        LogManager.d(TAG, "Scan job calling IntentScanStrategyCoordinator", new Object[0]);
                        intentStrategyCoord.performPeriodicProcessing((Context)ScanJob.this);
                        LogManager.d(TAG, "Scan job finished.  Calling jobFinished", new Object[0]);
                        ScanJob.this.jobFinished(jobParameters, false);
                        return;
                    }
                }
                if (!ScanJob.this.initialzeScanHelper()) {
                    LogManager.e(TAG, "Cannot allocate a scanner to look for beacons.  System resources are low.", new Object[0]);
                    ScanJob.this.jobFinished(jobParameters, false);
                }
                ScanJobScheduler.getInstance().ensureNotificationProcessorSetup(ScanJob.this.getApplicationContext());
                if (jobParameters.getJobId() == ScanJob.getImmediateScanJobId((Context)ScanJob.this)) {
                    LogManager.i(TAG, "Running immediate scan job: instance is " + (Object)((Object)ScanJob.this), new Object[0]);
                } else {
                    LogManager.i(TAG, "Running periodic scan job: instance is " + (Object)((Object)ScanJob.this), new Object[0]);
                }
                ArrayList<ScanResult> queuedScanResults = new ArrayList<ScanResult>(ScanJobScheduler.getInstance().dumpBackgroundScanResultQueue());
                LogManager.d(TAG, "Processing %d queued scan results", queuedScanResults.size());
                for (ScanResult result : queuedScanResults) {
                    ScanRecord scanRecord = result.getScanRecord();
                    if (scanRecord == null || ScanJob.this.mScanHelper == null) continue;
                    ScanJob.this.mScanHelper.processScanResult(result.getDevice(), result.getRssi(), scanRecord.getBytes(), System.currentTimeMillis() - SystemClock.elapsedRealtime() + result.getTimestampNanos() / 1000000L);
                }
                LogManager.d(TAG, "Done processing queued scan results", new Object[0]);
                Object object = ScanJob.this;
                synchronized (object) {
                    boolean startedScan;
                    if (ScanJob.this.mStopCalled) {
                        LogManager.d(TAG, "Quitting scan job before we even start.  Somebody told us to stop.", new Object[0]);
                        ScanJob.this.jobFinished(jobParameters, false);
                        return;
                    }
                    if (ScanJob.this.mInitialized) {
                        LogManager.d(TAG, "Scanning already started.  Resetting for current parameters", new Object[0]);
                        startedScan = ScanJob.this.restartScanning();
                    } else {
                        startedScan = ScanJob.this.startScanning();
                    }
                    ScanJob.this.mStopHandler.removeCallbacksAndMessages(null);
                    if (startedScan) {
                        if (ScanJob.this.mScanState != null) {
                            LogManager.i(TAG, "Scan job running for " + ScanJob.this.mScanState.getScanJobRuntimeMillis() + " millis", new Object[0]);
                            ScanJob.this.mStopHandler.postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    LogManager.i(TAG, "Scan job runtime expired: " + (Object)((Object)ScanJob.this), new Object[0]);
                                    ScanJob.this.stopScanning();
                                    ScanJob.this.mScanState.save();
                                    ScanJob.this.jobFinished(jobParameters, false);
                                    ScanJob.this.mStopHandler.post(new Runnable(){

                                        @Override
                                        public void run() {
                                            ScanJob.this.scheduleNextScan();
                                        }
                                    });
                                }
                            }, (long)ScanJob.this.mScanState.getScanJobRuntimeMillis());
                        }
                    } else {
                        LogManager.i(TAG, "Scanning not started so Scan job is complete.", new Object[0]);
                        ScanJob.this.stopScanning();
                        ScanJob.this.mScanState.save();
                        LogManager.d(TAG, "ScanJob Lifecycle STOP (start fail): " + (Object)((Object)ScanJob.this), new Object[0]);
                        ScanJob.this.jobFinished(jobParameters, false);
                    }
                }
            }
        }).start();
        return true;
    }

    private void scheduleNextScan() {
        if (this.mScanState != null) {
            if (!this.mScanState.getBackgroundMode().booleanValue()) {
                LogManager.d(TAG, "In foreground mode, schedule next scan", new Object[0]);
                ScanJobScheduler.getInstance().forceScheduleNextScan((Context)this);
            } else {
                this.startPassiveScanIfNeeded();
            }
        }
    }

    private void startPassiveScanIfNeeded() {
        if (this.mScanState != null) {
            LogManager.d(TAG, "Checking to see if we need to start a passive scan", new Object[0]);
            boolean insideAnyRegion = this.mScanState.getMonitoringStatus().insideAnyRegion();
            if (insideAnyRegion) {
                LogManager.i(TAG, "We are inside a beacon region.  We will not scan between cycles.", new Object[0]);
            } else if (Build.VERSION.SDK_INT >= 26) {
                if (this.mScanHelper != null) {
                    this.mScanHelper.startAndroidOBackgroundScan(this.mScanState.getBeaconParsers());
                }
            } else {
                LogManager.d(TAG, "This is not Android O.  No scanning between cycles when using ScanJob", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onStopJob(JobParameters params) {
        LogManager.d(TAG, "onStopJob called", new Object[0]);
        ScanJob scanJob = this;
        synchronized (scanJob) {
            this.mStopCalled = true;
            if (params.getJobId() == ScanJob.getPeriodicScanJobId((Context)this)) {
                LogManager.i(TAG, "onStopJob called for periodic scan " + (Object)((Object)this), new Object[0]);
            } else {
                LogManager.i(TAG, "onStopJob called for immediate scan " + (Object)((Object)this), new Object[0]);
            }
            LogManager.i(TAG, "ScanJob Lifecycle STOP: " + (Object)((Object)this), new Object[0]);
            this.mStopHandler.removeCallbacksAndMessages(null);
            IntentScanStrategyCoordinator intentStrategyCoord = BeaconManager.getInstanceForApplication((Context)this).getIntentScanStrategyCoordinator();
            if (intentStrategyCoord != null) {
                LogManager.d(TAG, "ScanJob completed for intent scan strategy.", new Object[0]);
                return false;
            }
            this.stopScanning();
            this.startPassiveScanIfNeeded();
            if (this.mScanHelper != null) {
                this.mScanHelper.terminateThreads();
            }
        }
        return false;
    }

    private void stopScanning() {
        this.mInitialized = false;
        if (this.mScanHelper != null) {
            if (Build.VERSION.SDK_INT >= 26) {
                this.mScanHelper.stopAndroidOBackgroundScan();
            }
            if (this.mScanHelper.getCycledScanner() != null) {
                this.mScanHelper.getCycledScanner().stop();
                this.mScanHelper.getCycledScanner().destroy();
            }
        }
        LogManager.d(TAG, "Scanning stopped", new Object[0]);
    }

    private boolean initialzeScanHelper() {
        ScanHelper scanHelper;
        this.mScanState = ScanState.restore((Context)this);
        if (this.mScanState != null) {
            scanHelper = new ScanHelper((Context)this);
            this.mScanState.setLastScanStartTimeMillis(System.currentTimeMillis());
            scanHelper.setMonitoringStatus(this.mScanState.getMonitoringStatus());
            scanHelper.setRangedRegionState(this.mScanState.getRangedRegionState());
            scanHelper.setBeaconParsers(this.mScanState.getBeaconParsers());
            scanHelper.setExtraDataBeaconTracker(this.mScanState.getExtraBeaconDataTracker());
            if (scanHelper.getCycledScanner() == null) {
                try {
                    scanHelper.createCycledLeScanner(this.mScanState.getBackgroundMode(), null);
                }
                catch (OutOfMemoryError e) {
                    LogManager.w(TAG, "Failed to create CycledLeScanner thread.", new Object[0]);
                    return false;
                }
            }
        } else {
            return false;
        }
        this.mScanHelper = scanHelper;
        return true;
    }

    private boolean restartScanning() {
        if (this.mScanState != null && this.mScanHelper != null) {
            if (Build.VERSION.SDK_INT >= 26) {
                this.mScanHelper.stopAndroidOBackgroundScan();
            }
            long scanPeriod = this.mScanState.getBackgroundMode() != false ? this.mScanState.getBackgroundScanPeriod() : this.mScanState.getForegroundScanPeriod();
            long betweenScanPeriod = this.mScanState.getBackgroundMode() != false ? this.mScanState.getBackgroundBetweenScanPeriod() : this.mScanState.getForegroundBetweenScanPeriod();
            if (this.mScanHelper.getCycledScanner() != null) {
                this.mScanHelper.getCycledScanner().setScanPeriods(scanPeriod, betweenScanPeriod, this.mScanState.getBackgroundMode());
            }
            this.mInitialized = true;
            if (scanPeriod <= 0L) {
                LogManager.w(TAG, "Starting scan with scan period of zero.  Exiting ScanJob.", new Object[0]);
                if (this.mScanHelper.getCycledScanner() != null) {
                    this.mScanHelper.getCycledScanner().stop();
                }
                return false;
            }
            if (this.mScanHelper.getRangedRegionState().size() > 0 || this.mScanHelper.getMonitoringStatus().regions().size() > 0) {
                if (this.mScanHelper.getCycledScanner() != null) {
                    this.mScanHelper.getCycledScanner().start();
                }
                return true;
            }
            if (this.mScanHelper.getCycledScanner() != null) {
                this.mScanHelper.getCycledScanner().stop();
            }
            return false;
        }
        return false;
    }

    private boolean startScanning() {
        BeaconManager beaconManager = BeaconManager.getInstanceForApplication(this.getApplicationContext());
        beaconManager.setScannerInSameProcess(true);
        if (beaconManager.isMainProcess()) {
            LogManager.i(TAG, "scanJob version %s is starting up on the main process", "2.21.0-beta2");
        } else {
            LogManager.i(TAG, "beaconScanJob library version %s is starting up on a separate process", "2.21.0-beta2");
            ProcessUtils processUtils = new ProcessUtils((Context)this);
            LogManager.i(TAG, "beaconScanJob PID is " + processUtils.getPid() + " with process name " + processUtils.getProcessName(), new Object[0]);
        }
        return this.restartScanning();
    }

    public static void setOverrideImmediateScanJobId(int id) {
        sOverrideImmediateScanJobId = id;
    }

    public static void setOverridePeriodicScanJobId(int id) {
        sOverridePeriodicScanJobId = id;
    }

    public static int getImmediateScanJobId(Context context) {
        if (sOverrideImmediateScanJobId >= 0) {
            LogManager.i(TAG, "Using ImmediateScanJobId from static override: " + sOverrideImmediateScanJobId, new Object[0]);
            return sOverrideImmediateScanJobId;
        }
        return ScanJob.getJobIdFromManifest(context, "immediateScanJobId");
    }

    public static int getPeriodicScanJobId(Context context) {
        if (sOverrideImmediateScanJobId >= 0) {
            LogManager.i(TAG, "Using PeriodicScanJobId from static override: " + sOverridePeriodicScanJobId, new Object[0]);
            return sOverridePeriodicScanJobId;
        }
        return ScanJob.getJobIdFromManifest(context, "periodicScanJobId");
    }

    private static int getJobIdFromManifest(Context context, String name) {
        ServiceInfo info = null;
        try {
            info = context.getPackageManager().getServiceInfo(new ComponentName(context, ScanJob.class), 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        if (info != null && info.metaData != null && info.metaData.get(name) != null) {
            int jobId = info.metaData.getInt(name);
            LogManager.i(TAG, "Using " + name + " from manifest: " + jobId, new Object[0]);
            return jobId;
        }
        throw new RuntimeException("Cannot get job id from manifest.  Make sure that the " + name + " is configured in the manifest for the ScanJob.");
    }
}

