/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.Serializable;
import java.util.HashMap;
import org.altbeacon.beacon.Beacon;

public class ExtraDataBeaconTracker
implements Serializable {
    private static final String TAG = "BeaconTracker";
    @NonNull
    private final HashMap<String, HashMap<Integer, Beacon>> mBeaconsByKey = new HashMap();
    private final boolean matchBeaconsByServiceUUID;

    public ExtraDataBeaconTracker() {
        this(true);
    }

    public ExtraDataBeaconTracker(boolean matchBeaconsByServiceUUID) {
        this.matchBeaconsByServiceUUID = matchBeaconsByServiceUUID;
    }

    @Nullable
    public synchronized Beacon track(@NonNull Beacon beacon) {
        Beacon trackedBeacon = null;
        trackedBeacon = beacon.isMultiFrameBeacon() || beacon.getServiceUuid() != -1 ? this.trackGattBeacon(beacon) : beacon;
        return trackedBeacon;
    }

    @Nullable
    private Beacon trackGattBeacon(@NonNull Beacon beacon) {
        if (beacon.isExtraBeaconData()) {
            this.updateTrackedBeacons(beacon);
            return null;
        }
        String key = this.getBeaconKey(beacon);
        HashMap<Integer, Beacon> matchingTrackedBeacons = this.mBeaconsByKey.get(key);
        if (null == matchingTrackedBeacons) {
            matchingTrackedBeacons = new HashMap();
        } else {
            Beacon trackedBeacon = matchingTrackedBeacons.values().iterator().next();
            beacon.setExtraDataFields(trackedBeacon.getExtraDataFields());
        }
        matchingTrackedBeacons.put(beacon.hashCode(), beacon);
        this.mBeaconsByKey.put(key, matchingTrackedBeacons);
        return beacon;
    }

    private void updateTrackedBeacons(@NonNull Beacon beacon) {
        HashMap<Integer, Beacon> matchingTrackedBeacons = this.mBeaconsByKey.get(this.getBeaconKey(beacon));
        if (null != matchingTrackedBeacons) {
            for (Beacon matchingTrackedBeacon : matchingTrackedBeacons.values()) {
                matchingTrackedBeacon.setRssi(beacon.getRssi());
                matchingTrackedBeacon.setExtraDataFields(beacon.getDataFields());
            }
        }
    }

    private String getBeaconKey(@NonNull Beacon beacon) {
        if (this.matchBeaconsByServiceUUID) {
            return beacon.getBluetoothAddress() + beacon.getServiceUuid();
        }
        return beacon.getBluetoothAddress();
    }
}

