/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service.scanner;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Process;
import android.os.SystemClock;
import androidx.annotation.AnyThread;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import java.util.Date;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.scanner.CycledLeScanCallback;
import org.altbeacon.beacon.service.scanner.CycledLeScannerForAndroidO;
import org.altbeacon.beacon.service.scanner.CycledLeScannerForJellyBeanMr2;
import org.altbeacon.beacon.service.scanner.CycledLeScannerForLollipop;
import org.altbeacon.beacon.startup.StartupBroadcastReceiver;
import org.altbeacon.bluetooth.BluetoothCrashResolver;

@TargetApi(value=18)
public abstract class CycledLeScanner {
    public static final long ANDROID_N_MAX_SCAN_DURATION_MILLIS = 1800000L;
    private static final String TAG = "CycledLeScanner";
    private BluetoothAdapter mBluetoothAdapter;
    private long mLastScanCycleStartTime = 0L;
    private long mLastScanCycleEndTime = 0L;
    protected long mNextScanCycleStartTime = 0L;
    private long mScanCycleStopTime = 0L;
    private long mCurrentScanStartTime = 0L;
    private boolean mLongScanForcingEnabled = false;
    private boolean mScanning;
    protected boolean mScanningPaused;
    private boolean mScanCyclerStarted = false;
    private boolean mScanningEnabled = false;
    protected final Context mContext;
    private long mScanPeriod;
    private boolean mScanningLeftOn = false;
    private BroadcastReceiver mCancelAlarmOnUserSwitchBroadcastReceiver = null;
    protected long mBetweenScanPeriod;
    @NonNull
    protected final Handler mHandler = new Handler(Looper.getMainLooper());
    @NonNull
    protected final Handler mScanHandler;
    @NonNull
    private final HandlerThread mScanThread;
    protected final BluetoothCrashResolver mBluetoothCrashResolver;
    protected final CycledLeScanCallback mCycledLeScanCallback;
    protected boolean mBackgroundFlag = false;
    protected boolean mRestartNeeded = false;
    private volatile boolean mDistinctPacketsDetectedPerScan = false;
    private static final long ANDROID_N_MIN_SCAN_CYCLE_MILLIS = 6000L;
    private PendingIntent mWakeUpOperation = null;

    protected CycledLeScanner(Context context, long scanPeriod, long betweenScanPeriod, boolean backgroundFlag, CycledLeScanCallback cycledLeScanCallback, BluetoothCrashResolver crashResolver) {
        this.mScanPeriod = scanPeriod;
        this.mBetweenScanPeriod = betweenScanPeriod;
        this.mContext = context;
        this.mCycledLeScanCallback = cycledLeScanCallback;
        this.mBluetoothCrashResolver = crashResolver;
        this.mBackgroundFlag = backgroundFlag;
        this.mScanThread = new HandlerThread("CycledLeScannerThread");
        this.mScanThread.start();
        this.mScanHandler = new Handler(this.mScanThread.getLooper());
    }

    public static CycledLeScanner createScanner(Context context, long scanPeriod, long betweenScanPeriod, boolean backgroundFlag, CycledLeScanCallback cycledLeScanCallback, BluetoothCrashResolver crashResolver) {
        boolean useAndroidLScanner = false;
        boolean useAndroidOScanner = false;
        if (Build.VERSION.SDK_INT < 18) {
            LogManager.w(TAG, "Not supported prior to API 18.", new Object[0]);
            return null;
        }
        if (Build.VERSION.SDK_INT < 21) {
            LogManager.i(TAG, "This is pre Android 5.0.  We are using old scanning APIs", new Object[0]);
            useAndroidLScanner = false;
        } else if (Build.VERSION.SDK_INT < 26) {
            if (BeaconManager.isAndroidLScanningDisabled()) {
                LogManager.i(TAG, "This is Android 5.0, but L scanning is disabled. We are using old scanning APIs", new Object[0]);
                useAndroidLScanner = false;
            } else {
                LogManager.i(TAG, "This is Android 5.0.  We are using new scanning APIs", new Object[0]);
                useAndroidLScanner = true;
            }
        } else {
            LogManager.i(TAG, "Using Android O scanner", new Object[0]);
            useAndroidOScanner = true;
        }
        if (useAndroidOScanner) {
            return new CycledLeScannerForAndroidO(context, scanPeriod, betweenScanPeriod, backgroundFlag, cycledLeScanCallback, crashResolver);
        }
        if (useAndroidLScanner) {
            return new CycledLeScannerForLollipop(context, scanPeriod, betweenScanPeriod, backgroundFlag, cycledLeScanCallback, crashResolver);
        }
        return new CycledLeScannerForJellyBeanMr2(context, scanPeriod, betweenScanPeriod, backgroundFlag, cycledLeScanCallback, crashResolver);
    }

    public void setLongScanForcingEnabled(boolean enabled) {
        this.mLongScanForcingEnabled = enabled;
    }

    @MainThread
    public void setScanPeriods(long scanPeriod, long betweenScanPeriod, boolean backgroundFlag) {
        long proposedScanStopTime;
        long proposedNextScanStartTime;
        LogManager.d(TAG, "Set scan periods called with %s, %s Background mode must have changed.", scanPeriod, betweenScanPeriod);
        if (this.mBackgroundFlag != backgroundFlag) {
            this.mRestartNeeded = true;
        }
        this.mBackgroundFlag = backgroundFlag;
        this.mScanPeriod = scanPeriod;
        this.mBetweenScanPeriod = betweenScanPeriod;
        if (this.mBackgroundFlag) {
            LogManager.d(TAG, "We are in the background.  Setting wakeup alarm", new Object[0]);
            this.setWakeUpAlarm();
        } else {
            LogManager.d(TAG, "We are not in the background.  Cancelling wakeup alarm", new Object[0]);
            this.cancelWakeUpAlarm();
        }
        long now = SystemClock.elapsedRealtime();
        if (this.mNextScanCycleStartTime > now && (proposedNextScanStartTime = this.mLastScanCycleEndTime + betweenScanPeriod) < this.mNextScanCycleStartTime) {
            this.mNextScanCycleStartTime = proposedNextScanStartTime;
            LogManager.i(TAG, "Adjusted nextScanStartTime to be %s", new Date(this.mNextScanCycleStartTime - SystemClock.elapsedRealtime() + System.currentTimeMillis()));
        }
        if (this.mScanCycleStopTime > now && (proposedScanStopTime = this.mLastScanCycleStartTime + scanPeriod) < this.mScanCycleStopTime) {
            this.mScanCycleStopTime = proposedScanStopTime;
            LogManager.i(TAG, "Adjusted scanStopTime to be %s", this.mScanCycleStopTime);
        }
    }

    @MainThread
    public void start() {
        LogManager.d(TAG, "start called", new Object[0]);
        this.mScanningEnabled = true;
        if (!this.mScanCyclerStarted) {
            this.scanLeDevice(true);
        } else {
            LogManager.d(TAG, "scanning already started", new Object[0]);
        }
    }

    @MainThread
    public void stop() {
        LogManager.d(TAG, "stop called", new Object[0]);
        this.mScanningEnabled = false;
        if (this.mScanCyclerStarted) {
            this.scanLeDevice(false);
            if (this.mScanningLeftOn) {
                LogManager.d(TAG, "Stopping scanning previously left on.", new Object[0]);
                this.mScanningLeftOn = false;
                try {
                    LogManager.d(TAG, "stopping bluetooth le scan", new Object[0]);
                    this.finishScan();
                }
                catch (Exception e) {
                    LogManager.w(e, TAG, "Internal Android exception scanning for beacons", new Object[0]);
                }
            }
        } else {
            LogManager.d(TAG, "scanning already stopped", new Object[0]);
        }
    }

    @AnyThread
    public boolean getDistinctPacketsDetectedPerScan() {
        return this.mDistinctPacketsDetectedPerScan;
    }

    @AnyThread
    public void setDistinctPacketsDetectedPerScan(boolean detected) {
        this.mDistinctPacketsDetectedPerScan = detected;
    }

    @MainThread
    public void destroy() {
        LogManager.d(TAG, "Destroying", new Object[0]);
        this.mHandler.removeCallbacksAndMessages(null);
        this.mScanHandler.post(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                LogManager.d(CycledLeScanner.TAG, "Quitting scan thread", new Object[0]);
                CycledLeScanner.this.mScanThread.quit();
            }
        });
        this.cleanupCancelAlarmOnUserSwitch();
    }

    protected abstract void stopScan();

    protected abstract boolean deferScanIfNeeded();

    protected abstract void startScan();

    @MainThread
    protected void scanLeDevice(Boolean enable) {
        block21: {
            try {
                this.mScanCyclerStarted = true;
                if (this.getBluetoothAdapter() == null) {
                    LogManager.e(TAG, "No Bluetooth adapter.  beaconService cannot scan.", new Object[0]);
                }
                if (this.mScanningEnabled && enable.booleanValue()) {
                    block19: {
                        if (this.deferScanIfNeeded()) {
                            return;
                        }
                        LogManager.d(TAG, "starting a new scan cycle", new Object[0]);
                        if (!this.mScanning || this.mScanningPaused || this.mRestartNeeded) {
                            this.mScanning = true;
                            this.mScanningPaused = false;
                            try {
                                if (this.getBluetoothAdapter() == null) break block19;
                                if (this.getBluetoothAdapter().isEnabled()) {
                                    if (this.mBluetoothCrashResolver != null && this.mBluetoothCrashResolver.isRecoveryInProgress()) {
                                        LogManager.w(TAG, "Skipping scan because crash recovery is in progress.", new Object[0]);
                                    } else if (this.mScanningEnabled) {
                                        if (this.mRestartNeeded) {
                                            this.mRestartNeeded = false;
                                            LogManager.d(TAG, "restarting a bluetooth le scan", new Object[0]);
                                        } else {
                                            LogManager.d(TAG, "starting a new bluetooth le scan", new Object[0]);
                                        }
                                        try {
                                            if (Build.VERSION.SDK_INT < 23 || this.checkLocationPermission()) {
                                                this.mCurrentScanStartTime = SystemClock.elapsedRealtime();
                                                this.startScan();
                                            }
                                        }
                                        catch (Exception e) {
                                            LogManager.e(e, TAG, "Internal Android exception scanning for beacons", new Object[0]);
                                        }
                                    } else {
                                        LogManager.d(TAG, "Scanning unnecessary - no monitoring or ranging active.", new Object[0]);
                                    }
                                    this.mLastScanCycleStartTime = SystemClock.elapsedRealtime();
                                    break block19;
                                }
                                LogManager.d(TAG, "Bluetooth is disabled.  Cannot scan for beacons.", new Object[0]);
                            }
                            catch (Exception e) {
                                LogManager.e(e, TAG, "Exception starting Bluetooth scan.  Perhaps Bluetooth is disabled or unavailable?", new Object[0]);
                            }
                        } else {
                            LogManager.d(TAG, "We are already scanning and have been for " + (SystemClock.elapsedRealtime() - this.mCurrentScanStartTime) + " millis", new Object[0]);
                        }
                    }
                    this.mScanCycleStopTime = SystemClock.elapsedRealtime() + this.mScanPeriod;
                    this.scheduleScanCycleStop();
                    LogManager.d(TAG, "Scan started", new Object[0]);
                    break block21;
                }
                LogManager.d(TAG, "disabling scan", new Object[0]);
                this.mScanning = false;
                this.mScanCyclerStarted = false;
                this.stopScan();
                this.mCurrentScanStartTime = 0L;
                this.mLastScanCycleEndTime = SystemClock.elapsedRealtime();
                this.mHandler.removeCallbacksAndMessages(null);
                this.finishScanCycle();
            }
            catch (SecurityException e) {
                LogManager.w(TAG, "SecurityException working accessing bluetooth.", new Object[0]);
            }
        }
    }

    @MainThread
    protected void scheduleScanCycleStop() {
        long millisecondsUntilStop = this.mScanCycleStopTime - SystemClock.elapsedRealtime();
        if (this.mScanningEnabled && millisecondsUntilStop > 0L) {
            LogManager.d(TAG, "Waiting to stop scan cycle for another %s milliseconds", millisecondsUntilStop);
            if (this.mBackgroundFlag) {
                this.setWakeUpAlarm();
            }
            this.mHandler.postDelayed(new Runnable(){

                @Override
                @MainThread
                public void run() {
                    CycledLeScanner.this.scheduleScanCycleStop();
                }
            }, millisecondsUntilStop > 1000L ? 1000L : millisecondsUntilStop);
        } else {
            this.finishScanCycle();
        }
    }

    protected abstract void finishScan();

    @MainThread
    private void finishScanCycle() {
        LogManager.d(TAG, "Done with scan cycle", new Object[0]);
        try {
            this.mCycledLeScanCallback.onCycleEnd();
            if (this.mScanning) {
                if (this.getBluetoothAdapter() != null) {
                    if (this.getBluetoothAdapter().isEnabled()) {
                        if (!this.mDistinctPacketsDetectedPerScan || this.mBetweenScanPeriod != 0L || this.mustStopScanToPreventAndroidNScanTimeout()) {
                            long now = SystemClock.elapsedRealtime();
                            if (Build.VERSION.SDK_INT >= 24 && this.mBetweenScanPeriod + this.mScanPeriod < 6000L && now - this.mLastScanCycleStartTime < 6000L) {
                                LogManager.d(TAG, "Not stopping scan because this is Android N and we keep scanning for a minimum of 6 seconds at a time. We will stop in " + (6000L - (now - this.mLastScanCycleStartTime)) + " millisconds.", new Object[0]);
                                this.mScanningLeftOn = true;
                            } else {
                                try {
                                    LogManager.d(TAG, "stopping bluetooth le scan", new Object[0]);
                                    this.finishScan();
                                    this.mScanningLeftOn = false;
                                }
                                catch (Exception e) {
                                    LogManager.w(e, TAG, "Internal Android exception scanning for beacons", new Object[0]);
                                }
                            }
                        } else {
                            LogManager.d(TAG, "Not stopping scanning.  Device capable of multiple indistinct detections per scan.", new Object[0]);
                            this.mScanningLeftOn = true;
                        }
                        this.mLastScanCycleEndTime = SystemClock.elapsedRealtime();
                    } else {
                        LogManager.d(TAG, "Bluetooth is disabled.  Cannot scan for beacons.", new Object[0]);
                        this.mRestartNeeded = true;
                    }
                }
                this.mNextScanCycleStartTime = this.getNextScanStartTime();
                if (this.mScanningEnabled) {
                    this.scanLeDevice(true);
                }
            }
            if (!this.mScanningEnabled) {
                LogManager.d(TAG, "Scanning disabled. ", new Object[0]);
                this.mScanCyclerStarted = false;
                this.cancelWakeUpAlarm();
            }
        }
        catch (SecurityException e) {
            LogManager.w(TAG, "SecurityException working accessing bluetooth.", new Object[0]);
        }
    }

    protected BluetoothAdapter getBluetoothAdapter() {
        try {
            if (this.mBluetoothAdapter == null) {
                BluetoothManager bluetoothManager = (BluetoothManager)this.mContext.getApplicationContext().getSystemService("bluetooth");
                this.mBluetoothAdapter = bluetoothManager.getAdapter();
                if (this.mBluetoothAdapter == null) {
                    LogManager.w(TAG, "Failed to construct a BluetoothAdapter", new Object[0]);
                }
            }
        }
        catch (SecurityException e) {
            LogManager.e(TAG, "Cannot consruct bluetooth adapter.  Security Exception", new Object[0]);
        }
        return this.mBluetoothAdapter;
    }

    protected void setWakeUpAlarm() {
        long milliseconds = 300000L;
        if (milliseconds < this.mBetweenScanPeriod) {
            milliseconds = this.mBetweenScanPeriod;
        }
        if (milliseconds < this.mScanPeriod) {
            milliseconds = this.mScanPeriod;
        }
        AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        alarmManager.set(2, SystemClock.elapsedRealtime() + milliseconds, this.getWakeUpOperation());
        LogManager.d(TAG, "Set a wakeup alarm to go off in %s ms: %s", milliseconds, this.getWakeUpOperation());
        this.cancelAlarmOnUserSwitch();
    }

    protected void cancelAlarmOnUserSwitch() {
        if (this.mCancelAlarmOnUserSwitchBroadcastReceiver == null) {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.USER_BACKGROUND");
            filter.addAction("android.intent.action.USER_FOREGROUND");
            this.mCancelAlarmOnUserSwitchBroadcastReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    LogManager.w(CycledLeScanner.TAG, "User switch detected.  Cancelling alarm to prevent potential crash.", new Object[0]);
                    CycledLeScanner.this.cancelWakeUpAlarm();
                }
            };
            this.mContext.registerReceiver(this.mCancelAlarmOnUserSwitchBroadcastReceiver, filter);
        }
    }

    protected void cleanupCancelAlarmOnUserSwitch() {
        if (this.mCancelAlarmOnUserSwitchBroadcastReceiver != null) {
            try {
                this.mContext.unregisterReceiver(this.mCancelAlarmOnUserSwitchBroadcastReceiver);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.mCancelAlarmOnUserSwitchBroadcastReceiver = null;
        }
    }

    protected PendingIntent getWakeUpOperation() {
        if (this.mWakeUpOperation == null) {
            Intent wakeupIntent = new Intent(this.mContext, StartupBroadcastReceiver.class);
            wakeupIntent.putExtra("wakeup", true);
            this.mWakeUpOperation = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)wakeupIntent, (int)0xC000000);
        }
        return this.mWakeUpOperation;
    }

    protected void cancelWakeUpAlarm() {
        LogManager.d(TAG, "cancel wakeup alarm: %s", this.mWakeUpOperation);
        long milliseconds = Long.MAX_VALUE;
        AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        alarmManager.set(2, milliseconds, this.getWakeUpOperation());
        LogManager.d(TAG, "Set a wakeup alarm to go off in %s ms: %s", milliseconds - SystemClock.elapsedRealtime(), this.getWakeUpOperation());
    }

    private long getNextScanStartTime() {
        if (this.mBetweenScanPeriod == 0L) {
            return SystemClock.elapsedRealtime();
        }
        long fullScanCycle = this.mScanPeriod + this.mBetweenScanPeriod;
        long normalizedBetweenScanPeriod = this.mBetweenScanPeriod - SystemClock.elapsedRealtime() % fullScanCycle;
        LogManager.d(TAG, "Normalizing between scan period from %s to %s", this.mBetweenScanPeriod, normalizedBetweenScanPeriod);
        return SystemClock.elapsedRealtime() + normalizedBetweenScanPeriod;
    }

    private boolean checkLocationPermission() {
        return this.checkPermission("android.permission.ACCESS_COARSE_LOCATION") || this.checkPermission("android.permission.ACCESS_FINE_LOCATION");
    }

    private boolean checkPermission(String permission2) {
        return this.mContext.checkPermission(permission2, Process.myPid(), Process.myUid()) == 0;
    }

    private boolean mustStopScanToPreventAndroidNScanTimeout() {
        boolean timeoutAtRisk;
        long timeOfNextScanCycleEnd = SystemClock.elapsedRealtime() + this.mBetweenScanPeriod + this.mScanPeriod;
        boolean bl = timeoutAtRisk = Build.VERSION.SDK_INT >= 24 && this.mCurrentScanStartTime > 0L && timeOfNextScanCycleEnd - this.mCurrentScanStartTime > 1800000L;
        if (timeoutAtRisk) {
            LogManager.d(TAG, "The next scan cycle would go over the Android N max duration.", new Object[0]);
            if (this.mLongScanForcingEnabled) {
                LogManager.d(TAG, "Stopping scan to prevent Android N scan timeout.", new Object[0]);
                return true;
            }
            LogManager.w(TAG, "Allowing a long running scan to be stopped by the OS.  To prevent this, set longScanForcingEnabled in the AndroidBeaconLibrary.", new Object[0]);
        }
        return false;
    }
}

