/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.content.Context;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.BeaconParser;
import org.altbeacon.beacon.Region;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.Callback;
import org.altbeacon.beacon.service.ExtraDataBeaconTracker;
import org.altbeacon.beacon.service.MonitoringStatus;
import org.altbeacon.beacon.service.RangeState;

public class ScanState
implements Serializable {
    private static final String TAG = ScanState.class.getSimpleName();
    private static final String STATUS_PRESERVATION_FILE_NAME = "android-beacon-library-scan-state";
    private static final String TEMP_STATUS_PRESERVATION_FILE_NAME = "android-beacon-library-scan-state-temp";
    public static int MIN_SCAN_JOB_INTERVAL_MILLIS = 300000;
    private Map<Region, RangeState> mRangedRegionState = new HashMap<Region, RangeState>();
    private transient MonitoringStatus mMonitoringStatus;
    private Set<BeaconParser> mBeaconParsers = new HashSet<BeaconParser>();
    private ExtraDataBeaconTracker mExtraBeaconDataTracker = new ExtraDataBeaconTracker();
    private long mForegroundBetweenScanPeriod;
    private long mBackgroundBetweenScanPeriod;
    private long mForegroundScanPeriod;
    private long mBackgroundScanPeriod;
    private boolean mBackgroundMode;
    private long mLastScanStartTimeMillis = 0L;
    private transient Context mContext;

    public Boolean getBackgroundMode() {
        return this.mBackgroundMode;
    }

    public void setBackgroundMode(Boolean backgroundMode) {
        this.mBackgroundMode = backgroundMode;
    }

    public Long getBackgroundBetweenScanPeriod() {
        return this.mBackgroundBetweenScanPeriod;
    }

    public void setBackgroundBetweenScanPeriod(Long backgroundBetweenScanPeriod) {
        this.mBackgroundBetweenScanPeriod = backgroundBetweenScanPeriod;
    }

    public Long getBackgroundScanPeriod() {
        return this.mBackgroundScanPeriod;
    }

    public void setBackgroundScanPeriod(Long backgroundScanPeriod) {
        this.mBackgroundScanPeriod = backgroundScanPeriod;
    }

    public Long getForegroundBetweenScanPeriod() {
        return this.mForegroundBetweenScanPeriod;
    }

    public void setForegroundBetweenScanPeriod(Long foregroundBetweenScanPeriod) {
        this.mForegroundBetweenScanPeriod = foregroundBetweenScanPeriod;
    }

    public Long getForegroundScanPeriod() {
        return this.mForegroundScanPeriod;
    }

    public void setForegroundScanPeriod(Long foregroundScanPeriod) {
        this.mForegroundScanPeriod = foregroundScanPeriod;
    }

    public ScanState(Context context) {
        this.mContext = context;
    }

    public MonitoringStatus getMonitoringStatus() {
        return this.mMonitoringStatus;
    }

    public void setMonitoringStatus(MonitoringStatus monitoringStatus) {
        this.mMonitoringStatus = monitoringStatus;
    }

    public Map<Region, RangeState> getRangedRegionState() {
        return this.mRangedRegionState;
    }

    public void setRangedRegionState(Map<Region, RangeState> rangedRegionState) {
        this.mRangedRegionState = rangedRegionState;
    }

    public ExtraDataBeaconTracker getExtraBeaconDataTracker() {
        return this.mExtraBeaconDataTracker;
    }

    public void setExtraBeaconDataTracker(ExtraDataBeaconTracker extraDataBeaconTracker) {
        this.mExtraBeaconDataTracker = extraDataBeaconTracker;
    }

    public Set<BeaconParser> getBeaconParsers() {
        return this.mBeaconParsers;
    }

    public void setBeaconParsers(Set<BeaconParser> beaconParsers) {
        this.mBeaconParsers = beaconParsers;
    }

    public long getLastScanStartTimeMillis() {
        return this.mLastScanStartTimeMillis;
    }

    public void setLastScanStartTimeMillis(long time) {
        this.mLastScanStartTimeMillis = time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScanState restore(Context context) {
        ScanState scanState = null;
        Class<ScanState> clazz = ScanState.class;
        synchronized (ScanState.class) {
            FileInputStream inputStream = null;
            ObjectInputStream objectInputStream = null;
            try {
                inputStream = context.openFileInput(STATUS_PRESERVATION_FILE_NAME);
                objectInputStream = new ObjectInputStream(inputStream);
                scanState = (ScanState)objectInputStream.readObject();
                scanState.mContext = context;
            }
            catch (FileNotFoundException fnfe) {
                LogManager.w(TAG, "Serialized ScanState does not exist.  This may be normal on first run.", new Object[0]);
            }
            catch (IOException | ClassCastException | ClassNotFoundException e) {
                if (e instanceof InvalidClassException) {
                    LogManager.d(TAG, "Serialized ScanState has wrong class. Just ignoring saved state...", new Object[0]);
                } else {
                    LogManager.e(TAG, "Deserialization exception", new Object[0]);
                    Log.e((String)TAG, (String)"error: ", (Throwable)e);
                }
            }
            finally {
                if (null != inputStream) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException fnfe) {}
                }
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException fnfe) {}
                }
            }
            if (scanState == null) {
                scanState = new ScanState(context);
            }
            if (scanState.mExtraBeaconDataTracker == null) {
                scanState.mExtraBeaconDataTracker = new ExtraDataBeaconTracker();
            }
            scanState.mMonitoringStatus = MonitoringStatus.getInstanceForApplication(context);
            LogManager.d(TAG, "Scan state restore regions: monitored=" + scanState.getMonitoringStatus().regions().size() + " ranged=" + scanState.getRangedRegionState().keySet().size(), new Object[0]);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return scanState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        Class<ScanState> clazz = ScanState.class;
        synchronized (ScanState.class) {
            FileOutputStream outputStream = null;
            ObjectOutputStream objectOutputStream = null;
            try {
                outputStream = this.mContext.openFileOutput(TEMP_STATUS_PRESERVATION_FILE_NAME, 0);
                objectOutputStream = new ObjectOutputStream(outputStream);
                objectOutputStream.writeObject(this);
            }
            catch (IOException e) {
                LogManager.e(TAG, "Error while saving scan status to file: ", e.getMessage());
            }
            finally {
                if (null != outputStream) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {}
                }
                if (objectOutputStream != null) {
                    try {
                        objectOutputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
            File file = new File(this.mContext.getFilesDir(), STATUS_PRESERVATION_FILE_NAME);
            File tempFile = new File(this.mContext.getFilesDir(), TEMP_STATUS_PRESERVATION_FILE_NAME);
            LogManager.d(TAG, "Temp file is " + tempFile.getAbsolutePath(), new Object[0]);
            LogManager.d(TAG, "Perm file is " + file.getAbsolutePath(), new Object[0]);
            if (!file.delete()) {
                LogManager.e(TAG, "Error while saving scan status to file: Cannot delete existing file.", new Object[0]);
            }
            if (!tempFile.renameTo(file)) {
                LogManager.e(TAG, "Error while saving scan status to file: Cannot rename temp file.", new Object[0]);
            }
            this.mMonitoringStatus.saveMonitoringStatusIfOn();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public int getScanJobIntervalMillis() {
        long cyclePeriodMillis = this.getBackgroundMode() != false ? this.getBackgroundScanPeriod() + this.getBackgroundBetweenScanPeriod() : this.getForegroundScanPeriod() + this.getForegroundBetweenScanPeriod();
        int scanJobIntervalMillis = MIN_SCAN_JOB_INTERVAL_MILLIS;
        if (cyclePeriodMillis > (long)MIN_SCAN_JOB_INTERVAL_MILLIS) {
            scanJobIntervalMillis = (int)cyclePeriodMillis;
        }
        return scanJobIntervalMillis;
    }

    public int getScanJobRuntimeMillis() {
        LogManager.d(TAG, "ScanState says background mode for ScanJob is " + this.getBackgroundMode(), new Object[0]);
        long scanPeriodMillis = this.getBackgroundMode() != false ? this.getBackgroundScanPeriod().longValue() : this.getForegroundScanPeriod().longValue();
        if (!this.getBackgroundMode().booleanValue() && scanPeriodMillis < (long)MIN_SCAN_JOB_INTERVAL_MILLIS) {
            return MIN_SCAN_JOB_INTERVAL_MILLIS;
        }
        return (int)scanPeriodMillis;
    }

    public void applyChanges(BeaconManager beaconManager) {
        this.mBeaconParsers = new HashSet<BeaconParser>(beaconManager.getBeaconParsers());
        this.mForegroundScanPeriod = beaconManager.getForegroundScanPeriod();
        this.mForegroundBetweenScanPeriod = beaconManager.getForegroundBetweenScanPeriod();
        this.mBackgroundScanPeriod = beaconManager.getBackgroundScanPeriod();
        this.mBackgroundBetweenScanPeriod = beaconManager.getBackgroundBetweenScanPeriod();
        this.mBackgroundMode = beaconManager.getBackgroundMode();
        ArrayList<Region> existingMonitoredRegions = new ArrayList<Region>(this.mMonitoringStatus.regions());
        ArrayList<Region> existingRangedRegions = new ArrayList<Region>(this.mRangedRegionState.keySet());
        ArrayList<Region> newMonitoredRegions = new ArrayList<Region>(beaconManager.getMonitoredRegions());
        ArrayList<Region> newRangedRegions = new ArrayList<Region>(beaconManager.getRangedRegions());
        LogManager.d(TAG, "ranged regions: old=" + existingRangedRegions.size() + " new=" + newRangedRegions.size(), new Object[0]);
        LogManager.d(TAG, "monitored regions: old=" + existingMonitoredRegions.size() + " new=" + newMonitoredRegions.size(), new Object[0]);
        for (Region newRangedRegion : newRangedRegions) {
            if (!existingRangedRegions.contains(newRangedRegion)) {
                LogManager.d(TAG, "Starting ranging region: " + newRangedRegion, new Object[0]);
                this.mRangedRegionState.put(newRangedRegion, new RangeState(new Callback(this.mContext.getPackageName())));
                continue;
            }
            Region existingRegion = existingRangedRegions.get(existingMonitoredRegions.indexOf(newRangedRegion));
            if (!newRangedRegion.hasSameIdentifiers(existingRegion)) continue;
            this.mRangedRegionState.remove(existingRegion);
            this.mRangedRegionState.put(newRangedRegion, new RangeState(new Callback(this.mContext.getPackageName())));
        }
        for (Region existingRangedRegion : existingRangedRegions) {
            if (newRangedRegions.contains(existingRangedRegion)) continue;
            LogManager.d(TAG, "Stopping ranging region: " + existingRangedRegion, new Object[0]);
            this.mRangedRegionState.remove(existingRangedRegion);
        }
        LogManager.d(TAG, "Updated state with " + newRangedRegions.size() + " ranging regions and " + newMonitoredRegions.size() + " monitoring regions.", new Object[0]);
        this.save();
    }
}

