/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.bluetooth.le.ScanResult;
import android.content.ComponentName;
import android.content.Context;
import android.os.Build;
import android.os.PersistableBundle;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import java.util.ArrayList;
import java.util.List;
import org.altbeacon.beacon.BeaconLocalBroadcastProcessor;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.ScanJob;
import org.altbeacon.beacon.service.ScanState;

@RequiresApi(api=21)
public class ScanJobScheduler {
    private static final String TAG = ScanJobScheduler.class.getSimpleName();
    private static final Object SINGLETON_LOCK = new Object();
    private static final long MIN_MILLIS_BETWEEN_SCAN_JOB_SCHEDULING = 10000L;
    @Nullable
    private static volatile ScanJobScheduler sInstance = null;
    @NonNull
    private Long mScanJobScheduleTime = 0L;
    @NonNull
    private List<ScanResult> mBackgroundScanResultQueue = new ArrayList<ScanResult>();
    @Nullable
    private BeaconLocalBroadcastProcessor mBeaconNotificationProcessor;
    @NonNull
    private boolean mBackgroundScanJobFirstRun = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static ScanJobScheduler getInstance() {
        ScanJobScheduler instance = sInstance;
        if (instance == null) {
            Object object = SINGLETON_LOCK;
            synchronized (object) {
                instance = sInstance;
                if (instance == null) {
                    sInstance = instance = new ScanJobScheduler();
                }
            }
        }
        return instance;
    }

    private ScanJobScheduler() {
    }

    void ensureNotificationProcessorSetup(Context context) {
        if (this.mBeaconNotificationProcessor == null) {
            this.mBeaconNotificationProcessor = BeaconLocalBroadcastProcessor.getInstance(context);
        }
        this.mBeaconNotificationProcessor.register();
    }

    List<ScanResult> dumpBackgroundScanResultQueue() {
        List<ScanResult> retval = this.mBackgroundScanResultQueue;
        this.mBackgroundScanResultQueue = new ArrayList<ScanResult>();
        return retval;
    }

    private void applySettingsToScheduledJob(Context context, BeaconManager beaconManager, ScanState scanState) {
        scanState.applyChanges(beaconManager);
        LogManager.d(TAG, "Applying scan job settings with background mode " + scanState.getBackgroundMode(), new Object[0]);
        boolean startBackgroundImmediateScan = false;
        if (this.mBackgroundScanJobFirstRun && scanState.getBackgroundMode().booleanValue()) {
            LogManager.d(TAG, "This is the first time we schedule a job and we are in background, set immediate scan flag to true in order to trigger the HW filter install.", new Object[0]);
            startBackgroundImmediateScan = true;
        }
        this.schedule(context, scanState, startBackgroundImmediateScan);
    }

    public void applySettingsToScheduledJob(Context context, BeaconManager beaconManager) {
        LogManager.d(TAG, "Applying settings to ScanJob", new Object[0]);
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        ScanState scanState = ScanState.restore(context);
        this.applySettingsToScheduledJob(context, beaconManager, scanState);
    }

    public void cancelSchedule(Context context) {
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        jobScheduler.cancel(ScanJob.getImmediateScanJobId(context));
        jobScheduler.cancel(ScanJob.getPeriodicScanJobId(context));
        if (this.mBeaconNotificationProcessor != null) {
            this.mBeaconNotificationProcessor.unregister();
        }
        this.mBackgroundScanJobFirstRun = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleAfterBackgroundWakeup(Context context, List<ScanResult> scanResults) {
        if (scanResults != null) {
            this.mBackgroundScanResultQueue.addAll(scanResults);
        }
        ScanJobScheduler scanJobScheduler = this;
        synchronized (scanJobScheduler) {
            if (System.currentTimeMillis() - this.mScanJobScheduleTime <= 10000L) {
                LogManager.d(TAG, "Not scheduling an immediate scan job because we just did recently.", new Object[0]);
                return;
            }
            LogManager.d(TAG, "scheduling an immediate scan job because last did " + (System.currentTimeMillis() - this.mScanJobScheduleTime) + "millis ago.", new Object[0]);
            this.mScanJobScheduleTime = System.currentTimeMillis();
        }
        ScanState scanState = ScanState.restore(context);
        this.schedule(context, scanState, true);
    }

    public void forceScheduleNextScan(Context context) {
        ScanState scanState = ScanState.restore(context);
        this.schedule(context, scanState, false);
    }

    public void scheduleForIntentScanStrategy(Context context) {
        JobInfo.Builder periodicJobBuilder = new JobInfo.Builder(ScanJob.getPeriodicScanJobId(context), new ComponentName(context, ScanJob.class)).setPersisted(true).setExtras(new PersistableBundle());
        long fifteenMinutesMillis = 900000L;
        if (Build.VERSION.SDK_INT >= 24) {
            periodicJobBuilder.setPeriodic(fifteenMinutesMillis, 0L).build();
        } else {
            periodicJobBuilder.setPeriodic(fifteenMinutesMillis).build();
        }
        JobInfo jobInfo = periodicJobBuilder.build();
        LogManager.d(TAG, "Scheduling periodic ScanJob " + jobInfo + " to run every 15 minutes", new Object[0]);
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        int error = jobScheduler.schedule(jobInfo);
        if (error < 0) {
            LogManager.e(TAG, "Failed to schedule a periodic scan job to look for region exits. Error: " + error, new Object[0]);
        }
    }

    private void schedule(Context context, ScanState scanState, boolean backgroundWakeup) {
        long millisToNextJobStart;
        this.ensureNotificationProcessorSetup(context);
        long betweenScanPeriod = scanState.getScanJobIntervalMillis() - scanState.getScanJobRuntimeMillis();
        if (backgroundWakeup) {
            LogManager.d(TAG, "We just woke up in the background based on a new scan result or first run of the app. Start scan job immediately.", new Object[0]);
            millisToNextJobStart = 0L;
        } else {
            millisToNextJobStart = betweenScanPeriod > 0L ? SystemClock.elapsedRealtime() % (long)scanState.getScanJobIntervalMillis() : 0L;
            if (millisToNextJobStart < 50L) {
                millisToNextJobStart = 50L;
            }
        }
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        int monitoredAndRangedRegionCount = scanState.getMonitoringStatus().regions().size() + scanState.getRangedRegionState().size();
        if (monitoredAndRangedRegionCount > 0) {
            if (backgroundWakeup || !scanState.getBackgroundMode().booleanValue()) {
                if (millisToNextJobStart < (long)(scanState.getScanJobIntervalMillis() - 50)) {
                    LogManager.d(TAG, "Scheduling immediate ScanJob to run in " + millisToNextJobStart + " millis", new Object[0]);
                    JobInfo immediateJob = new JobInfo.Builder(ScanJob.getImmediateScanJobId(context), new ComponentName(context, ScanJob.class)).setPersisted(true).setExtras(new PersistableBundle()).setMinimumLatency(millisToNextJobStart).setOverrideDeadline(millisToNextJobStart).build();
                    int error = jobScheduler.schedule(immediateJob);
                    if (error < 0) {
                        LogManager.e(TAG, "Failed to schedule an immediate scan job.  Beacons will not be detected. Error: " + error, new Object[0]);
                    } else if (this.mBackgroundScanJobFirstRun) {
                        LogManager.d(TAG, "First immediate scan job scheduled successful, change the flag to false.", new Object[0]);
                        this.mBackgroundScanJobFirstRun = false;
                    }
                } else {
                    LogManager.d(TAG, "Not scheduling immediate scan, assuming periodic is about to run", new Object[0]);
                }
            } else {
                LogManager.d(TAG, "Not scheduling an immediate scan because we are in background mode.   Cancelling existing immediate ScanJob.", new Object[0]);
                jobScheduler.cancel(ScanJob.getImmediateScanJobId(context));
            }
            JobInfo.Builder periodicJobBuilder = new JobInfo.Builder(ScanJob.getPeriodicScanJobId(context), new ComponentName(context, ScanJob.class)).setPersisted(true).setExtras(new PersistableBundle());
            if (Build.VERSION.SDK_INT >= 24) {
                periodicJobBuilder.setPeriodic((long)scanState.getScanJobIntervalMillis(), 0L).build();
            } else {
                periodicJobBuilder.setPeriodic((long)scanState.getScanJobIntervalMillis()).build();
            }
            JobInfo jobInfo = periodicJobBuilder.build();
            LogManager.d(TAG, "Scheduling periodic ScanJob " + jobInfo + " to run every " + scanState.getScanJobIntervalMillis() + " millis", new Object[0]);
            int error = jobScheduler.schedule(jobInfo);
            if (error < 0) {
                LogManager.e(TAG, "Failed to schedule a periodic scan job.  Beacons will not be detected. Error: " + error, new Object[0]);
            }
        } else {
            LogManager.d(TAG, "We are not monitoring or ranging any regions.  We are going to cancel all scan jobs.", new Object[0]);
            jobScheduler.cancel(ScanJob.getImmediateScanJobId(context));
            jobScheduler.cancel(ScanJob.getPeriodicScanJobId(context));
        }
    }
}

