/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.os.Bundle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.Region;

public class RangingData {
    private static final String TAG = "RangingData";
    private final Collection<Beacon> mBeacons;
    private final Region mRegion;
    private static final String REGION_KEY = "region";
    private static final String BEACONS_KEY = "beacons";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RangingData(Collection<Beacon> beacons, Region region) {
        Collection<Beacon> collection = beacons;
        synchronized (collection) {
            this.mBeacons = beacons;
        }
        this.mRegion = region;
    }

    public Collection<Beacon> getBeacons() {
        return this.mBeacons;
    }

    public Region getRegion() {
        return this.mRegion;
    }

    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putSerializable(REGION_KEY, (Serializable)this.mRegion);
        ArrayList<Beacon> serializableBeacons = new ArrayList<Beacon>();
        for (Beacon beacon : this.mBeacons) {
            serializableBeacons.add(beacon);
        }
        bundle.putSerializable(BEACONS_KEY, serializableBeacons);
        return bundle;
    }

    public static RangingData fromBundle(Bundle bundle) {
        bundle.setClassLoader(Region.class.getClassLoader());
        Region region = null;
        Collection beacons = null;
        if (bundle.get(BEACONS_KEY) != null) {
            beacons = (Collection)((Object)bundle.getSerializable(BEACONS_KEY));
        }
        if (bundle.get(REGION_KEY) != null) {
            region = (Region)bundle.getSerializable(REGION_KEY);
        }
        return new RangingData(beacons, region);
    }
}

